<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText3, li.MsoBodyText3, div.MsoBodyText3
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.Corpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_RESCUMUL" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="89%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoHeading8"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">I – INFORMATIONS GÉNÉRALES ET SYNTHÉTIQUES</span></p>
                              
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="89%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D</span></b><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">ÉTERMINATION DU RÉSULTAT CUMULÉ À LA FIN DE L’EXERCICE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">B</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-right:46.5pt;text-align:justify"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="margin-right:-.05pt;text-align:justify"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoHeader" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <xsl:variable name="varOdmTmpTab2">
                  
                  
                  <table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">Section d’exploitation</span></b></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" style="margin-right:9.65pt"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">Montant</span></p>
                           
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">A Solde des réalisations de l’exercice N précédé du signe + (excédent) ou – (déficit)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEFONEXERC')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">B Résultat antérieur reporté ligne 002 du compte financier N Précédé du signe + (excédent)
                                 ou – (déficit)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOT002')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">C Résultat de clôture de la section d’exploitation (a) = A+B</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" style="border-top:none;border-left:none; border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOTFON')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">Section d’investissement</span></b></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1"> </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">D Solde des réalisations de l’exercice N précédé du signe + (excédent) ou – (déficit)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEINVEXERC')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">E Résultat antérieur reporté ligne 001 du compte financier N Précédé du signe + (excédent)
                                 ou – (déficit)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOT001')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">F Solde d’exécution de la section d’investissement N F = D+E, précédé de + ou</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOTINV')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">G Solde des restes à réaliser d’investissement N (b)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOTINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:solid black 1.0pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">H Solde cumulé de la section d’investissement H (=F+G)</span></p>
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><i><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">NB : en cas de solde négatif, il s’agit d’un besoin de financement à couvrir obligatoirement
                                    par l’affectation du résultat
                                    d’exploitation</span></i></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDETOTINV')]/n:MtCumulCA/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     
                     
                     <tr>
                        
                        
                        <td width="51.6%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">I Plus-values nettes de cessions d’éléments d’actif (c)</span></p>
                           
                           </td>
                        
                        
                        <td width="48.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 5.4pt 0in 5.4pt" rowspan="1" colspan="1">
                           
                           
                           <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='SOLDEPLUSVAL')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       </xsl:call-template></span></b></p>
                           </td>
                        </tr>
                     </table>
                  </xsl:variable>
               
               
               <xsl:call-template name="table:outputTable">
                  
                  
                  <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                  </xsl:call-template>
               
               
               
               <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(a) en cas de déficit reporté de la section d’exploitation, il n'y a pas d'affectation,
                     en cas d’excédent, il est affecté
                     en priorité au financement des investissements (recette sur le compte 1064) pour le
                     montant des plus-values nettes sur cessions
                     d’éléments d’actif.</span></p>
               
               
               
               <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(b) le solde des restes à réaliser de la section d’exploitation n'est pas pris en
                     compte pour l'affectation du résultat d’exploitation.
                     Le solde est reporté au budget de reprise du résultat de l’exercice après le vote
                     du compte financier.</span></p>
               
               
               
               <p class="MsoBodyText3" align="left" style="margin-right:9.65pt;text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(c) différence entre le montant des titres émis sur le compte 775 et celui des mandats
                     émis sur le compte 675</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>