<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../number.xsl"></xsl:import><xsl:import href="../../date.xsl"></xsl:import><xsl:import href="../../table.xsl"></xsl:import><xsl:import href="../../style.xsl"></xsl:import><xsl:import href="../../lien.xsl"></xsl:import><xsl:import href="../../commons/constants.xsl"></xsl:import><xsl:import href="../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../commons/templates.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docXHTML.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docPDF.css" />
      
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin-top:0cm;
  margin-right:0cm;
  margin-bottom:10.0pt;
  margin-left:0cm;
  line-height:115%;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
   </head>
   <body id="ETAT_BALGE" lang="FR"><div id="header">
         <xsl:variable name="tableau1"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text1"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/></xsl:variable><xsl:variable name="text2"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></xsl:variable><xsl:value-of select="concat ($text1, ' ', '-', ' ', $text2)" /></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text3"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></xsl:variable><xsl:value-of select="concat ('Exercice', ' ', $text3)" /></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="tableau2"><xsl:element name="table"><xsl:attribute name = "class" select ="'BORD_BAS MsoTableGrid'" /><xsl:attribute name="width">100%</xsl:attribute><xsl:attribute name="cellspacing">0</xsl:attribute><xsl:attribute name="cellpadding">0</xsl:attribute><thead><tr style="height:18.8pt"><td width="90%" colspan="11" style="border:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.8pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:12.0pt; font-family:&#34;Arial&#34;,sans-serif">III – ÉTATS FINANCIERS</span></b></p>
                  </td><td width="10%" colspan="2" style="border:solid black 1.0pt; border-left:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.8pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:12.0pt; font-family:&#34;Arial&#34;,sans-serif">III</span></b></p>
                  </td></tr><tr style="height:18.25pt"><td width="90%" colspan="11" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:10.0pt; font-family:&#34;Arial&#34;,sans-serif">Balance des comptes</span></b></p>
                  </td><td width="10%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:10.0pt; font-family:&#34;Arial&#34;,sans-serif">D</span></b></p>
                  </td></tr><tr style="height:18.25pt"><td width="100%" colspan="13" style="border:none;border-bottom: solid black 1.0pt;padding:0cm 5.4pt 0cm 5.4pt;height:18.25pt" rowspan="1"> </td></tr><tr style="height:18.25pt"><td width="6%" rowspan="2" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"> Numéro de compte</span></b></p>
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif"></span></b></p>
                  </td><td width="14%" rowspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Libellé du compte</span></b></p>
                  </td><td width="16%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Balance d’entrée</span></b></p>
                  </td><td width="16%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Opérations non budgétaires</span></b></p>
                  </td><td width="16%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Opérations budgétaires</span></b></p>
                  </td><td width="16%" colspan="2" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Total</span></b></p>
                  </td><td width="16%" colspan="3" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Soldes</span></b></p>
                  </td></tr><tr style="height:18.25pt"><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Débit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Crédit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Débit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Crédit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Débit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Crédit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Débit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Crédit</span></b></p>
                  </td><td width="8%" colspan="2" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Débit</span></b></p>
                  </td><td width="8%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><b><span style="font-size:8.0pt; font-family:&#34;Arial&#34;,sans-serif">Crédit</span></b></p>
                  </td></tr></thead><xsl:for-each select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BAL_GE')]"><xsl:sort select="./dc:NumOrdre/@V" data-type="number" /><xsl:variable name="bclBloc_DCPT_BU_LC_1" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:18.25pt"><xsl:variable name="content1"><xsl:value-of select="distinct-values($bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V)"/></xsl:variable><xsl:variable name="className1" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('ARIAL_7', ' ', $className1, ' ', 'LIBELLE BORD_GCH BORD_DRT LIBELLE')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">6%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content1" /></xsl:call-template><xsl:variable name="content2"><xsl:variable name="text4"><xsl:value-of select="distinct-values($bclBloc_DCPT_BU_LC_1/dc:Intitule1/@V)"/></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'PARAGRAPHE'" /><xsl:value-of select="$text4" /></xsl:element><xsl:value-of select="distinct-values($bclBloc_DCPT_BU_LC_1/dc:Intitule2/@V)"/></xsl:variable><xsl:variable name="className2" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('ARIAL_7', ' ', $className2, ' ', 'LIBELLE BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">14%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content2" /></xsl:call-template><xsl:variable name="content3"><xsl:variable name="text5"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtBalEntreeDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text5" /></xsl:element></xsl:variable><xsl:variable name="className3" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className3, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content3" /></xsl:call-template><xsl:variable name="content4"><xsl:variable name="text6"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtBalEntreeCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text6" /></xsl:element></xsl:variable><xsl:variable name="className4" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className4, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content4" /></xsl:call-template><xsl:variable name="content5"><xsl:variable name="text7"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text7" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link1" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudDeb/@V"/><xsl:variable name="link2" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link3" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link4" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link5" select="$link1"/><xsl:variable name="link6" select="'LienBalg'"/><xsl:variable name="link7" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link8" select="$link2"/><xsl:variable name="link9" select="$link3"/><xsl:variable name="link10" select="$link4"/><xsl:variable name="link11" select="'op-non-budg-debit'"/><xsl:variable name="link12" select="'D'"/><xsl:variable name="text8"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text8" /><xsl:with-param name="Param_1" select="$link5" /><xsl:with-param name="Param_2" select="$link6" /><xsl:with-param name="Param_3" select="$link7" /><xsl:with-param name="Param_4" select="$link8" /><xsl:with-param name="Param_5" select="$link9" /><xsl:with-param name="Param_6" select="$link10" /><xsl:with-param name="Param_7" select="$link11" /><xsl:with-param name="Param_8" select="$link12" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className5" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className5, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content5" /></xsl:call-template><xsl:variable name="content6"><xsl:variable name="text9"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text9" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link13" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudCre/@V"/><xsl:variable name="link14" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link15" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link16" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link17" select="$link13"/><xsl:variable name="link18" select="'LienBalg'"/><xsl:variable name="link19" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link20" select="$link14"/><xsl:variable name="link21" select="$link15"/><xsl:variable name="link22" select="$link16"/><xsl:variable name="link23" select="'op-non-budg-credit'"/><xsl:variable name="link24" select="'R'"/><xsl:variable name="text10"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeNonBudCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text10" /><xsl:with-param name="Param_1" select="$link17" /><xsl:with-param name="Param_2" select="$link18" /><xsl:with-param name="Param_3" select="$link19" /><xsl:with-param name="Param_4" select="$link20" /><xsl:with-param name="Param_5" select="$link21" /><xsl:with-param name="Param_6" select="$link22" /><xsl:with-param name="Param_7" select="$link23" /><xsl:with-param name="Param_8" select="$link24" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className6" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className6, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content6" /></xsl:call-template><xsl:variable name="content7"><xsl:variable name="text11"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text11" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link25" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudDeb/@V"/><xsl:variable name="link26" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link27" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link28" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link29" select="$link25"/><xsl:variable name="link30" select="'LienBalg'"/><xsl:variable name="link31" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link32" select="$link26"/><xsl:variable name="link33" select="$link27"/><xsl:variable name="link34" select="$link28"/><xsl:variable name="link35" select="'op-budg-debit'"/><xsl:variable name="link36" select="'D'"/><xsl:variable name="text12"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text12" /><xsl:with-param name="Param_1" select="$link29" /><xsl:with-param name="Param_2" select="$link30" /><xsl:with-param name="Param_3" select="$link31" /><xsl:with-param name="Param_4" select="$link32" /><xsl:with-param name="Param_5" select="$link33" /><xsl:with-param name="Param_6" select="$link34" /><xsl:with-param name="Param_7" select="$link35" /><xsl:with-param name="Param_8" select="$link36" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className7" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className7, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content7" /></xsl:call-template><xsl:variable name="content8"><xsl:variable name="text13"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text13" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link37" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudCre/@V"/><xsl:variable name="link38" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link39" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link40" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link41" select="$link37"/><xsl:variable name="link42" select="'LienBalg'"/><xsl:variable name="link43" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link44" select="$link38"/><xsl:variable name="link45" select="$link39"/><xsl:variable name="link46" select="$link40"/><xsl:variable name="link47" select="'op-budg-credit'"/><xsl:variable name="link48" select="'R'"/><xsl:variable name="text14"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtOpeBudCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text14" /><xsl:with-param name="Param_1" select="$link41" /><xsl:with-param name="Param_2" select="$link42" /><xsl:with-param name="Param_3" select="$link43" /><xsl:with-param name="Param_4" select="$link44" /><xsl:with-param name="Param_5" select="$link45" /><xsl:with-param name="Param_6" select="$link46" /><xsl:with-param name="Param_7" select="$link47" /><xsl:with-param name="Param_8" select="$link48" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className8" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className8, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content8" /></xsl:call-template><xsl:variable name="content9"><xsl:variable name="text15"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text15" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link49" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotDeb/@V"/><xsl:variable name="link50" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link51" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link52" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link53" select="$link49"/><xsl:variable name="link54" select="'LienBalg'"/><xsl:variable name="link55" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link56" select="$link50"/><xsl:variable name="link57" select="$link51"/><xsl:variable name="link58" select="$link52"/><xsl:variable name="link59" select="'tot-debit'"/><xsl:variable name="link60" select="'D'"/><xsl:variable name="text16"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text16" /><xsl:with-param name="Param_1" select="$link53" /><xsl:with-param name="Param_2" select="$link54" /><xsl:with-param name="Param_3" select="$link55" /><xsl:with-param name="Param_4" select="$link56" /><xsl:with-param name="Param_5" select="$link57" /><xsl:with-param name="Param_6" select="$link58" /><xsl:with-param name="Param_7" select="$link59" /><xsl:with-param name="Param_8" select="$link60" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className9" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className9, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content9" /></xsl:call-template><xsl:variable name="content10"><xsl:variable name="text17"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text17" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link61" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotCre/@V"/><xsl:variable name="link62" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link63" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link64" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link65" select="$link61"/><xsl:variable name="link66" select="'LienBalg'"/><xsl:variable name="link67" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link68" select="$link62"/><xsl:variable name="link69" select="$link63"/><xsl:variable name="link70" select="$link64"/><xsl:variable name="link71" select="'tot-credit'"/><xsl:variable name="link72" select="'R'"/><xsl:variable name="text18"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtTotCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text18" /><xsl:with-param name="Param_1" select="$link65" /><xsl:with-param name="Param_2" select="$link66" /><xsl:with-param name="Param_3" select="$link67" /><xsl:with-param name="Param_4" select="$link68" /><xsl:with-param name="Param_5" select="$link69" /><xsl:with-param name="Param_6" select="$link70" /><xsl:with-param name="Param_7" select="$link71" /><xsl:with-param name="Param_8" select="$link72" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className10" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className10, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content10" /></xsl:call-template><xsl:variable name="content11"><xsl:variable name="text19"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text19" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link73" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeDeb/@V"/><xsl:variable name="link74" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link75" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link76" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link77" select="$link73"/><xsl:variable name="link78" select="'LienBalg'"/><xsl:variable name="link79" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link80" select="$link74"/><xsl:variable name="link81" select="$link75"/><xsl:variable name="link82" select="$link76"/><xsl:variable name="link83" select="'solde-debit'"/><xsl:variable name="link84" select="'D'"/><xsl:variable name="text20"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeDeb/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text20" /><xsl:with-param name="Param_1" select="$link77" /><xsl:with-param name="Param_2" select="$link78" /><xsl:with-param name="Param_3" select="$link79" /><xsl:with-param name="Param_4" select="$link80" /><xsl:with-param name="Param_5" select="$link81" /><xsl:with-param name="Param_6" select="$link82" /><xsl:with-param name="Param_7" select="$link83" /><xsl:with-param name="Param_8" select="$link84" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className11" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className11, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content11" /></xsl:call-template><xsl:variable name="content12"><xsl:variable name="text21"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:value-of select="$text21" /></xsl:element></xsl:if><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link85" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeCre/@V"/><xsl:variable name="link86" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link87" select="$docbudg/dc:DocumentComptable[(./dc:BudgetComptable/dc:LigneComptable/dc:Etat/@V='BAL_GE') and (./dc:BudgetComptable/dc:LigneComptable=$bclBloc_DCPT_BU_LC_1)]/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link88" select="$bclBloc_DCPT_BU_LC_1/dc:NumCompte/@V"/><xsl:variable name="link89" select="$link85"/><xsl:variable name="link90" select="'LienBalg'"/><xsl:variable name="link91" select="document('LiensBalance.xml')/comptes"/><xsl:variable name="link92" select="$link86"/><xsl:variable name="link93" select="$link87"/><xsl:variable name="link94" select="$link88"/><xsl:variable name="link95" select="'solde-credit'"/><xsl:variable name="link96" select="'R'"/><xsl:variable name="text22"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$bclBloc_DCPT_BU_LC_1/dc:MtSoldeCre/@V"/><xsl:with-param name="format" select="&quot;# ##0,00 ;empty [&#160;]&quot;"/></xsl:call-template></xsl:variable><xsl:element name="span"><xsl:attribute name="class" select="'ARIAL_7 DECIMAL'" /><xsl:call-template name="com:accueilOutputTitle"><xsl:with-param name="Param_0" select="$text22" /><xsl:with-param name="Param_1" select="$link89" /><xsl:with-param name="Param_2" select="$link90" /><xsl:with-param name="Param_3" select="$link91" /><xsl:with-param name="Param_4" select="$link92" /><xsl:with-param name="Param_5" select="$link93" /><xsl:with-param name="Param_6" select="$link94" /><xsl:with-param name="Param_7" select="$link95" /><xsl:with-param name="Param_8" select="$link96" /></xsl:call-template></xsl:element></xsl:if></xsl:variable><xsl:variable name="className12" select="$bclBloc_DCPT_BU_LC_1/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat ('DECIMAL ARIAL_7', ' ', $className12, ' ', 'BORD_DRT')" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">8%</xsl:with-param><xsl:with-param name="height">null</xsl:with-param><xsl:with-param name="content" select="$content12" /></xsl:call-template></tr></xsl:for-each><tr style="height:18.25pt"><td width="100%" colspan="13" style="border-top:none;border-left: solid black 1.0pt;border-bottom:none;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;height:18.25pt" rowspan="1"><p class="MsoNormal" align="center" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:center;line-height:normal"><span style="font-size:10.0pt; font-family:&#34;Arial&#34;,sans-serif"><xsl:if test="not( $docbudg/dc:DocumentComptable/dc:BudgetComptable[(./dc:LigneComptable/dc:Etat/@V='BAL_GE')]/dc:LigneComptable)"><xsl:value-of select="concat ('Cet état ne contient pas d', '''', 'information.')" /></xsl:if></span></p></td></tr></xsl:element></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:10.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif"> </span></p>
         <p class="MsoNormal"> </p>
      </div>
      <div id="footer">
         <p class="MsoNormal"><span style="font-size:8.0pt;line-height:115%"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:variable name="link97" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link98" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link99" select="'images/return.png'"/><xsl:variable name="link100" select="'Accueil'"/><xsl:variable name="link101" select="$link97"/><xsl:variable name="link102" select="$link98"/><xsl:call-template name="com:lienOutputImage"><xsl:with-param name="Param_0" select="'images/return.png'" /><xsl:with-param name="Param_1" select="$link99" /><xsl:with-param name="Param_2" select="$link100" /><xsl:with-param name="Param_3" select="$link101" /><xsl:with-param name="Param_4" select="$link102" /></xsl:call-template></xsl:if></span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>