<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>
<xsl:template match="/">


<xsl:if test="//xsql-error">
  <xsl:text>Nombre de balises : </xsl:text>
  <xsl:number value="count(*//*)"/>
  <br/>
  <xsl:text>Nombre d'erreurs : </xsl:text>
  <xsl:number value="count(//xsql-error)"/>
  <br/> 
  <xsl:for-each select="//xsql-error">
  <xsl:text>Erreur </xsl:text>
  <xsl:number level="any" count="xsql-error"/>
  <table border="1" style="background:yellow">
    <tr>
      <td><b>Niveau</b></td>
      <td><xsl:call-template name="initRemonteNoeud"/><xsl:value-of select="name(.)"/></td>
    </tr>
    <tr>
      <td><b>Numero de balise</b></td>
      <td><xsl:number level="any" count="*"/></td>
    </tr>
    <tr>
      <td><b>Action</b></td>
      <td><xsl:value-of select="@action"/></td>
    </tr>
    <tr valign="top">
      <td><b>Statement</b></td>
      <td><xsl:value-of select="statement"/></td>
    </tr>
    <tr valign="top">
      <td><b>Message</b></td>
      <td><xsl:value-of select="message"/></td>
    </tr>
  </table>
  <br/>
  </xsl:for-each>
</xsl:if>


</xsl:template>


<xsl:template mode="remonteArbre" match="*">
  <xsl:call-template name="initRemonteNoeud"/>
  <xsl:value-of select="name(.)"/>/
</xsl:template>
  
<xsl:template name="initRemonteNoeud" match="*">
  <xsl:if test="../..">                              
    <xsl:apply-templates mode="remonteArbre" select=".." />
  </xsl:if>
</xsl:template>
</xsl:stylesheet> 
