<?php
/** Gestion d'un article.
 * @version      $Id$
 */



include ("inc.php3");

include_once("inc_logos.php3");
include_once("inc_mots.php3");
include_once("inc_documents.php3");

/* Ajout Clever Age / Nicolas Hoizey / Referencement des liens & gestion sondages */
include_once('inc_liens.php3');
include_once("inc_sondages.php3");
/* fin zone de modification Clever Age */

/* Ajout Clever Age / Antoine Angenieux / Couche metier */
require_once (dirname(__FILE__)."/include/bd/auteur.php");
require_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_forum_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_petition_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_signature_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_forum_list_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_profil_factory.php");

// Ajout Aurelien Vialet <avialet@clever-age.com> Gestion des champs formulaires
require_once (dirname(__FILE__)."/inc_contraintes.php");
require_once (dirname(__FILE__)."/include/bd/inc_article_historique_factory.php");
// Fin de l'ajout Aurelien Vialet

/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
require_once (dirname(__FILE__)."/include/bd/inc_mapping_factory.php");

// le poids du redacteur .... utile pour la suite 
$profilMetier = & recuperer_instance_profil();
$loadOK = $profilMetier->getProfilForIntitule('item_redacteur');
if (PEAR :: isError($loadOK)) {
    die($loadOK->getMessage());
}
define ("POIDSREDACTEUR", $loadOK->getPoids());
//var_dump ($profilMetier);

$articles_surtitre = lire_meta("articles_surtitre");
$articles_soustitre = lire_meta("articles_soustitre");
$articles_descriptif = lire_meta("articles_descriptif");
$articles_urlref = lire_meta("articles_urlref");
$articles_chapeau = lire_meta("articles_chapeau");
$articles_ps = lire_meta("articles_ps");
$articles_redac = lire_meta("articles_redac");
$articles_mots = lire_meta("articles_mots");

$activer_version_articles = lire_meta("activer_version_articles");
$activer_histo_articles = lire_meta("activer_histo_articles");

$articleMetier = & recuperer_instance_article();

$auteurMetier = & recuperer_instance_auteur();

/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
$mapping = & recuperer_instance_mapping();
$mappingMetier = & recuperer_instance_article();
/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

// Rcupration de l'heure courante (valeur par dfaut de l'heure de publication)
$heure = date( 'H' );
$minute = date( 'i' );
$seconde = date( 's' );

// Gestion de la mise en ligne d'une version d'un article
$id_version = 0;

if ($activer_version_articles == 'oui') {
	if ($new_version == 'oui') {
		// Gestion de la mise en place d'une nouvelle version d'un article
		$id_version = $id_article;
		$id_article = 0;
		$new = 'oui';
	}
}

// TODO : seems not very logical
if ($activerhistorique == 'oui' || $activerhistorique == 'non') {
	$loadOK = $articleMetier->load($id_article);
	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	} else {
		$articleMetier->setActiverHistorique($activerhistorique);
		$articleMetier->update();
	}
}



if ($id_article == 0) {
	if ($new == 'oui') {
		$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => intval($articleMetier->getRubriqueId())));
		if (!$authorization->isAuthorizedAction()) {
			echo _T('avis_acces_interdit');
			exit;
		}

		/********* Modification elebescond@clever-age.com ***********************/
		if ($titre == '')
			$titre = _T('art_info_sans_titre', null, $articleMetier->getRubriqueId());
		/*
		if ($titre=='') $titre = _T('info_sans_titre');
		*/
		/********* Fin modification elebescond@clever-age.com ***********************/

		$langue_new = '';
		/**************** Modification elebescond@clever-age.com *************************************/
		$rubriqueMetier = & recuperer_instance_rubrique();
		$loadOK = $rubriqueMetier->load($id_rubrique);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		} else {
			$langue_new = $rubriqueMetier->getLang();
		}
		/*
		$result_lang_rub = spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$articleMetier->getRubriqueId()");
		if ($row = spip_fetch_array($result_lang_rub))
			$langue_new = $row["lang"];
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/

		if (!$langue_new)
			$langue_new = lire_meta('langue_site');
		$langue_choisie_new = 'non';

		/********* Modification elebescond@clever-age.com ***********/
		$forums_publics = lire_meta('forums_publics');
		/*
		$forums_publics = substr(lire_meta('forums_publics'),0,3);
		*/
		/********* Fin modification elebescond@clever-age.com ***********/

		/* Modification Clever Age, utilisation couche m�tier */
		$articleMetier->setRubriqueId($id_rubrique);
		$articleMetier->setStatut('prepa');
		$articleMetier->setAccepterForum($forums_publics);
		$articleMetier->setLang($langue_new);

		// Ajout Aurelien Vialet <avialet@clever-age.com>
		// Gestion du versionning des articles
		$articleMetier->setVersionId($id_version);

		$createOK = $articleMetier->create();
		if (PEAR :: isError($createOK)) {
			die($createOK->getMessage());
		}
		/*
		spip_query("INSERT INTO spip_articles (id_rubrique, statut, date, accepter_forum, lang, langue_choisie) VALUES ($articleMetier->getRubriqueId(), 'prepa', NOW(), '$forums_publics', '$langue_new', '$langue_choisie_new')");
		$id_article = spip_insert_id();
		
		spip_query("INSERT INTO spip_articles (id_rubrique, statut, date, accepter_forum) VALUES ($articleMetier->getRubriqueId(), 'prepa', NOW(), '$forums_publics')");
		*/
		$id_article = $articleMetier->getArticleId();

		$deleteAuteursOK = $articleMetier->deleteAuteurs();
		if (PEAR :: isError($createOK)) {
			die($deleteAuteursOK->getMessage());
		}

		$addAuteurOK = $articleMetier->addAuteur($connect_id_auteur);
		if (PEAR :: isError($addAuteurOK)) {
			die($addAuteurOK->getMessage());
		}
		/*
		spip_query("DELETE FROM spip_auteurs_articles WHERE id_article = $id_article");
		spip_query("DELETE FROM spip_auteurs_articles WHERE id_article = $id_article");
		spip_query("INSERT INTO spip_auteurs_articles (id_auteur, id_article) VALUES ($connect_id_auteur, $id_article)");
		*/
		/* Fin de zone de modifications */
	} else {
		@ header("Location: ./index.php3");
		exit;
	}
}

$clean_link = new Link("articles.php3?id_article=$id_article");

// Initialiser doublons pour documents (completes par "propre($texte)")
$id_doublons['documents'] = "0";

//////////////////////////////////////////////////////
// Determiner les droits d'edition de l'article
//

/*
    MODIFICATION CLEVER AGE COUCHE METIER
*/

$loadOK = $articleMetier->load($id_article);

if (PEAR :: isError($loadOK)) {
	die($loadOK->getMessage());
} else {
	$statut_article = $articleMetier->getStatut();
	if ($statut_article != '') {
		$titre_article = $articleMetier->getTitre();
		$rubrique_article = $articleMetier->getRubriqueId();
	}
}
$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
if (!$authorization->isAuthorizedAction()) {
	echo _T('avis_acces_interdit');
	exit;
}

/*
$query = "SELECT statut, titre, id_rubrique FROM spip_articles WHERE id_article=$id_article";
$result = spip_query($query);
if ($row = spip_fetch_array($result)) {
	$statut_article = $row['statut'];
	$titre_article = $row['titre'];
	$rubrique_article = $row['id_rubrique'];
}
else {
	$statut_article = '';
}
*/

$flag_auteur = $articleMetier->isAuthor($connect_id_auteur);
if (PEAR :: isError($flag_auteur)) {
	die($flag_auteur->getMessage());
}
/*
$query = "SELECT * FROM spip_auteurs_articles WHERE id_article=$id_article AND id_auteur=$connect_id_auteur";
$result_auteur = spip_query($query);

$flag_auteur = (spip_num_rows($result_auteur) > 0);
*/

/*
    FIN DE ZONE DE MODIFICATIONS
*/
//--------Zone de modifications Clever Age elebescond-------------
//$authorization = &recuperer_instance_authorization();

$authorization1 = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
$authorization2 = & recuperer_instance_authorization('modifierStatutArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article, 'statut_nouv' => $statut_nouv));
$authorization3 = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));

$flag_editable = ($authorization1->isAuthorizedAction() AND ($authorization2->isAuthorizedAction() OR $authorization3->isAuthorizedAction()));
/*
$flag_editable = ($authorization->isAuthorized($GLOBALS['connect_id_auteur'], 'isManagedRubriqueByAuteurId', array('rubriqueId' => $rubrique_article))
	OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop' OR $statut_article == 'poubelle')));
*/
 

/*
$flag_editable = (acces_rubrique($rubrique_article)
	OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop' OR $statut_article == 'poubelle')));
*/
//--------Fin Zone de modifications Clever Age elebescond-------------

/// En double avec articles_edit.php3, mais necessite le flag_editable
$modif_document = $GLOBALS['modif_document'];

if ($modif_document == 'oui' AND $flag_editable) {
	//--------Zone de modifications Clever Age aangenieux-------------
	$documentMetier = & recuperer_instance_document();
	$loadOK = $documentMetier->load($id_document);

	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	}

	if ($documentMetier->getMode() == 'document') {
		if ($titre_document != '') {
			$documentMetier->setTitre($titre_document);
		} else {
			if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
				$titre_document_array = explode('/', $documentMetier->getFichier());
				$titre_document = $titre_document_array[2];
				$titre_document_array = explode('.', $titre_document);

				$titre_document = strtr($titre_document_array[0], "_", " ");
				$documentMetier->setTitre($titre_document);
			}
		}
	} else {
		if (($titre_document == '' && $descriptif_document == '') || ($titre_document != '')) {
			$documentMetier->setTitre($titre_document);
		} else {
			if ($titre_document == '' && $descriptif_document != '' && $documentMetier->getTitre() == '') {
				$titre_document_array = explode('/', $documentMetier->getFichier());
				$titre_document = $titre_document_array[2];
				$titre_document_array = explode('.', $titre_document);

				$titre_document = strtr($titre_document_array[0], "_", " ");
				$documentMetier->setTitre($titre_document);
			}
		}
	}

	$documentMetier->setDescriptif($descriptif_document);
	if ($largeur_document AND $hauteur_document) {
		$documentMetier->setLargeur($largeur_document);
		$documentMetier->setHauteur($hauteur_document);
	}

	$updateOK = $documentMetier->update();
	if (PEAR :: isError($updateOK)) {
		die($updateOK->getMessage());
	}
	/*
	$titre_document = corriger_caracteres($titre_document);
	$descriptif_document = corriger_caracteres($descriptif_document);
	$query = "UPDATE spip_documents SET titre=\"$titre_document\", descriptif=\"$descriptif_document\"";
	if ($largeur_document AND $hauteur_document) $query .= ", largeur='$largeur_document', hauteur='$hauteur_document'";
	$query .= " WHERE id_document=$id_document";
	spip_query($query);
	*/
	//----------Fin zone de modifications-----------------------------
}

//
// Appliquer les modifications
//
$suivi_edito = lire_meta("suivi_edito");
$reindexer = false;

$ok_nouveau_statut = false;
 
if ($statut_nouv && $flag_editable) {
	//--------Zone de modifications Clever Age elebescond-------------
	$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
	if ($authorization->isAuthorizedAction())
		$ok_nouveau_statut = true;
	/*
	if (acces_rubrique($rubrique_article)) $ok_nouveau_statut = true;
	*/
	//--------Zone de modifications Clever Age elebescond@clever-age.com-------------
	else
		if ($flag_auteur) {
			if ($statut_nouv == 'prop' AND $statut_article == 'prepa')
				$ok_nouveau_statut = true;
			else
				if ($statut_nouv == 'prepa' AND $statut_article == 'poubelle')
					$ok_nouveau_statut = true;
		}

	if ($ok_nouveau_statut) {
		// GESTION DU VERSIONNING
		//-----------MODIFICATION CLEVER AGE
		$articleMetier->setStatut($statut_nouv);
		/*
		$query = "UPDATE spip_articles SET statut='$statut_nouv' WHERE id_article=$id_article";
		$result = spip_query($query);
		*/

		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_nouv == 'poubelle' AND $statut_nouv != $statut_article) {
			$mappings = $mapping->getMappings($articleMetier->getArticleId());
			if ( PEAR::isError($mappings) ) {
				die($mappings->getMessage());
			}
			else {
				for ($i = 0; $i < count($mappings); $i++) {
					$deleteOK = $mappingMetier->delete($mappings[$i]);
					if (PEAR :: isError($deleteOK)) {
						die($deleteOK->getMessage());
					}
					$deleteOK = $mapping->deleteEntryByArticleIdAndMappingId($articleMetier->getArticleId(), $id_map);
					if (PEAR :: isError($deleteOK)) {
						die($deleteOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

		if ($statut_nouv == 'publie' AND $statut_nouv != $statut_article) {
			if (($activer_version_articles == 'oui') && ($articleMetier->getVersionId() != 0)) {
				//echo $articleMetier->getVersionId();
				$redirectId = $articleMetier->getVersionId();
				//$articleMetier->load(1);
				// Modification Aurelien Vialet <avialet@clever-age.com>
				// Mise  jour en publi implique dans le cas d'une version qu'il 
				// faut pour une version la pass en artilce racine
				
				if ($articleMetier->getVersionId() != 0) {
					$articleMetier->switchVersion($articleMetier->getVersionId(), $articleMetier->getArticleId());
				}
				// header("location:articles.php3?id_article=1"); //, c pas l'article 1 !!!!!
				header("location:articles.php3?id_article=".$articleMetier->getVersionId());
				
				// Gestion du changement de statut si on publie une version
				// Fin de modification Aurelien Vialet <avialet@clever-age.com>
			}
			
			
			
            //			$maDate = new Date();
            //			$articleMetier->setDate($maDate->getDate(DATE_FORMAT_ISO));
			//$articleMetier->setDate('NOW()');
			/*
			$query = "UPDATE spip_articles SET date=NOW() WHERE id_article=$id_article";
			$result = spip_query($query);
			*/
		}

		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}
		//-------FIN MODIFICATION CLEVER AGE

		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_nouv != $statut_article) {
			$mappings = $mapping->getMappings($articleMetier->getArticleId());
			if ( PEAR::isError($mappings) ) {
				die($mappings->getMessage());
			}
			else {
				for ($i = 0; $i < count($mappings); $i++) {
					$loadOK = $mappingMetier->load($mappings[$i]);
					if (PEAR :: isError($loadOK)) {
						die($loadOK->getMessage());
					} else {
						if ($statut_nouv == 'publie')
							$mappingMetier->setStatut('mappe');
						else
							$mappingMetier->setStatut('map_off');
						$updateOK = $mappingMetier->update();
						if (PEAR :: isError($updateOK)) {
							die($updateOK->getMessage());
						}
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/


		$statut_ancien = $statut_article; // message pour les traitements de fond (indexation ; envoi mail)
		$statut_article = $statut_nouv;
		//--------Zone de modifications Clever Age elebescond-------------
		//$authorization = &recuperer_instance_authorization();
		//$flag_editable = ($authorization->isAuthorized($GLOBALS['connect_id_auteur'], 'isManagedRubriqueByAuteurId', array('rubriqueId' => $rubrique_article))
		//OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop')));
		/*
		$flag_editable = (acces_rubrique($rubrique_article)
			OR ($flag_auteur AND ($statut_article == 'prepa' OR $statut_article == 'prop')));
		*/
		//--------Fin Zone de modifications Clever Age elebescond-------------

	}
}

// Modification de la date de publication
if ( isset($_GET['jour']) && $flag_editable ) {
    $articleMetier->load( $_GET['id_article'] );
     $status = $articleMetier->setPublicationDate( array($_GET['annee'], $_GET['mois'], $_GET['jour']),
                                                  array($_GET['heure'], $_GET['minute'], '00') );
    if ( PEAR::isError($status) ) {
        die( 'Impossible de modifier la date de publication : ' . $status->getMessage() );
    }

	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setPublicationDate(array($_GET['annee'], $_GET['mois'], $_GET['jour']),
													array($_GET['heure'], $_GET['minute'], '00'));
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

}

// Modification de la date d'expiration
if ( isset($_GET['jour_expiration']) && $flag_editable ) { 
    $articleMetier->load( $_GET['id_article'] );
    $status = $articleMetier->setExpirationDateWithArray ( array($_GET['annee_expiration'], $_GET['mois_expiration'], $_GET['jour_expiration']),
                                                  array($_GET['heure_expiration'], $_GET['minute_expiration'], '00') );
    if ( PEAR::isError($status) ) {
        die( 'Impossible de modifier la date d\'expiration : ' . $status->getMessage() );
    }
}




if ($jour_redac && $flag_editable) {
	if ($annee_redac <> '' AND $annee_redac < 1001)
		$annee_redac += 9000;

	if ($mois_redac == "00")
		$jour_redac = "00";

	//------------MODIFICATION CLEVER AGE elebescond@clever-age.com
	if ($avec_redac == "non") {
		$annee_redac = '0000';
		$mois_redac = '00';
		$jour_redac = '00';

		$articleMetier->setRedactionDate("$annee_redac-$mois_redac-$jour_redac 01:01:01");
		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}
		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		$mappings = $mapping->getMappings($articleMetier->getArticleId());
		if ( PEAR::isError($mappings) ) {
			die($mappings->getMessage());
		}
		else {
			for ($i = 0; $i < count($mappings); $i++) {
				$loadOK = $mappingMetier->load($mappings[$i]);
				if (PEAR :: isError($loadOK)) {
					die($loadOK->getMessage());
				} else {
					$mappingMetier->setRedactionDate($articleMetier->getRedactionDate());
					$updateOK = $mappingMetier->update();
					if (PEAR :: isError($updateOK)) {
						die($updateOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

	} else {
		$maDate = new Date("$annee_redac-$mois_redac-$jour_redac 01:01:01");

		$articleMetier->setRedactionDate($maDate->getDate(DATE_FORMAT_ISO));
		//$articleMetier->setRedactionDate('$annee_redac-$mois_redac-$jour_redac'); //A MODIFIER APRES CHANGEMENT DU MODELE DE DONNEES POUR LA GESTION DES DATES

		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}

		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		$mappings = $mapping->getMappings($articleMetier->getArticleId());
		if ( PEAR::isError($mappings) ) {
			die($mappings->getMessage());
		}
		else {
			for ($i = 0; $i < count($mappings); $i++) {
				$loadOK = $mappingMetier->load($mappings[$i]);
				if (PEAR :: isError($loadOK)) {
					die($loadOK->getMessage());
				} else {
					$mappingMetier->setRedactionDate($articleMetier->getRedactionDate());
					$updateOK = $mappingMetier->update();
					if (PEAR :: isError($updateOK)) {
						die($updateOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

	}
	/*
	if ($avec_redac=="non") {
		$annee_redac = '0000';
		$mois_redac = '00';
		$jour_redac = '00';
	}
	}$query = "UPDATE spip_articles SET date_redac='$annee_redac-$mois_redac-$jour_redac' WHERE id_article=$id_article";
	$result = spip_query($query);
	*/

	//--------FIN MODIFICATION CLEVER AGE

}

// Appliquer la modification de langue
if (lire_meta('multi_articles') == 'oui' AND $flag_editable) {

	/**************** Modification elebescond@clever-age.com *************************************/
	$rubriqueMetier = & recuperer_instance_rubrique();
	$loadOK = $rubriqueMetier->load($rubrique_article);
	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	}
	$langue_parent = $rubriqueMetier->getLang();

	/*
	$row = spip_fetch_array(spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$rubrique_article"));
	$langue_parent = $row['lang'];
	*/
	/**************** Fin modification elebescond@clever-age.com *************************************/

	/**************** Modification elebescond@clever-age.com *************************************/
	if ($changer_lang) {
		$loadOK = $articleMetier->load($id_article);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		}
		if ($changer_lang != "herit") {
			$articleMetier->setLang($changer_lang);
			$articleMetier->setLangChoisie('oui');
		} else {
			$articleMetier->setLang($langue_parent);
			$articleMetier->setLangChoisie('non');
		}
		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}
		
                /******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		$mappings = $mapping->getMappings($articleMetier->getArticleId());
		if ( PEAR::isError($mappings) ) {
			die($mappings->getMessage());
		}
		else {
			for ($i = 0; $i < count($mappings); $i++) {
				$loadOK = $mappingMetier->load($mappings[$i]);
				if (PEAR :: isError($loadOK)) {
					die($loadOK->getMessage());
				} else {
					$mappingMetier->setLang($articleMetier->getLang());
					$mappingMetier->setLangChoisie($articleMetier->getLangChoisie());
					$updateOK = $mappingMetier->update();
					if (PEAR :: isError($updateOK)) {
						die($updateOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/


	}
	/*
	if ($changer_lang) {
	    if ($changer_lang != "herit")
	        spip_query("UPDATE spip_articles SET lang='".addslashes($changer_lang)."', langue_choisie='oui' WHERE id_article=$id_article");
	    else
	        spip_query("UPDATE spip_articles SET lang='".addslashes($langue_parent)."', langue_choisie='non' WHERE id_article=$id_article");
	}
	*/
	/**************** Fin modification elebescond@clever-age.com *************************************/

}

// Passer les images/docs en "inclus=non"
//----------------Zone de modifications Clever Age aangenieux----------
$documentMetier = & recuperer_instance_document();
$ze_doc = $documentMetier->getAlldocumentIdsForArticleId($id_article);

if (PEAR :: isError($ze_doc)) {
	die($ze_doc->getMessage());
}
/*
$query = "SELECT docs.id_document FROM spip_documents AS docs, spip_documents_articles AS lien WHERE lien.id_article=$id_article AND lien.id_document=docs.id_document";
$result = spip_query($query);
while($row=spip_fetch_array($result)){
	$ze_doc[]=$row['id_document'];
}
*/
//----------------Fin de zone de modifications--------------------------

if (count($ze_doc) > 0) {
	$ze_docs = join($ze_doc, ",");
	//----------------Zone de modifications Clever Age aangenieux----------
	$documentMetier = & recuperer_instance_document();
	$updateOK = $documentMetier->updateInclusForDocumentIds('non', $ze_docs);
	if (PEAR :: isError($updateOK)) {
		die($updateOK->getMessage());
	}
	/*
	spip_query("UPDATE spip_documents SET inclus='non' WHERE id_document IN ($ze_docs)");
	*/
	//----------------Fin de zone de modifications--------------------------
}

//
// Reunit les textes decoupes parce que trop longs
//
// patch David Charbonnier  tester 
$nb_texte = 0;
while ($nb_texte ++ < 100) { // 100 pour eviter une improbable boucle infinie
	$varname = "texte$nb_texte";
	$texte_plus = $$varname; // double $ pour obtenir $texte1, $texte2...
	if ($texte_plus) {
		$texte_ajout .= " ".$texte_plus;
	} else {
		break;
	}
}
$texte = $texte_ajout.$texte;
/*
$nb_texte = 0;
while ($nb_texte ++ < 100){		// 100 pour eviter une improbable boucle infinie
	$varname = "texte$nb_texte";
	$texte_plus = $$varname;	// double $ pour obtenir $texte1, $texte2...
	if ($texte_plus){
		$texte_plus = ereg_replace("<!--SPIP-->[\n\r]*","\n\n\n",$texte_plus);
		$texte_ajout .= " ".$texte_plus;
	} else {
		break;
	}
}
$texte = $texte_ajout . $texte;
*/
// fin patch 

// preparer le virtuel
if ($changer_virtuel && $flag_editable) {
	$virtuel = eregi_replace("^http://$", "", trim($virtuel));
	if ($virtuel)
		$chapo = addslashes(corriger_caracteres("=$virtuel"));
	else
		$chapo = "";

	//-----------MODIFICATION CLEVER AGE

	$articleMetier->setChapo($chapo);

	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die(PEAR :: isError($updateOK));
	}

	/*
	$query = "UPDATE spip_articles SET chapo=\"$chapo\" WHERE id_article=$id_article";
	$result = spip_query($query);
	*/
	//-----------FIN MODIFICATION CLEVER AGE
	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setChapo($chapo);
				$updateOK = $mappingMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

}


if ($titre && !$ajout_forum && $flag_editable) {
	// ajout de l'entre dans la table historique 
	if (($activer_histo_articles == 'oui') && ($articleMetier->getActiverHistorique() == 'oui')) {
		$articleMetier->create_historique ();
	}
	
	//------MODIFICATION CLEVER AGE
	$articleMetier->setSurtitre($surtitre);
	$articleMetier->setTitre($titre);
	$articleMetier->setSoustitre($soustitre);
	$articleMetier->setDescriptif($descriptif);
	$articleMetier->setNomSite($nom_site);
	$articleMetier->setUrlSite($url_site);
	$articleMetier->setChapo($chapo);
	$articleMetier->setTexte($texte);
	$articleMetier->setPs($ps);
	/*
	$surtitre = addslashes(corriger_caracteres($surtitre));
	$titre = addslashes(corriger_caracteres($titre));
	$soustitre = addslashes(corriger_caracteres($soustitre));
	$descriptif = addslashes(corriger_caracteres($descriptif));
	$nom_site = addslashes(corriger_caracteres($nom_site));
	$url_site = addslashes(corriger_caracteres($url_site));
	$chapo = addslashes(corriger_caracteres($chapo));
	$texte = addslashes(corriger_caracteres($texte));
	$ps = addslashes(corriger_caracteres($ps));
	*/

	// recoller les champs du extra
	if ($champs_extra) {
		include_once("inc_extra.php3");
		//-------MODIFICATION CLEVER AGE --- AANGENIEUX --- Gestion extra -------
		$add_extra = extra_recup_saisie("articles", $id_secteur);
		/*
		$add_extra = ", extra = '".addslashes(extra_recup_saisie("article", $id_secteur))."'";
		*/
	} else
		$add_extra = '';

	$articleMetier->setExtra($add_extra);
	//--------------FIN DE MODIFICATION CA---------------------------

	// Verifier qu'on envoie bien dans une rubrique autorisee

	//--------Zone de modifications Clever Age elebescond-------------
	$authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array ('rubriqueId' => $rubrique_article));
	if ($flag_auteur OR $authorization->isAuthorizedAction()) {
		$articleMetier->setRubriqueId($id_rubrique);
	}

	/*
	if ($flag_auteur OR acces_rubrique($id_rubrique)) {
		//$change_rubrique = "id_rubrique=\"$id_rubrique\",";
	}
	*/
	//--------Fin Zone de modifications Clever Age elebescond-------------

	/*
	} else {
		$change_rubrique = "";
	}
	*/
	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die($updateOK->getMessage());
	}

	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setSurtitre($articleMetier->getSurtitre());
				//$mappingMetier->setTitre($articleMetier->getTitre());
				$mappingMetier->setSoustitre($articleMetier->getSoustitre());
				//$mappingMetier->setDescriptif($articleMetier->getDescriptif());
				$mappingMetier->setNomSite($articleMetier->getNomSite());
				$mappingMetier->setUrlSite($articleMetier->getUrlSite());
				$mappingMetier->setChapo($articleMetier->getChapo());
				$mappingMetier->setTexte($articleMetier->getTexte());
				$mappingMetier->setPs($articleMetier->getPs());
				$mappingMetier->setExtra($articleMetier->getExtra());
				$updateOK = $mappingMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

        /*
	$query = "UPDATE spip_articles SET surtitre=\"$surtitre\", titre=\"$titre\", soustitre=\"$soustitre\", $change_rubrique descriptif=\"$descriptif\", chapo=\"$chapo\", texte=\"$texte\", ps=\"$ps\", url_site=\"$url_site\", nom_site=\"$nom_site\" $add_extra WHERE id_article=$id_article";
	$result = spip_query($query);
	*/
	//----------FIN MODIFICATION CLEVER AGE


	/* Ajout Clever Age / Nicolas Hoizey / R�f�rencement des liens */
	$contenu = $surtitre.$titre.$soustitre.$descriptif.$chapo.$texte.$ps;
	if ($champs_extra)
		$contenu .= addslashes(extra_recup_saisie('article', $id_secteur));
	update_liens($contenu, 'art-'.$id_article);
	/* fin zone de modification Clever Age */


	if ($statut_article == 'publie')
		$reindexer = true;

	// Changer la langue heritee
	if ($articleMetier->getRubriqueId() != $id_rubrique_old) {
		/**************** Modification elebescond@clever-age.com *************************************/
		$loadOK = $articleMetier->load($id_article);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		}
		$langue_old = $articleMetier->getLang();
		$langue_choisie_old = $articleMetier->getLangChoisie();
		/*
		$row = spip_fetch_array(spip_query("SELECT lang, langue_choisie FROM spip_articles WHERE id_article=$id_article"));
		$langue_old = $row['lang'];
		$langue_choisie_old = $row['langue_choisie'];
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/

		/**************** Modification elebescond@clever-age.com *************************************/
		if ($langue_choisie_old != "oui") {
			$rubriqueMetier = & recuperer_instance_rubrique();
			$loadOK = $rubriqueMetier->load($articleMetier->getRubriqueId());
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			}
			$langue_new = $rubriqueMetier->getLang();
			if ($langue_new != $langue_old) {
				$articleMetier->setLang($langue_new);
				$updateOK = $articleMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
				/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
				$mappings = $mapping->getMappings($articleMetier->getArticleId());
				if ( PEAR::isError($mappings) ) {
					die($mappings->getMessage());
				}
				else {
					for ($i = 0; $i < count($mappings); $i++) {
						$loadOK = $mappingMetier->load($mappings[$i]);
						if (PEAR :: isError($loadOK)) {
							die($loadOK->getMessage());
						} else {
							$mappingMetier->setLang($articleMetier->getLang());
							$updateOK = $mappingMetier->update();
							if (PEAR :: isError($updateOK)) {
								die($updateOK->getMessage());
							}
						}
					}
				}
				/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

                        }
		}
		/*
		if ($langue_choisie_old != "oui") {
			$row = spip_fetch_array(spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$id_rubrique"));
			$langue_new = $row['lang'];
			if ($langue_new != $langue_old) spip_query("UPDATE spip_articles SET lang = '$langue_new' WHERE id_article = $id_article");
		}
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/
	}

	// afficher le nouveau titre dans la barre de fenetre
	$titre_article = stripslashes($titre);

	//-----------MODIFICATION CLEVER AGE

	// marquer l'article (important pour les articles nouvellement crees)
	$maDate = new Date();
	$articleMetier->setModificationDate($maDate->getDate(DATE_FORMAT_ISO));
	//$articleMetier->setModificationDate('NOW()');
	$articleMetier->setAuteurModif($connect_id_auteur);
	$updateOK = $articleMetier->update();

	if (PEAR :: isError($updateOK)) {
		die(PEAR :: isError($updateOK));
	}
	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	$mappings = $mapping->getMappings($articleMetier->getArticleId());
	if ( PEAR::isError($mappings) ) {
		die($mappings->getMessage());
	}
	else {
		for ($i = 0; $i < count($mappings); $i++) {
			$loadOK = $mappingMetier->load($mappings[$i]);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$mappingMetier->setModificationDate($articleMetier->getModificationDate());
				$mappingMetier->setAuteurModif($articleMetier->getAuteurModif());
				$updateOK = $mappingMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}
			}
		}
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

	/*
	spip_query("UPDATE spip_articles SET date_modif=NOW(), auteur_modif=$connect_id_auteur WHERE id_article=$id_article");
	*/
	$id_article_bloque = $id_article; // message pour inc_presentation
	
	
	
}

// remplacement par une sous version de l'historique
if ($flag_editable and $id_article_historique_replace and ($activer_histo_articles == 'oui') and ($articleMetier->getActiverHistorique() == 'oui')) {
    $articleMetier->create_historique ();
	$articleMetier->switchHistorique($id_article_historique_replace);
}
//----------FIN MODIFICATION CLEVER AGE

//
// Suivi forums publics
//

// fonction dupliquee dans inc-forum.php3
function get_forums_publics($id_article = 0) {

	$forums_publics = lire_meta("forums_publics");
	if ($id_article) {
		//------------MODIFICATION CLEVER AGE
        $articleMetier = & recuperer_instance_article();
		$loadOK = $articleMetier->loadLightWeight($id_article);
		/*
		$query = "SELECT accepter_forum FROM spip_articles WHERE id_article=$id_article";
		$res = spip_query($query);
		*/

		if ( PEAR::isError($loadOK) ) {
			die($loadOK->getMessage());
		} else {
			$forums_publics = $articleMetier->getAccepterForum();
		}
		/*
		if ($obj = spip_fetch_object($res))
			$forums_publics = $obj->accepter_forum;
		*/
		//-----------FIN MODIFICATION CLEVER AGE

	} else { // dans ce contexte, inutile
		$forums_publics = substr(lire_meta("forums_publics"), 0, 3);
	}
	return $forums_publics;
}

//
// Lire l'article
//

//----------MODIFICATION CLEVER AGE
if ($articleMetier->getArticleId() == $id_article) { //Test si article charg� OK
	$surtitre = $articleMetier->getSurtitre();
	$titre = $articleMetier->getTitre();
	$soustitre = $articleMetier->getSoustitre();
	$id_rubrique = $articleMetier->getRubriqueId();
	$descriptif = $articleMetier->getDescriptif();
	$chapo = $articleMetier->getChapo();
	$texte = $articleMetier->getTexte();
	$ps = $articleMetier->getPs();
	$date = $articleMetier->getDate();
	$statut_article = $articleMetier->getStatut();
	$maDate = new Date($articleMetier->getMajDate());
	$maj = $maDate->getDate(DATE_FORMAT_TIMESTAMP);
	//$maj = $articleMetier->getMajDate();
	$date_redac = $articleMetier->getRedactionDate();
	$visites = $articleMetier->getVisites();
	$referers = $articleMetier->getReferers();
	$extra = $articleMetier->getExtra();
	$id_trad = $articleMetier->getTradId();
    $date_expiration = $articleMetier->getExpirationDate();
}

/*
$query = "SELECT * FROM spip_articles WHERE id_article='$id_article'";
$result = spip_query($query);

if ($row = spip_fetch_array($result)) {
	$id_article = $row["id_article"];
	$surtitre = $row["surtitre"];
	$titre = $row["titre"];
	$soustitre = $row["soustitre"];
	$id_rubrique = $row["id_rubrique"];
	$descriptif = $row["descriptif"];
	$nom_site = $row["nom_site"];
	$url_site = $row["url_site"];
	$chapo = $row["chapo"];
	$texte = $row["texte"];
	$ps = $row["ps"];
	$date = $row["date"];
	$statut_article = $row["statut"];
	$maj = $row["maj"];
	$date_redac = $row["date_redac"];
	$visites = $row["visites"];
	$referers = $row["referers"];
	$extra = $row["extra"];
	$id_trad = $row["id_trad"];
}
*/

//----------FIN MODIFICATION CLEVER AGE

// pour l'affichage du virtuel
unset ($virtuel);
if (substr($chapo, 0, 1) == '=') {
	$virtuel = substr($chapo, 1);
}

if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})", $date_redac, $regs)) {
	$mois_redac = $regs[2];
	$jour_redac = $regs[3];
	$annee_redac = $regs[1];
	if ($annee_redac > 4000)
		$annee_redac -= 9000;
}

if (ereg("([0-9]{4})-([0-9]{2})-([0-9]{2})", $date, $regs)) {
	$mois = $regs[2];
	$jour = $regs[3];
	$annee = $regs[1];
}

debut_page("&laquo; $titre_article &raquo;", "documents", "articles");

debut_grand_cadre();
afficher_parents($articleMetier->getRubriqueId());
$parents = "~ <img src='img_pack/racine-site-24.gif' width=24 height=24 align='middle'> <A HREF='naviguer.php3?coll=0'><B>"._T('lien_racine_site')."</B></A> ".aide("rubhier")."<BR>".$parents;
$parents = ereg_replace("~", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $parents);
$parents = ereg_replace("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ", "", $parents);
echo "$parents";

fin_grand_cadre();

/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
// Mod par Johnny Muller
if ($statut_article == 'mappe' || $statut_article == 'map_off') {
	echo _T('avis_acces_interdit');
	fin_page();
	exit;
}
/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

//////////////////////////////////////////////////////
// Affichage de la colonne de gauche
//

debut_gauche();

debut_boite_info();

echo "<div align='center'>\n";

if ($statut_article == "publie") {
	$post_dates = lire_meta("post_dates");
	$voir_en_ligne = true;
	if ($post_dates == "non") {

		//---------MODIFICATION CLEVER AGE

		if ($articleMetier->isPostDated()) {
			$voir_en_ligne = false;
		}

		/*
		$query = "SELECT id_article FROM spip_articles WHERE id_article=$id_article AND date<=NOW()";
		$result = spip_query($query);
		if (!spip_num_rows($result)) {
			$voir_en_ligne = false;
		}
		*/

		//----------FIN MODIFICATION CLEVER AGE

	}
}

/*********** Modification elebescond@clever-age.com *********************/
echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'><b>"._T('art_info_numero_article', null, $articleMetier->getRubriqueId())."</b></font>\n";
/*
echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'><b>"._T('info_numero_article')."</b></font>\n";
*/
/*********** Fin modification elebescond@clever-age.com *********************/
echo "<br><font face='Verdana,Arial,Sans,sans-serif' size='6'><b>$id_article</b></font>\n";
if ($voir_en_ligne) {
	icone_horizontale(_T('icone_voir_en_ligne'), "../spip_redirect.php3?id_article=$id_article&recalcul=oui", "racine-24.gif", "rien.gif");
	//icone_horizontale(_T('icone_voir_en_pdf'), "../spip_redirect.php3?id_article_pdf=$id_article&recalcul=oui", "pdf-24.png", "rien.gif");
} else { 
    $authorization = & recuperer_instance_authorization('previsualiserArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
    if ($authorization->isAuthorizedAction()) 
      icone_horizontale(_T('icone_previsualiser'), "../spip_redirect.php3?id_article=$id_article&preview=oui", "racine-24.gif","rien.gif");
}

//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization( 'afficherSuiviForumArticle', 
                                                     $GLOBALS['connect_id_auteur'], 
                                                     array ('id_rubrique' => $articleMetier->getRubriqueId()) );
if ($authorization->isAuthorizedAction()) {
	/*
	if ($connect_statut=='minirezo' AND acces_rubrique($id_rubrique)) {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	//----------Modification Clever Age elebescond@clever-age.com-----------------
	$forumMetier = & recuperer_instance_forum();
	$nb_forums = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'publie', 'off', 'prop'");
	if (PEAR :: isError($nb_forums)) {
		die($nb_forums->getMessage());
	}
	if ($nb_forums) {
		icone_horizontale(_T('icone_suivi_forum', array ('nb_forums' => $nb_forums)), "controle_forum_suite.php3?affType=discussion&affMessage[]=tout&vierge=1&id_current_forum=$id_article&type_forum=article", "suivi-forum-24.gif", "");
	}
	/*
	$query = "SELECT count(*) AS count FROM spip_forum WHERE id_article=$id_article AND statut IN ('publie', 'off', 'prop')";
	if ($row = spip_fetch_array(spip_query($query))) {
		$nb_forums = $row['count'];
		if ($nb_forums) {
			icone_horizontale(_T('icone_suivi_forum', array('nb_forums' => $nb_forums)),
				"articles_forum.php3?id_article=$id_article", "suivi-forum-24.gif", "");
		}
	}
	*/
	//---------Fin modification Clever Age-------------------
}

$activer_statistiques = lire_meta("activer_statistiques");
$activer_statistiques_ref = lire_meta("activer_statistiques_ref");

if ($activer_statistiques == 'oui') {
    $authorization = & recuperer_instance_authorization('afficherIconeEvolutionVisites', $GLOBALS['connect_id_auteur'], array ('statut_article' => $statut_article, 'visites' => $visites, 'activer_statistiques' => $activer_statistiques, 'options' => $options));
    if ($authorization->isAuthorizedAction()) {
    	/*
    	if ($connect_statut == "minirezo" AND $statut_article == 'publie' AND $visites > 0 AND $activer_statistiques != "non" AND $options == "avancees") {
    	*/
    	//----------------FIN Zone de modifications Clever Age elebescond----------	
        if ($visites > 0)
        icone_horizontale(_T('icone_evolution_visites', array('visites' => $visites, 'aff_ref' => $aff_ref)), "statistiques_visites.php3?id_article=$id_article", "statistiques-24.gif","rien.gif");
    }
}
echo "</div>\n";
fin_boite_info();

// Gestion du versioning <avialet@clever-age.com>
// Boite de dialogue d'information sur la version parente
if ($activer_version_articles == 'oui') {
	if ($articleMetier->getVersionId() != 0) {
		debut_boite_info();
		$articleParent = &recuperer_instance_article();
		$articleParent->load($articleMetier->getVersionId());
		echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'><b>\n"
		._T('article_version_parent')."</b></font>";
		echo "<br><font face='Verdana,Arial,Sans,sans-serif' size='1'>\n"
		."<a href='articles.php3?id_article="
		.$articleParent->getArticleId()."'>"
		.$articleParent->getArticleId().". "
		.$articleParent->getTitre()
		."</a>";
		fin_boite_info();
	}
}
// Fin de la gestion du versionning <avialet@clever-age.com>


// Logos de l'article

$arton = "arton$id_article";
$artoff = "artoff$id_article";

// Chargement des contraintes sur l'article
$strErr = displayErrorMsg(getErrorMsg('article', $articleMetier));


/*********** Modification elebescond@clever-age.com *********************/
if ($id_article > 0 AND $flag_editable)
	afficher_boite_logo($arton, $artoff, _T('art_logo_article', null, $articleMetier->getRubriqueId()).aide("logoart"), _T('logo_survol'));
/*
if ($id_article>0 AND $flag_editable)
	afficher_boite_logo($arton, $artoff, _T('logo_article').aide ("logoart"), _T('logo_survol'));
*/
/*********** Fin modification elebescond@clever-age.com *********************/

//
// Boites de configuration avancee
//

//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization('afficherBoiteConfigurationAvancee', $GLOBALS['connect_id_auteur'], array ('options' => $options, 'flag_editable' => $flag_editable));
if ($authorization->isAuthorizedAction()) {
	/*
	if ($options == "avancees" && $connect_statut=='minirezo' && $flag_editable) {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	echo "<p>";
	debut_cadre_relief("forum-interne-24.gif");
	$visible = $change_accepter_forum || $change_petition;

	echo "<font size='2' FACE='Verdana,Arial,Sans,sans-serif'><center><b>";
	if ($visible)
		echo bouton_block_visible("forumpetition");
	else
		echo bouton_block_invisible("forumpetition");
	echo _T('bouton_forum_petition');
	echo "</b></center></font>";
	if ($visible)
		echo debut_block_visible("forumpetition");
	else
		echo debut_block_invisible("forumpetition");
    // !! ----------------------------------------------
	echo "<font face='Verdana,Arial,Sans,sans-serif' size='1'>\n";

	// Forums et petitions

	$forums_publics = get_forums_publics($id_article);

	if ($change_accepter_forum) {
		//-----------MODIFICATION CLEVER AGE
		$articleMetier->setAccepterForum($change_accepter_forum);
		$updateOK = $articleMetier->update();
		if (PEAR :: isError($updateOK)) {
			die($updateOK->getMessage());
		}
		/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		$mappings = $mapping->getMappings($articleMetier->getArticleId());
		if ( PEAR::isError($mappings) ) {
			die($mappings->getMessage());
		}
		else {
			for ($i = 0; $i < count($mappings); $i++) {
				$loadOK = $mappingMetier->load($mappings[$i]);
				if (PEAR :: isError($loadOK)) {
					die($loadOK->getMessage());
				} else {
					$mappingMetier->setAccepterForum($articleMetier->getAccepterForum());
					$updateOK = $mappingMetier->update();
					if (PEAR :: isError($updateOK)) {
						die($updateOK->getMessage());
					}
				}
			}
		}
		/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		/*
		$query_forum = "UPDATE spip_articles SET accepter_forum='$change_accepter_forum' WHERE id_article='$id_article'";
		$result_forum = spip_query($query_forum);
		*/
		//-----------FIN MODIFICATION CLEVER AGE
		$forums_publics = $change_accepter_forum;
		if ($change_accepter_forum == 'abo_posteriori' || $change_accepter_forum == 'abo_priori') {
			ecrire_meta('accepter_visiteurs', 'oui');
			ecrire_metas();
		}
	}

	echo "\n<form action='articles.php3' method='get'>";

	echo "\n<input type='hidden' name='id_article' value='$id_article'>";
	echo "<br>"._T('info_fonctionnement_forum')."\n";
	if ($forums_publics == "posteriori") {
		echo "<br><input type='radio' name='change_accepter_forum' value='posteriori' id='accepterforumpos' checked>";
		echo "<B><label for='accepterforumpos'> "._T('bouton_radio_modere_posteriori')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='posteriori' id='accepterforumpos'>";
		echo "<label for='accepterforumpos'> "._T('bouton_radio_modere_posteriori')."</label>";
	}
	if ($forums_publics == "priori") {
		echo "<br><input type='radio' name='change_accepter_forum' value='priori' id='accepterforumpri' checked>";
		echo "<B><label for='accepterforumpri'> "._T('bouton_radio_modere_priori')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='priori' id='accepterforumpri'>";
		echo "<label for='accepterforumpri'> "._T('bouton_radio_modere_priori')."</label>";
	}
	//-----------MODIFICATION elebescond@clever-age.com
	if ($forums_publics == "abo_priori") {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo_priori' id='accepterforumabopri' checked>";
		echo "<B><label for='accepterforumabopri'> "._T('bouton_radio_modere_abonnement_priori')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo_priori' id='accepterforumabopri'>";
		echo "<label for='accepterforumabopri'> "._T('bouton_radio_modere_abonnement_priori')."</label>";
	}
	if ($forums_publics == "abo_posteriori") {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo_posteriori' id='accepterforumabopos' checked>";
		echo "<B><label for='accepterforumabopos'> "._T('bouton_radio_modere_abonnement_posteriori')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo_posteriori' id='accepterforumabopos'>";
		echo "<label for='accepterforumabopos'> "._T('bouton_radio_modere_abonnement_posteriori')."</label>";
	}
	/*
	if ($forums_publics == "abo") {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo' id='accepterforumabo' checked>";
		echo "<B><label for='accepterforumabo'> "._T('bouton_radio_modere_abonnement')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='abo' id='accepterforumabo'>";
		echo "<label for='accepterforumabo'> "._T('bouton_radio_modere_abonnement')."</label>";
	}
	*/
	//-----------FIN MODIFICATION elebescond@clever-age.com
	if ($forums_publics == "non") {
		echo "<br><input type='radio' name='change_accepter_forum' value='non' id='accepterforumnon' checked>";
		echo "<B><label for='accepterforumnon'> "._T('info_pas_de_forum')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_accepter_forum' value='non' id='accepterforumnon'>";
		echo "<label for='accepterforumnon'> "._T('info_pas_de_forum')."</label>";
	}

	echo "<div align='right'><input type='submit' name='Changer' class='fondo' value='"._T('bouton_changer')."' STYLE='font-size:10px'></div>\n";
	echo "</form>";

	echo "<br>";

	// Petitions

	if ($change_petition) {
		if ($change_petition == "on") {
			if (!$email_unique)
				$email_unique = "non";
			if (!$site_obli)
				$site_obli = "non";
			if (!$site_unique)
				$site_unique = "non";
			if (!$message)
				$message = "non";

			$texte_petition = addslashes($texte_petition);

			//-------------MODIFICATION CLEVER AGE elebescond
			$petitionMetier = & recuperer_instance_petition();
			$petitionReplaceOK = $petitionMetier->replace($id_article, $email_unique, $site_obli, $site_unique, $message, $texte_petition);
			if (PEAR :: isError($petitionReplaceOK)) {
				die($petitionReplaceOK->getMessage());
			}
			/*
			$query_pet = "REPLACE spip_petitions (id_article, email_unique, site_obli, site_unique, message, texte) ".
				"VALUES ($id_article, '$email_unique', '$site_obli', '$site_unique', '$message', '$texte_petition')";
			$result_pet = spip_query($query_pet);
			*/
			//-------------FIN MODIFICATION

		} else
			if ($change_petition == "off") {
				//-------------MODIFICATION CLEVER AGE elebescond
				$petitionMetier = & recuperer_instance_petition();
				$deleteOK = $petitionMetier->delete($id_article);
				if (PEAR :: isError($deleteOK)) {
					die($deleteOK->getMessage());
				}
				/*
				$query_pet = "DELETE FROM spip_petitions WHERE id_article=$id_article";
				$result_pet = spip_query($query_pet);
				*/
				//-------------FIN MODIFICATION
			}
	}

	//-------------MODIFICATION CLEVER AGE elebescond
	$petitionMetier = & recuperer_instance_petition();
	$loadOK = $petitionMetier->load($id_article);
	if (PEAR :: isError($loadOK)) {
		if ($loadOK->getCode() != 99) {
			die($loadOK->getMessage());
		}
	} else {
		$petition = ($petitionMetier->getArticleId() == $id_article);
        //		$id_rubrique = $articleMetier->getRubriqueId();
		$email_unique = $petitionMetier->getEmailUnique();
		$site_obli = $petitionMetier->getSiteObli();
		$site_unique = $petitionMetier->getSiteUnique();
		$message_petition = $petitionMetier->getMessage();
		$texte_petition = $petitionMetier->getTexte();
	}
	/*
	$query_petition = "SELECT * FROM spip_petitions WHERE id_article=$id_article";
	$result_petition = spip_query($query_petition);
	$petition = (spip_num_rows($result_petition) > 0);
	
	while ($row = spip_fetch_array($result_petition)) {
		$id_rubrique=$row["id_article"];
		$email_unique=$row["email_unique"];
		$site_obli=$row["site_obli"];
		$site_unique=$row["site_unique"];
		$message=$row["message"];
		$texte_petition=$row["texte"];
	}
	*/
	//-------------FIN MODIFICATION

	echo "\n<FORM ACTION='articles.php3' METHOD='post'>";
	echo "\n<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";

	if ($petition) {
		echo "<input type='radio' name='change_petition' value='on' id='petitionon' checked>";
		echo "<B><label for='petitionon'>"._T('bouton_radio_petition_activee')."</label></B>";
		//-------------MODIFICATION CLEVER AGE elebescond
		$signatureMetier = & recuperer_instance_signature();
		$howManyArticlesOK = $signatureMetier->howManyArticles($id_article);
		if (PEAR :: isError($howManyArticlesOK)) {
			die($howManyArticlesOK->getMessage());
		}
		if ($howManyArticlesOK > 0) {
			echo "<p><font size=1><a href='controle_petition.php3?id_article=$id_article'>".$result['nb']." "._T('info_signatures')."</a></font>\n";
		}
		/*
		$query_signatures = "SELECT COUNT(*) AS nb FROM spip_signatures WHERE id_article=$id_article";
		$result = spip_fetch_array(spip_query($query_signatures));
		if ($result['nb'] > 0) {
			echo "<p><font size=1><a href='controle_petition.php3?id_article=$id_article'>".$result['nb']." "._T('info_signatures')."</a></font>\n";
		}
		*/
		//---------------FIN MODIFICATION CLEVER AGE

		echo "<p>";
		if ($email_unique == "oui")
			echo "<input type='checkbox' name='email_unique' value='oui' id='emailunique' checked>";
		else
			echo "<input type='checkbox' name='email_unique' value='oui' id='emailunique'>";
		echo " <label for='emailunique'>"._T('bouton_checkbox_signature_unique_email')."</label><BR>";
		if ($site_obli == "oui")
			echo "<input type='checkbox' name='site_obli' value='oui' id='siteobli' checked>";
		else
			echo "<input type='checkbox' name='site_obli' value='oui' id='siteobli'>";
		echo " <label for='siteobli'>"._T('bouton_checkbox_indiquer_site')."</label><BR>";
		if ($site_unique == "oui")
			echo "<input type='checkbox' name='site_unique' value='oui' id='siteunique' checked>";
		else
			echo "<input type='checkbox' name='site_unique' value='oui' id='siteunique'>";
		echo " <label for='siteunique'>"._T('bouton_checkbox_signature_unique_site')."</label><BR>";
		if ($message == "oui")
			echo "<input type='checkbox' name='message' value='oui' id='message' checked>";
		else
			echo "<input type='checkbox' name='message' value='oui' id='message'>";
		echo " <label for='message'>"._T('bouton_checkbox_envoi_message')."</label>";

		echo "<P>"._T('texte_descriptif_petition')."&nbsp;:<BR>";
		echo "<TEXTAREA NAME='texte_petition' CLASS='forml' ROWS='4' COLS='10' wrap=soft>";
		echo $texte_petition;
		echo "</TEXTAREA><P>\n";

	} else {
		echo "<input type='radio' name='change_petition' value='on' id='petitionon'>";
		echo "<label for='petitionon'>"._T('bouton_radio_activer_petition')."</label>";
	}
	if (!$petition) {
		echo "<br><input type='radio' name='change_petition' value='off' id='petitionoff' checked>";
		echo "<B><label for='petitionoff'>"._T('bouton_radio_pas_petition')."</label></B>";
	} else {
		echo "<br><input type='radio' name='change_petition' value='off' id='petitionoff'>";
		echo "<label for='petitionoff'>"._T('bouton_radio_supprimer_petition')."</label>";
	}

	echo "<P align='right'><INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."' STYLE='font-size:10px'>";
	echo "</FORM>";

	echo "</font>";
	echo fin_block();

	fin_cadre_relief();

	echo "<br>";

	// Redirection (article virtuel)
	debut_cadre_relief("site-24.gif");
	$visible = ($changer_virtuel || $virtuel);

	echo "<font size='2' FACE='Verdana,Arial,Sans,sans-serif'><center><b>";
	if ($visible)
		echo bouton_block_visible("redirection");
	else
		echo bouton_block_invisible("redirection");
	echo _T('bouton_redirection');
	echo aide("artvirt");
	echo "</b></center></font>";
	if ($visible)
		echo debut_block_visible("redirection");
	else
		echo debut_block_invisible("redirection");

	echo "<form action='articles.php3?id_article=$id_article' method='post'>";
	echo "\n<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";
	echo "\n<INPUT TYPE='hidden' NAME='changer_virtuel' VALUE='oui'>";
	$virtuelhttp = ($virtuel ? "" : "http://");

	echo "<INPUT TYPE='text' NAME='virtuel' CLASS='formo' style='font-size:9px;' VALUE=\"$virtuelhttp$virtuel\" SIZE='40'><br>";
	echo "<font face='Verdana,Arial,Sans,sans-serif' size=2>";
	/************* Modification elebescond@clever-age.com *******************/
	echo "(<b>"._T('art_texte_article_virtuel', null, $articleMetier->getRubriqueId() )."&nbsp;:</b> "._T('art_texte_reference_mais_redirige', null, $articleMetier->getRubriqueId() ).")";
	/*
	echo "(<b>"._T('texte_article_virtuel')."&nbsp;:</b> "._T('texte_reference_mais_redirige').")";
	*/
	/************* Fin modification elebescond@clever-age.com *******************/
	echo "</font>";
	echo "<div align='right'><INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."' STYLE='font-size:10px'></div>";
	echo "</form>";
	echo fin_block();

	fin_cadre_relief();
}


/************* Modification tbeaumanoir@clever-age.com *******************/
// Historique
$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
if ($authorization->isAuthorizedAction()) {
    if ($activer_histo_articles == 'oui') {
        debut_cadre_relief("article_history-24.png");
    	$visible = ($changer_virtuel || $virtuel);

        echo "<font size='2' FACE='Verdana,Arial,Sans,sans-serif'><center><b>";
        if ($visible)
            echo bouton_block_visible("historique");
        else
            echo bouton_block_invisible("historique");
        echo _T('bouton_historique');
        echo "</b></center></font>";
        if ($visible)
            echo debut_block_visible("historique");
        else
            echo debut_block_invisible("historique");

        echo "<form action='articles.php3?id_article=$id_article' method='post'>";
        echo "\n<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";
	
        $activerhistorique = $articleMetier->getActiverHistorique();

        echo '<font face="Verdana,Arial,Sans,sans-serif" size="1">';
        if ($activerhistorique == "oui") {
            echo '<input type="radio" name="activerhistorique" value="oui" id="activerhistorique" checked="checked">';
            echo ' <label for="activerhistorique"><b>'._T('bouton_radio_historique_activer').'</b></label><br />';
        } else {
        echo '<input type="radio" name="activerhistorique" value="oui" id="activerhistorique">';
        echo ' <label for="activerhistorique">'._T('bouton_radio_historique_activer').'</label><br />';
        }
        if ($activerhistorique != "oui") {
	       echo '<input type="radio" name="activerhistorique" value="non" id="desactiverhistorique" checked="checked">';
            echo ' <label for="desactiverhistorique"><b>'._T('bouton_radio_historique_desactiver').'</b></label><br />';     
        } else {
            echo '<input type="radio" name="activerhistorique" value="non" id="desactiverhistorique">';
            echo ' <label for="desactiverhistorique">'._T('bouton_radio_historique_desactiver').'</label><br />';
        }
        echo '</font>';	
        echo "<div align='right'><INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."' STYLE='font-size:10px'></div>";

        echo "</form>";
        echo fin_block();
        fin_cadre_relief(); 
    }
}        
	/************* Fin modification tbeaumanoir@clever-age.com *******************/


//
// Afficher les raccourcis
//

debut_raccourcis();
icone_horizontale(_T('icone_tous_articles'), "articles_page.php3", "article-24.gif");
//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization('afficherRaccourcis', $GLOBALS['connect_id_auteur'], array ('rubrique_article' => $rubrique_article, 'options' => $options));
if ($authorization->isAuthorizedAction()) {
	/*
	if ($connect_statut == 'minirezo' AND acces_rubrique($rubrique_article) AND $options == "avancees") {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	$retour = urlencode($clean_link->getUrl());
	/**************** Modification elebescond@clever-age.com *****************/
    $authorization = & recuperer_instance_authorization('ajouterAuteurArticle', $GLOBALS['connect_id_auteur']);
    if ($authorization->isAuthorizedAction())
	    icone_horizontale(_T('art_icone_creer_auteur'), "auteur_infos.php3?new=oui&ajouter_id_article=$id_article&redirect=$retour", "redacteurs-24.gif", "creer.gif");
	/*
	icone_horizontale(_T('icone_creer_auteur'), "auteur_infos.php3?new=oui&ajouter_id_article=$id_article&redirect=$retour", "redacteurs-24.gif", "creer.gif");
	*/
	/**************** Fin modification elebescond@clever-age.com *****************/

	$articles_mots = lire_meta('articles_mots');
	/**************** Modification elebescond@clever-age.com *****************/
	if ($articles_mots != "non")
		icone_horizontale(_T('art_icone_creer_mot_cle', null, $articleMetier->getRubriqueId()), "mots_edit.php3?new=oui&ajouter_id_article=$id_article&redirect=$retour", "mot-cle-24.gif", "creer.gif");
	/*
	if ($articles_mots != "non")
		icone_horizontale(_T('icone_creer_mot_cle'), "mots_edit.php3?new=oui&ajouter_id_article=$id_article&redirect=$retour", "mot-cle-24.gif", "creer.gif");
	*/
	/**************** Fin modification elebescond@clever-age.com *****************/
}

fin_raccourcis();

//////////////////////////////////////////////////////
// Affichage de la colonne de droite
//

debut_droite();


if ($strErr) {
	debut_cadre_relief();
	// Ajout Aurelien Vialet <avialet@clever-age.com> Gestion des erreur sur les champs/Gestion des champs de formulaires
	echo $strErr;
	// Fin de l'ajout Aurelien Vialet
	fin_cadre_relief();
}

changer_typo('', 'article'.$id_article);

// qu'est-ce que c'est que ces choses ??

function mySel($varaut, $variable) {
	$retour = " VALUE=\"$varaut\"";
	if ($variable == $varaut) {
		$retour .= " SELECTED";
	}
	return $retour;
}

function my_sel($num, $tex, $comp) {
	if ($num == $comp) {
		echo "<OPTION VALUE='$num' SELECTED>$tex\n";
	} else {
		echo "<OPTION VALUE='$num'>$tex\n";
	}

}

function afficher_mois($mois) {
	my_sel("00", _T('mois_non_connu'), $mois);
	my_sel("01", _T('date_mois_1'), $mois);
	my_sel("02", _T('date_mois_2'), $mois);
	my_sel("03", _T('date_mois_3'), $mois);
	my_sel("04", _T('date_mois_4'), $mois);
	my_sel("05", _T('date_mois_5'), $mois);
	my_sel("06", _T('date_mois_6'), $mois);
	my_sel("07", _T('date_mois_7'), $mois);
	my_sel("08", _T('date_mois_8'), $mois);
	my_sel("09", _T('date_mois_9'), $mois);
	my_sel("10", _T('date_mois_10'), $mois);
	my_sel("11", _T('date_mois_11'), $mois);
	my_sel("12", _T('date_mois_12'), $mois);
}

function afficher_annee($annee) {
	// Cette ligne permettrait de faire des articles sans date de publication
	// my_sel("0000","n.c.",$annee);

    if ($annee == '0000') my_sel("0000","n.c.",$annee);

	if ($annee < 1996 AND $annee <> 0) {
		echo "<OPTION VALUE='$annee' SELECTED>$annee\n";
	}
    my_sel("0000","n.c.",$annee);
	for ($i = 1996; $i < date(Y) + 4; $i ++) {
		my_sel($i, $i, $annee);
	}
}

function afficher_jour($jour) {
	my_sel("00", _T('jour_non_connu_nc'), $jour);
	for ($i = 1; $i < 32; $i ++) {
		if ($i < 10) {
			$aff = "&nbsp;".$i;
		} else {
			$aff = $i;
		}

        $d = strlen($i) == 1 ? '0'.$i : $i;
		my_sel( $d , $aff, $jour );
	}
}

function afficher_heure( $heure ) {
    my_sel( '', _T('heure_non_connu_nc'), $heure );
    for ( $i = 0; $i < 24; $i++ ) {
        $h = strlen($i) == 1 ? '0'.$i : $i;
        my_sel( $h, $h, $heure );
    }
}

function afficher_minute( $minute ) {
    my_sel( '', _T('minute_non_connu_nc'), $minute );
    for ( $i = 0; $i < 60; $i++ ) {
        $m = strlen($i) == 1 ? '0'.$i : $i;
        my_sel( $m, $m, $minute );
    }
}

debut_cadre_relief();
echo "<CENTER>";

//
// Titre, surtitre, sous-titre
//

if ($statut_article == 'publie') {
	$logo_statut = "puce-verte.gif";
} else // TODO : un bon switch case fera l'affaire
	if ($statut_article == 'prepa') {
		$logo_statut = "puce-blanche.gif";
	} else
		if ($statut_article == 'prop') {
			$logo_statut = "puce-orange.gif";
		} else
			if ($statut_article == 'valid') {
				$logo_statut = "puce-jaune.gif";
			} else
				if ($statut_article == 'archi') {
					$logo_statut = "puce-marron.gif";
				} else
					if ($statut_article == 'refuse') {
						$logo_statut = "puce-rouge.gif";
					} else
						if ($statut_article == 'poubelle') {
							$logo_statut = "puce-poubelle.gif";
						}

echo "\n<table cellpadding=0 cellspacing=0 border=0 width='100%'>";
echo "<tr width='100%'><td width='100%' valign='top'>";
if ($surtitre) {
	echo "<span $dir_lang><font face='arial,helvetica' size=3><b>";
	echo typo($surtitre);
	echo "</b></font></span>\n";
}
gros_titre($titre, $logo_statut);

if ($soustitre) {
	echo "<span $dir_lang><font face='arial,helvetica' size=3><b>";
	echo typo($soustitre);
	echo "</b></font></span>\n";
}

// TODO : c'est super moche !
$nom_site = $articleMetier->getNomSite();
$url_site = $articleMetier->getUrlSite();
if ($descriptif OR $url_site OR $nom_site) {
	echo "<p><div align='left' style='padding: 5px; border: 1px dashed #aaaaaa; background-color: #e4e4e4;' $dir_lang>";
	echo "<font size=2 face='Verdana,Arial,Sans,sans-serif'>";
	/********** Modification elebescond@clever-age.com ********************/
	$texte_case = ($descriptif) ? "{{"._T('art_info_descriptif', null, $articleMetier->getRubriqueId())."}} $descriptif\n\n" : '';
	/*
	$texte_case = ($descriptif) ? "{{"._T('info_descriptif')."}} $descriptif\n\n" : '';
	*/
	/********** Fin modification elebescond@clever-age.com ********************/
	$texte_case .= ($nom_site.$url_site) ? "{{"._T('info_urlref')."}} [".$nom_site."->".$url_site."]" : '';
	echo propre($texte_case);
	echo "</font>";
	echo "</div>";
}

if ($statut_article == 'prop') {
	/********** Modification elebescond@clever-age.com ********************/
	echo "<P><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2 COLOR='red'><B>"._T('art_text_article_propose_publication', null, $articleMetier->getRubriqueId())."</B></FONT></P>";
	/*
	echo "<P><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2 COLOR='red'><B>"._T('text_article_propose_publication')."</B></FONT></P>";
	*/
	/********** Fin modification elebescond@clever-age.com ********************/
}

echo "</td>";

// Ajout Aurelien Vialet <avialet@clever-age.com> 
// Nouvelle version d'un article
if ($activer_version_articles == 'oui') {
	if ((true) && ($articleMetier->getVersionId() == 0)) {
		// Ici il faudra verifier si il y a des droits pour creer une nouvelle 
		// Version de l'article
		echo "<td><img src='img_pack/rien.gif' width=5></td>\n";
		echo "<td align='center'>";
		icone(_T("nouvelle_version_article"), "articles_edit.php3?id_article=$id_article&id_article_historique=$id_article&new_version=oui", "article_new_version-24.png", "edit.gif");
		echo "</td>";
	}
}
// Fin de l'ajout Aurelien Vialet <avialet@clever-age.com>

/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
echo "<td><img src='img_pack/rien.gif' width=5></td>\n";
if ( ( $options == 'basiques' ) && ( lire_meta("activer_mapping_articles") == 'oui' ) ) {
	echo "<td align='center' valign='top'>";
	icone(_T("mapping_article"), "mapping_edit.php3?id_article=$id_article", "mapping.gif", "");
	echo "</td>";
}
/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

if ($flag_editable) {
	echo "<td><img src='img_pack/rien.gif' width=5></td>\n";
	echo "<td align='center'>";
	//-----------MODIFICATION CLEVER AGE-----------
	if (lire_meta('articles_modif') != 'non') {
		$flag_modif = !($articleMetier->hasLastModified($connect_id_auteur));
		$date_diff = $articleMetier->whenWasModified();
		$auteur_modif = $articleMetier->getAuteurModif();
		if ($flag_modif) {
			$nom_auteur_modif = $articleMetier->getLastModifiedUserName();
		}

	}


	$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction()) {

		/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_article == 'mappe') {
			icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			if ($flag_modif) {
				echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_mapping_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
				echo aide("artmodif");
			}
		}
		else {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			if ($flag_modif) {
				echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_article_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
				echo aide("artmodif");
			}
		}
		/*
		if ($flag_modif) {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			echo "<font face='arial,helvetica,sans-serif' size='2'>"._T('avis_article_modifie', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff))."</font>";
			echo aide("artmodif");
		} else {
			icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
		}
		*/
		/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	}
	echo "</td>";
}
echo "</tr></table>\n";

echo "<div class='serif' align='left'>";

/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
if ( ( $options == 'avancees' ) && ( lire_meta("activer_mapping_articles") == 'oui' ) ) {
	require_once (dirname(__FILE__)."/include/bd/inc_metier_factory.php");
	$dbMetier = &recuperer_instance_metier();
	$db = &$dbMetier->_getDB();

	debut_cadre_enfonce();
	echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
	echo "<TR><TD BGCOLOR='$couleur_foncee'>";
	echo "<FONT SIZE=1 COLOR='#FFFFFF'><B>MAPPING</B></FONT>";
	echo "</TD></TR></TABLE>";
	echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
	echo '<tr><td bgcolor="#cccccc" colspan="2"><font size="1" color="#000000" face="Verdana,Arial,Sans,sans-serif">';
	echo bouton_block_invisible('addmapping');
	echo _T('titre_cadre_interieur_ajout_mapping')."</font></td></tr></table>";
	echo debut_block_invisible('addmapping');
	echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
	echo '<tr><td align="left">';
    //echo '<a href="#" onclick="window.open(\'brouteur_select_rubrique.php3?id_rubrique=0\', \'changer_rubrique\', \'width=900,height=450, scrollbars=yes\')">choisir une rubrique</a>';
    echo '</td></tr>';
	echo "<tr><td align='right'>"._T('entree_mapping_ajouter_rubriques')."</td></tr>";
	echo "<FORM ACTION='do_mapping.php3' METHOD='post' name='formulaire'><tr><td align=center valign=middle>";
	echo "<input type='HIDDEN' name='id_rubrique' value='0'>";
	echo "<input type='hidden' name='id_action' value='1'>";
	echo "<input type='hidden' name='id_article' value=$id_article>";
	echo "<input type='text' CLASS='fondl' style='size: 250px;' NAME='lbl_current_rubrique_info' readonly value='' onclick=\"window.open('brouteur_select_rubrique.php3?id_rubrique=0', 'changer_rubrique', 'width=900,height=450, scrollbars=yes');\">";
	echo "&nbsp;&nbsp;<input type=submit CLASS='fondo' value='"._T('bouton_enregistrer')."'>";
	echo "</td></tr></table></form>";
	echo fin_block();
	echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
	echo '<tr><td bgcolor="#cccccc" colspan="2"><font size="1" color="#000000" face="Verdana,Arial,Sans,sans-serif">';
	echo bouton_block_invisible('listmapping');
	echo _T('titre_cadre_interieur_liste_mapping')."</font></td></tr></table>";
	echo debut_block_invisible('listmapping');
	echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
	echo '<tr><td align="left">';
	echo "<form name='mapping' method=post action='do_mapping.php3'>";
	echo ""._T('entree_mapping_liste_rubriques')."</td></tr>";
	echo "<tr><td align=center valign=middle><select name='id_map' CLASS='fondl' style='size: 250px;'>";
	$query = "SELECT map.id_map, rubriques.titre, rubriques.id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques rubriques, ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_articles_mapping map WHERE map.id_article = $id_article AND map.id_map = articles.id_article AND rubriques.id_rubrique = articles.id_rubrique";
	$result = $db->query($query);
	$rubriqueMetier = &recuperer_instance_rubrique();
	while($row = $result->fetchRow()) {
		$chemin = "";
		$id_rubrique_courante = $row['id_rubrique'];
		while ($id_rubrique_courante != 0) {
			$loadOK = $rubriqueMetier->load($id_rubrique_courante);
			if(PEAR::isError($loadOK)) {
				die($loadOK->getMessage());
			}
			$chemin = "/".ereg_replace("^[[:space:]]*[0-9]+[.)".chr(176)."][[:space:]]+", "", $rubriqueMetier->getTitre()) . $chemin;
			$id_rubrique_courante = $rubriqueMetier->getParentId();
		}
		if (strlen($chemin) > 60) 
			$chemin = substr($chemin,0,30) . "..." . substr($chemin,-30);
		echo "<option id='".$row['id_rubrique']."' value='".$row['id_map']."'>$chemin</option>";
		//echo "<option id='".$row['id_rubrique']."' value='".$row['id_map']."'>".$row['titre']."</option>";
	}
	$result->free();
	echo "</select><br/><input type=submit CLASS='fondo' value='"._T('bouton_supprimer')."'>";
	echo "&nbsp;&nbsp;&nbsp;<input type=button CLASS='fondo' value='"._T('bouton_consulter')."' onclick='document.location.href=\"naviguer.php3?coll=\"+document.mapping.id_map[document.mapping.id_map.selectedIndex].id'>";
	echo "<input type='hidden' name='id_action' value='0'>";
	echo "<input type='hidden' name='id_article' value=$id_article>";
	echo "</td></tr></table>";
	echo "</form>";
	echo fin_block();
	
	fin_cadre_enfonce();
}
/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

//
// Affichage date redac et date publi
//

if ($flag_editable AND $options == 'avancees') {
	debut_cadre_enfonce();

	echo "<FORM ACTION='articles.php3' METHOD='get'>";
	echo "<INPUT TYPE='hidden' NAME='id_article' VALUE='$id_article'>";

	/* Modification Clever Age, elebescond */
	$authorization = & recuperer_instance_authorization('modifierDatePublicationArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction()) {
        if ( $datetime = $articleMetier->getDate() ) {
            list($date, $time) = explode( ' ', $datetime );
            list($annee, $mois, $jour) = explode( '-', $date );
            list($heure, $minute, $seconde) = explode( ':', $time );
            $heure = $heure ? $heure : '00';
            $minute = $minute ? $minute : '00';
        }

		/* Fin Modification Clever Age */
		echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
		echo "<TR><TD BGCOLOR='$couleur_foncee' COLSPAN=2><FONT SIZE=1 COLOR='#FFFFFF'><B>"._T('texte_date_publication_article');
		echo aide("artdate");
		echo "</B></FONT></TD></TR>";
		echo "<TR><TD ALIGN='center'>";
		echo "<SELECT NAME='jour' SIZE=1 CLASS='fondl'>";
		afficher_jour($jour);
		echo "</SELECT> ";
		echo "<SELECT NAME='mois' SIZE=1 CLASS='fondl'>";
		afficher_mois($mois);
		echo "</SELECT> ";
		echo "<SELECT NAME='annee' SIZE=1 CLASS='fondl'>";
		afficher_annee($annee);
		echo "</SELECT>";
        if ( lire_meta('activer_horaire_publication_etendu') == 'oui' ) {
            echo "<br /><SELECT NAME='heure' SIZE=1 CLASS='fondl'>";
            afficher_heure($heure);
            echo "</SELECT> ";
            echo "<SELECT NAME='minute' SIZE=1 CLASS='fondl'>";
            afficher_minute($minute);
            echo "</SELECT> ";
        }
		echo "</TD><TD ALIGN='right'>";
		echo "<INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."'>";
		echo "</TD></TR></TABLE>";
	} else {
		echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
		/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
		if ($statut_article == 'mappe')
			echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_mapping')." : ";
		else
			echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_article')." : ";
		//echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_creation_article')." : ";
		/******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
         		echo majuscules(affdate($date))."</font></B></FONT>".aide('artdate')."</TD></TR>";
		//echo majuscules(affdate_base($date, 'complet'))."</font></B></FONT>".aide('artdate')."</TD></TR>";
  		echo "</TABLE>";
	}

   

	/* Modification Clever Age, elebescond */
	$authorization = & recuperer_instance_authorization('modifierDateAnterieurPublicationArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		/* Fin Modification Clever Age */
		if (($options == 'avancees' AND $articles_redac != 'non') OR ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')) {
			echo '<p><table cellpadding="5" cellspacing="0" border="0" width="100%">';
			echo '<tr><td bgcolor="#cccccc" colspan="2"><font size="1" color="#000000" face="Verdana,Arial,Sans,sans-serif">';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')
				$date_affichee = ' : '.majuscules(affdate($date_redac));
			echo bouton_block_invisible('dateredac');
			echo "<b>"._T('texte_date_publication_anterieure').$date_affichee."</b></font></td></tr></table>";
			echo debut_block_invisible('dateredac');
			echo '<table cellpadding="5" cellspacing="0" border="0" width="100%">';
			echo '<tr><td align="left">';
			echo '<input type="radio" name="avec_redac" value="non" id="avec_redac_on"';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac == '0000-00-00')
				echo ' checked="checked"';
			echo ' /> <label for="avec_redac_on">'._T('texte_date_publication_anterieure_nonaffichee').'</label>';
			echo '<br /><input type="radio" name="avec_redac" value="oui" id="avec_redac_off"';
			if ($annee_redac.'-'.$mois_redac.'-'.$jour_redac != '0000-00-00')
				echo ' checked="checked"';
			echo ' /> <label for="avec_redac_off">'._T('bouton_radio_afficher').' :</label> ';

			echo '<select name="jour_redac" class="fondl">';
			afficher_jour($jour_redac);
			echo '</select> &nbsp;';
			echo '<select name="mois_redac" class="fondl">';
			afficher_mois($mois_redac);
			echo '</select> &nbsp;';
			echo '<input type="text" name="annee_redac" class="fondl" value="'.$annee_redac.'" size="5" maxlength="4" />';

			echo '</td><td align="right">';
			echo '<input type="submit" name="Changer" class="fondo" value="'._T('bouton_changer').'" />';
			echo aide('artdate_redac');
			echo '</td></tr>';
			echo '</table>';
			echo fin_block();
		}


    
    
     // date d'expiration
    if (lire_meta('activer_expiration') == 'oui') {
        $authorization = & recuperer_instance_authorization('modifierDateExpirationArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
        if ($authorization->isAuthorizedAction()) {
            if ( $datetime = $articleMetier->getExpirationDate() ) {
                // bof
                // if (is_null($datetime)) $datetime = '0000-00-00 00:00';
                list($date_exp, $time_exp) = explode( ' ', $datetime );
                list($annee, $mois, $jour) = explode( '-', $date_exp );
                list($heure, $minute, $seconde) = explode( ':', $time_exp );
                $heure = $heure ? $heure : '00';
                $minute = $minute ? $minute : '00';
            } else {
                $jour = $mois = $heure = $minute = '00';
                $annee = '0000';
            }
            echo '<br />';
            echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
            echo "<TR><TD BGCOLOR='$couleur_foncee' COLSPAN=2><FONT SIZE=1 COLOR='#FFFFFF'><B>"._T('texte_date_expiration_article');
            //echo aide("artdate");
            echo "</B></FONT></TD></TR>";
            echo "<TR><TD ALIGN='center'>";
            echo "<SELECT NAME='jour_expiration' SIZE=1 CLASS='fondl'>";
            afficher_jour($jour);
            echo "</SELECT> ";
            echo "<SELECT NAME='mois_expiration' SIZE=1 CLASS='fondl'>";
            afficher_mois($mois);
            echo "</SELECT> ";
            echo "<SELECT NAME='annee_expiration' SIZE=1 CLASS='fondl'>";
            afficher_annee($annee);
            echo "</SELECT>";
            if ( lire_meta('activer_horaire_publication_etendu') == 'oui' ) {
                echo "<br /><SELECT NAME='heure_expiration' SIZE=1 CLASS='fondl'>";
                afficher_heure($heure);
                echo "</SELECT> ";
                echo "<SELECT NAME='minute_expiration' SIZE=1 CLASS='fondl'>";
                afficher_minute($minute);
                echo "</SELECT> ";
            }
            echo "</TD><TD ALIGN='right'>";
            echo "<INPUT TYPE='submit' NAME='Changer' CLASS='fondo' VALUE='"._T('bouton_changer')."'>";
            echo "</TD></TR></TABLE>";
        } else {
            if ($date_expiration) {
                echo "<TABLE CELLPADDING=5 CELLSPACING=0 BORDER=0 WIDTH=100% BACKGROUND=''>";
                echo "<TR><TD BGCOLOR='$couleur_foncee'><FONT SIZE=1 COLOR='#FFFFFF' face='Verdana,Arial,Sans,sans-serif'><b>"._T('texte_date_expiration_article')." : ";
                echo majuscules(affdate($date_expiration))."</font></B></FONT>".aide('artdate')."</TD></TR>";
                //echo majuscules(affdate_base($date, 'complet'))."</font></B></FONT>".aide('artdate')."</TD></TR>";
                echo "</TABLE>";
            }
        }
    }
    
        echo "</FORM>";
    
	fin_cadre_enfonce();
} else
	if ($statut_article == 'publie') {
		echo "<CENTER>".affdate($date)."</CENTER><P>";
	}


// Modification Aurelien Vialet <avialet@clever-age.com>
// Gestion du versionning des articles
if ($activer_version_articles == 'oui') {

	if ($articleMetier->getVersionId() == 0) {
	   $aArticlesVersion = $articleMetier->getAllForVersion(' id_article');
       if (count($aArticlesVersion) > 0) {
		debut_cadre_enfonce("article_new_version-24.png");
	
		echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
		if ($flag_editable AND $options == 'avancees') {
			echo bouton_block_invisible("versionarticle");
		}
		echo "<B>"._T('article_version')."</B>";
		echo aide("#");
		echo "</TD></TR></TABLE>";
		echo debut_block_invisible("versionarticle");
		echo "<table bgcolor='#FFFFFF' width='100%'>";
		while (list (, $val) = each($aArticlesVersion)) {
			echo "<tr>";
			echo "<td class='arial2'>".majuscules(affdate($val->getDate()))."</td>";
			echo "<td class='arial2'><a href='articles.php3?id_article="
			.$val->getArticleId()."'>"
			.$val->getArticleId().". "
			.$val->getTitre()
			."</a></td>";
			echo "</tr>";
		}
		echo "</table>";
		
		fin_cadre_enfonce();
        }
	}
}
//
// Fin de la gestion des versions de l'article
//


//
// Gestion des historique d'une version d'un article
//
if ($options == 'avancees') {
if (($activer_histo_articles == 'oui') and ($articleMetier->getActiverHistorique() == 'oui') and $articleMetier->countHistorique() > 0) {
	$articleHisto = & recuperer_instance_article_historique();
	if (isset($articleHistoPurge)) {
		$articleHisto->purgeHisto($articleHistoPurge);
	}
	$aArticlesHisto = $articleHisto->loadHistoForArticle($articleMetier->getArticleId());
	
	debut_cadre_enfonce("article_history-24.png");
	echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
//	if ($flag_editable AND $options == 'avancees') {
			echo bouton_block_invisible("historiquearticle");
//}
	echo "<B>"._T('article_historique')."</B>";
	echo aide("#");
	echo "</TD></TR></TABLE>";
	echo debut_block_invisible("historiquearticle");
	
	//if (count($aArticlesHisto) > 0) {
    echo "<table bgcolor='#FFFFFF' width='100%' border=0>";
    if ($flag_editable) {
        echo '<form action"articles.php3" method="get">';
        echo '<input type="hidden" name="id_article" value="'.$articleMetier->getArticleId().'" >';
    }
    //$first = true;
    foreach ( $aArticlesHisto as $histo ) {
        // En cas d'erreur...
        if ( PEAR::isError($histo) ) { die( $histo->getMessage() ); }

        // Rcupration de l'auteur de l'article
        $auteur_histo =& recuperer_instance_auteur();
        $status = $auteur_histo->load( $histo->getAuteurId() );
        
        if ( PEAR::isError($status) ) {
            $str_auteur = 'Auteur inconnu';
        } else {
            $str_auteur = "<a href=\"".$auteur_histo->getUrl()."\">". $auteur_histo->getNom()."</a>";
        }
       
        echo "<tr>";
        echo "<td class='arial2'>".affdate_base($histo->getDate(), 'complet')
            ." par ". $str_auteur .'</td>';
        echo "<td class='arial2'><a href='articles_texte_compare.php3?id_article="
            .$articleMetier->getArticleId()."&id_article_historique=".$histo->getArticleHistoriqueId()."'>"._T('comparer')."</a> ";
        echo "<td class='arial2'><a href='articles_texte_compare.php3?id_article_historique=".$histo->getArticleHistoriqueId()."'>"._T('voir')."</a> ";
        //echo "<a href='articles.php3?id_article=".$articleMetier->getArticleId()."&id_article_historique_replace=".$histo->getArticleHistoriqueId()."'>"._T('remplacer')."</a> ";
        if ($flag_editable) {
            echo "<td><input name='articleHistoPurge[]' type='checkbox' value='".$histo->getArticleHistoriqueId()."'></td>";
        }
        echo "</tr>";
			// }
    }
    echo "<tr>";
    if ($flag_editable) {
    echo '<td colspan="2" align="right"></td>'.
        '<td>'.
        '<input type="submit" name="Purger" class="fondo" value="'._T('bouton_purger').'" />'.
        '</td>'.
        '</tr>'.
        '</form>';
    }
    echo "</table>";
	//}
    fin_cadre_enfonce();
}
}

//
// Fin de la gestion de l'historique d'une version de l'article
//

//
// Liste des auteurs de l'article
//

echo "<a name='auteurs'></a>";
debut_cadre_enfonce("redacteurs-24.gif");

echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
if ($flag_editable AND $options == 'avancees') {
	echo bouton_block_invisible("auteursarticle");
}
echo "<B>"._T('texte_auteurs')."</B>";
echo aide("artauteurs");
echo "</TD></TR></TABLE>";
//fxlacroix
/*$auteurCourant = &recuperer_instance_auteur();
$auteurCourant->load($GLOBALS['connect_id_auteur']);
$result = $auteurCourant->getAllAuteurTable($auteurCourant->getProfil());

echo "<FORM action='' method='POST'>";
echo "<div name='AfficheAuteur' >";
echo "<SELECT name='id_auteur'>";

foreach($result as $sAuteurVisible){
	$auteurAutre = &recuperer_instance_auteur();
	$auteurAutre->load($sAuteurVisible);
	var_dump($auteurAutre);
	echo "	<OPTION value='".$auteurAutre->getAuteurId()."' >".$auteurAutre->getNom; 
	echo "	</OPTION>";
}
echo "</div>";
echo "</SELECT>";
echo "<input type='submit' name='submit' value='ajouterAuteur' />";
echo "</FORM>";*/
//fin fxlacroix


////////////////////////////////////////////////////
// Gestion des auteurs
//

// Creer un nouvel auteur et l'ajouter
//----------------Zone de modifications Clever Age elebescond@clever-age.com----------

$authorization = & recuperer_instance_authorization('creerNouvelAuteurArticle', $GLOBALS['connect_id_auteur'], array ('creer_auteur' => $creer_auteur));
//var_dump($authorization);

if ($authorization->isAuthorizedAction()) {
	
	/*
	if ($creer_auteur AND $connect_statut=='minirezo') {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	$creer_auteur = addslashes($creer_auteur);
	//-----------Zone de modification Clever Age elebescond---------------
	
	$auteurMetier->setNom($creer_auteur);
	$auteurMetier->setStatut('comite');
	$profilMetier = & recuperer_instance_profil();
	$loadOK = $profilMetier->getProfilForIntitule('item_redacteur');
	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	}
	$auteurMetier->setProfil($profilMetier->getPoids());
	$createOK = $auteurMetier->create();

	if (PEAR :: isError($createOK)) {
		die($createOK->getMessage());
	}

	$nouv_auteur = $auteurMetier->getAuteurId();
	/*
	$query_creer = "INSERT INTO spip_auteurs (nom, statut) VALUES (\"$creer_auteur\", 'comite')";
	$result_creer = spip_query($query_creer);
	$nouv_auteur = spip_insert_id();
	*/
	//-----------Fin Modifications Clever Age -----------
	$ajout_auteur = true;
}

//
// Recherche d'auteur
//

if ($cherche_auteur) { // TODO : fct jamais teste
	echo "<P ALIGN='left'>";

	//-----------Zone de modification Clever Age elebescond---------------

	$allAuteurs = $auteurMetier->getAllAuteurs();

	if (PEAR :: isError($allAuteurs)) {
		die($allAuteurs->getMessage());
	}

	unset ($table_auteurs);
	unset ($table_ids);
	$authorization = & recuperer_instance_authorization('isAuthorizedToManageAuteur', $GLOBALS['connect_id_auteur'], array ('id_auteur_slave' => $monAuteur->getAuteurId()));
	while (list (, $monAuteur) = each($allAuteurs)) {
		if ($authorization->isAuthorizedAction()) {
			echo '1'; // ???? strange non !
			$table_auteurs[] = $monAuteur->getNom();
			$table_ids[] = $monAuteur->getAuteurId();
		}
	}
	/*
	$query = "SELECT id_auteur, nom FROM spip_auteurs";
	$result = spip_query($query);
	unset($table_auteurs);
	unset($table_ids);
	while ($row = spip_fetch_array($result)) {
		$table_auteurs[] = $row["nom"];
		$table_ids[] = $row["id_auteur"];
	}
	*/
	//-----------Fin Modifications Clever Age -----------

	$resultat = mots_ressemblants($cherche_auteur, $table_auteurs, $table_ids);
	debut_boite_info();

	if (!$resultat) {
		echo "<B>"._T('texte_aucun_resultat_auteur', array ('cherche_auteur' => $cherche_auteur)).".</B><BR>";
	} else
		if (count($resultat) == 1) {
			$ajout_auteur = 'oui';
			list (, $nouv_auteur) = each($resultat);
			echo "<B>"._T('texte_ajout_auteur')."</B><BR>";

			//-------------MODIFICATION CLEVER AGE elebescond
			// $auteurMetier = & recuperer_instance_auteur();
			$loadOK = $auteurMetier->load($nouv_auteur);
			echo "<UL>";
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			} else {
				$id_auteur = $auteurMetier->getAuteurId();
				$nom_auteur = $auteurMetier->getNom();
				$email_auteur = $auteurMetier->getEmail();
				$bio_auteur = $auteurMetier->getBio();
				;
				echo "<LI><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B><FONT SIZE=3>$nom_auteur</FONT></B>";
				echo "</FONT>\n";
			}
			/*
			$query = "SELECT * FROM spip_auteurs WHERE id_auteur=$nouv_auteur";
			$result = spip_query($query);
			echo "<UL>";
			while ($row = spip_fetch_array($result)) {
				$id_auteur = $row['id_auteur'];
			    $nom_auteur = $row['nom'];
			    $email_auteur = $row['email'];
			    $bio_auteur = $row['bio'];
			
				echo "<LI><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B><FONT SIZE=3>$nom_auteur</FONT></B>";
			    echo "</FONT>\n";
			}
			*/
			//-------------FIN MODIFICATION
			echo "</UL>";
		} else
			if (count($resultat) < 16) {
				reset($resultat);
				unset ($les_auteurs);
				while (list (, $id_auteur) = each($resultat))
					$les_auteurs[] = $id_auteur;
				if ($les_auteurs) {
					$les_auteurs = join(',', $les_auteurs);
					echo "<B>"._T('texte_plusieurs_articles', array ('cherche_auteur' => $cherche_auteur))."</B><BR>";
					//-----------Zone de modification Clever Age elebescond---------------
					// $auteurMetier = & recuperer_instance_auteur();
					$allAuteurs = $auteurMetier->getAllForAuteurIds($les_auteurs, "nom");

					if (PEAR :: isError($allAuteurs)) {
						die($allAuteurs->getMessage());
					}

					echo "<UL>";
					while (list (, $monAuteur) = each($allAuteurs)) {
						$id_auteur = $monAuteur->getAuteurId();
						$nom_auteur = $monAuteur->getNom();
						$email_auteur = $monAuteur->getEmail();
						$bio_auteur = $monAuteur->getBio();

						echo "<LI><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B><FONT SIZE=3>$nom_auteur</FONT></B>";

						if ($email_auteur)
							echo " ($email_auteur)";
						echo " | <A HREF=\"articles.php3?id_article=$id_article&ajout_auteur=oui&nouv_auteur=$id_auteur\">"._T('lien_ajouter_auteur')."</A>";

						if (trim($bio_auteur)) {
							echo "<BR><FONT SIZE=1>".propre(couper($bio_auteur, 100))."</FONT>\n";
						}
						echo "</FONT><p>\n";
					}
					/*
					$query = "SELECT * FROM spip_auteurs WHERE id_auteur IN ($les_auteurs) ORDER BY nom";
					$result = spip_query($query);
					echo "<UL>";
					while ($row = spip_fetch_array($result)) {
						$id_auteur = $row['id_auteur'];
						$nom_auteur = $row['nom'];
						$email_auteur = $row['email'];
						$bio_auteur = $row['bio'];
					
						echo "<LI><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B><FONT SIZE=3>$nom_auteur</FONT></B>";
					
						if ($email_auteur) echo " ($email_auteur)";
						echo " | <A HREF=\"articles.php3?id_article=$id_article&ajout_auteur=oui&nouv_auteur=$id_auteur#auteurs\">"._T('lien_ajouter_auteur')."</A>";
					
						if (trim($bio_auteur)) {
							echo "<BR><FONT SIZE=1>".propre(couper($bio_auteur, 100))."</FONT>\n";
						}
						echo "</FONT><p>\n";
					}
					*/
					//-----------Fin Modifications Clever Age -----------
					echo "</UL>";
				}
			} else {
				echo "<B>"._T('texte_trop_resultats_auteurs', array ('cherche_auteur' => $cherche_auteur))."</B><BR>";
			}
	fin_boite_info();
	echo "<P>";

}

//
// Appliquer les modifications sur les auteurs
//

if ($ajout_auteur && $flag_editable) {
	if ($nouv_auteur > 0) {
        $loadOK = $auteurMetier->load($nouv_auteur);
        if (!PEAR :: isError($loadOK)) {
            if ($auteurMetier->getProfil() >= POIDSREDACTEUR) { 
        		$authorization = & recuperer_instance_authorization('isAuthorizedToManageAuteur', $GLOBALS['connect_id_auteur'], array ('id_auteur_slave' => $nouv_auteur));
                $authorization2 = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $auteurMetier->getAuteurId(), array ('rubriqueId' => intval($articleMetier->getRubriqueId())));
        		if ($authorization->isAuthorizedAction() && $authorization2->isAuthorizedAction()) {
        			$articleMetier->deleteAuteur($nouv_auteur);
        			$articleMetier->addAuteur($nouv_auteur);
        		}
            }
        }
	}
}

if ($supp_auteur && $flag_editable) {
	//-------MODIFICATION CLEVER AGE
	$authorization = & recuperer_instance_authorization('isAuthorizedToManageAuteur', $GLOBALS['connect_id_auteur'], array ('id_auteur_slave' => $supp_auteur));
	if ( $GLOBALS['connect_id_auteur'] == $supp_auteur || $authorization->isAuthorizedAction() ) {
		$articleMetier->deleteAuteur($supp_auteur);
	}
	/*
	$query="DELETE FROM spip_auteurs_articles WHERE id_auteur='$supp_auteur' AND id_article='$id_article'";
	$result=spip_query($query);
	*/
	//--------FIN MODIFICATION CLEVER AGE
}

//
// Afficher les auteurs
//

unset ($les_auteurs);

//-----------Zone de modification Clever Age elebescond---------------
// $auteurMetier = & recuperer_instance_auteur();
$allAuteurs = $auteurMetier->getAllForArticleId($id_article, true);

if (PEAR :: isError($allAuteurs)) {
	die($allAuteurs->getMessage());
}

if (sizeOf($allAuteurs) > 0) {
	$ifond = 0;
	echo "\n<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''>\n";
	while (list (, $monAuteur) = each($allAuteurs)) {
		$id_auteur = $monAuteur->getAuteurId();
		$nom_auteur = $monAuteur->getNom();
		$email_auteur = $monAuteur->getEmail();
		if ($bio_auteur = attribut_html(propre(couper($monAuteur->getBio(), 100))))
			$bio_auteur = " TITLE=\"$bio_auteur\"";
		$url_site_auteur = $monAuteur->getUrlSite();
		$statut_auteur = $monAuteur->getStatut();
		if ($monAuteur->getMessagerie() == 'non' OR $monAuteur->getLogin() == '')
			$messagerie = 'non';

		$les_auteurs[] = $id_auteur;

		//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
		$authorization = & recuperer_instance_authorization('afficherSelectionStatutArticle', $GLOBALS['connect_id_auteur']);
		if ($authorization->isAuthorizedAction())
			$aff_articles = "('prepa', 'prop', 'publie', 'refuse')";
		/*
		if ($connect_statut == "minirezo") $aff_articles = "('prepa', 'prop', 'publie', 'refuse')";
		*/
		//----------------FIN Zone de modifications Clever Age elebescond----------
		else
			$aff_articles = "('prop', 'publie')";

		$nombre_articles = $articleMetier->howManyWritten($id_auteur, $aff_articles);

		$ifond = $ifond ^ 1;
		$couleur = ($ifond) ? '#FFFFFF' : $couleur_claire;

		$url_auteur = "auteurs_edit.php3?id_auteur=$id_auteur";

		echo "<TR BGCOLOR='$couleur' WIDTH=\"100%\">";
		echo "<TD WIDTH='20'>";
		//Construction du tableau qui va bien
		$row['statut'] = $monAuteur->getStatut();
		$row['source'] = $monAuteur->getSource();
		$row['pass'] = $monAuteur->getPass();
		$row['login'] = $monAuteur->getLogin();
		$row['profil'] = $monAuteur->getProfil();

		echo bonhomme_statut($row);
		echo "</TD>\n";

		echo "<TD CLASS='arial2'>";
		echo "<A HREF=\"$url_auteur\"$bio_auteur>$nom_auteur</A>";
		echo "</TD>\n";

		echo "<TD CLASS='arial2'>";
		echo bouton_imessage($id_auteur)."&nbsp;";
		echo "</TD>\n";

		echo "<TD CLASS='arial2'>";
		if ($email_auteur)
			echo "<A HREF='mailto:$email_auteur'>"._T('email')."</A>";
		else
			echo "&nbsp;";
		echo "</TD>\n";

		echo "<TD CLASS='arial2'>";
		if ($url_site_auteur)
			echo "<A HREF='$url_site_auteur'>"._T('info_site_min')."</A>";
		else
			echo "&nbsp;";
		echo "</TD>\n";

		echo "<TD CLASS='arial2' ALIGN='right'>";
		if ($nombre_articles > 1)
			echo "$nombre_articles articles";
		else
			if ($nombre_articles == 1)
				echo _T('info_1_article');
			else
				echo "&nbsp;";
		echo "</TD>\n";

		echo "<TD CLASS='arial1' align='right'>";
		$authorization = & recuperer_instance_authorization('isAuthorizedToManageAuteur', 
                                                            $GLOBALS['connect_id_auteur'], 
                                                            array ('id_auteur_slave' => $id_auteur));
		if ( ($articleMetier->countAuteurs() > 1 && $flag_editable AND $GLOBALS['connect_id_auteur'] == $id_auteur )
             OR ($articleMetier->countAuteurs() > 1 && $flag_editable AND $authorization->isAuthorizedAction() AND $options == 'avancees') ) {
			echo "<A HREF='articles.php3?id_article=$id_article&supp_auteur=$id_auteur#auteurs'>"._T('lien_retirer_auteur')."&nbsp;<img src='img_pack/croix-rouge.gif' alt='X' width='7' height='7' border='0' align='middle'></A>";
		} else
			echo "&nbsp;";
		echo "</TD>\n";

		echo "</TR>\n";
	}
	echo "</TABLE>\n";

	$les_auteurs = join(',', $les_auteurs);
}

//-----------Fin Modifications Clever Age -----------

//
// Ajouter un auteur
//
//-----------Zone de modification Clever Age elebescond---------------
$authorization = & recuperer_instance_authorization('ajouterAuteurArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));

if ($flag_editable AND $options == 'avancees' AND $authorization->isAuthorizedAction()) {

	/*
	if ($flag_editable AND $options == 'avancees') {
	*/
	//-----------Fin Zone de modification Clever Age elebescond---------------
	echo debut_block_invisible("auteursarticle");

	//-----------Zone de modification Clever Age elebescond---------------
	// $auteurMetier = & recuperer_instance_auteur();
	$allAuteurs = $auteurMetier->getAllExceptAuteurIdsAndProfils($les_auteurs);
	//$allAuteurs = $auteurMetier->getAllExceptAuteurIdsAndStatuts($les_auteurs);

    // je veux juste les redacteurs 
    foreach ($allAuteurs as $key => $monAuteur) {
        if ($monAuteur->getProfil() < POIDSREDACTEUR ) {
        		unset ($allAuteurs[$key]); // on doit etre au moins un redacteur pour apparaitre ds la boucle des auteurs
        }
        $authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $monAuteur->getAuteurId(), array ('rubriqueId' => intval($articleMetier->getRubriqueId())));
        //var_dump ($authorization);
        if (!$authorization->isAuthorizedAction()) { 
            unset ($allAuteurs[$key]);
        }
    }
    reset ($allAuteurs);

	if (PEAR :: isError($allAuteurs)) {
		die($allAuteurs->getMessage());
	}

	if (sizeOf($allAuteurs) > 0) {
		echo "<FORM ACTION='articles.php3' METHOD='post' style='margin-top:5px;'>";
		echo "<DIV align=right><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B>"._T('titre_cadre_ajouter_auteur')."&nbsp; </B></FONT>\n";
		echo "<INPUT TYPE='Hidden' NAME='id_article' VALUE=\"$id_article\">";

		if (sizeOf($allAuteurs) > 80 AND $flag_mots_ressemblants) {
			echo "<INPUT TYPE='text' NAME='cherche_auteur' CLASS='fondl' VALUE='' SIZE='20'>";
			echo " <INPUT TYPE='submit' NAME='Chercher' VALUE='"._T('bouton_chercher')."' CLASS='fondo'>";
		} else {
			//AJouter un nouvel auteur - fxlacroix comment
			echo "<INPUT TYPE='Hidden' NAME='ajout_auteur' VALUE='oui'>";
			echo "<SELECT NAME='nouv_auteur' SIZE='1' STYLE='WIDTH=150' CLASS='fondl'>";
			$group = false;
			$group2 = false;

			while (list (, $monAuteur) = each($allAuteurs)) {
				$id_auteur = $monAuteur->getAuteurId();
				//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
				$authorization = & recuperer_instance_authorization('isAuthorizedToManageAuteur', $GLOBALS['connect_id_auteur'], array ('id_auteur_slave' => $id_auteur));
				if ($authorization->isAuthorizedAction()) {
					$nom = $monAuteur->getNom();
					$email = $monAuteur->getEmail();
					$statut = $monAuteur->getStatut();
					$profil = $monAuteur->getProfil();
					$profilMetier = & recuperer_instance_profil();
                    //var_dump ($profilMetier);
					$loadOK = $profilMetier->load($profil);
					if (PEAR :: isError($loadOK)) {
						die($loadOK->getMessage());
					}

					$profil = _T($profilMetier->getIntitule());

					$premiere = strtoupper(substr(trim($nom), 0, 1));

					if ($p = strpos($email, '@'))
						$email = substr($email, 0, $p).'@...';
					if ($email)
						$email = " ($email)";

					if ($profil != $profil_old) {
						echo "\n<option value=\"x\"></option>";
						echo "\n<option value=\"x\"> $profil".'s'."</option>";
					}

					if ($premiere != $premiere_old AND ($profil != _T('item_administrateur') OR !$premiere_old)) {
						echo "\n<option value=\"x\"></option>";
					}

					$texte_option = couper("$nom$email", 40);
					echo "\n<option value=\"$id_auteur\">&nbsp;&nbsp;&nbsp;&nbsp;$texte_option</option>";
					$statut_old = $statut;
					$profil_old = $profil;
					$premiere_old = $premiere;
				}
			}
			//----------------FIN Zone de modifications Clever Age elebescond----------
			echo "</SELECT>";
			echo " <INPUT TYPE='submit' NAME='Ajouter' VALUE="._T('bouton_ajouter')." CLASS='fondo'>";
		}
		echo "</div></FORM>";
		//Fin du formaulaire pour ajouter un nouvel auteur - 
	}
	/*
	$query = "SELECT * FROM spip_auteurs WHERE ";
	if ($les_auteurs) $query .= "id_auteur NOT IN ($les_auteurs) AND ";
	$query .= "statut!='5poubelle' AND statut!='6forum' AND statut!='nouveau' ORDER BY statut, nom";
	$result = spip_query($query);
	
	if (spip_num_rows($result) > 0) {
		echo "<FORM ACTION='articles.php3?id_article=$id_article#auteurs' METHOD='post'>";
		echo "<DIV align=right><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B>"._T('titre_cadre_ajouter_auteur')."&nbsp; </B></FONT>\n";
		echo "<INPUT TYPE='Hidden' NAME='id_article' VALUE=\"$id_article\">";
	
		if (spip_num_rows($result) > 80 AND $flag_mots_ressemblants) {
			echo "<INPUT TYPE='text' NAME='cherche_auteur' CLASS='fondl' VALUE='' SIZE='20'>";
			echo " <INPUT TYPE='submit' NAME='Chercher' VALUE='"._T('bouton_chercher')."' CLASS='fondo'>";
		}
		else {
			echo "<INPUT TYPE='Hidden' NAME='ajout_auteur' VALUE='oui'>";
			echo "<SELECT NAME='nouv_auteur' SIZE='1' STYLE='WIDTH=150' CLASS='fondl'>";
			$group = false;
			$group2 = false;
	
			while ($row = spip_fetch_array($result)) {
				$id_auteur = $row["id_auteur"];
				$nom = $row["nom"];
				$email = $row["email"];
				$statut = $row["statut"];
	
				$statut=ereg_replace("0minirezo", _T('info_administrateurs'), $statut);
				$statut=ereg_replace("1comite", _T('info_redacteurs'), $statut);
				$statut=ereg_replace("2redac", _T('info_redacteurs'), $statut);
	
				$premiere = strtoupper(substr(trim($nom), 0, 1));
	
				if ($connect_statut != '0minirezo')
					if ($p = strpos($email, '@'))
						$email = substr($email, 0, $p).'@...';
				if ($email)
					$email = " ($email)";
	
				if ($statut != $statut_old) {
					echo "\n<OPTION VALUE=\"x\">";
					echo "\n<OPTION VALUE=\"x\"> $statut";
				}
	
				if ($premiere != $premiere_old AND ($statut != _T('info_administrateurs') OR !$premiere_old)) {
					echo "\n<OPTION VALUE=\"x\">";
				}
	
				$texte_option = couper("$nom$email", 40);
				echo "\n<OPTION VALUE=\"$id_auteur\">&nbsp;&nbsp;&nbsp;&nbsp;$texte_option";
				$statut_old = $statut;
				$premiere_old = $premiere;
			}
	
			echo "</SELECT>";
			echo " <INPUT TYPE='submit' NAME='Ajouter' VALUE="._T('bouton_ajouter')." CLASS='fondo'>";
		}
		echo "</div></FORM>";
	}
	*/
	//-----------Modifications Clever Age -----------

	echo fin_block();
}

fin_cadre_enfonce(false);

//////////////////////////////////////////////////////
// Liste des mots-cles de l'article
//
//-------------MODIFICATION CLEVER AGE elebescond
$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
if ($authorization->isAuthorizedAction()) {
	if ($options == 'avancees' AND $articles_mots != 'non') {
		formulaire_mots('articles', $id_article, $nouv_mot, $supp_mot, $cherche_mot, $flag_editable);
	}
}
/*
if ($options == 'avancees' AND $articles_mots != 'non') {
	formulaire_mots('articles', $id_article, $nouv_mot, $supp_mot, $cherche_mot, $flag_editable);
}
*/
//-------------Fin MODIFICATION CLEVER AGE elebescond

//
// Langue de l'article
//
if ((lire_meta('multi_articles') == 'oui') OR ((lire_meta('multi_rubriques') == 'oui') AND (lire_meta('gerer_trad') == 'oui'))) {

	/**************** Modification elebescond@clever-age.com *************************************/
	
	$loadOK = $articleMetier->load($id_article);
	if (PEAR :: isError($loadOK)) {
		die($loadOK->getMessage());
	}
	$langue_article = $articleMetier->getLang();
	$langue_choisie_article = $articleMetier->getLangChoisie();
	/*
	$row = spip_fetch_array(spip_query("SELECT lang, langue_choisie FROM spip_articles WHERE id_article=$id_article"));
	$langue_article = $row['lang'];
	$langue_choisie_article = $row['langue_choisie'];
	*/
	/**************** Fin modification elebescond@clever-age.com *************************************/

	debut_cadre_enfonce('langues-24.gif');
	echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC' class='serif2'>";
	echo bouton_block_invisible('languesarticle,ne_plus_lier,lier_traductions');
	echo "<B>";
	/******************** Modification elebescond@clever-age.com ****************/
	if (lire_meta('gerer_trad') == 'oui')
		echo _T('art_titre_langue_trad_article', null, $articleMetier->getRubriqueId());
	else
		echo _T('art_titre_langue_article', null, $articleMetier->getRubriqueId());
	/*
	if (lire_meta('gerer_trad') == 'oui')
		echo _T('titre_langue_trad_article');
	else
		echo _T('titre_langue_article');
	*/
	/******************** Fin modification elebescond@clever-age.com ****************/
	echo "&nbsp; (".traduire_nom_langue($langue_article).")";

	echo "</B>";
	echo "</TD></TR></TABLE>";

	// Choix langue article
	if (lire_meta('multi_articles') == 'oui' AND $flag_editable) {
		echo debut_block_invisible('languesarticle');

		/**************** Modification elebescond@clever-age.com *************************************/
		$rubriqueMetier = & recuperer_instance_rubrique();
		$loadOK = $rubriqueMetier->load($articleMetier->getRubriqueId());
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		}
		$langue_parent = $rubriqueMetier->getLang();
		/*
		$row = spip_fetch_array(spip_query("SELECT lang FROM spip_rubriques WHERE id_rubrique=$id_rubrique"));
		$langue_parent = $row['lang'];
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/

		if ($langue_choisie_article == 'oui')
			$herit = false;
		else
			$herit = true;

		//debut_cadre_enfonce();
		echo "<div style='padding: 5px; text-align: center;'><font face='Verdana,Arial,Sans,sans-serif' size='2'>";
		/**************** Modification elebescond@clever-age.com *************************************/
		echo menu_langues('changer_lang', $langue_article, _T('art_info_multi_cet_article', null, $articleMetier->getRubriqueId()).' ', $langue_parent);
		/*
		echo menu_langues('changer_lang', $langue_article, _T('info_multi_cet_article').' ', $langue_parent);
		*/
		/**************** Fin modification elebescond@clever-age.com *************************************/
		echo "</font></div>\n";
		//fin_cadre_enfonce();

		echo fin_block();
	}

	// Gerer les groupes de traductions
	if (lire_meta('gerer_trad') == 'oui') {
		if ($flag_editable AND $supp_trad == 'oui') { // Ne plus lier a un groupe de trad
			/**************** Modification elebescond@clever-age.com *************************************/
			$loadOK = $articleMetier->load($id_article);
			if (PEAR :: isError($loadOK)) {
				die($loadOK->getMessage());
			}
			$articleMetier->setTradId(0);
			$updateOK = $articleMetier->update();
			if (PEAR :: isError($updateOK)) {
				die($updateOK->getMessage());
			}
			/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			$mappings = $mapping->getMappings($articleMetier->getArticleId());
			if ( PEAR::isError($mappings) ) {
				die($mappings->getMessage());
			}
			else {
				for ($i = 0; $i < count($mappings); $i++) {
					$loadOK = $mappingMetier->load($mappings[$i]);
					if (PEAR :: isError($loadOK)) {
						die($loadOK->getMessage());
					} else {
						$mappingMetier->setTradId($articleMetier->getTradId());
						$updateOK = $mappingMetier->update();
						if (PEAR :: isError($updateOK)) {
							die($updateOK->getMessage());
						}
					}
				}
			}
			/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

                        /*
			spip_query("UPDATE spip_articles SET id_trad = '0' WHERE id_article = $id_article");
			*/
			/**************** Fin modification elebescond@clever-age.com *************************************/

			// Verifier si l'ancien groupe ne comporte plus qu'un seul article. Alors mettre a zero.
			/**************** Modification elebescond@clever-age.com *************************************/

			$nombre_autres_trad = $articleMetier->howManyArticleForTradID($id_trad);
			if (PEAR :: isError($nombre_autres_trad)) {
				die($nombre_autres_trad->getMessage());
			}
			if ($nombre_autres_trad == 1) {
				$updateTradIdForTradId = $articleMetier->updateTradIdForTradId($id_trad, 0);
				if (PEAR :: isError($updateTradIdForTradId)) {
					die($updateTradIdForTradId->getMessage());
				}
			}
			/*
			$result_autres_trad= spip_query("SELECT COUNT(id_article) AS total FROM spip_articles WHERE id_trad = $id_trad");
			if ($row = spip_fetch_array($result_autres_trad))
				$nombre_autres_trad = $row["total"];
			if ($nombre_autres_trad == 1)
				spip_query("UPDATE spip_articles SET id_trad = '0' WHERE id_trad = $id_trad");
				*/
			/**************** Fin modification elebescond@clever-age.com *************************************/
			$id_trad = 0;
		}

		/************* Modification elebescond@clever-age.com *********************/
		$profilMetier = & recuperer_instance_profil();
		$monProfil = $profilMetier->getProfilForIntitule('item_webmestre');
		if (PEAR :: isError($monProfil)) {
			die($monProfil->getMessage());
		}

		if ($connect_profil >= $monProfil->getPoids() AND $id_trad_new > 0) { // Changer article de reference de la trad
			$updateTradIdForTradId = $articleMetier->updateTradIdForTradId($id_trad_old, $id_trad_new);
			if (PEAR :: isError($updateTradIdForTradId)) {
				die($updateTradIdForTradId->getMessage());
			}
			$id_trad = $id_trad_new;
		}

		/*
		if ($connect_statut=='0minirezo' AND $id_trad_new > 0) { // Changer article de reference de la trad
			spip_query("UPDATE spip_articles SET id_trad = $id_trad_new WHERE id_trad = $id_trad_old");
			$id_trad = $id_trad_new;
		}
		*/
		/************* Fin modification elebescond@clever-age.com *********************/

		if ($flag_editable AND $lier_trad > 0) { // Lier a un groupe de trad
			/************* Modification elebescond@clever-age.com *********************/
			$loadOK = $articleMetier->load($lier_trad);
			if (!PEAR :: isError($loadOK)) {
				$id_lier = $articleMetier->getTradId();
				if ($id_lier == 0) { // Si l'article vise n'a pas deja de traduction, creer nouveau id_trad
					$nouveau_trad = $lier_trad;
				} else {
					/*************** Modification elebescond@clever-age.com ***************/
					if ($id_lier == $id_trad)
						$err = "<div>"._T('art_trad_deja_traduit', null, $articleMetier->getRubriqueId())."</div>";
					/*
					if ($id_lier == $id_trad) $err = "<div>"._T('trad_deja_traduit')."</div>";
					*/
					/*************** Fin modification elebescond@clever-age.com ***************/
					$nouveau_trad = $id_lier;
				}
				$articleMetier->setTradId($nouveau_trad);
				$updateOK = $articleMetier->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}

				/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
				$mappings = $mapping->getMappings($articleMetier->getArticleId());
				if ( PEAR::isError($mappings) ) {
					die($mappings->getMessage());
				}
				else {
					for ($i = 0; $i < count($mappings); $i++) {
						$loadOK = $mappingMetier->load($mappings[$i]);
						if (PEAR :: isError($loadOK)) {
							die($loadOK->getMessage());
						} else {
							$mappingMetier->setTradId($articleMetier->getTradId());
							$updateOK = $mappingMetier->update();
							if (PEAR :: isError($updateOK)) {
								die($updateOK->getMessage());
							}
						}
					}
				}
				/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/

				if ($id_lier > 0) {
					$updateTradIdForTradIdOK = $articleMetier->updateTradIdForTradId($id_lier, $nouveau_trad);
					if (PEAR :: isError($updateTradIdForTradIdOK)) {
						die($updateTradIdForTradIdOK->getMessage());
					}
				}

				$articleMetier2 = & recuperer_instance_article();
				$loadOK = $articleMetier2->load($id_article);
				if (PEAR :: isError($loadOK)) {
					die($loadOK->getMessage());
				}

				$articleMetier2->setTradId($nouveau_trad);

				$updateOK = $articleMetier2->update();
				if (PEAR :: isError($updateOK)) {
					die($updateOK->getMessage());
				}

				if ($id_trad > 0) {
					$updateTradIdForTradIdOK = $articleMetier2->updateTradIdForTradId($id_trad, $nouveau_trad);
					if (PEAR :: isError($updateTradIdForTradIdOK)) {
						die($updateTradIdForTradIdOK->getMessage());
					}
				}

				$id_trad = $nouveau_trad;
			}
			/**************** Modification elebescond@clever-age.com *****************/
			else
				$err .= "<div>"._T('art_trad_article_inexistant', null, $articleMetier->getRubriqueId())."</div>";
			/*
			else
				$err .= "<div>"._T('trad_article_inexistant')."</div>";
			*/
			/**************** Fin modification elebescond@clever-age.com *****************/
			/*
			$query_lier = "SELECT id_trad FROM spip_articles WHERE id_article=$lier_trad";
			$result_lier = spip_query($query_lier);
			if ($row = spip_fetch_array($result_lier)) {
				$id_lier = $row['id_trad'];
			
				if ($id_lier == 0) { // Si l'article vise n'a pas deja de traduction, creer nouveau id_trad
					$nouveau_trad = $lier_trad;
				}
				else {
					if ($id_lier == $id_trad) $err = "<div>"._T('trad_deja_traduit')."</div>";
					$nouveau_trad = $id_lier;
				}
			
				spip_query("UPDATE spip_articles SET id_trad = $nouveau_trad WHERE id_article = $lier_trad");
				if ($id_lier > 0) spip_query("UPDATE spip_articles SET id_trad = $nouveau_trad WHERE id_trad = $id_lier");
				spip_query("UPDATE spip_articles SET id_trad = $nouveau_trad WHERE id_article = $id_article");
				if ($id_trad > 0) spip_query("UPDATE spip_articles SET id_trad = $nouveau_trad WHERE id_trad = $id_trad");
			
				$id_trad = $nouveau_trad;
			}
			else
				$err .= "<div>"._T('trad_article_inexistant')."</div>";
			*/
			/************* Fin modification elebescond@clever-age.com *********************/
			if ($err)
				echo "<font color='red' size=2' face='verdana,arial,helvetica,sans-serif'>$err</font>";
		}

		// Afficher la liste des traductions
		if ($id_trad != 0) {
			/************* Modification elebescond@clever-age.com *********************/
			$articles = $articleMetier->getAllArticleForTradId($id_trad);
			if (PEAR :: isError($articles)) {
				die($articles->getMessage());
			}

			while (list (, $article) = each($articles)) {
				$id_article_trad = $article->getArticleId();
				$titre_trad = $article->getTitre();
				$lang_trad = $article->getLang();
				$statut_trad = $article->getStatut();

				changer_typo($lang_trad);
				$titre_trad = "<span $dir_lang>$titre_trad</span>";

				if ($ifond == 1) {
					$ifond = 0;
					$bgcolor = "white";
				} else {
					$ifond = 1;
					$bgcolor = $couleur_claire;
				}

				$ret .= "<tr bgcolor='$bgcolor'>";
				$ret .= "<td width='7'>";
				if ($statut_trad == 'publie')
					$ret .= "<img src='img_pack/puce-verte.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				else
					if ($statut_trad == 'prepa')
						$ret .= "<img src='img_pack/puce-blanche.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
					else
						if ($statut_trad == 'prop')
							$ret .= "<img src='img_pack/puce-orange.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
						else
							if ($statut_trad == 'valid')
								$ret .= "<img src='img_pack/puce-jaune.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
							else
								if ($statut_trad == 'archi')
									$ret .= "<img src='img_pack/puce-marron.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
								else
									if ($statut_trad == 'refuse')
										$ret .= "<img src='img_pack/puce-rouge.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
									else
										if ($statut_trad == 'poubelle')
											$ret .= "<img src='img_pack/puce-poubelle.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				$ret .= "</td>";

				$ret .= "<td width='12'>";

				if ($id_article_trad == $id_trad) {
					$ret .= "<img src='img_pack/langues-12.gif' width='12' height='12' alt='' border='0'>";
					$titre_trad = "<b>$titre_trad</b>";
				} else {

					$profilMetier = & recuperer_instance_profil();
					$monProfil = $profilMetier->getProfilForIntitule('item_webmestre');
					if (PEAR :: isError($monProfil)) {
						die($monProfil->getMessage());
					}

					if ($connect_profil >= $monProfil->getPoids())
						$ret .= "<a href='articles.php3?id_article=$id_article&id_trad_old=$id_trad&id_trad_new=$id_article_trad'><img src='img_pack/langues-off-12.gif' width='12' height='12' alt='' border='0'></a>";
					else
						$ret .= "<img src='img_pack/langues-off-12.gif' width='12' height='12' alt='' border='0'>";
				}

				$ret .= "</td>";

				$ret .= "<td class='arial2'>";
				if ($id_article_trad == $id_article)
					$ret .= "$titre_trad";
				else
					$ret .= "<a href='articles.php3?id_article=$id_article_trad'>$titre_trad</a>";
				if ($id_article_trad == $id_trad)
					$ret .= " "._T("art_trad_reference", null, $articleMetier->getRubriqueId());
				$ret .= "</td>";

				$ret .= "<td class='arial2'>".traduire_nom_langue($lang_trad)."</td>\n";
			}
			/*
			$query_trad = "SELECT id_article, titre, lang, statut FROM spip_articles WHERE id_trad = $id_trad";
			$result_trad = spip_query($query_trad);
			
			while ($row = spip_fetch_array($result_trad)) {
				$id_article_trad = $row["id_article"];
				$titre_trad = $row["titre"];
				$lang_trad = $row["lang"];
				$statut_trad = $row["statut"];
			
				changer_typo($lang_trad);
				$titre_trad = "<span $dir_lang>$titre_trad</span>";
			
				if ($ifond == 1) {
					$ifond = 0;
					$bgcolor = "white";
				} else {
					$ifond = 1;
					$bgcolor = $couleur_claire;
				}
			
			
				$ret .= "<tr bgcolor='$bgcolor'>";
				$ret .= "<td width='7'>";
				if ($statut_trad=='publie')
					$ret .= "<img src='img_pack/puce-verte.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				else if ($statut_trad=='prepa')
					$ret .= "<img src='img_pack/puce-blanche.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				else if ($statut_trad=='prop')
					$ret .= "<img src='img_pack/puce-orange.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				else if ($statut_trad == 'refuse')
					$ret .= "<img src='img_pack/puce-rouge.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				else if ($statut_trad == 'poubelle')
					$ret .= "<img src='img_pack/puce-poubelle.gif' alt='' width='7' height='7' border='0' NAME='statut'>";
				$ret .= "</td>";
			
				$ret .= "<td width='12'>";
			
				if ($id_article_trad == $id_trad) {
					$ret .= "<img src='img_pack/langues-12.gif' width='12' height='12' alt='' border='0'>";
					$titre_trad = "<b>$titre_trad</b>";
				} else {
					if ($connect_statut=='0minirezo') $ret .= "<a href='articles.php3?id_article=$id_article&id_trad_old=$id_trad&id_trad_new=$id_article_trad'><img src='img_pack/langues-off-12.gif' width='12' height='12' alt='' border='0'></a>";
					else $ret .= "<img src='img_pack/langues-off-12.gif' width='12' height='12' alt='' border='0'>";
				}
			
				$ret .= "</td>";
			
				$ret .= "<td class='arial2'>";
				if ($id_article_trad == $id_article) $ret .= "$titre_trad";
				else $ret .= "<a href='articles.php3?id_article=$id_article_trad'>$titre_trad</a>";
				if ($id_article_trad == $id_trad) $ret .= " "._T("trad_reference");
				$ret .= "</td>";
			
				$ret .= "<td class='arial2'>".traduire_nom_langue($lang_trad)."</td>\n";
			}
			*/
			/************* Fin modification elebescond@clever-age.com *********************/
			changer_typo($spip_lang);

			// bloc traductions
			if ($ret) {
				echo "<div align='$spip_lang_left' style='margin-top: 5px; padding: 0px; border: 1px dashed #999999; background-color: #f0f0f0;' $dir_lang>";
				echo "<table width='100%' cellspacing='0' border='0' cellpadding='3'>";
				/*********** Modification elebescond@clever-age.com ****************/
				echo "<tr bgcolor='#eeeecc'><td colspan='4' class='serif2'><b>"._T('art_trad_article_traduction', null, $articleMetier->getRubriqueId())."</b></td></tr>";
				/*
				echo "<tr bgcolor='#eeeecc'><td colspan='4' class='serif2'><b>"._T('trad_article_traduction')."</b></td></tr>";
				*/
				/*********** Fin modification elebescond@clever-age.com ****************/
				echo $ret;
				echo "</table>";
				echo "</div>";
				echo "<br>\n";
			}

			changer_typo($langue_article);
		}

		echo debut_block_invisible('lier_traductions');

		echo "<table width='100%'><tr>";
		if ($flag_editable AND $options == "avancees" AND !$ret) {
			// Formulaire pour lier a un article
			echo "<td class='arial2' width='60%'>";
			$lien = $GLOBALS['clean_link'];
			$lien->delVar($nom_select);
			$lien = $lien->getUrl();

			echo "<form action='$lien' method='post' style='margin:0px; padding:0px;'>";
			echo _T('trad_lier');
			echo "<div align='right'><input type='text' class='fondl' name='lier_trad' size='5'> <INPUT TYPE='submit' NAME='Modifier' VALUE='"._T('bouton_modifier')."' CLASS='fondl'></div>";
			echo "</form>";
			echo "</td>\n";
			echo "<td background='' width='10'> &nbsp; </td>";
			echo "<td background='img_pack/tirets-separation.gif' width='2'><img src='img_pack/rien.gif' alt='' width=2 height=2></td>";
			echo "<td background='' width='10'> &nbsp; </td>";
		}
		echo "<td>";
		/********** Modification elebescond@clever-age.com *************/
		icone_horizontale(_T('art_trad_new', null, $articleMetier->getRubriqueId()), "articles_edit.php3?new=oui&lier_trad=$id_article&id_rubrique=$id_rubrique", "traductions-24.gif", "creer.gif");
		/*
		icone_horizontale(_T('trad_new'), "articles_edit.php3?new=oui&lier_trad=$id_article&id_rubrique=$id_rubrique", "traductions-24.gif", "creer.gif");
		*/
		/********** Fin modification elebescond@clever-age.com *************/
		echo "</td>";
		if ($flag_editable AND $options == "avancees" AND $ret) {
			echo "<td background='' width='10'> &nbsp; </td>";
			echo "<td background='img_pack/tirets-separation.gif' width='2'><img src='img_pack/rien.gif' alt='' width=2 height=2></td>";
			echo "<td background='' width='10'> &nbsp; </td>";
			echo "<td>";
			icone_horizontale(_T('trad_delier'), "articles.php3?id_article=$id_article&supp_trad=oui", "traductions-24.gif", "supprimer.gif");
			echo "</td>\n";
		}

		echo "</tr></table>";

		echo fin_block();
	}

	fin_cadre_enfonce();
}

//////////////////////////////////////////////////////
// Modifier le statut de l'article
//

?>
	<script type='text/javascript'>
	<!--
	function change_bouton(selObj){
	
		var selection=selObj.options[selObj.selectedIndex].value;
	
		if (selection=="publie"){
			document.statut.src="img_pack/puce-verte.gif";
		}
		if (selection=="prepa"){
			document.statut.src="img_pack/puce-blanche.gif";
		}
		if (selection=="prop"){
			document.statut.src="img_pack/puce-orange.gif";
		}
		if (selection=="valid"){
			document.statut.src="img_pack/puce-jaune.gif";
		}
		if (selection=="archi"){
			document.statut.src="img_pack/puce-marron.gif";
		}
		if (selection=="refuse"){
			document.statut.src="img_pack/puce-rouge.gif";
		}
		if (selection=="poubelle"){
			document.statut.src="img_pack/puce-poubelle.gif";
		
			<?php if (lire_meta("activer_mapping_articles") == 'oui') { ?>
			if (confirm("<?php echo _T('alerte_suppression_mapping') ; ?>")) {
				document.statut.src="img_pack/puce-poubelle.gif";
			}
           
			else {
				for (i = 0; i < selObj.length; i++) {
					if (selObj.options[i].value == "<?php echo $statut_article; ?>") {
						selObj.selectedIndex = i;
						change_bouton(selObj);
					}
				}
			}
             <?php } else { ?>
			document.statut.src="img_pack/puce-poubelle.gif";
			<?php } ?>

                }
	}
	// -->
	</script>
	<?php    
	
	//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
$authorization = & recuperer_instance_authorization('modifierStatutArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
if ($authorization->isAuthorizedAction()) {
	/*
	if ($connect_statut == 'minirezo' AND acces_rubrique($rubrique_article)) {
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------
	echo "<FORM ACTION='articles.php3' METHOD='get'>";
	debut_cadre_relief("racine-site-24.gif");
	echo "<CENTER>";
	echo "<INPUT TYPE='Hidden' NAME='id_article' VALUE=\"$id_article\">";

	/*************** Modification elebescond@clever-age.com *******************/
	echo "<B>"._T('art_texte_article_statut', null, $articleMetier->getRubriqueId())."</B> ";
	/*
	echo "<B>"._T('texte_article_statut')."</B> ";
	*/
	/*************** Fin modification elebescond@clever-age.com *******************/

	echo "<SELECT NAME='statut_nouv' SIZE='1' CLASS='fondl' onChange='change_bouton(this)'>";

	//----------------Zone de modifications Clever Age elebescond----------
	echo "<OPTION".mySel("prepa", $statut_article)." style='background-color: white' />"._T('texte_statut_en_cours_redaction')."\n";
	echo "<OPTION".mySel("prop", $statut_article)." style='background-color: #FFF1C6' />"._T('texte_statut_propose_evaluation')."\n";
	$authorization = & recuperer_instance_authorization('validerArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		echo "<OPTION".mySel("valid", $statut_article)." style='background-color: #ffffff' />"._T('texte_statut_valide')."\n";

	$authorization = & recuperer_instance_authorization('publierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		echo "<OPTION".mySel("publie", $statut_article)." style='background-color: #B4E8C5' />"._T('texte_statut_publie')."\n";

	$authorization = & recuperer_instance_authorization('archiverArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		echo "<OPTION".mySel("archi", $statut_article)." style='background-color: #ffffff'>"._T('texte_statut_archive')."\n";

	$authorization = & recuperer_instance_authorization('jeterArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		echo "<OPTION".mySel("poubelle", $statut_article)." style='background:url(img_pack/rayures-sup.gif)' />"._T('texte_statut_poubelle')."\n";

	$authorization = & recuperer_instance_authorization('refuserArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
	if ($authorization->isAuthorizedAction())
		echo "<OPTION".mySel("refuse", $statut_article)." style='background-color: #FFA4A4' />"._T('texte_statut_refuse')."\n";

	/*    
	echo "<OPTION" . mySel("prepa", $statut_article) ." style='background-color: white'>"._T('texte_statut_en_cours_redaction')."\n";
	echo "<OPTION" . mySel("prop", $statut_article) . " style='background-color: #FFF1C6'>"._T('texte_statut_propose_evaluation')."\n";
	echo "<OPTION" . mySel("publie", $statut_article) . " style='background-color: #B4E8C5'>"._T('texte_statut_publie')."\n";
	echo "<OPTION" . mySel("poubelle", $statut_article) . " style='background:url(img_pack/rayures-sup.gif)'>"._T('texte_statut_poubelle')."\n";
	echo "<OPTION" . mySel("refuse", $statut_article) . " style='background-color: #FFA4A4'>"._T('texte_statut_refuse')."\n";
	*/
	//----------------FIN Zone de modifications Clever Age elebescond----------

	echo "</SELECT>";

	echo " \n";

	if ($statut_article == 'publie') {
		echo "<img src='img_pack/puce-verte.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
	} else
		if ($statut_article == 'prepa') {
			echo "<img src='img_pack/puce-blanche.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
		} else
			if ($statut_article == 'prop') {
				echo "<img src='img_pack/puce-orange.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
			} else
				if ($statut_article == 'valid') {
					echo "<img src='img_pack/puce-jaune.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
				} else
					if ($statut_article == 'archi') {
						echo "<img src='img_pack/puce-marron.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
					} else
						if ($statut_article == 'refuse') {
							echo "<img src='img_pack/puce-rouge.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
						} else
							if ($statut_article == 'poubelle') {
								echo "<img src='img_pack/puce-poubelle.gif' alt='' width='13' height='14' border='0' NAME='statut'>";
							}
	echo " \n";

	echo "<INPUT TYPE='submit' NAME='Modifier' VALUE='"._T('bouton_modifier')."' CLASS='fondo'>";
	echo aide("artstatut");
	echo "</CENTER>";
	fin_cadre_relief();
	echo "</FORM>";
}

//////////////////////////////////////////////////////
// Corps de l'article
//

echo "\n\n<div align='justify'>";

if ($virtuel) {
	debut_boite_info();
	echo _T('info_renvoi_article')." ".propre("<center>[->$virtuel]</center>");
	fin_boite_info();
} else {
	echo "<div $dir_lang><b>";
	echo justifier(propre($chapo));
	echo "</b></div>\n\n";

	echo "<div $dir_lang>".justifier(propre($texte))."</div>";

	if ($ps) {
		echo debut_cadre_enfonce();
		echo "<div $dir_lang><font size=2 face='Verdana,Arial,Sans,sans-serif'>";
		/***************** Modification elebescond@clever-age.com ***********/
		echo justifier("<b>"._T('art_info_ps', null, $articleMetier->getRubriqueId())."</b> ".propre($ps));
		/*
		echo justifier("<b>"._T('info_ps')."</b> ".propre($ps));
		*/
		/***************** Fin modification elebescond@clever-age.com ***********/
		echo "</font></div>";
		echo fin_cadre_enfonce();
	}

	if ($les_notes) {
		echo debut_cadre_relief();
		echo "<div $dir_lang><font size=2>";
		/***************** Modification elebescond@clever-age.com ***********/
		echo justifier("<b>"._T('art_info_notes', null, $articleMetier->getRubriqueId())."&nbsp;:</b> ".$les_notes);
		/*
		echo justifier("<b>"._T('info_notes')."&nbsp;:</b> ".$les_notes);
		*/
		/***************** Fin modification elebescond@clever-age.com ***********/
		echo "</font></div>";
		echo fin_cadre_relief();
	}

	if ($champs_extra AND $extra) {
		include_once("inc_extra.php3");
		extra_affichage($extra, "articles");
	}
}

//
// Bouton "modifier cet article"
//

if ($flag_editable) {
	echo "\n\n<div align=right><br>";

	if ($date_diff >= 0 AND $date_diff < 60 AND $auteur_modif > 0 AND $auteur_modif != $connect_id_auteur) {
		//-------------MODIFICATION CLEVER AGE elebescond
		// $auteurMetier = & recuperer_instance_auteur();
		$loadOK = $auteurMetier->load($auteur_modif);
		if (PEAR :: isError($loadOK)) {
			die($loadOK->getMessage());
		} else {
			$nom_auteur_modif = $auteurMetier->getNom();
		}
		$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
		if ($authorization->isAuthorizedAction()) {

			if ($statut_article == 'mappe') {
				icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "warning-24.gif");
			}
			else {
				icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "warning-24.gif", "");
			}

			echo "<font face='arial,helvetica,sans-serif' size=1>"._T('art_texte_travail_article', array ('nom_auteur_modif' => $nom_auteur_modif, 'date_diff' => $date_diff), $articleMetier->getRubriqueId())."</font>";
			echo aide("artmodif");
		}
	} else {
		$authorization = & recuperer_instance_authorization('modifierArticle', $GLOBALS['connect_id_auteur'], array ('id_article' => $id_article));
		if ($authorization->isAuthorizedAction()) {
			if ($statut_article == 'mappe') {
				icone(_T('art_icone_modifier_mapping', null, $articleMetier->getRubriqueId()), "mappings_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			}
			else {
				icone(_T('art_icone_modifier_article', null, $articleMetier->getRubriqueId()), "articles_edit.php3?id_article=$id_article", "article-24.gif", "edit.gif");
			}
		}
        if ($statut_article == "publie") {
		  echo "<br />";
		  icone(_T('dxs_export_article', null, $articleMetier->getRubriqueId()), "articles_export.php3?id_article=$id_article&export=oui", "article-24.gif", "edit.gif");
        }

	}

	echo "</div>";
}

//
// Documents associes a l'article
//

echo "<a name='docs'></a>\n";
afficher_documents_non_inclus($id_article, "article", $flag_editable);

/* Ajout Clever Age / Nicolas Hoizey / R�f�rencement des liens & sondage*/
afficher_liens('art-'.$id_article);

/*
HACK_BEGIN sondage
*/
afficher_sondage($id_article, $flag_editable);
/*
HACK_END
*/
/* fin zone de modification Clever Age */

//
// "Demander la publication"
//

if ($flag_auteur AND $statut_article == 'prepa') {
	echo "<P>";
	debut_cadre_relief();
	echo "<center>";
	/********* Modification elebescond@clever-age.com ******************/
	echo "<B>"._T('art_texte_proposer_publication', null, $articleMetier->getRubriqueId())."</B>";
	echo aide("artprop");
	bouton(_T('art_bouton_demande_publication', null, $articleMetier->getRubriqueId()), "articles.php3?id_article=$id_article&statut_nouv=prop");
	/*
	echo "<B>"._T('texte_proposer_publication')."</B>";
	echo aide ("artprop");
	bouton(_T('bouton_demande_publication'), "articles.php3?id_article=$id_article&statut_nouv=prop");
	*/
	/********* Fin modification elebescond@clever-age.com ******************/
	echo "</center>";
	fin_cadre_relief();
}

echo "</DIV>";

fin_cadre_relief();

//
// Forums
//

echo "<BR><BR>";

$forum_retour = urlencode("articles.php3?id_article=$id_article");

echo "\n<div align='center'>";
icone(_T('icone_poster_message'), "forum_envoi.php3?statut=prive&adresse_retour=".$forum_retour."&id_article=$id_article&titre_message=".urlencode($titre), "forum-interne-24.gif", "creer.gif");
echo "</div>";

echo "<P align='left'>";

//----------Modification Clever Age elebescond@clever-age.com-----------------
$forumMetier = & recuperer_instance_forum();
$nb_forums = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'prive'", 0);
if (PEAR :: isError($nb_forums)) {
	die($nb_forums->getMessage());
}
/*
$query_forum = "SELECT COUNT(*) AS cnt FROM spip_forum WHERE statut='prive' AND id_article='$id_article' AND id_parent=0";
$result_forum = spip_query($query_forum);
$total = 0;
if ($row = spip_fetch_array($result_forum)) $total = $row["cnt"];
*/
//---------Fin modification Clever Age-------------------

if (!$debut)
	$debut = 0;
$total_afficher = 8;
if ($total > $total_afficher) {
	echo "<div class='serif2' align='center'>";
	for ($i = 0; $i < $total; $i = $i + $total_afficher) {
		$y = $i + $total_afficher -1;
		if ($i == $debut)
			echo "<FONT SIZE=3><B>[$i-$y]</B></FONT> ";
		else
			echo "[<A HREF='articles.php3?id_article=$id_article&debut=$i'>$i-$y</A>] ";
	}
	echo "</div>";
}

// ----------Modifications Clever Age elebescond@clever-age.com-------------------
$forumList = & recuperer_instance_list_forum();
$queryParams = array ();
$queryParams[] = 'prive';
$queryParams[] = $id_article;

$forumList->displayHTMLList(FORUM_BY_STATE_AND_ARTICLEID, $queryParams, $forum_retour, "non", "oui", $debut, $total_afficher);
/*
$query_forum = "SELECT * FROM spip_forum WHERE statut='prive' AND id_article='$id_article' AND id_parent=0 ORDER BY date_heure DESC LIMIT $debut,$total_afficher";
$result_forum = spip_query($query_forum);
afficher_forum($result_forum, $forum_retour);
*/
// ----------Fin modification CA-------------------------

if
 (!$debut)
	$debut = 0;
$total_afficher = 8;
if ($total > $total_afficher) {
	echo "<div class='serif2' align='center'>";
	for ($i = 0; $i < $total; $i = $i + $total_afficher) {
		$y = $i + $total_afficher -1;
		if ($i == $debut)
			echo "<FONT SIZE=3><B>[$i-$y]</B></FONT> ";
		else
			echo "[<A HREF='articles.php3?id_article=$id_article&debut=$i'>$i-$y</A>] ";
	}
	echo "</div>";
}

echo "</div>\n";



// choses lentes reportees en fin de page
@ flush();

// ajout Olivier Mansour
/* 
if ($jour && $flag_editable) {
	if (lire_meta("post_dates") != 'non')
		calculer_dates_rubriques();
}
*/
// a quoi ca sert ? ces lignes ? 
/*
if ($titre && !$ajout_forum && $flag_editable && !$ok_nouveau_statut) {
	calculer_rubriques();
}
*/

if ($ok_nouveau_statut) {
//	calculer_rubriques();
	if ($statut_nouv == 'publie' AND $statut_ancien != $statut_nouv) {
		include_once("inc_mail.php3");
		envoyer_mail_publication($id_article);
	}
	if ($statut_nouv == "prop" AND $statut_ancien != $statut_nouv AND $statut_ancien != 'publie') {
		include_once("inc_mail.php3");
		envoyer_mail_proposition($id_article);
	}
	if ($statut_nouv == 'publie' AND $statut_nouv != $statut_ancien)
		$reindexer = true;
}

if ($reindexer AND (lire_meta('activer_moteur') == 'oui')) {
	include_once("inc_index.php3");
	indexer_article($id_article);
}

fin_page();

?>
