<?php
/** Affichage du diff entre deux versions d'un article.
 * Si $_GET['id_article'] n'est pas dfini, on affiche juste la version de l'historique.
 *
 * @version $Id$
 */


// Includes
require_once 'inc.php3';
require_once 'inc_diff.php3';
require_once dirname(__FILE__) . '/include/bd/inc_article_factory.php';
require_once dirname(__FILE__) . '/include/bd/inc_article_historique_factory.php';


// Chargement des articles et des donnes qui leurs sont lies
// -- Dernire version de l'article
if ( isset($_GET['id_article']) && is_numeric($_GET['id_article']) ) {
    $articleMetier =& recuperer_instance_article();
    $articleMetier->load( $_GET['id_article'] );
    $dateArticle = $articleMetier->getDate();
    $auteur_histo_to =& recuperer_instance_auteur();
    $status = $auteur_histo_to->load( $articleMetier->getAuteurModif() );
    if ( PEAR::isError($status) ) {
        $str_auteur_to = null;
    } else {
        $str_auteur_to = "(<a href=\"".$auteur_histo_to->getUrl()."\">". $auteur_histo_to->getNom()."</a>)";
    }
    
}

// -- Version de l'historique
$articleHistoriqueMetier =& recuperer_instance_article_historique();
$articleHistoriqueMetier->load( $_GET['id_article_historique'] );
$dateArticleHistorique = $articleHistoriqueMetier->getDate();
$auteur_histo_from =& recuperer_instance_auteur();
$status = $auteur_histo_from->load( $articleHistoriqueMetier->getAuteurId() );
if ( PEAR::isError($status) ) {
    $str_auteur_from = null;
} else {
    $str_auteur_from = "(<a href=\"".$auteur_histo_from->getUrl()."\">". $auteur_histo_from->getNom()."</a>) ";
}


// Affichage de la page
$titre_page = isset($_GET['id_article']) ? _T("comparer_deux_historiques") : _T('afficher_historique_article');
debut_page( $titre_page, "documents", "articles");


debut_grand_cadre();

icone(_T('icone_retour'), "articles.php3?id_article=".$articleHistoriqueMetier->getArticleId(), "article-24.gif", "rien.gif");

debut_cadre_relief();
debut_tableau();

// Affichage du diff format en HTML ( -- dclaration de la fonction dans inc_diff.php3)
if ( isset($_GET['id_article']) ) {
    /* style pour diffs */
    echo '<style>',
        'tr.diff-added td {border-left: solid 5px #00FF00;}',
        'tr.diff-deleted td {border-left: solid 5px #FF0000;}',
        'tr.diff-changed td {border-left: solid 5px #FFF000;}',
        'tr.diff-context td {border-left: solid 5px #DDD;}',
        '</style>';

    echo ligne( array('Diff&eacute;rences entre les versions '.
                      $dateArticleHistorique. ' '. $str_auteur_from .' et '. $dateArticle. ' '. $str_auteur_to),
                'th' );
    
    echo ligne(array ('<hr>'));

    echo getDiffHtml( $articleHistoriqueMetier, $articleMetier );

    // Revenir au contenu de la version de l'historique (si l'auteur en a le droit)
    $authorization = & recuperer_instance_authorization( 'modifierArticle', 
                                                         $GLOBALS['connect_id_auteur'], 
                                                         array ('id_article' => $articleMetier->getArticleId()) );
    if ($authorization->isAuthorizedAction()) {
        echo "<p>", "<br />",
            "<a href='articles.php3?id_article=".$id_article."&id_article_historique_replace=".$id_article_historique."'>",
            _T('remplacer_par_historique')."</a>", "</p>";
    } 
} else {
    echo ligne( array('Affichage de la version '. $dateArticleHistorique .' '. $str_auteur_from),
                'th' );
    echo ligne(array ('<hr>'));
    echo $articleHistoriqueMetier->toString();
}

fin_tableau();



fin_cadre_relief();

fin_grand_cadre();

fin_page();

?>