<?php
/** Affiche une colonne du brouteur de rubriques
 * @version     $Id$
 */

###
# Rcupration et traitement des paramtres en entre
###

# -- id de la rubrique slectionne
$id_rubrique = isset($_GET['id_rubrique']) && is_numeric($_GET['id_rubrique']) ? $_GET['id_rubrique'] : null;
# -- numro de la colonne
$frame = isset($_GET['frame']) && is_numeric($_GET['frame']) ? $_GET['frame'] : null;
# -- raffrachir l'affichage des colonnes suivantes ('oui' ou null)
$effacer_suivant = isset($_GET['effacer_suivant']) && strpos( $_GET['effacer_suivant'], 'oui' ) ? $_GET['effacer_suivant'] : null;

// TODO: passer en conf
$nb_col = 4;

// Base
require_once 'inc.php3';

// 
debut_html();

###
# Javascript
###

# -- Inclusion des librairies javascript
echo '<script type="text/javascript" src="js/brouteur.lib.js"></script>' . "\n";

# -- Raffrachissement des colonnes suivantes
if ($effacer_suivant == 'oui') {
    echo '<script type="text/javascript">' . "\n";
    for ($i = $frame+1; $i < $nb_col; $i++) {
        echo '  parent.iframe'.$i.'.location.href="brouteur_select_rubrique_frame.php3?frame='.$i.'"' . "\n";
    }
    echo '</script>' . "\n";
}

echo "<div class='arial2'>";

###
# Rcupration des infos sur la rubrique slectionne
###

$rubriqueMetier =& recuperer_instance_rubrique();
$loadOK = $rubriqueMetier->load( $id_rubrique );

if( ! PEAR::isError($loadOK) ) {
    // Vrification des droits de l'utilisateur connect sur la rubrique
    $authorization =& recuperer_instance_authorization( 'isManagedRubriqueByAuteurId', 
                                                        $GLOBALS['connect_id_auteur'], 
                                                        array('rubriqueId' => $rubriqueMetier->getRubriqueId()) );

    if ( $authorization->isAuthorizedAction() ) {
        $ze_rubrique = $rubriqueMetier->getRubriqueId();
        $titre = $rubriqueMetier->getTitre();

        // Slection de l'icne en fonction du niveau de la rubrique
        $id_parent = $rubriqueMetier->getParentId();
        if ($id_parent == 0) $icone = "secteur-24.gif";
        else $icone = "rubrique-24.gif";
        
        echo "<div style='background-color: #cccccc; margin-bottom: 3px;'>";
        icone_horizontale("$titre", "Javascript:void()", "$icone","");
        echo "</div>";
    }
} 
// Si aucune rubrique n'existe on affiche la qd mme le header de la premire colonne
else if ($frame == 0) {
    // si l'auteur est restreint il faut afficher la liste des rubriques restreintes
     
    $allRubriques = $rubriqueMetier->getRubriqueIdForAuteurIdExceptRoot($GLOBALS['connect_id_auteur']);
    if (sizeOf($allRubriques) == 0) { // l'auteur n'est pas restrein
        echo "<div style='background-color: #cccccc; margin-bottom: 3px;'>";
        icone_horizontale(_T('info_racine_site'), "javascript:void()", "racine-site-24.gif","");
    		echo "<script>";
  		    echo "var sFichierAppelant = new String(window.parent.opener.document.location);";
			//echo "document.write(sFichierAppelant);";
  		    echo "is_choisir_ok = sFichierAppelant.indexOf('rubriques_edit');";
  		    echo "if (is_choisir_ok==-1){";
      		    echo '}';
      		    echo 'else{ '; 
					   echo 'document.write("<a href=\"#\" onclick=\"changeRub(\'0\',\''._T('info_racine_site').'\')\">Choisir</a>")';
					 // TODO : chaine de langue pour choisir
					   echo'}';
		  echo "</script>";
		  echo "</div>";
     } else {
        //$rubrique = &recuperer_instance_rubrique();
        foreach ($allRubriques as $rubrique) {
            affiche_colonne($rubrique);
        }
     } 
}


###
# Affichage des sous-rubriques
###

$rubriqueMetier = &recuperer_instance_rubrique();
$rubriques = $rubriqueMetier->getAllForParentId( $id_rubrique, 'titre' );

if ( ! PEAR::isError($rubriques) ) {
    while ( list(, $rubrique) = each($rubriques) ) {
        // Vrification des permission de l'utilisateur pour chaque sous-rubrique
        $authorization = &recuperer_instance_authorization(
            'isManagedRubriqueByAuteurId', 
            $GLOBALS['connect_id_auteur'], 
            array('rubriqueId' => $rubrique->getRubriqueId()) );

        // Si l'utilisateur dispose de droits suffisants...
        if ( $authorization->isAuthorizedAction() ) {
            affiche_colonne($rubrique);
        }
    }
}

// TODO  -- ?? pquoi ? 
if ($id_rubrique > 0) {
    $profilMetier = &recuperer_instance_profil();
    $profil = $profilMetier->getProfilForIntitule('item_webmestre');
}

echo "</div>";

echo "</body></html>";


// affiche une colonne 
// une rubrique metier en entree
function affiche_colonne ($rubrique) {
    global $frame, $nb_col, $spip_lang_left;

    $ze_rubrique = $rubrique->getRubriqueId();
    $titre = addslashes( $rubrique->getTitre() );
    $id_parent = $rubrique->getParentId();

    // La rubrique est de premier niveau
    if ($id_parent == '0')  {
        // Gestion du javascript pour la frame opener aurelien
        echo "<div style='margin:3px; padding-top: 5px; padding-bottom: 5px; padding-$spip_lang_left: 28px; background: url(img_pack/secteur-24.gif) $spip_lang_left center no-repeat;'>
           <b class='verdana2'>
           <a href='brouteur_select_rubrique_frame.php3?id_rubrique=$ze_rubrique&frame=".($frame+1)."&effacer_suivant=oui' target='iframe".($frame+1)."'>$titre</a>&nbsp;<a href=\"#\" onclick=\"changeRub(".$ze_rubrique.",'".$titre."')\">Choisir</a></b>
          </div>";
          // TODO : chaine de langue pour choisir
    } else {
        // Gestion du javascript pour la frame opener aurelien
        if ($frame+1 < $nb_col) { 
            echo "<div style='margin:3px; padding-top: 5px; padding-bottom: 5px; padding-$spip_lang_left: 28px; background: url(img_pack/rubrique-24.gif) $spip_lang_left center no-repeat;'><b><a href='brouteur_select_rubrique_frame.php3?id_rubrique=$ze_rubrique&frame=".($frame+1)."&effacer_suivant=oui' target='iframe".($frame+1)."'>$titre</a>&nbsp;<a href=\"#\" onclick=\"changeRub(".$ze_rubrique.",'".$titre."')\">Choisir</a></b></div>";
            // TODO : chaine de langue pour choisir 
        }
        // Dcalage des colonnes, si besoin
        else {
          echo "<div style='margin:3px; padding-top: 5px; padding-bottom: 5px; padding-$spip_lang_left: 28px; background: url(img_pack/rubrique-24.gif) $spip_lang_left center no-repeat;'><b><a href='javascript:window.parent.location=\"brouteur_select_rubrique.php3?id_rubrique=$ze_rubrique\"'>$titre</a>&nbsp;<a href=\"#\" onclick=\"changeRub(".$ze_rubrique.",'".$titre."')\">Choisir</a></b></div>";
          // TODO : chaine de langue pour choisir
       }
  }

}


?>