<?php

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_AUTH_LDAP")) return;
define("_ECRIRE_INC_AUTH_LDAP", "1");

class Auth_ldap {
	var $user_dn;
	var $auteurId, $nom, $login, $email, $pass, $statut, $bio;

	function init() {
		//-----------Modifications Clever Age mbelge-----------
		if (!$GLOBALS['ldap_present']) 
			return false;
		else {
			$auteurLDAP = &recuperer_instance_auteur(true);
			return true;
		}
		/*
		// Verifier la presence de LDAP
		if (!$GLOBALS['ldap_present']) return false;
		return spip_connect_ldap();
        */
		//-----------Fin Modifications Clever Age -----------
	}

	function verifier_challenge_md5($login, $mdpass_actuel, $mdpass_futur) {
		return false;
	}

	function verifier($login, $pass) {
		global $ldap_link, $ldap_base;
		
		// Securite, au cas ou le serveur LDAP est tres laxiste
		if (!$login || !$pass) return false;

		// Attributs testes pour egalite avec le login
		$atts = array('uid', 'login', 'userid', 'cn', 'sn');
		$login_search = ereg_replace("[^-._[:space:][:alnum:]]", "", $login); // securite

		//-----------Modifications Clever Age mbelge-----------
		$auteurLDAP = &recuperer_instance_auteur(true);
		if($auteurLDAP->verifyPassword($login, $pass)) {
			$this->user_dn = $auteurLDAP->getAuteurDN();
			$this->login = $login;
			return true;
		} else {
			return false;
		}
		
		/*
		// Tenter une recherche pour essayer de retrouver le DN
		reset($atts);
		while (list(, $att) = each($atts)) {
			$filter = "$att=$login_search";
			$result = @ldap_search($ldap_link, $ldap_base, $filter, array("dn"));
			$info = @ldap_get_entries($ldap_link, $result);
			// Ne pas accepter les resultats si plus d'une entree
			// (on veut un attribut unique)
			if (is_array($info) AND $info['count'] == 1) {
				$dn = $info[0]['dn'];
				if (@ldap_bind($ldap_link, $dn, $pass)) {
					$this->user_dn = $dn;
					$this->login = $login;
					return true;
				}
			}
		}

		// Si echec, essayer de deviner le DN
		reset($atts);
		while (list(, $att) = each($atts)) {
			$dn = "$att=$login_search, $ldap_base";
			if (@ldap_bind($ldap_link, $dn, $pass)) {
				$this->user_dn = $dn;
				$this->login = $login;
				return true;
			}
		}
		return false;
		*/
		//-----------Fin Modifications Clever Age -----------
	}

	function lire() {
		global $ldap_link, $ldap_base, $flag_utf8_decode;
		$this->nom = $this->email = $this->pass = $this->statut = 'NULL';

		if (!$this->login) return false;

		// Si l'auteur existe dans la base, y recuperer les infos
		//-----------Modifications Clever Age elebescond-----------
        $auteurMetier = &recuperer_instance_auteur();
        $allAuteurs = $auteurMetier->getAllForLoginAndSource($this->login, 'ldap');
        if(PEAR::isError($allAuteurs)) {
            die($allAuteurs->getMessage());
        }
        while (list(,$auteurMetier) = each($allAuteurs)) {
            $this->auteurId = $auteurMetier->getAuteurId();
            $this->nom = $auteurMetier->getNom();
		    $this->bio = $auteurMetier->getBio();
		    $this->email = $auteurMetier->getEmail();
			$this->statut = $auteurMetier->getStatut();
			return true;
        }
        /*
        $query = "SELECT * FROM spip_auteurs WHERE login='".addslashes($this->login)."' AND source='ldap'";
		$result = spip_query($query);

		if ($row = spip_fetch_array($result)) {
			$this->nom = $row['nom'];
			$this->email = $row['email'];
			$this->statut = $row['statut'];
			$this->bio = $row['bio'];
			return true;
		}
		*/
        //-----------Fin Modifications Clever Age -----------
		
		// Lire les infos sur l'auteur depuis LDAP
		//-----------Modifications Clever Age mbelge-----------
		$auteurLDAP = &recuperer_instance_auteur(true);
		$auteurLDAP->getAuteurInfos($this->login);
		$this->nom = $auteurLDAP->getNom();
		$this->email = $auteurLDAP->getEmail();
		$this->login = $auteurLDAP->getLogin();
		$this->bio = $auteurLDAP->getBio();
		/*
		$result = @ldap_read($ldap_link, $this->user_dn, "objectClass=*", array("uid", "cn", "mail", "description"));
		if (!$result) return false;
		$info = @ldap_get_entries($ldap_link, $result);
		if (!is_array($info)) return false;
		for ($i = 0; $i < $info["count"]; $i++) {
			$val = $info[$i];
			if (is_array($val)) {
				if (!$this->nom) $this->nom = $val['cn'][0];
				if (!$this->email) $this->email = $val['mail'][0];
				if (!$this->login) $this->login = $val['uid'][0];
				if (!$this->bio) $this->bio = $val['description'][0];
			}
		}
		*/
        //-----------Fin Modifications Clever Age -----------

		// Convertir depuis UTF-8 (jeu de caracteres par defaut)
		if ($flag_utf8_decode) {
			$this->nom = utf8_decode($this->nom);
			$this->email = utf8_decode($this->email);
			$this->login = utf8_decode($this->login);
			$this->bio = utf8_decode($this->bio);
		}
		return true;
	}

	function activer() {
		$nom = addslashes($this->nom);
		$login = addslashes($this->login);
		$email = addslashes($this->email);
		$bio = addslashes($this->bio);
		$statut = lire_meta("ldap_profil_import");
		//-----------Modifications Clever Age elebescond-----------
        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule($statut);
        
        $profil = $monProfil->getPoids();
        
        if (!$profil) return false;
        
        /*
        $profil = "1comite";		
		if (!$statut) return false;
		*/
        //-----------Fin Modifications Clever Age elebescond-----------
		// Si l'auteur n'existe pas, l'inserer avec le statut par defaut (defini a l'install)
        //-----------Modifications Clever Age elebescond-----------
        $auteurMetier = &recuperer_instance_auteur();
        $size = $auteurMetier->getAllForLogin($login);
        if(PEAR::isError($size)) {
            die($size->getMessage());
        }
        $auteurMetier->setSource('ldap');
	    $auteurMetier->setNom($nom);
	    $auteurMetier->setLogin($login);
	    $auteurMetier->setEmail($email);
	    $auteurMetier->setProfil($profil);
	    $auteurMetier->setBio($bio);
	    $auteurMetier->setPass('');

	    if(sizeOf($size) == 0 ) {
        	$createOK = $auteurMetier->create();
	    	if(PEAR::isError($createOK)) {
            	die($createOK->getMessage());
        	}
        	$this->auteurId = $auteurMetier->_auteurId;
        }
        /*
        $query = "SELECT id_auteur FROM spip_auteurs WHERE login='$login'";
		$result = spip_query($query);
		if (spip_num_rows($result)) return false;
		*/
        /*
        $query = "INSERT IGNORE INTO spip_auteurs (source, nom, login, email, bio, statut, pass) ".
			"VALUES ('ldap', '$nom', '$login', '$email', '$bio', '$statut', '')";
		return spip_query($query);
		*/
        //-----------Fin Modifications Clever Age -----------
	}
}
?>
