<?php

//
// $Id$

include_once ("inc_acces.php3");

// cette focntion est inutile dans AGORA 
function creer_base() {

	global $spip_version;

	//
	// Elements redactionnels
	//

	spip_log("creation des tables d'objets");
	$query = "CREATE TABLE spip_articles (
		id_article bigint(21) NOT NULL auto_increment,
		surtitre text NOT NULL,
		titre text NOT NULL,
		soustitre text NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		descriptif text NOT NULL,
		chapo mediumtext NOT NULL,
		texte longblob NOT NULL,
		ps mediumtext NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		statut varchar(10) DEFAULT '0' NOT NULL,
		id_secteur bigint(21) DEFAULT '0' NOT NULL,
		maj TIMESTAMP,
		export VARCHAR(10) DEFAULT 'oui',
		date_redac datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		visites INTEGER DEFAULT '0' NOT NULL,
		referers INTEGER DEFAULT '0' NOT NULL,
		popularite DOUBLE DEFAULT '0' NOT NULL,
		accepter_forum CHAR(3) NOT NULL,
		auteur_modif bigint(21) DEFAULT '0' NOT NULL,
		date_modif datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		lang VARCHAR(10) DEFAULT '' NOT NULL,
		langue_choisie VARCHAR(3) DEFAULT 'non',
		id_trad bigint(21) DEFAULT '0' NOT NULL,
		extra longblob NULL,
		nom_site tinytext NOT NULL,
		url_site VARCHAR(255) NOT NULL,
		PRIMARY KEY (id_article),
		KEY id_rubrique (id_rubrique),
		KEY id_secteur (id_secteur),
		KEY id_trad (id_trad),
		KEY lang (lang),
		KEY statut (statut, date),
		KEY url_site (url_site),
		KEY date_modif (date_modif))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_auteurs (
		id_auteur bigint(21) NOT NULL auto_increment,
		nom text NOT NULL,
		bio text NOT NULL,
		email tinytext NOT NULL,
		nom_site tinytext NOT NULL,
		url_site text NOT NULL,
		login VARCHAR(255) BINARY NOT NULL,
		pass tinytext NOT NULL,
		low_sec tinytext NOT NULL,
		statut VARCHAR(255) NOT NULL,
		maj TIMESTAMP,
		pgp BLOB NOT NULL,
		htpass tinyblob NOT NULL,
		en_ligne datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		imessage VARCHAR(3) NOT NULL,
		messagerie VARCHAR(3) NOT NULL,
		alea_actuel tinytext NOT NULL,
		alea_futur tinytext NOT NULL,
		prefs tinytext NOT NULL,
		cookie_oubli tinytext NOT NULL,
		source VARCHAR(10) DEFAULT 'spip' NOT NULL,
		lang VARCHAR(10) DEFAULT '' NOT NULL,
		extra longblob NULL,
		PRIMARY KEY (id_auteur),
		KEY login (login),
		KEY statut (statut),
		KEY lang (lang),
		KEY en_ligne (en_ligne))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_breves (
		id_breve bigint(21) NOT NULL auto_increment,
		date_heure datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		titre text NOT NULL,
		texte longblob NOT NULL,
		lien_titre text NOT NULL,
		lien_url text NOT NULL,
		statut varchar(6) NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		lang VARCHAR(10) DEFAULT '' NOT NULL,
		langue_choisie VARCHAR(3) DEFAULT 'non',
		maj TIMESTAMP,
		extra longblob NULL,
		PRIMARY KEY (id_breve),
		KEY id_rubrique (id_rubrique))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_messages (
		id_message bigint(21) NOT NULL auto_increment,
		titre text NOT NULL,
		texte longblob NOT NULL,
		type varchar(6) NOT NULL,
		date_heure datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		date_fin datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		rv varchar(3) NOT NULL,
		statut varchar(6) NOT NULL,
		id_auteur bigint(21) NOT NULL,
		maj TIMESTAMP,
		KEY id_auteur (id_auteur),
		PRIMARY KEY (id_message))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots (
		id_mot bigint(21) NOT NULL auto_increment,
		type VARCHAR(100) NOT NULL,
		titre text NOT NULL,
		descriptif text NOT NULL,
		texte longblob NOT NULL,
		id_groupe bigint(21) NOT NULL,
		extra longblob NULL,
		maj TIMESTAMP,
		PRIMARY KEY (id_mot),
		KEY type(type))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_groupes_mots (
		id_groupe bigint(21) NOT NULL auto_increment,
		titre text NOT NULL,
		unseul varchar(3) NOT NULL,
		obligatoire varchar(3) NOT NULL,
		articles varchar(3) NOT NULL,
		breves varchar(3) NOT NULL,
		rubriques varchar(3) NOT NULL,
		syndic varchar(3) NOT NULL,
		0minirezo varchar(3) NOT NULL,
		1comite varchar(3) NOT NULL,
		6forum varchar(3) NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (id_groupe))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_rubriques (
		id_rubrique bigint(21) NOT NULL auto_increment,
		id_parent bigint(21) DEFAULT '0' NOT NULL,
		titre text NOT NULL,
		descriptif text NOT NULL,
		texte longblob NOT NULL,
		id_secteur bigint(21) DEFAULT '0' NOT NULL,
		maj TIMESTAMP,
		export VARCHAR(10) DEFAULT 'oui',
		id_import BIGINT DEFAULT '0',
		statut VARCHAR(10) NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		lang VARCHAR(10) DEFAULT '' NOT NULL,
		langue_choisie VARCHAR(3) DEFAULT 'non',
		extra longblob NULL,
		PRIMARY KEY (id_rubrique),
		KEY lang (lang),
		KEY id_parent (id_parent))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_documents (
		id_document bigint(21) NOT NULL auto_increment,
		id_vignette bigint(21) DEFAULT '0' NOT NULL,
		id_type bigint(21) DEFAULT '0' NOT NULL,
		titre text NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		descriptif text NOT NULL,
		fichier varchar(255) NOT NULL,
		taille integer NOT NULL,
		largeur integer NOT NULL,
		hauteur integer NOT NULL,
		mode ENUM('vignette', 'document') NOT NULL,
		inclus VARCHAR(3) DEFAULT 'non',
		maj TIMESTAMP,
		PRIMARY KEY (id_document),
		KEY id_vignette (id_vignette),
		KEY mode (mode),
		KEY id_type (id_type))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_types_documents (
		id_type bigint(21) NOT NULL auto_increment,
		titre text NOT NULL,
		descriptif text NOT NULL,
		extension varchar(10) NOT NULL,
		mime_type varchar(100) NOT NULL,
		inclus ENUM('non', 'image', 'embed') NOT NULL DEFAULT 'non',
		upload ENUM('oui', 'non') NOT NULL DEFAULT 'oui',
		maj TIMESTAMP,
		PRIMARY KEY (id_type),
		UNIQUE extension (extension),
		KEY inclus (inclus))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_syndic (
		id_syndic bigint(21) NOT NULL auto_increment,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		id_secteur bigint(21) DEFAULT '0' NOT NULL,
		nom_site blob NOT NULL,
		url_site blob NOT NULL,
		url_syndic blob NOT NULL,
		descriptif blob NOT NULL,
		maj TIMESTAMP,
		syndication VARCHAR(3) NOT NULL,
		statut VARCHAR(10) NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		date_syndic datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		date_index datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		moderation VARCHAR(3) NOT NULL,
		PRIMARY KEY (id_syndic),
		KEY id_rubrique (id_rubrique),
		KEY id_secteur (id_secteur),
		KEY statut (statut, date_syndic))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_syndic_articles (
		id_syndic_article bigint(21) NOT NULL auto_increment,
		id_syndic bigint(21) DEFAULT '0' NOT NULL,
		titre text NOT NULL,
		url VARCHAR(255) NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		lesauteurs text NOT NULL,
		maj TIMESTAMP,
		statut VARCHAR(10) NOT NULL,
		descriptif blob NOT NULL,
		PRIMARY KEY (id_syndic_article),
		KEY id_syndic (id_syndic),
		KEY statut (statut),
		KEY url (url))";
	$result = spip_query($query);


	//
	// Elements interactifs
	//

	spip_log("creation des tables interactions");
	$query = "CREATE TABLE spip_forum (
		id_forum bigint(21) NOT NULL auto_increment,
		id_parent bigint(21) DEFAULT '0' NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		id_breve bigint(21) DEFAULT '0' NOT NULL,
		date_heure datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		titre text NOT NULL,
		texte mediumtext NOT NULL,
		auteur text NOT NULL,
		email_auteur text NOT NULL,
		nom_site text NOT NULL,
		url_site text NOT NULL,
		statut varchar(8) NOT NULL,
		ip varchar(16),
		maj TIMESTAMP,
		id_auteur BIGINT DEFAULT '0' NOT NULL,
		id_message bigint(21) DEFAULT '0' NOT NULL,
		id_syndic bigint(21) DEFAULT '0' NOT NULL,
		PRIMARY KEY (id_forum),
		KEY id_parent (id_parent),
		KEY id_rubrique (id_rubrique),
		KEY id_article (id_article),
		KEY id_breve (id_breve),
		KEY id_message (id_message),
		KEY id_syndic (id_syndic),
		KEY statut (statut, date_heure))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_petitions (
		id_article bigint(21) DEFAULT '0' NOT NULL,
		email_unique char(3) NOT NULL,
		site_obli char(3) NOT NULL,
		site_unique char(3) NOT NULL,
		message char(3) NOT NULL,
		texte longblob NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_signatures (
		id_signature bigint(21) NOT NULL auto_increment,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		date_time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		nom_email text NOT NULL,
		ad_email text NOT NULL,
		nom_site text NOT NULL,
		url_site text NOT NULL,
		message mediumtext NOT NULL,
		statut varchar(10) NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (id_signature),
		KEY id_article (id_article),
		KEY statut(statut))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_visites_temp (
		ip INTEGER UNSIGNED NOT NULL,
		type ENUM('article', 'rubrique', 'breve', 'autre') NOT NULL,
		id_objet INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (type, id_objet, ip))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_visites (
		date DATE NOT NULL,
		visites INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (date))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_visites_articles (
		date DATE NOT NULL,
		id_article INTEGER UNSIGNED NOT NULL,
		visites INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (date, id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_referers_temp (
		ip INTEGER UNSIGNED NOT NULL,
		referer VARCHAR(255) NOT NULL,
		referer_md5 BIGINT UNSIGNED NOT NULL,
		type ENUM('article', 'rubrique', 'breve', 'autre') NOT NULL,
		id_objet INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (type, id_objet, referer_md5, ip))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_referers (
		referer_md5 BIGINT UNSIGNED NOT NULL,
		date DATE NOT NULL,
		referer VARCHAR(255) NOT NULL,
		visites INTEGER UNSIGNED NOT NULL,
		visites_jour INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (referer_md5))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_referers_articles (
		id_article INTEGER UNSIGNED NOT NULL,
		referer_md5 BIGINT UNSIGNED NOT NULL,
		date DATE NOT NULL,
		referer VARCHAR(255) NOT NULL,
		visites INTEGER UNSIGNED NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (id_article, referer_md5),
		KEY referer_md5 (referer_md5))";
	$result = spip_query($query);


	//
	// Relations
	//

	spip_log("creation des tables relations");
	$query = "CREATE TABLE spip_auteurs_articles (
		id_auteur bigint(21) DEFAULT '0' NOT NULL,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		KEY id_auteur (id_auteur),
		KEY id_article (id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_auteurs_rubriques (
		id_auteur bigint(21) DEFAULT '0' NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		KEY id_auteur (id_auteur),
		KEY id_rubrique (id_rubrique))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_auteurs_messages (
		id_auteur bigint(21) DEFAULT '0' NOT NULL,
		id_message bigint(21) DEFAULT '0' NOT NULL,
		vu CHAR(3) NOT NULL,
		KEY id_auteur (id_auteur),
		KEY id_message (id_message))";
	$result = spip_query($query);


	$query = "CREATE TABLE spip_documents_articles (
		id_document bigint(21) DEFAULT '0' NOT NULL,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		KEY id_document (id_document),
		KEY id_article (id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_documents_rubriques (
		id_document bigint(21) DEFAULT '0' NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		KEY id_document (id_document),
		KEY id_rubrique (id_rubrique))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_documents_breves (
		id_document bigint(21) DEFAULT '0' NOT NULL,
		id_breve bigint(21) DEFAULT '0' NOT NULL,
		KEY id_document (id_document),
		KEY id_breve (id_breve))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots_articles (
		id_mot bigint(21) DEFAULT '0' NOT NULL,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		KEY id_mot (id_mot),
		KEY id_article (id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots_breves (
		id_mot bigint(21) DEFAULT '0' NOT NULL,
		id_breve bigint(21) DEFAULT '0' NOT NULL,
		KEY id_mot (id_mot),
		KEY id_breve (id_breve))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots_rubriques (
		id_mot bigint(21) DEFAULT '0' NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		KEY id_mot (id_mot),
		KEY id_rubrique (id_rubrique))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots_syndic (
		id_mot bigint(21) DEFAULT '0' NOT NULL,
		id_syndic bigint(21) DEFAULT '0' NOT NULL,
		KEY id_mot (id_mot),
		KEY id_syndic (id_syndic))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_mots_forum (
		id_mot bigint(21) DEFAULT '0' NOT NULL,
		id_forum bigint(21) DEFAULT '0' NOT NULL,
		KEY id_mot (id_mot),
		KEY id_forum (id_forum))";
	$result = spip_query($query);


	//
	// Gestion du site
	//

	spip_log("creation des tables gestion du site");
	$query = "CREATE TABLE spip_forum_cache (
		id_forum bigint(21) DEFAULT '0' NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		id_article bigint(21) DEFAULT '0' NOT NULL,
		id_breve bigint(21) DEFAULT '0' NOT NULL,
		id_syndic bigint(21) DEFAULT '0' NOT NULL,
		fichier char(150) binary NOT NULL,
		maj TIMESTAMP,
		PRIMARY KEY (fichier, id_forum, id_article, id_rubrique, id_breve, id_syndic),
		KEY id_forum(id_forum),
		KEY id_rubrique(id_rubrique),
		KEY id_article(id_article),
		KEY id_syndic(id_syndic),
		KEY id_breve(id_breve))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_meta (
		nom VARCHAR(255) NOT NULL,
		valeur VARCHAR(255) DEFAULT '',
		maj TIMESTAMP,
		PRIMARY KEY (nom))";
	$result = spip_query($query);


	//
	// Indexation (moteur de recherche)
	//

	$query = "CREATE TABLE spip_index_articles (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_article int unsigned NOT NULL,
		KEY hash (hash),
		KEY id_article (id_article))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_auteurs (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_auteur int unsigned NOT NULL,
		KEY hash (hash),
		KEY id_auteur (id_auteur))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_breves (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_breve int unsigned NOT NULL,
		KEY hash (hash),
		KEY id_breve (id_breve))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_mots (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_mot int unsigned NOT NULL,
		KEY hash (hash), KEY id_mot (id_mot))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_rubriques (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_rubrique int unsigned NOT NULL,
		KEY hash (hash),
		KEY id_rubrique (id_rubrique))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_syndic (
		hash bigint unsigned NOT NULL,
		points int unsigned DEFAULT '0' NOT NULL,
		id_syndic int unsigned NOT NULL,
		KEY hash (hash),
		KEY id_syndic (id_syndic))";
	$result = spip_query($query);

	$query = "CREATE TABLE spip_index_dico (
		hash bigint unsigned NOT NULL,
		dico VARCHAR(30) NOT NULL,
		PRIMARY KEY (dico))";
	$result = spip_query($query);


	//
	// Pre-remplissage de la base
	//
	spip_log("pre-remplissage de la base");
	remplir_type_documents();

}


function remplir_type_documents() {
	// Images reconnues par PHP
	$query = "INSERT IGNORE spip_types_documents (id_type, extension, titre, inclus) VALUES ".
		"(1, 'jpg', 'JPEG', 'image'), ".
		"(2, 'png', 'PNG', 'image'), ".
		"(3, 'gif', 'GIF', 'image')";
	spip_query($query);

	// Autres images (peuvent utiliser le tag <img>)
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('bmp', 'BMP', 'image'), ".
		"('psd', 'Photoshop', 'image'), ".
		"('tif', 'TIFF', 'image')";
	spip_query($query);

	// Multimedia (peuvent utiliser le tag <embed>)
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('aiff', 'AIFF', 'embed'), ".
		"('asf', 'Windows Media', 'embed'), ".
		"('avi', 'Windows Media', 'embed'), ".
		"('mid', 'Midi', 'embed'), ".
		"('mng', 'MNG', 'embed'), ".
		"('mov', 'QuickTime', 'embed'), ".
		"('mp3', 'MP3', 'embed'), ".
		"('mpg', 'MPEG', 'embed'), ".
		"('ogg', 'Ogg', 'embed'), ".
		"('qt', 'QuickTime', 'embed'), ".
		"('ra', 'RealAudio', 'embed'), ".
		"('ram', 'RealAudio', 'embed'), ".
		"('rm', 'RealAudio', 'embed'), ".
		"('swf', 'Flash', 'embed'), ".
		"('wav', 'WAV', 'embed'), ".
		"('wmv', 'Windows Media', 'embed')";
	spip_query($query);

	// Documents varies
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('ai', 'Adobe Illustrator', 'non'), ".
		"('bz2', 'BZip', 'non'), ".
		"('c', 'C source', 'non'), ".
		"('deb', 'Debian', 'non'), ".
		"('doc', 'Word', 'non'), ".
		"('djvu', 'DjVu', 'non'), ".
		"('dvi', 'LaTeX DVI', 'non'), ".
		"('eps', 'PostScript', 'non'), ".
		"('gz', 'GZ', 'non'), ".
		"('h', 'C header', 'non'), ".
		"('html', 'HTML', 'non'), ".
		"('pas', 'Pascal', 'non'), ".
		"('pdf', 'PDF', 'non'), ".
		"('ppt', 'PowerPoint', 'non'), ".
		"('ps', 'PostScript', 'non'), ".
		"('rpm', 'RedHat/Mandrake/SuSE', 'non'), ".
		"('rtf', 'RTF', 'non'), ".
		"('sdd', 'StarOffice', 'non'), ".
		"('sdw', 'StarOffice', 'non'), ".
		"('sit', 'Stuffit', 'non'), ".
		"('sxc', 'OpenOffice Calc', 'non'), ".
		"('sxi', 'OpenOffice Impress', 'non'), ".
		"('sxw', 'OpenOffice', 'non'), ".
		"('tex', 'LaTeX', 'non'), ".
		"('tgz', 'TGZ', 'non'), ".
		"('txt', 'texte', 'non'), ".
		"('xcf', 'GIMP multi-layer', 'non'), ".
		"('xls', 'Excel', 'non'), ".
		"('xml', 'XML', 'non'), ".
		"('zip', 'Zip', 'non')";
	spip_query($query);
}

function stripslashes_base($table, $champs) {
	$modifs = '';
	reset($champs);
	while (list(, $champ) = each($champs)) {
		$modifs[] = $champ . '=REPLACE(REPLACE(' .$champ. ',"\\\\\'", "\'"), \'\\\\"\', \'"\')';
	}
	$query = "UPDATE $table SET ".join(',', $modifs);
	spip_query($query);
}


function maj_version($version, $test = true) {
	/***** Modification elebescond@clever-age.com ********/
	if ($test) {
		$metaMetier = &recuperer_instance_meta();
		$loadOK = $metaMetier->load('version_installee');
		if (PEAR::isError($loadOK)) {
			die ($loadOK->getMessage());
		}
		$metaMetier->setValeur($version);
		$updateOK = $metaMetier->update();
		if (PEAR::isError($updateOK)) {
			die ($updateOK->getMessage());
		}
	}
	else {
		include_ecrire ('inc_lang.php3');
		echo _T('alerte_maj_impossible', array('version' => $version));
		exit;
	}
	/*
	if ($test) {
		spip_query("REPLACE spip_meta (nom, valeur) VALUES ('version_installee', '$version')");
		spip_log("mise a jour de la base vers $version");
	}
	else {
		include_ecrire ('inc_lang.php3');
		echo _T('alerte_maj_impossible', array('version' => $version));
		exit;
	}
	*/
	/***** Fin modification elebescond@clever-age.com ********/
}

function _private_maj_base($version, &$bd_params, &$db)
{
	$phpBeforeFile = dirname(__FILE__).'/install/sql/'.$bd_params->getDbEngine().'/maj/'.$version.'_before.php';
	$structFile = dirname(__FILE__).'/install/sql/'.$bd_params->getDbEngine().'/maj/'.$version.'.sql';
	$dataFile = dirname(__FILE__).'/install/sql/'.$bd_params->getDbEngine().'/maj/'.$version.'_data.sql';
	$phpAfterFile = dirname(__FILE__).'/install/sql/'.$bd_params->getDbEngine().'/maj/'.$version.'_after.php';
	
	if (file_exists($phpBeforeFile))
	{
		include $phpBeforeFile;
	}
	
	if (file_exists($structFile))
	{
		$sqlScript = new SQLScript_spipagora($structFile, BLOCKMODE);
		$result_ok = $sqlScript->executeScript($db);
		unset($sqlScript);
		
		if (!$result_ok) {
			echo "<B>"._T('avis_operation_echec')."</B> "._T('texte_operation_echec');
			exit;
		}
	}
	
	if (file_exists($dataFile))
	{
		$sqlScript = new SQLScript_spipagora($dataFile, LINEMODE);
		$result_ok = $sqlScript->executeScript($db);
		unset($sqlScript);
		if (!$result_ok) {
			echo "<B>"._T('avis_operation_echec')."</B> "._T('texte_operation_echec');
			exit;
		}
	}
	
	if (file_exists($phpAfterFile))
	{
		include $phpAfterFile;
	}
	
	maj_version($version);

}

function maj_base() {
	/********* Modification elebescond@clever-age.com **********/
	
	
	require_once('DB.php');
	require_once(dirname(__FILE__).'/include/bd/parameters.php');
	
	//Inclusion de la classe permettant d'executer des requetes SQL depuis des fichiers
	//SQL convenablement formattes
	require_once(dirname(__FILE__).'/install/SQLScript/spipagora.php');

	global $agora_version;
	global $bd_params;
	
	$db = &DB::connect($bd_params->getDSN(), null);
	
	$version_installee = 0.0;
	$metaMetier = &recuperer_instance_meta();
	$loadOK = $metaMetier->load('version_installee');

	$version_installee = (double) $metaMetier->getValeur();
	
	if (!(double)$metaMetier->getValeur() || PEAR::isError($metaMetier)) {
		include_ecrire ('inc_lang.php3');
		echo _T('alerte_maj_impossible', array('version' => $version));
		return true;
	}
	
	
	
	//Maciek: dynamicaly determine which version we should update.
	$verExecuted = 0.0;
	foreach (glob(dirname(__FILE__).'/install/sql/'.$bd_params->getDbEngine().'/maj/*.sql') as $filename) {
		$filename = basename($filename);
		$verToExecute = floatval(substr($filename, 0, 4));
		if ($verToExecute == 0) {
			include_ecrire ('inc_lang.php3');
			echo _T('alerte_maj_impossible', array('version' => $version));
			return true;
		}
			
		if ($verToExecute > $version_installee) {
			if ($verToExecute != $verExecuted) {
				_private_maj_base($verToExecute, $bd_params, $db);
				$verExecuted = $verToExecute;
			}
		}
	}

	$metaMetier->load('version_installee');
	$version_installee = (double) $metaMetier->getValeur();
	if ($version_installee < $agora_version) _private_maj_base($agora_version, $bd_params, $db);


	//Maciek: we need to delete the spip_action cache too...
	foreach (glob(dirname(__FILE__).'/data/auth_*.php') as $filename) {
		unlink ( $filename);
	}
	
	return true;
	
	
	/********* Fin modification elebescond@clever-age.com **********/
}

//Ajout elebescond
// Function glob pour les pauvres gens comme moi qui utilise php 4.2.2
if (!function_exists(glob)) {
	function glob ($pattern) {
	   $path_parts = pathinfo ($pattern);
	   $pattern = '^' . str_replace (array ('*',  '?'), array ('(.+)', '(.)'), $path_parts['basename'] . '$');
	   $dir = opendir ($path_parts['dirname']);
	   while ($file = readdir ($dir)) {
	       if (ereg ($pattern, $file)) $result[] = "{$path_parts['dirname']}/$file";
	   }
	   closedir ($dir);
	
	   // my changes here
	   if ( isset($result) )
	       return $result;
	  
	   return (array) null;
	} 
}
?>