<?php

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_BASE_AGORA_MYSQL")) return;
define("_ECRIRE_INC_BASE_AGORA_MYSQL", "1");

include_ecrire ("inc_acces.php3");


function creer_base() {

	global $agora_version;

	//
	// Elements redactionnels
	//

	spip_log("creation des tables d'objets");
	$query = "CREATE TABLE spip_articles (
		id_article bigint(21) NOT NULL auto_increment,
		surtitre text NOT NULL,
		titre text NOT NULL,
		soustitre text NOT NULL,
		id_rubrique bigint(21) DEFAULT '0' NOT NULL,
		descriptif text NOT NULL,
		chapo mediumtext NOT NULL,
		texte longblob NOT NULL,
		ps mediumtext NOT NULL,
		date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		statut varchar(10) DEFAULT '0' NOT NULL,
		id_secteur bigint(21) DEFAULT '0' NOT NULL,
		maj TIMESTAMP,
		export VARCHAR(10) DEFAULT 'oui',
		date_redac datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		visites INTEGER DEFAULT '0' NOT NULL,
		referers INTEGER DEFAULT '0' NOT NULL,
		popularite DOUBLE DEFAULT '0' NOT NULL,
		accepter_forum CHAR(3) NOT NULL,
		auteur_modif bigint(21) DEFAULT '0' NOT NULL,
		date_modif datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
		lang VARCHAR(10) DEFAULT '' NOT NULL,
		extra longblob NULL,
		PRIMARY KEY (id_article),
		KEY id_rubrique (id_rubrique),
		KEY id_secteur (id_secteur),
		KEY lang (lang),
		KEY statut (statut, date))";
	$result = spip_query($query);


	$query = "CREATE TABLE spip_actions (
  		action varchar(255) NOT NULL default '',
  		poids int(11) NOT NULL default '0',
  		PRIMARY KEY  (action)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_articles (
  		id_article bigint(21) NOT NULL default '0',
  		surtitre blob NOT NULL,
  		titre blob NOT NULL,
  		soustitre blob NOT NULL,
  		id_rubrique bigint(21) NOT NULL default '0',
  		descriptif blob NOT NULL,
  		chapo blob NOT NULL,
  		texte blob NOT NULL,
  		ps blob NOT NULL,
  		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
  		statut varchar(10) NOT NULL default '0',
  		id_secteur bigint(21) NOT NULL default '0',
  		maj varchar(19) default NULL,
  		export varchar(10) default 'oui',
  		date_redac varchar(19) NOT NULL default '0000-00-00 00:00:00',
  		visites int(11) NOT NULL default '0',
  		referers int(11) NOT NULL default '0',
  		popularite double NOT NULL default '0',
  		accepter_forum varchar(8) NOT NULL default '',
  		auteur_modif bigint(21) NOT NULL default '0',
  		date_modif varchar(19) NOT NULL default '0000-00-00 00:00:00',
  		extra longblob NOT NULL,
  		lang varchar(10) NOT NULL default '',
  		PRIMARY KEY  (id_article),
  		KEY id_rubrique (id_rubrique),
  		KEY id_secteur (id_secteur),
  		KEY statut (statut,date_heure)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_auteurs (
  		id_auteur bigint(21) NOT NULL default '0',
  		nom blob NOT NULL,
  		bio blob NOT NULL,
  		email blob NOT NULL,
  		nom_site blob NOT NULL,
  		url_site blob NOT NULL,
  		login varchar(255) binary NOT NULL default '',
  		pass blob NOT NULL,
  		statut varchar(255) NOT NULL default '',
  		profil bigint(20) NOT NULL default '0',
  		maj varchar(19) default NULL,
  		pgp blob NOT NULL,
  		htpass blob NOT NULL,
  		en_ligne varchar(19) NOT NULL default '0000-00-00 00:00:00',
  		imessage varchar(4) NOT NULL default '',
  		messagerie varchar(4) NOT NULL default '',
  		alea_actuel blob NOT NULL,
  		alea_futur blob NOT NULL,
  		prefs blob NOT NULL,
  		cookie_oubli blob NOT NULL,
  		source varchar(10) NOT NULL default 'spip',
  		lang varchar(20) default NULL,
  		extra longblob NOT NULL,
  		PRIMARY KEY  (id_auteur),
  		KEY login (login),
  		KEY statut (statut),
  		KEY en_ligne (en_ligne)
		) TYPE=MyISAM";
	
	$query = "CREATE TABLE spip_auteurs_articles (
		id_auteur bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		KEY id_auteur (id_auteur),
		KEY id_article (id_article)
		) TYPE=MyISAM";


	$query = "CREATE TABLE spip_auteurs_messages (
  		id_auteur bigint(21) NOT NULL default '0',
  		id_message bigint(21) NOT NULL default '0',
  		vu varchar(4) NOT NULL default '',
  		KEY id_auteur (id_auteur),
  		KEY id_message (id_message)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_auteurs_rubriques (
		id_auteur bigint(21) NOT NULL default '0',
		id_rubrique bigint(21) NOT NULL default '0',
		KEY id_auteur (id_auteur),
		KEY id_rubrique (id_rubrique)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_auteurs_seq (
  		id int(10) unsigned NOT NULL auto_increment,
  		PRIMARY KEY  (id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_breves (
  		id_breve bigint(21) NOT NULL default '0',
  		date_heure varchar(19) NOT NULL default '',
  		titre blob NOT NULL,
  		texte blob NOT NULL,
  		lien_titre blob NOT NULL,
  		lien_url blob NOT NULL,
  		statut varchar(6) NOT NULL default '',
  		id_rubrique bigint(21) NOT NULL default '0',
  		maj varchar(19) default NULL,
  		extra longblob NOT NULL,
  		lang longblob NOT NULL,
  		PRIMARY KEY  (id_breve),
  		KEY id_rubrique (id_rubrique)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_lists (
		lst_id int(11) NOT NULL default '0',
		lst_name varchar(255) NOT NULL default '',
		lst_comment text NOT NULL,
		lst_moderation varchar(10) NOT NULL default '',
		lst_moderator_email varchar(255) NOT NULL default '',
		lst_subscribe_subject varchar(255) NOT NULL default '',
		lst_subscribe_text text NOT NULL,
		lst_subject varchar(255) NOT NULL default '',
		lst_unsubscribe_subject varchar(255) NOT NULL default '',
		lst_unsubscribe_text text NOT NULL,
		lst_subject_tag tinyint(1) NOT NULL default '1',
		lst_html_skeleton varchar(200) NOT NULL default '',
		lst_text_skeleton varchar(200) NOT NULL default '',
		lst_nb_articles tinyint(4) NOT NULL default '0',
		PRIMARY KEY  (lst_id),
		FULLTEXT KEY lst_name (lst_name)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_lists_subscribers (
		lst_id int(11) NOT NULL default '0',
		sub_id bigint(20) NOT NULL default '0',
		lsr_mode tinyint(1) NOT NULL default '0',
		lsr_id varchar(32) NOT NULL default '',
		PRIMARY KEY  (lst_id,sub_id),
		KEY lst_id (lst_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_pending (
		lst_id int(11) NOT NULL default '0',
		sub_id bigint(20) NOT NULL default '0',
		pnd_action varchar(15) NOT NULL default '',
		pnd_mode tinyint(1) NOT NULL default '0',
		pnd_action_date int(11) NOT NULL default '0',
		pnd_action_id varchar(32) NOT NULL default '',
		PRIMARY KEY  (lst_id,sub_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_posts (
		pst_id bigint(20) NOT NULL default '0',
		lst_id int(11) NOT NULL default '0',
		pst_date_create int(11) NOT NULL default '0',
		pst_date_update int(11) NOT NULL default '0',
		pst_date_sent int(11) NOT NULL default '0',
		pst_subject varchar(255) NOT NULL default '',
		PRIMARY KEY  (pst_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_posts_articles (
		article_id bigint(20) unsigned NOT NULL default '0',
		pst_id bigint(20) NOT NULL default '0',
		art_order tinyint(3) unsigned NOT NULL default '0',
		KEY article_id (article_id),
			KEY pst_id (pst_id)
		) TYPE=MyISAM COMMENT='Tables contenant les articles associs  un post de NL donn'";

	$query = "CREATE TABLE spip_cm_posts_done (
		pst_id bigint(20) NOT NULL default '0',
		sub_id bigint(20) NOT NULL default '0',
		PRIMARY KEY  (pst_id,sub_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_posts_links (
		lnk_id bigint(20) NOT NULL default '0',
		pst_id bigint(20) NOT NULL default '0',
		lnk_name varchar(255) NOT NULL default '',
		lnk_url text NOT NULL,
		PRIMARY KEY  (lnk_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_posts_queued (
		pst_id bigint(20) NOT NULL default '0',
		sub_id bigint(20) NOT NULL default '0',
		psq_date int(11) NOT NULL default '0',
		PRIMARY KEY  (pst_id,sub_id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_settings (
		set_name varchar(15) NOT NULL default '',
		set_value varchar(255) NOT NULL default '',
		PRIMARY KEY  (set_name)
		) TYPE=MyISAM COMMENT='Application settings'";

	$query = "CREATE TABLE spip_cm_subscribers (
		sub_id bigint(20) NOT NULL default '0',
		sub_email varchar(255) NOT NULL default '',
		sub_first_name varchar(50) NOT NULL default '',
		sub_middle_name varchar(50) NOT NULL default '',
		sub_last_name varchar(50) NOT NULL default '',
		sub_title varchar(10) NOT NULL default '',
		sub_profile varchar(32) NOT NULL default '',
		PRIMARY KEY  (sub_id),
		KEY sub_profile (sub_profile),
		KEY sub_email (sub_email)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_cm_subscribers_seq (
		id int(10) unsigned NOT NULL auto_increment,
		PRIMARY KEY  (id)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_documents (
		id_document bigint(21) NOT NULL default '0',
		id_vignette bigint(21) NOT NULL default '0',
		id_type bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		descriptif blob NOT NULL,
		fichier varchar(255) NOT NULL default '',
		taille int(11) NOT NULL default '0',
		largeur int(11) NOT NULL default '0',
		hauteur int(11) NOT NULL default '0',
		mode_spip varchar(8) NOT NULL default 'vignette',
		inclus varchar(4) default 'non',
		maj varchar(19) default NULL,
		PRIMARY KEY  (id_document),
		KEY id_vignette (id_vignette),
		KEY mode (mode_spip),
		KEY id_type (id_type)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_documents_articles (
		id_document bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		KEY id_document (id_document),
		KEY id_article (id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_documents_breves (
		id_document bigint(21) NOT NULL default '0',
		id_breve bigint(21) NOT NULL default '0',
		KEY id_document (id_document),
		KEY id_breve (id_breve)
		) TYPE=MyISAM";


	$query = "CREATE TABLE spip_documents_rubriques (
		id_document bigint(21) NOT NULL default '0',
		id_rubrique bigint(21) NOT NULL default '0',
		KEY id_document (id_document),
		KEY id_rubrique (id_rubrique)
		) TYPE=MyISAM";


	$query = "CREATE TABLE spip_forum (
		id_forum bigint(21) NOT NULL default '0',
		id_parent bigint(21) NOT NULL default '0',
		id_rubrique bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		id_breve bigint(21) NOT NULL default '0',
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		titre blob NOT NULL,
		texte blob NOT NULL,
		auteur blob NOT NULL,
		email_auteur blob NOT NULL,
		nom_site blob NOT NULL,
		url_site blob NOT NULL,
		statut varchar(8) NOT NULL default '',
		ip varchar(16) default NULL,
		maj varchar(19) default NULL,
		id_auteur bigint(20) NOT NULL default '0',
		id_message bigint(21) NOT NULL default '0',
		id_syndic bigint(21) NOT NULL default '0',
		profil_auteur int(11) default '0',
		alerte_mail varchar(4) NOT NULL default 'oui',
		PRIMARY KEY  (id_forum),
		KEY id_parent (id_parent),
		KEY id_rubrique (id_rubrique),
		KEY id_article (id_article),
		KEY id_breve (id_breve),
		KEY id_message (id_message),
		KEY statut (statut,date_heure)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_forum_cache (
		id_forum bigint(21) NOT NULL default '0',
		id_rubrique bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		id_breve bigint(21) NOT NULL default '0',
		id_syndic bigint(21) NOT NULL default '0',
		fichier varchar(150) binary NOT NULL default '',
		maj varchar(19) default NULL,
		PRIMARY KEY  (fichier,id_forum,id_article,id_rubrique,id_breve,id_syndic),
		KEY id_forum (id_forum),
		KEY id_rubrique (id_rubrique),
		KEY id_article (id_article),
		KEY id_syndic (id_syndic),
		KEY id_breve (id_breve)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_groupes_mots (
		id_groupe bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		unseul varchar(4) NOT NULL default '',
		obligatoire varchar(4) NOT NULL default '',
		articles varchar(4) NOT NULL default '',
		breves varchar(4) NOT NULL default '',
		rubriques varchar(4) NOT NULL default '',
		syndic varchar(4) NOT NULL default '',
		auteurs varchar(4) NOT NULL default '',
		forum varchar(4) NOT NULL default '',
		maj varchar(19) default NULL,
		profils int(11) NOT NULL default '0',
		PRIMARY KEY  (id_groupe)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_articles (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_article int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_article (id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_auteurs (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_auteur int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_auteur (id_auteur)
		TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_breves (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_breve int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_breve (id_breve)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_dico (
		hash varchar(255) NOT NULL default '0',
		dico varchar(30) NOT NULL default '',
		PRIMARY KEY  (dico)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_mots (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_mot int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_mot (id_mot)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_rubriques (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_rubrique int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_rubrique (id_rubrique)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_index_syndic (
		hash varchar(255) NOT NULL default '0',
		points int(10) unsigned NOT NULL default '0',
		id_syndic int(10) unsigned NOT NULL default '0',
		KEY hash (hash),
		KEY id_syndic (id_syndic)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_liens (
		contenant varchar(10) NOT NULL default '',
		lien_interne varchar(10) NOT NULL default '',
		lien_externe varchar(255) NOT NULL default '',
		PRIMARY KEY  (contenant,lien_interne,lien_externe)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_lock_mots (
		lockID varchar(100) NOT NULL default '',
		lockTable varchar(100) NOT NULL default '',
		lockStamp varchar(100) NOT NULL default '',
		PRIMARY KEY  (lockID)
		) TYPE=MyISAM COMMENT='Locks pour utilisation des NestedSet sur les mots cls'";

	$query = "CREATE TABLE spip_messages (
		id_message bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		texte blob NOT NULL,
		type varchar(6) NOT NULL default '',
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		rv varchar(4) NOT NULL default '',
		statut varchar(6) NOT NULL default '',
		id_auteur bigint(21) NOT NULL default '0',
		maj varchar(19) default NULL,
		PRIMARY KEY  (id_message),
		KEY id_auteur (id_auteur)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_meta (
		nom varchar(255) NOT NULL default '',
		valeur varchar(255) default '',
		maj varchar(19) default NULL,
		PRIMARY KEY  (nom)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots (
		id_mot bigint(21) NOT NULL default '0',
		id_root bigint(21) unsigned NOT NULL default '0',
		l bigint(20) unsigned default NULL,
		r bigint(20) unsigned default NULL,
		streh bigint(20) unsigned default NULL,
		level_mot bigint(20) unsigned default NULL,
		strna varchar(100) default NULL,
		type_mot varchar(100) NOT NULL default '',
		titre blob NOT NULL,
		descriptif blob NOT NULL,
		texte blob NOT NULL,
		id_groupe bigint(21) NOT NULL default '0',
		maj varchar(19) default NULL,
		extra longblob NOT NULL,
		PRIMARY KEY  (id_mot),
		KEY type (type_mot),
		KEY id_root (id_root),
		KEY l (l),
		KEY r (r),
		KEY streh (streh),
		KEY level (level_mot)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_articles (
		id_mot bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		KEY id_mot (id_mot),
		KEY id_article (id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_auteurs (
		  id_mot bigint(20) unsigned NOT NULL default '0',
		  id_auteur bigint(20) unsigned NOT NULL default '0',
		  KEY id_mot (id_mot),
		  KEY id_auteur (id_auteur)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_breves (
		  id_mot bigint(21) NOT NULL default '0',
		  id_breve bigint(21) NOT NULL default '0',
		  KEY id_mot (id_mot),
		  KEY id_breve (id_breve)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_forum (
		  id_mot bigint(21) NOT NULL default '0',
		  id_forum bigint(21) NOT NULL default '0',
		  KEY id_mot (id_mot),
		  KEY id_forum (id_forum)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_rubriques (
		  id_mot bigint(21) NOT NULL default '0',
		  id_rubrique bigint(21) NOT NULL default '0',
		  KEY id_mot (id_mot),
		  KEY id_rubrique (id_rubrique)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_mots_syndic (
		  id_mot bigint(21) NOT NULL default '0',
		  id_syndic bigint(21) NOT NULL default '0',
		  KEY id_mot (id_mot),
		  KEY id_syndic (id_syndic)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_petitions (
		  id_article bigint(21) NOT NULL default '0',
		  email_unique varchar(4) NOT NULL default '',
		  site_obli varchar(4) NOT NULL default '',
		  site_unique varchar(4) NOT NULL default '',
		  message varchar(4) NOT NULL default '',
		  texte blob NOT NULL,
		  maj varchar(19) default NULL,
		  PRIMARY KEY  (id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_profils (
		  poids int(11) NOT NULL default '0',
		  intitule varchar(255) NOT NULL default '',
		  PRIMARY KEY  (poids)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_referers (
		  referer_md5 varchar(255) NOT NULL default '0',
		  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		  referer varchar(255) NOT NULL default '',
		  visites int(10) unsigned NOT NULL default '0',
		  visites_jour int(10) unsigned NOT NULL default '0',
		  maj varchar(19) default NULL,
		  PRIMARY KEY  (referer_md5),
		  FULLTEXT KEY maj (maj),
		  FULLTEXT KEY maj_2 (maj)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_referers_articles (
		  id_article int(10) unsigned NOT NULL default '0',
		  referer_md5 varchar(255) NOT NULL default '0',
		  date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		  referer varchar(255) NOT NULL default '',
		  visites int(10) unsigned NOT NULL default '0',
		  maj varchar(19) default NULL,
		  PRIMARY KEY  (id_article,referer_md5),
		  KEY referer_md5 (referer_md5)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_referers_temp (
		  ip varchar(15) NOT NULL default '0.0.0.0',
		  referer varchar(255) NOT NULL default '',
		  referer_md5 varchar(255) NOT NULL default '0',
		  type_referers varchar(8) NOT NULL default 'article',
		  id_objet int(10) unsigned NOT NULL default '0',
		  maj varchar(19) default NULL,
		  PRIMARY KEY  (type,id_objet,referer_md5,ip)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_rubriques (
		id_rubrique bigint(21) NOT NULL default '0',
		id_parent bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		descriptif blob NOT NULL,
		texte blob NOT NULL,
		id_secteur bigint(21) NOT NULL default '0',
		maj varchar(19) default NULL,
		export varchar(10) default 'oui',
		id_import bigint(20) default '0',
		statut varchar(10) NOT NULL default '',
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		extra longblob NOT NULL,
		lang varchar(10) NOT NULL default '',
		PRIMARY KEY  (id_rubrique),
		KEY id_parent (id_parent)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_signatures (
		id_signature bigint(21) NOT NULL default '0',
		id_article bigint(21) NOT NULL default '0',
		date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
		nom_email blob NOT NULL,
		ad_email blob NOT NULL,
		nom_site blob NOT NULL,
		url_site blob NOT NULL,
		message blob NOT NULL,
		statut varchar(10) NOT NULL default '',
		maj varchar(19) default NULL,
		PRIMARY KEY  (id_signature),
		KEY id_article (id_article),
		KEY statut (statut)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_sondages (
		id_article bigint(20) NOT NULL default '0',
		actif char(3) NOT NULL default 'oui',
		affichage_public char(3) NOT NULL default 'non',
		PRIMARY KEY  (id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_sondages_reponses (
		id_article bigint(20) NOT NULL default '0',
		id_reponse bigint(20) NOT NULL default '0',
		texte_reponse varchar(255) NOT NULL default '',
		votes int(11) NOT NULL default '0',
		PRIMARY KEY  (id_article,id_reponse)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_sondages_votes (
		id_article bigint(20) NOT NULL default '0',
		email_votant varchar(255) NOT NULL default '',
		date_time varchar(19) NOT NULL default '0000-00-00 00:00:00',
		id_reponse bigint(20) NOT NULL default '0',
		statut varchar(10) NOT NULL default '',
		PRIMARY KEY  (id_article,email_votant)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_syndic (
		id_syndic bigint(21) NOT NULL default '0',
		id_rubrique bigint(21) NOT NULL default '0',
		id_secteur bigint(21) NOT NULL default '0',
		nom_site blob NOT NULL,
		url_site blob NOT NULL,
		url_syndic blob NOT NULL,
		descriptif blob NOT NULL,
		maj varchar(19) default NULL,
		syndication varchar(4) NOT NULL default '',
		statut varchar(10) NOT NULL default '',
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		date_syndic varchar(19) NOT NULL default '0000-00-00 00:00:00',
		date_index varchar(19) NOT NULL default '0000-00-00 00:00:00',
		moderation varchar(4) NOT NULL default '',
		PRIMARY KEY  (id_syndic),
		KEY id_rubrique (id_rubrique),
		KEY id_secteur (id_secteur),
		KEY statut (statut,date_syndic)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_syndic_articles (
		id_syndic_article bigint(21) NOT NULL default '0',
		id_syndic bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		url varchar(255) NOT NULL default '',
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		lesauteurs blob NOT NULL,
		maj varchar(19) default NULL,
		statut varchar(10) NOT NULL default '',
		descriptif blob NOT NULL,
		PRIMARY KEY  (id_syndic_article),
		KEY id_syndic (id_syndic),
		KEY statut (statut),
		KEY url (url)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_types_documents (
		id_type bigint(21) NOT NULL default '0',
		titre blob NOT NULL,
		descriptif blob NOT NULL,
		extension varchar(10) NOT NULL default '',
		mime_type varchar(100) NOT NULL default '',
		inclus varchar(5) NOT NULL default 'non',
		upload varchar(4) NOT NULL default 'oui',
		maj varchar(19) default NULL,
		PRIMARY KEY  (id_type),
		UNIQUE KEY extension (extension),
		KEY inclus (inclus)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_visites (
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		visites int(10) unsigned NOT NULL default '0',
		maj varchar(19) default NULL,
		PRIMARY KEY  (date_heure)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_visites_articles (
		date_heure varchar(19) NOT NULL default '0000-00-00 00:00:00',
		id_article int(10) unsigned NOT NULL default '0',
		visites int(10) unsigned NOT NULL default '0',
		maj varchar(19) default NULL,
		PRIMARY KEY  (date_heure,id_article)
		) TYPE=MyISAM";

	$query = "CREATE TABLE spip_visites_temp (
		ip varchar(15) NOT NULL default '0.0.0.0',
		type varchar(8) NOT NULL default 'article',
		id_objet int(10) unsigned NOT NULL default '0',
		maj varchar(19) default NULL,
		PRIMARY KEY  (type,id_objet,ip)
		) TYPE=MyISAM";



	//
	// Pre-remplissage de la base
	//
	spip_log("pre-remplissage de la base");
	remplir_profils();
	remplir_type_documents();

}

function remplir_profils() {
	$profilMetier = &recuperer_instance_profil();
	
	$profilMetier->setPoids(-1);
	$profilMetier->setIntitule('item_non_abonne');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}
		
	$profilMetier->setPoids(0);
	$profilMetier->setIntitule('texte_statut_poubelle');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}

	$profilMetier->setPoids(1);
	$profilMetier->setIntitule('item_redacteur');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}
	
	$profilMetier->setPoids(2);
	$profilMetier->setIntitule('item_redacteur_en_chef');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}
	
	$profilMetier->setPoids(4);
	$profilMetier->setIntitule('item_webmestre');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}

	$profilMetier->setPoids(8);
	$profilMetier->setIntitule('item_administrateur');
	$createOK = $profilMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	}
}

function remplir_actions() {
	$actionMetier = &recuperer_instance_action();
	
	$actionMetier->setAction('modifierRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('publierArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('proposerArticle');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierArticleApresPublication');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierArticleAvantPublication');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerArticle');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('refuserBreve');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierBreveApresPublication');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerBreve');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierBreveAvantPublication');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherAuteursVisiteurs');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherAuteurs');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherNombreArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherAdminRestreint');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherBoiteIconeGestionAuteurs');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherAvertissementAucuneRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherInfoGaucheAuteursExterieur');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherEmailAuteur');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherImageRedacteur');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSuiviPetition');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeAdminSite');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeStatistique');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeTousAuteur');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSuiviForum');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherAuteursConnectes');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherLienNouvelleAnnonce');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherDocumentsColonneBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('definirStatutBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherFormulaireBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSelectionStatutBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modificationDateBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('flagEvaluationBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherBoiteLogoBreve');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('publierBreve');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSuiviForumArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeEvolutionVisites');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherBoiteConfigurationAvancee');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherRaccourcis');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerNouvelAuteurArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSelectionStatutArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherLienRetirerAuteurArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('traitementEmail');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierDateAnterieurPublicationArticle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeSupprimerCookie');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierAuteur');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierEmailAuteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSelectProfilAuteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSelectProfilAuteurPossible');
	$actionMetier->setPoids(0);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherLoginMdp');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherOngletAuteur');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('InsererAuteursCSV');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('verifierDroitEcritureRepEcrire');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('forcerCookie');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerLienAuteurRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('ajouterLienAuteurRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('recupererRubriqueAuteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('controlerForum2');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('controlerForum');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('changerStatutMessage');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('publierMessage');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('refuserMessage');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('mettrePoubelleMessage');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('gererMotCleAuteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('isAuthorizedToManageAuteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherForumPriveAdmin');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('viderCache');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherStatistiques');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('configurerSite');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('activerCookie');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('isManagedRubriqueByAuteurId');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSiteProblematique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherNombreMessageParStatut');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherIconeCreerSecteur');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierBreve');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('editerContenuRubrique');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerRubrique');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherSelectBreveStatut');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierArticle');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierDatePublicationArticle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('gererMotCleArticle');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('validerArticle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('jeterArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('refuserArticle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('ajouterAuteurArticle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierStatutArticle');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('archiverArticle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerMotCle');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierMotCle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerGroupeMot');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierGroupeMot');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerMotCle');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerGroupeMot');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('supprimerSite');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('creerSite');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('refuserSite');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('publierSite');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierStatutSyndic');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierDatePublicationSite');
	$actionMetier->setPoids(2);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('jeterSite');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('proposerSite');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('modifierSite');
	$actionMetier->setPoids(1);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('effacerBase');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('sauverBase');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('gestionPetition');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('uploadDocument');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherArticleAParaitre');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherNombreSyndicationOff');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherLesAuteurs');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherBoiteLogo');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherArticleEnRedaction');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('traiterEmail');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('afficherFormulaireMessage');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('configurerContenu');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('configurerFonctions');
	$actionMetier->setPoids(4);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	
	
	$actionMetier->setAction('adminStatId');
	$actionMetier->setPoids(8);
	$createOK = $actionMetier->create();
	if(PEAR::isError($createOK)) {
		die($createOK->getMessage());
	};
	

}


function remplir_type_documents() {
	// Images reconnues par PHP
	$query = "INSERT IGNORE spip_types_documents (id_type, extension, titre, inclus) VALUES ".
		"(1, 'jpg', 'JPEG', 'image'), ".
		"(2, 'png', 'PNG', 'image'), ".
		"(3, 'gif', 'GIF', 'image')";
	spip_query($query);

	// Autres images (peuvent utiliser le tag <img>)
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('bmp', 'BMP', 'image'), ".
		"('psd', 'Photoshop', 'image'), ".
		"('tif', 'TIFF', 'image')";
	spip_query($query);

	// Multimedia (peuvent utiliser le tag <embed>)
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('aiff', 'AIFF', 'embed'), ".
		"('asf', 'Windows Media', 'embed'), ".
		"('avi', 'Windows Media', 'embed'), ".
		"('mid', 'Midi', 'embed'), ".
		"('mng', 'MNG', 'embed'), ".
		"('mov', 'QuickTime', 'embed'), ".
		"('mp3', 'MP3', 'embed'), ".
		"('mpg', 'MPEG', 'embed'), ".
		"('ogg', 'Ogg', 'embed'), ".
		"('qt', 'QuickTime', 'embed'), ".
		"('ra', 'RealAudio', 'embed'), ".
		"('ram', 'RealAudio', 'embed'), ".
		"('rm', 'RealAudio', 'embed'), ".
		"('swf', 'Flash', 'embed'), ".
		"('wav', 'WAV', 'embed'), ".
		"('wmv', 'Windows Media', 'embed')";
	spip_query($query);

	// Documents varies
	$query = "INSERT IGNORE spip_types_documents (extension, titre, inclus) VALUES ".
		"('ai', 'Adobe Illustrator', 'non'), ".
		"('bz2', 'BZip', 'non'), ".
		"('c', 'C source', 'non'), ".
		"('deb', 'Debian', 'non'), ".
		"('doc', 'Word', 'non'), ".
		"('djvu', 'DjVu', 'non'), ".
		"('dvi', 'LaTeX DVI', 'non'), ".
		"('eps', 'PostScript', 'non'), ".
		"('gz', 'GZ', 'non'), ".
		"('h', 'C header', 'non'), ".
		"('html', 'HTML', 'non'), ".
		"('pas', 'Pascal', 'non'), ".
		"('pdf', 'PDF', 'non'), ".
		"('ppt', 'PowerPoint', 'non'), ".
		"('ps', 'PostScript', 'non'), ".
		"('rpm', 'RedHat/Mandrake/SuSE', 'non'), ".
		"('rtf', 'RTF', 'non'), ".
		"('sdd', 'StarOffice', 'non'), ".
		"('sdw', 'StarOffice', 'non'), ".
		"('sit', 'Stuffit', 'non'), ".
		"('sxc', 'OpenOffice Calc', 'non'), ".
		"('sxi', 'OpenOffice Impress', 'non'), ".
		"('sxw', 'OpenOffice', 'non'), ".
		"('tex', 'LaTeX', 'non'), ".
		"('tgz', 'TGZ', 'non'), ".
		"('txt', 'texte', 'non'), ".
		"('xcf', 'GIMP multi-layer', 'non'), ".
		"('xls', 'Excel', 'non'), ".
		"('xml', 'XML', 'non'), ".
		"('zip', 'Zip', 'non')";
	spip_query($query);
}

function stripslashes_base($table, $champs) {
	$modifs = '';
	reset($champs);
	while (list(, $champ) = each($champs)) {
		$modifs[] = $champ . '=REPLACE(REPLACE(' .$champ. ',"\\\\\'", "\'"), \'\\\\"\', \'"\')';
	}
	$query = "UPDATE $table SET ".join(',', $modifs);
	spip_query($query);
}


function maj_version ($version) {
	spip_query("REPLACE spip_meta (nom, valeur) VALUES ('version_installee', '$version')");
	spip_log("mise a jour de la base vers $version");
}

function maj_base() {

	global $spip_version;

	//
	// Lecture de la version installee
	//
	$version_installee = 0.0;
	$result = spip_query("SELECT valeur FROM spip_meta WHERE nom='version_installee'");
	if ($result) if ($row = spip_fetch_array($result)) $version_installee = (double) $row['valeur'];

	//
	// Si pas de version mentionnee dans spip_meta, c'est qu'il s'agit d'une nouvelle installation
	//   => ne pas passer par le processus de mise a jour
	//
	if (!$version_installee) {
		$version_installee = $spip_version;
		maj_version($version_installee);
	}

	//
	// Selection en fonction de la version
	//
	if ($version_installee < 0.98) {

		spip_query("ALTER TABLE spip_articles ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_articles ADD export VARCHAR(10) DEFAULT 'oui'");
		spip_query("ALTER TABLE spip_articles ADD images TEXT DEFAULT ''");
		spip_query("ALTER TABLE spip_articles ADD date_redac datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("ALTER TABLE spip_articles DROP INDEX id_article");
		spip_query("ALTER TABLE spip_articles ADD INDEX id_rubrique (id_rubrique)");
		spip_query("ALTER TABLE spip_articles ADD visites INTEGER DEFAULT '0' NOT NULL");
		spip_query("ALTER TABLE spip_articles ADD referers BLOB NOT NULL");

		spip_query("ALTER TABLE spip_auteurs ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_auteurs ADD pgp BLOB NOT NULL");

		spip_query("ALTER TABLE spip_auteurs_articles ADD INDEX id_auteur (id_auteur), ADD INDEX id_article (id_article)");

		spip_query("ALTER TABLE spip_rubriques ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_rubriques ADD export VARCHAR(10) DEFAULT 'oui', ADD id_import BIGINT DEFAULT '0'");

		spip_query("ALTER TABLE spip_breves ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_breves DROP INDEX id_breve");
		spip_query("ALTER TABLE spip_breves DROP INDEX id_breve_2");
		spip_query("ALTER TABLE spip_breves ADD INDEX id_rubrique (id_rubrique)");

		spip_query("ALTER TABLE spip_forum ADD ip VARCHAR(16)");
		spip_query("ALTER TABLE spip_forum ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_forum DROP INDEX id_forum");
		spip_query("ALTER TABLE spip_forum ADD INDEX id_parent (id_parent), ADD INDEX id_rubrique (id_rubrique), ADD INDEX id_article(id_article), ADD INDEX id_breve(id_breve)");
		maj_version (0.98);
	}

	if ($version_installee < 0.99) {

		$query = "SELECT DISTINCT id_article FROM spip_forum WHERE id_article!=0 AND id_parent=0";
		$result = spip_query($query);
		while ($row = spip_fetch_array($result)) {
			unset($forums_article);
			$id_article = $row['id_article'];
			$query2 = "SELECT id_forum FROM spip_forum WHERE id_article=$id_article";
			for (;;) {
				$result2 = spip_query($query2);
				unset($forums);
				while ($row2 = spip_fetch_array($result2)) $forums[] = $row2['id_forum'];
				if (!$forums) break;
				$forums = join(',', $forums);
				$forums_article[] = $forums;
				$query2 = "SELECT id_forum FROM spip_forum WHERE id_parent IN ($forums)";
			}
			$forums_article = join(',', $forums_article);
			$query3 = "UPDATE spip_forum SET id_article=$id_article WHERE id_forum IN ($forums_article)";
			spip_query($query3);
		}

		$query = "SELECT DISTINCT id_breve FROM spip_forum WHERE id_breve!=0 AND id_parent=0";
		$result = spip_query($query);
		while ($row = spip_fetch_array($result)) {
			unset($forums_breve);
			$id_breve = $row['id_breve'];
			$query2 = "SELECT id_forum FROM spip_forum WHERE id_breve=$id_breve";
			for (;;) {
				$result2 = spip_query($query2);
				unset($forums);
				while ($row2 = spip_fetch_array($result2)) $forums[] = $row2['id_forum'];
				if (!$forums) break;
				$forums = join(',', $forums);
				$forums_breve[] = $forums;
				$query2 = "SELECT id_forum FROM spip_forum WHERE id_parent IN ($forums)";
			}
			$forums_breve = join(',', $forums_breve);
			$query3 = "UPDATE spip_forum SET id_breve=$id_breve WHERE id_forum IN ($forums_breve)";
			spip_query($query3);
		}

		$query = "SELECT DISTINCT id_rubrique FROM spip_forum WHERE id_rubrique!=0 AND id_parent=0";
		$result = spip_query($query);
		while ($row = spip_fetch_array($result)) {
			unset($forums_rubrique);
			$id_rubrique = $row['id_rubrique'];
			$query2 = "SELECT id_forum FROM spip_forum WHERE id_rubrique=$id_rubrique";
			for (;;) {
				$result2 = spip_query($query2);
				unset($forums);
				while ($row2 = spip_fetch_array($result2)) $forums[] = $row2['id_forum'];
				if (!$forums) break;
				$forums = join(',', $forums);
				$forums_rubrique[] = $forums;
				$query2 = "SELECT id_forum FROM spip_forum WHERE id_parent IN ($forums)";
			}
			$forums_rubrique = join(',', $forums_rubrique);
			$query3 = "UPDATE spip_forum SET id_rubrique=$id_rubrique WHERE id_forum IN ($forums_rubrique)";
			spip_query($query3);
		}
		maj_version (0.99);
	}

	if ($version_installee < 0.997) {
		spip_query("DROP TABLE spip_index");
		maj_version (0.997);
	}

	if ($version_installee < 0.999) {
		global $htsalt;
		spip_query("ALTER TABLE spip_auteurs CHANGE pass pass tinyblob NOT NULL");
		spip_query("ALTER TABLE spip_auteurs ADD htpass tinyblob NOT NULL");
		$query = "SELECT id_auteur, pass FROM spip_auteurs WHERE pass!=''";
		$result = spip_query($query);
		while (list($id_auteur, $pass) = spip_fetch_array($result)) {
			$htpass = generer_htpass($pass);
			$pass = md5($pass);
			spip_query("UPDATE spip_auteurs SET pass='$pass', htpass='$htpass' WHERE id_auteur=$id_auteur");
		}
		maj_version (0.999);
	}

	if ($version_installee < 1.01) {
		spip_query("UPDATE spip_forum SET statut='publie' WHERE statut=''");
		maj_version (1.01);
	}

	if ($version_installee < 1.02) {
		spip_query("ALTER TABLE spip_forum ADD id_auteur BIGINT DEFAULT '0' NOT NULL");
		maj_version (1.02);
	}

	if ($version_installee < 1.03) {
		spip_query("DROP TABLE spip_maj");
		maj_version (1.03);
	}

	if ($version_installee < 1.04) {
		spip_query("ALTER TABLE spip_articles ADD accepter_forum VARCHAR(3)");
		maj_version (1.04);
	}

	if ($version_installee < 1.05) {
		spip_query("DROP TABLE spip_petition");
		spip_query("DROP TABLE spip_signatures_petition");
		maj_version (1.05);
	}

	if ($version_installee < 1.1) {
		spip_query("DROP TABLE spip_petition");
		spip_query("DROP TABLE spip_signatures_petition");
		maj_version (1.1);
	}

	// Correction de l'oubli des modifs creations depuis 1.04
	if ($version_installee < 1.204) {
		spip_query("ALTER TABLE spip_articles ADD accepter_forum VARCHAR(3) NOT NULL");
		spip_query("ALTER TABLE spip_forum ADD id_message bigint(21) NOT NULL");
		spip_query("ALTER TABLE spip_forum ADD INDEX id_message (id_message)");
		spip_query("ALTER TABLE spip_auteurs ADD en_ligne datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("ALTER TABLE spip_auteurs ADD imessage VARCHAR(3) not null");
		spip_query("ALTER TABLE spip_auteurs ADD messagerie VARCHAR(3) not null");
		maj_version (1.204);
	}

	if ($version_installee < 1.207) {
		spip_query("ALTER TABLE spip_rubriques DROP INDEX id_rubrique");
		spip_query("ALTER TABLE spip_rubriques ADD INDEX id_parent (id_parent)");
		spip_query("ALTER TABLE spip_rubriques ADD statut VARCHAR(10) NOT NULL");
		// Declencher le calcul des rubriques publiques
		spip_query("REPLACE spip_meta (nom, valeur) VALUES ('calculer_rubriques', 'oui')");
		maj_version (1.207);
	}

	if ($version_installee < 1.208) {
		spip_query("ALTER TABLE spip_auteurs_messages CHANGE forum vu CHAR(3) NOT NULL");
		spip_query("UPDATE spip_auteurs_messages SET vu='oui'");
		spip_query("UPDATE spip_auteurs_messages SET vu='non' WHERE statut='a'");

		spip_query("ALTER TABLE spip_messages ADD id_auteur bigint(21) NOT NULL");
		spip_query("ALTER TABLE spip_messages ADD INDEX id_auteur (id_auteur)");
		$result = spip_query("SELECT id_auteur, id_message FROM spip_auteurs_messages WHERE statut='de'");
		while ($row = spip_fetch_array($result)) {
			$id_auteur = $row['id_auteur'];
			$id_message = $row['id_message'];
			spip_query("UPDATE spip_messages SET id_auteur=$id_auteur WHERE id_message=$id_message");
		}

		spip_query("ALTER TABLE spip_auteurs_messages DROP statut");
		maj_version (1.208);
	}

	if ($version_installee < 1.209) {
		spip_query("ALTER TABLE spip_syndic ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_syndic_articles ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_messages ADD maj TIMESTAMP");
		maj_version (1.209);
	}

	if ($version_installee < 1.210) {
		spip_query("ALTER TABLE spip_messages DROP page");

		stripslashes_base('spip_articles', array('surtitre', 'titre', 'soustitre', 'descriptif', 'chapo', 'texte', 'ps'));
		stripslashes_base('spip_auteurs', array('nom', 'bio', 'nom_site'));
		stripslashes_base('spip_breves', array('titre', 'texte', 'lien_titre'));
		stripslashes_base('spip_forum', array('titre', 'texte', 'auteur', 'nom_site'));
		stripslashes_base('spip_messages', array('titre', 'texte'));
		stripslashes_base('spip_mots', array('type', 'titre', 'descriptif', 'texte'));
		stripslashes_base('spip_petitions', array('texte'));
		stripslashes_base('spip_rubriques', array('titre', 'descriptif', 'texte'));
		stripslashes_base('spip_signatures', array('nom_email', 'nom_site', 'message'));
		stripslashes_base('spip_syndic', array('nom_site', 'descriptif'));
		stripslashes_base('spip_syndic_articles', array('titre', 'lesauteurs'));
		maj_version (1.210);
	}

	if ($version_installee < 1.3) {
		// Modifier la syndication (pour liste de sites)
		spip_query("ALTER TABLE spip_syndic ADD syndication VARCHAR(3) NOT NULL");
		spip_query("ALTER TABLE spip_syndic ADD statut VARCHAR(10) NOT NULL");
		spip_query("ALTER TABLE spip_syndic ADD date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("UPDATE spip_syndic SET syndication='oui', statut='publie', date=NOW()");

		// Statut pour articles syndication, pour pouvoir desactiver un article
		spip_query("ALTER TABLE spip_syndic_articles ADD statut VARCHAR(10) NOT NULL");
		spip_query("UPDATE spip_syndic_articles SET statut='publie'");
		maj_version (1.3);
	}

	if ($version_installee < 1.301) {
		spip_query("ALTER TABLE spip_forum ADD id_syndic bigint(21) DEFAULT '0' NOT NULL");
		maj_version (1.301);
	}

	if ($version_installee < 1.302) {
		spip_query("ALTER TABLE spip_forum_cache DROP PRIMARY KEY");
		spip_query("ALTER TABLE spip_forum_cache DROP INDEX fichier");
		spip_query("ALTER TABLE spip_forum_cache ADD PRIMARY KEY (fichier, id_forum, id_article, id_rubrique, id_breve, id_syndic)");
		spip_query("ALTER TABLE spip_forum ADD INDEX id_syndic (id_syndic)");
		maj_version (1.302);
	}

	if ($version_installee < 1.303) {
		spip_query("ALTER TABLE spip_rubriques ADD date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("ALTER TABLE spip_syndic ADD date_syndic datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("UPDATE spip_syndic SET date_syndic=date");
		maj_version (1.303);
	}

	if ($version_installee < 1.306) {
		spip_query("DROP TABLE spip_index_syndic_articles");
		spip_query("ALTER TABLE spip_syndic ADD date_index datetime DEFAULT '0000-00-00 00:00:00' NOT NULL");
		spip_query("ALTER TABLE spip_syndic ADD INDEX date_index (date_index)");
		maj_version (1.306);
	}

	if ($version_installee < 1.307) {
		spip_query("ALTER TABLE spip_syndic_articles ADD descriptif blob NOT NULL");
		maj_version (1.307);
	}

	if ($version_installee < 1.404) {
		spip_query("UPDATE spip_mots SET type='Mots sans groupe...' WHERE type=''");

		$result = spip_query("SELECT * FROM spip_mots GROUP BY type");
		while($row = spip_fetch_array($result)) {
				$type = addslashes($row['type']);
				spip_query("INSERT INTO spip_groupes_mots
					(titre, unseul, obligatoire, articles, breves, rubriques, syndic, minirezo, comite, forum)
					VALUES (\"$type\", 'non', 'non', 'oui', 'oui', 'non', 'oui', 'oui', 'oui', 'non')");
		}
		spip_query("DELETE FROM spip_mots WHERE titre='kawax'");
		maj_version (1.404);
	}

	if ($version_installee < 1.405) {
		spip_query("ALTER TABLE spip_mots ADD id_groupe bigint(21) NOT NULL");

		$result = spip_query("SELECT * FROM spip_groupes_mots");
		while($row = spip_fetch_array($result)) {
				$id_groupe = addslashes($row['id_groupe']);
				$type = addslashes($row['titre']);
				spip_query("UPDATE spip_mots SET id_groupe = '$id_groupe' WHERE type=\"$type\"");
		}
		maj_version (1.405);
	}

	if ($version_installee < 1.408) {
		// Images articles passent dans spip_documents
		$query = "SELECT id_article, images FROM spip_articles WHERE LENGTH(images) > 0";
		$result = spip_query($query);

		$types = array('jpg' => 1, 'png' => 2, 'gif' => 3);

		while ($row = @spip_fetch_array($result)) {
			$id_article = $row['id_article'];
			$images = $row['images'];
			$images = explode(",", $images);
			reset($images);
			$replace = '_orig_';
			while (list (, $val) = each($images)) {
				$image = explode("|", $val);
				$fichier = $image[0];
				$largeur = $image[1];
				$hauteur = $image[2];
				ereg("-([0-9]+)\.(gif|jpg|png)$", $fichier, $match);
				$id_type = intval($types[$match[2]]);
				$num_img = $match[1];
				$fichier = "IMG/$fichier";
				$taille = @filesize("../$fichier");
				spip_query("INSERT INTO spip_documents (titre, id_type, fichier, mode, largeur, hauteur, taille) VALUES ".
					"('image $largeur x $hauteur', $id_type, '$fichier', 'vignette', '$largeur', '$hauteur', '$taille')");
				$id_document = spip_insert_id();
				if ($id_document > 0) {
					spip_query("INSERT INTO spip_documents_articles (id_document, id_article) VALUES ($id_document, $id_article)");
					$replace = "REPLACE($replace, '<IMG$num_img|', '<IM_$id_document|')";
				} else {
					echo _T('texte_erreur_mise_niveau_base', array('fichier' => $fichier, 'id_article' => $id_article));
					exit;
				}
			}
			$replace = "REPLACE($replace, '<IM_', '<IMG')";
			$replace_chapo = ereg_replace('_orig_', 'chapo', $replace);
			$replace_descriptif = ereg_replace('_orig_', 'descriptif', $replace);
			$replace_texte = ereg_replace('_orig_', 'texte', $replace);
			$replace_ps = ereg_replace('_orig_', 'ps', $replace);
			$query = "UPDATE spip_articles ".
				"SET chapo=$replace_chapo, descriptif=$replace_descriptif, texte=$replace_texte, ps=$replace_ps ".
				"WHERE id_article=$id_article";
			spip_query($query);
		}
		spip_query("ALTER TABLE spip_articles DROP images");
		maj_version (1.408);
	}

	if ($version_installee < 1.414) {
		// Forum par defaut "en dur" dans les spip_articles
		// -> non, prio (priori), pos (posteriori), abo (abonnement)
		include_ecrire ("inc_meta.php3");
		$accepter_forum = substr(lire_meta("forums_publics"),0,3) ;
		$query = "ALTER TABLE spip_articles CHANGE accepter_forum accepter_forum CHAR(3) NOT NULL";
		$result = spip_query($query);
		$query = "UPDATE spip_articles SET accepter_forum='$accepter_forum' WHERE accepter_forum != 'non'";
		$result = spip_query($query);
		maj_version (1.414);
	}

	if ($version_installee == 1.415) {
		spip_query("ALTER TABLE spip_documents DROP inclus");
		maj_version (1.415);
	}

	if ($version_installee < 1.417) {
		spip_query("ALTER TABLE spip_syndic_articles DROP date_index");
		maj_version (1.417);
	}

	if ($version_installee < 1.418) {
		$query = "SELECT * FROM spip_auteurs WHERE statut = 'minirezo' AND email != '' ORDER BY id_auteur LIMIT 0,1";
		$result = spip_query($query);
		if ($webmaster = spip_fetch_object($result)) {
			include_ecrire("inc_meta.php3");
			ecrire_meta('email_webmaster', $webmaster->email);
			ecrire_metas();
		}
		maj_version (1.418);
	}

	if ($version_installee < 1.419) {
		$query = "ALTER TABLE spip_auteurs ADD alea_actuel TINYTEXT DEFAULT ''";
		spip_query($query);
		$query = "ALTER TABLE spip_auteurs ADD alea_futur TINYTEXT DEFAULT ''";
		spip_query($query);
		$query = "UPDATE spip_auteurs SET alea_futur = FLOOR(32000*RAND())";
		spip_query($query);
		maj_version (1.419);
	}

	if ($version_installee < 1.420) {
		$query = "UPDATE spip_auteurs SET alea_actuel='' WHERE statut='nouveau'";
		spip_query($query);
		maj_version (1.420);
	}

	if ($version_installee < 1.421) {
		$query = "ALTER TABLE spip_articles ADD auteur_modif bigint(21) DEFAULT '0' NOT NULL";
		spip_query($query);
		$query = "ALTER TABLE spip_articles ADD date_modif datetime DEFAULT '0000-00-00 00:00:00' NOT NULL";
		spip_query($query);
		maj_version (1.421);
	}

	if ($version_installee < 1.432) {
		spip_query("ALTER TABLE spip_articles DROP referers");
		$query = "ALTER TABLE spip_articles ADD referers INTEGER DEFAULT '0' NOT NULL";
		spip_query($query);
		$query = "ALTER TABLE spip_articles ADD popularite INTEGER DEFAULT '0' NOT NULL";
		spip_query($query);
		maj_version (1.432);
	}

	if ($version_installee < 1.436) {
		$query = "ALTER TABLE spip_documents ADD date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL";
		spip_query($query);
		maj_version (1.436);
	}

	if ($version_installee < 1.437) {
		spip_query("ALTER TABLE spip_visites ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_visites_referers ADD maj TIMESTAMP");
		maj_version (1.437);
	}

	if ($version_installee < 1.438) {
		spip_query("ALTER TABLE spip_articles ADD INDEX id_secteur (id_secteur)");
		spip_query("ALTER TABLE spip_articles ADD INDEX statut (statut, date)");
		maj_version (1.438);
	}

	if ($version_installee < 1.439) {
		spip_query("ALTER TABLE spip_syndic ADD INDEX statut (statut, date_syndic)");
		spip_query("ALTER TABLE spip_syndic_articles ADD INDEX statut (statut)");
		spip_query("ALTER TABLE spip_syndic_articles CHANGE url url VARCHAR(255) NOT NULL");
		spip_query("ALTER TABLE spip_syndic_articles ADD INDEX url (url)");
		maj_version (1.439);
	}

	if ($version_installee < 1.440) {
		spip_query("ALTER TABLE spip_visites_temp CHANGE ip ip INTEGER UNSIGNED NOT NULL");
		maj_version (1.440);
	}

	if ($version_installee < 1.441) {
		spip_query("ALTER TABLE spip_visites_temp CHANGE date date DATE NOT NULL");
		spip_query("ALTER TABLE spip_visites CHANGE date date DATE NOT NULL");
		spip_query("ALTER TABLE spip_visites_referers CHANGE date date DATE NOT NULL");
		maj_version (1.441);
	}

	if ($version_installee < 1.442) {
		$query = "ALTER TABLE spip_auteurs ADD prefs TINYTEXT NOT NULL";
		spip_query($query);
		maj_version (1.442);
	}

	if ($version_installee < 1.443) {
		spip_query("ALTER TABLE spip_auteurs CHANGE login login VARCHAR(255) BINARY NOT NULL");
		spip_query("ALTER TABLE spip_auteurs CHANGE statut statut VARCHAR(255) NOT NULL");
		spip_query("ALTER TABLE spip_auteurs ADD INDEX login (login)");
		spip_query("ALTER TABLE spip_auteurs ADD INDEX statut (statut)");
		maj_version (1.443);
	}

	if ($version_installee < 1.444) {
		spip_query("ALTER TABLE spip_syndic ADD moderation VARCHAR(3) NOT NULL");
		maj_version (1.444);
	}

	if ($version_installee < 1.457) {
		spip_query("DROP TABLE spip_visites");
		spip_query("DROP TABLE spip_visites_temp");
		spip_query("DROP TABLE spip_visites_referers");
		creer_base(); // crade, a ameliorer :-((
		maj_version (1.457);
	}

	if ($version_installee < 1.458) {
		spip_query("ALTER TABLE spip_auteurs ADD cookie_oubli TINYTEXT NOT NULL");
		maj_version (1.458);
	}

	if ($version_installee < 1.459) {
		$result = spip_query("SELECT type FROM spip_mots GROUP BY type");
		while ($row = spip_fetch_array($result)) {
			$type = addslashes($row['type']);
			$res = spip_query("SELECT * FROM spip_groupes_mots
				WHERE titre='$type'");
			if (spip_num_rows($res) == 0) {
				spip_query("INSERT IGNORE INTO spip_groupes_mots
					(titre, unseul, obligatoire, articles, breves, rubriques, syndic, minirezo, comite, forum)
					VALUES ('$type', 'non', 'non', 'oui', 'oui', 'non', 'oui', 'oui', 'oui', 'non')");
				if ($id_groupe = spip_insert_id())
					spip_query("UPDATE spip_mots SET id_groupe = '$id_groupe' WHERE type='$type'");
			}
		}
		spip_query("UPDATE spip_articles SET popularite=0");
		maj_version (1.459);
	}

	if ($version_installee < 1.460) {
		// remettre les mots dans les groupes dupliques par erreur
		// dans la precedente version du paragraphe de maj 1.459
		// et supprimer ceux-ci
		$result = spip_query("SELECT * FROM spip_groupes_mots ORDER BY id_groupe");
		while ($row = spip_fetch_array($result)) {
			$titre = addslashes($row['titre']);
			if (! $vu[$titre] ) {
				$vu[$titre] = true;
				$id_groupe = $row['id_groupe'];
				spip_query ("UPDATE spip_mots SET id_groupe=$id_groupe WHERE type='$titre'");
				spip_query ("DELETE FROM spip_groupes_mots WHERE titre='$titre' AND id_groupe<>$id_groupe");
			}
		}
		maj_version (1.460);
	}

	if ($version_installee < 1.462) {
		spip_query("UPDATE spip_types_documents SET inclus='embed' WHERE inclus!='non' AND extension IN ".
			"('aiff', 'asf', 'avi', 'mid', 'mov', 'mp3', 'mpg', 'ogg', 'qt', 'ra', 'ram', 'rm', 'swf', 'wav', 'wmv')");
		maj_version (1.462);
	}

	if ($version_installee < 1.463) {
		spip_query("ALTER TABLE spip_articles CHANGE popularite popularite DOUBLE");
		spip_query("ALTER TABLE spip_visites_temp ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_referers_temp ADD maj TIMESTAMP");
		maj_version (1.463);
	}

	// l'upgrade < 1.462 ci-dessus etait fausse, d'ou correctif
	if (($version_installee < 1.464) AND ($version_installee >= 1.462)) {
		$res = spip_query("SELECT id_type, extension FROM spip_types_documents WHERE id_type NOT IN (1,2,3)");
		while ($row = spip_fetch_array($res)) {
			$extension = $row['extension'];
			$id_type = $row['id_type'];
			spip_query("UPDATE spip_documents SET id_type=$id_type
				WHERE fichier like '%.$extension'");
		}
		maj_version (1.464);
	}

	if ($version_installee < 1.465) {
		spip_query("ALTER TABLE spip_articles CHANGE popularite popularite DOUBLE NOT NULL");
		maj_version (1.465);
	}

	if ($version_installee < 1.466) {
		spip_query("ALTER TABLE spip_auteurs ADD source VARCHAR(10) DEFAULT 'spip' NOT NULL");
		maj_version (1.466);
	}

	/* ANNULE
	if ($version_installee < 1.467) {
		// gestion de listes de diff
		spip_query("ALTER TABLE spip_auteurs ADD abonne TEXT NOT NULL");
		spip_query("ALTER TABLE spip_auteurs ADD abonne_pass TINYTEXT NOT NULL");
		maj_version (1.467);
	}
	*/

	if ($version_installee < 1.468) {
		spip_query("ALTER TABLE spip_auteurs ADD INDEX en_ligne (en_ligne)");
		spip_query("ALTER TABLE spip_forum ADD INDEX statut (statut, date_heure)");
		maj_version (1.468);
	}

	if ($version_installee < 1.470) {
		/* ANNULE
		spip_query("ALTER TABLE spip_auteurs_articles ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_auteurs_rubriques ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_auteurs_messages ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_documents_articles ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_documents_rubriques ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_documents_breves ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_mots_articles ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_mots_breves ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_mots_rubriques ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_mots_syndic ADD maj TIMESTAMP");
		spip_query("ALTER TABLE spip_mots_forum ADD maj TIMESTAMP");*/

		if ($version_installee >= 1.467) {	// annule les "listes de diff"
			spip_query("DROP TABLE spip_listes");
			spip_query("ALTER TABLE spip_auteurs DROP abonne");
			spip_query("ALTER TABLE spip_auteurs DROP abonne_pass");
		}
		maj_version (1.470);
	}

	if ($version_installee < 1.471) {
		if ($version_installee >= 1.470) {	// annule les "maj"
			spip_query("ALTER TABLE spip_auteurs_articles DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_auteurs_rubriques DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_auteurs_messages DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_documents_articles DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_documents_rubriques DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_documents_breves DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_mots_articles DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_mots_breves DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_mots_rubriques DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_mots_syndic DROP maj TIMESTAMP");
			spip_query("ALTER TABLE spip_mots_forum DROP maj TIMESTAMP");
		}
		maj_version (1.471);
	}

	if ($version_installee < 1.472) {
		spip_query("ALTER TABLE spip_referers ADD visites_jour INTEGER UNSIGNED NOT NULL");
		maj_version (1.472);
	}

	if ($version_installee < 1.473) {
		spip_query("UPDATE spip_syndic_articles SET url = REPLACE(url, '&amp;', '&')");
		spip_query("UPDATE spip_syndic SET url_site = REPLACE(url_site, '&amp;', '&')");
		maj_version (1.473);
	}

	if ($version_installee < 1.600) {
		include_ecrire('inc_index.php3');
		purger_index();
		creer_liste_indexation();
		maj_version (1.600);
	}

	if ($version_installee < 1.601) {
		spip_query("ALTER TABLE spip_forum ADD INDEX id_syndic (id_syndic)");
		maj_version (1.601);
	}

	/* if ($version_installee < 1.602) {
		// juste des types de documents en plus (creer_base())
		maj_version (1.602);
	} */

	if ($version_installee < 1.603) {
		// supprimer les fichiers deplaces
		@unlink('inc_meta_cache.php3');
		@unlink('data/engines-list.ini');
		maj_version (1.603);
	}

	if ($version_installee < 1.604) {
		spip_query("ALTER TABLE spip_auteurs ADD lang VARCHAR(10) DEFAULT '' NOT NULL");
		$u = spip_query("SELECT * FROM spip_auteurs WHERE prefs LIKE '%spip_lang%'");
		while ($row = spip_fetch_array($u)) {
			$prefs = unserialize($row['prefs']);
			$l = $prefs['spip_lang'];
			unset ($prefs['spip_lang']);
			spip_query ("UPDATE spip_auteurs SET lang='".addslashes($l)."',
				prefs='".addslashes(serialize($prefs))."'
				WHERE id_auteur=".$row['id_auteur']);
		}
		maj_version (1.604);
	}

	if ($version_installee < 1.702) {
		spip_query("ALTER TABLE spip_articles ADD extra longblob NULL");
		spip_query("ALTER TABLE spip_auteurs ADD extra longblob NULL");
		spip_query("ALTER TABLE spip_breves ADD extra longblob NULL");
		spip_query("ALTER TABLE spip_rubriques ADD extra longblob NULL");
		spip_query("ALTER TABLE spip_mots ADD extra longblob NULL");

		// recuperer les eventuels 'supplement' installes en 1.701
		if ($version_installee == 1.701) {
			spip_query ("UPDATE spip_articles SET extra = supplement");
			spip_query ("ALTER TABLE spip_articles DROP supplement");
			spip_query ("UPDATE spip_auteurs SET extra = supplement");
			spip_query ("ALTER TABLE spip_auteurs DROP supplement");
			spip_query ("UPDATE spip_breves SET extra = supplement");
			spip_query ("ALTER TABLE spip_breves DROP supplement");
			spip_query ("UPDATE spip_rubriques SET extra = supplement");
			spip_query ("ALTER TABLE spip_rubriques DROP supplement");
			spip_query ("UPDATE spip_mots SET extra = supplement");
			spip_query ("ALTER TABLE spip_mots DROP supplement");
		}
		maj_version (1.702);
	}

	if ($version_installee < 1.703) {
		spip_query("ALTER TABLE spip_articles ADD lang VARCHAR(10) DEFAULT '' NOT NULL");
		spip_query("ALTER TABLE spip_rubriques ADD lang VARCHAR(10) DEFAULT '' NOT NULL");
		maj_version (1.703);
	}

	if ($version_installee < 1.704) {
		spip_query("ALTER TABLE spip_articles ADD INDEX lang (lang)");
		spip_query("ALTER TABLE spip_auteurs ADD INDEX lang (lang)");
		spip_query("ALTER TABLE spip_rubriques ADD INDEX lang (lang)");
		maj_version (1.704);
	}

}

?>
