<?php
//$Id$

require_once dirname(__FILE__)."/include/bd/inc_article_factory.php";
require_once dirname(__FILE__)."/include/bd/inc_rubrique_factory.php";
require_once dirname(__FILE__)."/include/typologie/inc_rule_factory.php";

// Le scripts essaye de charger le fichier de contraintes.
// Utile pour ne pas perdre les modifications/cration de contraintes lors des MAJ de SPIP AGORA
//require_once dirname(__FILE__)."/include/typologie/mes_contraintes.php";
if (file_exists(dirname(__FILE__)."/include/typologie/mes_contraintes.php")) {
    require_once dirname(__FILE__)."/include/typologie/mes_contraintes.php";
} else {
    $GLOBALS['aConstraints'] = array ();
}

// {{{ getErrorMsg

/**
 * This function apply constraints rules on the content type $sType
 * @param   $sContentType String ie : articles, rubriques
 * @access public
 */
function getErrorMsg($sContentType, $Object) {
	$isExtra = false;
    $articleId = false;
    $rubriqueId = false;
	if ($sContentType == "article") {
		$aRules = loadConstraintRules($sContentType, $Object->getRubriqueId());
        $articleId = $Object->getArticleId();
		$extra = $Object->getExtra();
		if ($extra) {
			$extra = unserialize($extra);
		}
	} else
		if ($sContentType == "rubrique") {
            $rubriqueId = $Object->getRubriqueId();
			$aRules = loadConstraintRules($sContentType, $Object->getParentId());
		}
	if (count($aRules) <= 0) {
		// Si aucune regle n'est dfinie
		return false;
	}

	$aErrorMsg = array ();
	while (list ($sField, $aRulesList) = each($aRules)) {
		// Vrification du type (extra ou non)
		if (is_array($extra)) {
		    if (in_array($sField, array_keys($extra))) {
		        $isExtra = true;
		    } else {
		        $isExtra = false;
		    }
		}
		$aErrorMsg[$sField] = array ();
		if (!$isExtra) {
			/**
			 * Ici on vrifie si la personne en crant les contraintes
			 * n'a pas fait d'erreur dans les noms des extras.
			 */ 
			
			$aClassMethods = get_class_methods($Object);
			$methodName = 'get'.$sField;
			if (!in_array(strtolower($methodName),$aClassMethods)) {
				trigger_error(" Il y a un problme au niveau de la configuration des contraintes : le champs extra ".$sField." ne semble pas exister");
				$aErrorMsg[$sField][] = "Le champs extra ".$sField." ne semble pas exister";
				return $aErrorMsg;
			} else {
			    eval ('$sFieldContent = $Object->get'.$sField.'();');
			}
		} else {
			eval ('$sFieldContent = $extra["'.$sField.'"];');
			$sFieldProps = $GLOBALS['champs_extra'][$sContentType."s"][$sField];
			$aFieldProps = split("[|]", $sFieldProps);
			if ( count($aFieldProps) > 0) {
			  $sField = $aFieldProps[2];
			}
		}
		while (list ($sRuleName, $sRuleValue) = each($aRulesList)) {
			$rule = & recuperer_instance_rule($sRuleName);
            $rule->setArticleId($articleId);
			$rule->setRuleValue($sRuleValue);
			$rule->setFieldContent($sFieldContent);
			$rule->setFieldName($sField);
			$ruleResult = $rule->validate();
			if (is_string($ruleResult)) {
				$aErrorMsg[$sField][] = $ruleResult;
			}
		}
	}
	return $aErrorMsg;

}

function displayErrorMsg($aErrorMsg) {
	if (!$aErrorMsg) {
		return false;
	}
	$bErr = false;
	$strErr = _T('err_common').'<br>';
	while (list (, $aFieldMsg) = each($aErrorMsg)) {
		if (count($aFieldMsg) > 0) {
			$bErr = true;
		}
		while (list (, $msg) = each($aFieldMsg)) {
			$strErr .= $msg."<br>";
		}
	}
	if ($bErr) {
		return $strErr;
	} else {
		return $bErr;
	}
}

// }}}

// {{{ loadConstraintRules

/**
 * This function load rules for the $sContentType
 * @param $sContentType String
 * @param $aConstraints Array
 * @access public
 */
function loadConstraintRules($sContentType, $aContrainst) {
	global $GLOBALS;
	$context = 'all';
	$ensemble = $aContrainst;
	$id_rubrique = $ensemble;
	$rubriqueMetier = & recuperer_instance_rubrique();
	while ($id_rubrique > 0) {
		if (isset ($GLOBALS['aConstraints'][$sContentType]['='.$id_rubrique])) {
			$context = '='.$id_rubrique;
			return $GLOBALS["aConstraints"][$sContentType][$context];
		}
		$currentRubrique = false;
		$loadOK = $rubriqueMetier->load($id_rubrique);
		$id_rubrique = $rubriqueMetier->getParentId();
		if (!PEAR :: isError($loadOK)) {
			if (isset ($GLOBALS['aConstraints'][$sContentType]['-'.$id_rubrique])) {
				$context = '-'.$id_rubrique;
				$id_rubrique = 0;
				$heritage = true;
			}
		}
	}
	return $GLOBALS["aConstraints"][$sContentType][$context];
}

// }}}
?>