<?php
/** Lib de fonctions ddies au diff d'articles (fonctionnalit de Spip-Agora : "Historique")
 * @version    $Id$
 * @author     trivoallan
 */

/** Renvoie la diffrence formatte en html entre deux articles
 * @param      object article      Article avant modifications
 * @param      object article      Article aprs modifications
 * @return     string 
 */
function getDiffHtml( $article_from, $article_to ) {

    checkForDependencies() or die( _T('dependance_manquante'). ' : le package PEAR Text_Diff' );

    // Chargement des librairies ncessaires
    require_once 'Text/Diff/Renderer.php';
    require_once dirname(__FILE__). '/include/diff/Renderer_Spip.php';

    // Computation des diffs -- on rcupre une instance de Text_Diff pour chaque elment de l'article
    $diffs = array();

    if (lire_meta('articles_surtitre') == 'oui')
        $diffs['surtitre'] = getDiff( $article_from->getSurtitre(), $article_to->getSurtitre() );
    if (lire_meta('articles_soustitre') == 'oui')
        $diffs['soustitre'] = getDiff( $article_from->getSousTitre(), $article_to->getSousTitre() );
    if (lire_meta('articles_descriptif') == 'oui')
        $diffs['descriptif'] = getDiff( $article_from->getDescriptif(), $article_to->getDescriptif() );
    if (lire_meta('articles_chapeau') == 'oui') 
        $diffs['chapo'] = getDiff( $article_from->getChapo(), $article_to->getChapo() );
    if (lire_meta('articles_ps') == 'oui')
        $diffs['ps'] = getDiff( $article_from->getPs(), $article_to->getPs() );
  
    $diffs['titre'] = getDiff( $article_from->getTitre(), $article_to->getTitre() );
    $diffs['texte'] = getDiff( $article_from->getTexte(), $article_to->getTexte() );

    // Site li
    if ( $article_from->_nomSite || $article_to->_nomSite ) {
        $diffs['site'] = getDiff( $article_from->_nomSite .'|'. $article_from->_urlSite,
                                  $article_to->_nomSite .'|'. $article_to->_urlSite );
    }

    // Extras
    if ( $extras_from = $article_from->getExtra() && is_array($extras_from) ) {
        $extras_to = unserialize( $article_to->getExtra() );
        $extras_from = unserialize($extras_from);
        foreach ( $extras_from as $extra_k => $extra_v ) {
            $diffs['extras'][] = getDiff( "<strong>$extra_k :</strong> $extra_v", 
                                        "<strong>$extra_k :</strong> " . $extras_to[$extra_k] . '<br />' );
        }
    }

    // Formatage 
    // YUCK !
    $renderer = new Text_Diff_Renderer_Spip;
    $str = array();
    $GLOBALS['sa_type_data'] = 'surtitre';
    $str[] = is_object($diffs['surtitre']) ? $renderer->render( $diffs['surtitre'] ) : '';
    $GLOBALS['sa_type_data'] = 'titre';
    $str[] = is_object($diffs['titre']) ? $renderer->render( $diffs['titre'] ) : '';
    $str[] = '<br />';
    $GLOBALS['sa_type_data'] = 'descriptif';
    $str[] = is_object($diffs['descriptif']) ? '<p>'. $renderer->render( $diffs['descriptif'] ) . '</p>' : '';
    $str[] = '<br />';
    $GLOBALS['sa_type_data'] = 'site';
    $str[] = is_object($diffs['site']) ? $renderer->render( $diffs['site'] ) : '';
    $GLOBALS['sa_type_data'] = 'chapo';
    $str[] = is_object($diffs['chapo']) ? '<p>'. $renderer->render( $diffs['chapo'] ) .'</p>' : '';
    $GLOBALS['sa_type_data'] = 'texte';
    $str[] = is_object($diffs['texte']) ? $renderer->render( $diffs['texte'] ) : '';
    $GLOBALS['sa_type_data'] = 'ps';
    $str[] = is_object($diffs['ps']) ? '<p>'. $renderer->render( $diffs['ps'] ) .'</p>' : '';
    $GLOBALS['sa_type_data'] = 'extra';
    if ( isset($diffs['extras']) && is_array($diffs['extras']) ) {
        foreach ( $diffs['extras'] as $extra ) {
            $str[] = is_object($extra) ? $renderer->render( $extra ) : '';
        }
    }

    return implode( "\n", $str );
  
}

/** Renvoie une instance de Text_Diff 
 * @return      object Text_Diff
 */
function getDiff( $str_from, $str_to ) {
    // Chargement des librairies ncessaires
    require_once 'Text/Diff.php';
    $diff = new Text_Diff( explode("\n", $str_from), explode("\n", $str_to) );
    return $diff;
}

/** Vrifie la prsence des dpendences ncessaires au bon fonctionnement de l'appli. repomp de install.php3
 * @todo    Rendre plus gnrique (liste de dpendences en paramtre) et placer dans une lib approprie.
 * @return  bool
 */
function checkForDependencies() {

    //Liste des fichiers du package PEAR ncessaires  l'installation d'AGORA
    $liste_fichier_pear = array('Text/Diff.php');
       
    //Pour l'instant il ne manque aucun fichier     
    $liste_fichier_manquant = NULL;
        
    //utilisation des chemins dclars dans les options : les include_path        
    // gestion du PATH_SEPARATOR 
    if (!defined("PATH_SEPARATOR")) {
        if (eregi('Win', getenv('SERVER_SOFTWARE'))) {
            define ("PATH_SEPARATOR", ";");
        } else {
            define ("PATH_SEPARATOR", ':');
        }
    } 

    //On cre la liste des chemins d'accs des fichiers
    $path_package = ini_get('include_path');
    $tableau_chemin = explode(PATH_SEPARATOR, $path_package);
    // Pour chaque fichier pear ncessaire, on regarde dans tous les chemins si on peut les ouvrir
    //On place les fichiers ouvert avec succes dans le tableau des fichier_ouvert
    foreach($liste_fichier_pear as $fichier){
        foreach ($tableau_chemin as $chemin) {
            if (substr ($chemin, strlen($chemin)-1, 1) != '/') $chemin .= '/';
            if($handler = file_exists($chemin.$fichier)){
                $fichier_ouvert[] = $fichier;
            }
        }
    }

    //On parcourt  nouveau la liste des fichiers ncessaire 
    //et on fait la diffrence avec ceux qui sont stocks dans $fichier_vouert
    foreach($liste_fichier_pear as $fichier){
        if(!in_array($fichier, $fichier_ouvert))
            $liste_fichier_manquant[] = $fichier;
    }
            
    return ! count($liste_fichier_manquant);

}

/** Renvoie une ligne de tableau html comprenant une cellule par lment du tableau $tab
 * @param     array    $tab
 * @param     string   $del    type de cellule
 * */
function ligne ($tab, $del = 'td') 
{
    $str = '<tr>';
    foreach ($tab as $val) {
        $str .= '<'.$del.'>'.$val.'</'.$del.'>';
    }
    return $str.'</tr>';
}

function debut_tableau()
{
    echo '<table border="0" cellspacing="0" cellpadding="3" width="100%">';
}

function fin_tableau()
{
    echo '</table>';
}

?>
