<?php
global $nl_preview_path;

if (isset($nl_preview_path)) {
	$GLOBALS['dossier_squelettes']='ecrire/squelettes_newsletter/'.$nl_preview_path;
} else {
	$GLOBALS['dossier_squelettes'] = ($GLOBALS['dossier_squelettes'] ? $GLOBALS['dossier_squelettes'].'/' : '');
}

//this function changes 2004-04-14 17:01:37
//to 2004-04-14T170137Z
//XXX TODO: Put all the dates in UTC. We'll do it one day...
function xml_iso_datetime($dateTime)
{
	return date("Y-m-d\THis\Z", strtotime($dateTime));
	
}

function xml_iso_datetime_reg($dateTime)
{
	preg_match('/([0-9]*)-([0-9]*)-([0-9]*) ([0-9]*):([0-9]*):([0-9]*)/',$dateTime, $dateMatches);

	$year = $dateMatches[1];
	$month = $dateMatches[2];
	$day = $dateMatches[3];

	if (strlen($dateMatches[4]) == 2)
	{ 
		$hour = $dateMatches[4];
	}
	elseif (strlen($dateMatches[4]) == 1)
	{
		$hour = '0'.$dateMatches[4];
	}
	else{
		$hour = '00';
	}
	
	if (strlen($dateMatches[5]) == 2)
	{
		$minute = $dateMatches[5];
	}
	elseif (strlen($dateMatches[5]) == 1)
{
		$minute = '0'.$dateMatches[5];
	}
	else{
		$minute = '00';
	}

	if (strlen($dateMatches[6]) == 2)
	{
		$sec = $dateMatches[6];
	}
	elseif (strlen($dateMatches[6]) == 1)
{
		$sec = '0'.$dateMatches[6];
	}
	else{
		$sec = '00';
	}

	return  $year.'-'.$month.'-'.$day.'T'.$hour.$minute.$sec.'Z';
}

//this function changes 2004-04-14T170137Z
//to 2004-04-14 17:01:37
//XXX TODO: Put all the dates in UTC. We'll do it one day...
function iso_datetime_xml($xmlTime)
{
	$xmlTime = trim($xmlTime);

	$year = substr($xmlTime,0,4);
	$month = substr($xmlTime,5,2);
	$day = substr($xmlTime,8,2);
	$hour = substr($xmlTime,11,2);
	$minute = substr($xmlTime,13,2);
	$sec = substr($xmlTime,15,2);

	return $year.'-'.$month.'-'.$day.' '.$hour.':'.$minute.':'.$sec;
}


//generation of the correct URL for the DXS version of an article
function url_article_dxs($id_article)
{
	return "article_dxs.php?id_article=".$id_article;
}

//generation of the correct URL for the DXS version of a "rubrique"
function url_rubrique_dxs($id_rubrique)
{
	return "rubrique_dxs.php?id_rubrique=".$id_rubrique;
}


function base64_data($id_document)
{
	require_once (dirname(__FILE__).'/include/bd/inc_document_factory.php');
	$document = &recuperer_instance_document();
	$document->load($id_document);
	$data = $document->getFichierContenuBase64();
	if ($data == FALSE)
		return '';
	else
		return $data;
	
}


//sends back an base64 encoded version of a file $filename in IMG
function base64_data_file($filename)
{
	require_once (dirname(__FILE__).'/include/bd/inc_document_factory.php');
	$document = &recuperer_instance_document();
	$document->load($id_document);
	$data = $document->getFichierContenuBase64();
	if ($data == FALSE)
		return '';
	else
		return $data;
	
}

//Generation des CDATA "parsables" par le systeme DXS
//le probleme que l'on peut avoir, c'est le ]]> dans 
//le contenu, interdit par les specs.
//on le remplace donc par une chaine aleatoire qui 
//ne sera pas presente dans le contenu CDATA
function genererTagCDATA($contenu, $tag)
{
	if ($contenu == '')
		return '';
	
	$escapeString = "]]>";
	
	while (strpos($contenu, $escapeString) != FALSE)
	{
		//theoretically never happens. Theoretically :+)
		if ($escapeString == '__DXS_ESCAPE_STRING__')
		{
			$letters = array ('a', 'e', 'i', 'o', 'u', 'b', 'c', 'd', 'f', 'g', 'v', 'w', 'x', 'z');
			shuffle($letters);
			$escapeString = implode("",$letters);
		}
		else
		{
			//quick'n'dirty solution.
			$escapeString = '__DXS_ESCAPE_STRING__';
		}
	}
	
	if ($escapeString != "]]>")
	{
		$contenu = str_replace("]]>", $escapeString, $contenu);
		$result = '<'.$tag.' escape="'.$escapeString.'"><![CDATA[';        
	}
	else
	{
		$result = '<'.$tag.'><![CDATA[';
	}
	return $result.$contenu.']]></'.$tag.'>';
}

function dxs_document_idtype($id_document){

    require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");

    $documentMetier = &recuperer_instance_document();

    if ( is_numeric($id_document) ) {

        $documentMetier->load($id_document);
        if (Pear::isError($documentMetier)) {
                return PEAR::raiseError("[ ".__FILE__.": dxs_document_idtype()] ".$documentMetier->getMessage()."", null,
                null, null, null, null, false);
        }

        return $documentMetier->getTypeId();
    }
}

function dxs_document_mode($id_document){

    require_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");

    $documentMetier = &recuperer_instance_document();

    if ( is_numeric($id_document) ) {

        $documentMetier->load($id_document);
        if (Pear::isError($documentMetier)) {
                return PEAR::raiseError("[ ".__FILE__.": dxs_document_mode()] ".$documentMetier->getMessage()."", null,
                null, null, null, null, false);
        }

        return $documentMetier->getMode();
    }
}

function generateWidth($width) {
    if (is_numeric($width) && $width > 0){
        return '<width>'.$width.'</width>';
    }
}

function generateHeight($height) {
    if (is_numeric($height) && $height > 0){
        return '<height>'.$height.'</height>';
    }
}

function generateLogo($id_article) {
    $dir = 'IMG/';
    $prefixes = array ('on' => 'arton', 'off' => 'artoff');

    if (is_dir($dir)) {
        if ($dh = opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if( is_file($dir . $file)) {
                    foreach ( $prefixes as $key => $prefix ) {
                        if( preg_match('/^'.$prefix.$id_article.'\./', $file)) {
                            $time_str = date("Y-m-d\THis\Z", filectime($dir . $file));
                            echo "

                                <item type=\"spiplogo\">
		                  <creationdate>".$time_str."</creationdate>
		                  <modificationdate>".$time_str."</modificationdate>
				  ".genererTagCDATA('Spiparticle\'s logo', 'titre')."
				  <url>".$GLOBALS['meta']['adresse_site']."/logo_".$key."_dxs.php?id_article=".$id_article."&amp;logo=".$file."</url>
				  ".genererTagCDATA('Spiparticles\'s logo '.$key, 'descriptif')."
				</item>";
                        }
                    }
                }
            }
            closedir($dh);
        }
    }
}

function generateExpirationDate($id_article) {

	$articleMetier = &recuperer_instance_article();
	$articleMetier->load($id_article);


	return xml_iso_datetime($articleMetier->getExpirationDate());
}

function base64_logo($logo_name)
{
    $dir= 'IMG/';
    $mode = 'r';
    $content = '';

    if ( $fhandler = fopen($dir . $logo_name, $mode) ){
        flock($fhandler, LOCK_SH);

        while(!feof($fhandler)) {
            $content.= fgets($fhandler, 1024);
        }

        flock($fhandler, LOCK_UN);
    } else {
        return false;
    }

    fclose($fhandler);

    return chunk_split(base64_encode($content));


}

?>