<?php

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_FILTRES")) return;
define("_ECRIRE_INC_FILTRES", "1");

// Include filtres pour la generation XML du DXS
require_once("inc_dxs.php");
// End include

// Echappement des entites HTML avec correction des entites "brutes"
// (generees par les butineurs lorsqu'on rentre des caracteres n'appartenant
// pas au charset de la page [iso-8859-1 par defaut])
function corriger_entites_html($texte) {
    return ereg_replace('&amp;(#[0-9]+;)', '&\1', $texte);
}

function entites_html($texte) {
    return corriger_entites_html(htmlspecialchars($texte));
}


// Transformer les &eacute; dans le charset local
function filtrer_entites($texte) {
    include_once(dirname(__FILE__).'/inc_charsets.php3');
    // filtrer
    $texte = html2unicode($texte);
    // remettre le tout dans le charset cible
    return unicode2charset($texte);
}

// Tout mettre en entites pour l'export backend (sauf iso-8859-1)
function entites_unicode($texte) {
    include_ecrire('inc_charsets.php3');
    return charset2unicode($texte);
}

// Enleve le numero des titres numerotes ("1. Titre" -> "Titre")
function supprimer_numero($texte) {
    $texte = ereg_replace("^[[:space:]]*[0-9]+[.)".chr(176)."][[:space:]]+", "", $texte);
    return $texte;
}

// Suppression basique et brutale de tous les <...>
function supprimer_tags($texte, $rempl = "") {
    // super gavant : la regexp ci-dessous plante sous php3, genre boucle infinie !
    // $texte = ereg_replace("<([^>\"']*|\"[^\"]*\"|'[^']*')*>", $rempl, $texte);
    $texte = ereg_replace("<[^>]*>", $rempl, $texte);
    return $texte;
}

// Convertit les <...> en la version lisible en HTML
function echapper_tags($texte, $rempl = "") {
    $texte = ereg_replace("<([^>]*)>", "&lt;\\1&gt;", $texte);
    return $texte;
}

// Convertit un texte HTML en texte brut
function textebrut($texte) {
    $texte = ereg_replace("[\n\r]+", " ", $texte);
    $texte = eregi_replace("<(p|br)([[:space:]][^>]*)?".">", "\n\n", $texte);
    $texte = ereg_replace("^\n+", "", $texte);
    $texte = ereg_replace("\n+$", "", $texte);
    $texte = ereg_replace("\n +", "\n", $texte);
    $texte = supprimer_tags($texte);
    $texte = ereg_replace("(&nbsp;| )+", " ", $texte);
    return $texte;
}

// Remplace les liens SPIP en liens ouvrant dans une nouvelle fenetre (target=blank)
function liens_ouvrants ($texte) {
    return ereg_replace("<a ([^>]*https?://[^>]*class=\"spip_(out|url)\")>",
        "<a \\1 target=\"_blank\">", $texte);
}

// Corrige les caracteres degoutants utilises par les Windozeries
function corriger_caracteres($texte) {
    static $trans;
    if (!$trans) {
        // 145,146,180 = simple quote ; 147,148 = double quote ; 150,151 = tiret long
        $trans['iso-8859-1'] = array(
            chr(146) => "'",
            chr(180) => "'",
            chr(147) => '&#8220;',
            chr(148) => '&#8221;',
            chr(150) => '-',
            chr(151) => '-',
            chr(133) => '...'
        );
        $trans['utf-8'] = array(
            chr(194).chr(146) => "'",
            chr(194).chr(180) => "'",
            chr(194).chr(147) => '&#8220;',
            chr(194).chr(148) => '&#8221;',
            chr(194).chr(150) => '-',
            chr(194).chr(151) => '-',
            chr(194).chr(133) => '...'
        );
    }
    $charset = lire_meta('charset');
    if (!$trans[$charset]) return $texte;
    if ($GLOBALS['flag_strtr2']) return strtr($texte, $trans[$charset]);
    reset($trans[$charset]);
    while (list($from, $to) = each($trans[$charset])) 
        $texte = str_replace($from, $to, $texte);
    return $texte;
}

// Transformer les sauts de paragraphe en simples passages a la ligne
function PtoBR($texte){
    $texte = eregi_replace("</p>", "\n", $texte);
    $texte = eregi_replace("<p([[:space:]][^>]*)?".">", "<br />", $texte);
    $texte = ereg_replace("^[[:space:]]*<br />", "", $texte);
    return $texte;
}

// Majuscules y compris accents, en HTML
function majuscules($texte) {
    if (lire_meta('charset') != 'iso-8859-1')
        return "<span style='text-transform: uppercase'>$texte</span>";

    $suite = htmlentities($texte);
    $suite = ereg_replace('&amp;', '&', $suite);
    $suite = ereg_replace('&lt;', '<', $suite);
    $suite = ereg_replace('&gt;', '>', $suite);
    $texte = '';
    if (ereg('^(.*)&([A-Za-z])([a-zA-Z]*);(.*)$', $suite, $regs)) {
        $texte .= majuscules($regs[1]); // quelle horrible recursion
        $suite = $regs[4];
        $carspe = $regs[2];
        $accent = $regs[3];
        if (ereg('^(acute|grave|circ|uml|cedil|slash|caron|ring|tilde|elig)$', $accent))
            $carspe = strtoupper($carspe);
        if ($accent == 'elig') $accent = 'Elig';
        $texte .= '&'.$carspe.$accent.';';
    }
    $texte .= strtoupper($suite);
    return $texte;
}

// "127.4 ko" ou "3.1 Mo"
function taille_en_octets ($taille) {
    if ($taille < 1024) {$taille = _T('taille_octets', array('taille' => $taille));}
    else if ($taille < 1024*1024) {
        $taille = _T('taille_ko', array('taille' => ((floor($taille / 102.4))/10)));
    } else {
        $taille = _T('taille_mo', array('taille' => ((floor(($taille / 1024) / 102.4))/10)));
    }
    return $taille;
}


// Transforme n'importe quel champ en une chaine utilisable
// en PHP ou Javascript en toute securite
// < ? php $x = '[(#TEXTE|texte_script)]'; ? >
function texte_script($texte) {
    $texte = str_replace('\\', '\\\\', $texte);
    $texte = str_replace('\'', '\\\'', $texte);
    return $texte;
}


// Rend une chaine utilisable sans dommage comme attribut HTML
function attribut_html($texte) {
    $texte = ereg_replace('"', '&quot;', supprimer_tags($texte));
    return $texte;
}

// Vider les url nulles comme 'http://' ou 'mailto:'
function vider_url($url) {
    if (eregi("^(http:?/?/?|mailto:?)$", trim($url)))
        return false;
    else
        return $url;
}

// Extraire une date de n'importe quel champ (a completer...)
function extraire_date($texte) {
    // format = 2001-08
    if (ereg("([1-2][0-9]{3})[^0-9]*(0?[1-9]|1[0-2])",$texte,$regs))
        return $regs[1]."-".$regs[2]."01";
}

// Maquiller une adresse e-mail
function antispam($texte) {
    include_ecrire ("inc_acces.php3");
    $masque = creer_pass_aleatoire(3);
    return ereg_replace("@", " $masque ", $texte);
}

// |sinon{rien} : affiche "rien" si la chaine est vide, affiche la chaine si non vide
function sinon ($texte, $sinon='') {
    if ($texte)
        return $texte;
    else
        return $sinon;
}


//
// Date, heure, saisons
//

function normaliser_date($date) {
    /* Ajout nhoizey@clever-age.com */
    if ($date == '1970-01-01 00:00:00') $date .= ' GMT';
    /* Fin d'ajout */
    if ($date!="NULL") {
        if (ereg("^[0-9]{8,10}$", $date))
            $date = date("Y-m-d H:i:s", $date);
        if (ereg("^([12][0-9]{3})([-/]00)?( [-0-9:]+)?$", $date, $regs))
            $date = $regs[1]."-01-01".$regs[3];
        else if (ereg("^([12][0-9]{3}[-/][01]?[0-9])([-/]00)?( [-0-9:]+)?$", $date, $regs))
            $date = ereg_replace("/","-",$regs[1])."-01".$regs[3];
        else if ($GLOBALS['flag_strtotime']) {
            $date = date("Y-m-d H:i:s", strtotime($date));          
        }
        else $date = ereg_replace('[^-0-9/: ]', '', $date);
    }
    return $date;
}

function vider_date($letexte) {
    if (ereg("^0000-00-00", $letexte)) return '';
    return $letexte;
}

function recup_heure($numdate){
    if (!$numdate) return '';

    if (ereg('([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})', $numdate, $regs)) {
        $heures = $regs[1];
        $minutes = $regs[2];
        $secondes = $regs[3];
    }
    return array($heures, $minutes, $secondes);
}

function heures($numdate) {
    $date_array = recup_heure($numdate);
    if ($date_array)
        list($heures, $minutes, $secondes) = $date_array;
    return $heures;
}

function minutes($numdate) {
    $date_array = recup_heure($numdate);
    if ($date_array)
        list($heures, $minutes, $secondes) = $date_array;
    return $minutes;
}

function secondes($numdate) {
    $date_array = recup_heure($numdate);
    if ($date_array)
        list($heures,$minutes,$secondes) = $date_array;
    return $secondes;
}

function heures_minutes($numdate) {
    return _T('date_fmt_heures_minutes', array('h'=> heures($numdate), 'm'=> minutes($numdate)));
}

function recup_date($numdate){

    if (!$numdate) return '';
    if (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})', $numdate, $regs)) {
        $jour = $regs[1];
        $mois = $regs[2];
        $annee = $regs[3];
        if ($annee < 90){
            $annee = 2000 + $annee;
        } else {
            $annee = 1900 + $annee ;
        }
        $heure = $regs[4];
        $minute = $regs[5];
        $seconde = $regs[6];
    }
    elseif (ereg('([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})',$numdate, $regs)) {
        $annee = $regs[1];
        $mois = $regs[2];
        $jour = $regs[3];
        $heure = $regs[4];
        $minute = $regs[5];
        $seconde = $regs[6];
    }
    elseif (ereg('([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})',$numdate, $regs)) {
        $annee = $regs[1];
        $mois = $regs[2];
        $jour = $regs[3];
	}
	elseif (ereg('([0-9]{1,2})/([0-9]{1,2})/([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2})', $numdate, $regs)) {
		$jour = $regs[1];
        $mois = $regs[2];
        $annee = $regs[3];
        if ($annee < 90){
            $annee = 2000 + $annee;
        } else {
            $annee = 1900 + $annee ;
        }
	}
    elseif (ereg('([0-9]{4})-([0-9]{2})', $numdate, $regs)){
        $annee = $regs[1];
        $mois = $regs[2];
    }
    if ($annee > 4000) $annee -= 9000;
    if (substr($jour, 0, 1) == '0') $jour = substr($jour, 1);

    return array($annee, $mois, $jour, $heure, $minute, $seconde);
}


function affdate_base($numdate, $vue) { 
    global $spip_lang;
    $date_array = recup_date($numdate);
    if ($date_array)
        list($annee, $mois, $jour,$heure, $minute, $seconde) = $date_array;
    else
        return '';

    // 1er, 21st, etc.
    $journum = $jour;
    switch ($spip_lang) {
        case 'en':
            switch($jour) {
            case 0: $jour = ''; break;
            case 1: $jour = '1st'; break;
            case 2: $jour = '2nd'; break;
            case 3: $jour = '3rd'; break;
            case 21: $jour = '21st'; break;
            case 22: $jour = '22nd'; break;
            case 23: $jour = '23rd'; break;
            case 31: $jour = '31st'; break;
            default: $jour .= 'th';
            }
        case 'fr':
            if ($jour == '1') $jour = '1er';
    }

    if ($jour == 0)
        $jour = '';

    $mois = intval($mois);
    if ($mois > 0 AND $mois < 13)
        $nommois = _T('date_mois_'.$mois);
    else
        $nommois = '';

    if ($annee < 0) {
        $annee = -$annee." "._T('date_avant_jc');
        $avjc = true;
    }
    else $avjc = false;

    switch ($vue) {
    case 'complet':
    	if ($avjc) return $annee;
        if ($jour)
            return d_apostrophe(_T('date_fmt_jour_mois_annee_heure_minute_seconde', array ('jour'=>$jour, 'nommois'=>$nommois, 'mois'=>$mois, 'annee'=>$annee, 'heure'=>$heure, 'minute'=>$minute, 'seconde'=>$seconde)));
        else
            return d_apostrophe(_T('date_fmt_jour_mois_annee_heure_minute_seconde', array ('mois'=>$mois, 'nommois'=>$nommois, 'annee'=>$annee, 'heure'=>$heure, 'minute'=>$minute, 'seconde'=>$seconde)));
    	
    case 'saison':
        if ($mois > 0){
            $saison = 1;
            if (($mois == 3 AND $jour >= 21) OR $mois > 3) $saison = 2;
            if (($mois == 6 AND $jour >= 21) OR $mois > 6) $saison = 3;
            if (($mois == 9 AND $jour >= 21) OR $mois > 9) $saison = 4;
            if (($mois == 12 AND $jour >= 21) OR $mois > 12) $saison = 1;
        }
        return _T('date_saison_'.$saison);

    case 'court':
        if ($avjc) return $annee;
        $a = date('Y');
        if ($annee < ($a - 100) OR $annee > ($a + 100)) return $annee;
        if ($annee != $a) return d_apostrophe(_T('date_fmt_mois_annee', array ('mois'=>$mois, 'nommois'=>ucfirst($nommois), 'annee'=>$annee)));
        return  d_apostrophe(_T('date_fmt_jour_mois', array ('jour'=>$jour, 'nommois'=>$nommois, 'mois'=>$mois, 'annee'=>$annee)));

    case 'jourcourt':
        if ($avjc) return $annee;
        $a = date('Y');
        if ($annee < ($a - 100) OR $annee > ($a + 100)) return $annee;
        if ($annee != $a) return d_apostrophe(_T('date_fmt_jour_mois_annee', array ('jour'=>$jour, 'mois'=>$mois, 'nommois'=>$nommois, 'annee'=>$annee)));
        return  d_apostrophe(_T('date_fmt_jour_mois', array ('jour'=>$jour, 'nommois'=>$nommois, 'mois'=>$mois, 'annee'=>$annee)));

    case 'entier':
        if ($avjc) return $annee;
        if ($jour)
            return d_apostrophe(_T('date_fmt_jour_mois_annee', array ('jour'=>$jour, 'nommois'=>$nommois, 'mois'=>$mois, 'annee'=>$annee)));
        else
            return d_apostrophe(_T('date_fmt_mois_annee', array ('mois'=>$mois, 'nommois'=>$nommois, 'annee'=>$annee)));

    case 'nom_mois':
        return $nommois;

    case 'mois':
        return sprintf("%02s",$mois);

    case 'jour':
        return $jour;

    case 'journum':
        return $journum;

    case 'nom_jour':
        if (!$mois OR !$jour) return '';
        $nom = mktime(1,1,1,$mois,$jour,$annee);
        $nom = 1+date('w',$nom);
        return _T('date_jour_'.$nom);

    case 'mois_annee':
        if ($avjc) return $annee;
        return trim(d_apostrophe(_T('date_fmt_mois_annee', array('mois'=>$mois, 'nommois'=>$nommois, 'annee'=>$annee))));

    case 'annee':
        return $annee;
    }

    return "<blink>"._T('info_format_non_defini')."</blink>";
}

function nom_jour($numdate) {
    return affdate_base($numdate, 'nom_jour');
}

function jour($numdate) {
    return affdate_base($numdate, 'jour');
}

function journum($numdate) {
    return affdate_base($numdate, 'journum');
}

function mois($numdate) {
    return affdate_base($numdate, 'mois');
}

function nom_mois($numdate) {
    return affdate_base($numdate, 'nom_mois');
}

function annee($numdate) {
    return affdate_base($numdate, 'annee');
}

function saison($numdate) {
    return affdate_base($numdate, 'saison');
}

function affdate($numdate) {
    return affdate_base($numdate, 'entier');
}

function affdate_court($numdate) {
    return affdate_base($numdate, 'court');
}

function affdate_jourcourt($numdate) {
    return affdate_base($numdate, 'jourcourt');
}

function affdate_mois_annee($numdate) {
    return affdate_base($numdate, 'mois_annee');
}

function affdate_heure($numdate) {
    return _T('date_fmt_jour_heure', array('jour' => affdate($numdate), 'heure' => heures_minutes($numdate)));
}

// renvoie "d'octobre" (ocitan) ou "de octubre" (espagnol)
function d_apostrophe($texte) {
    global $spip_lang;
    if (ereg("^(oci_.+|fr|ca)$",$spip_lang))
        return ereg_replace("^(.+ )?de ([aeiou])", "\\1d'\\2", $texte);
    else
        return $texte;
}


//
// Alignements en HTML
//

function aligner($letexte,$justif) {
    /* --- nhoizey ---
    $letexte = eregi_replace("<p([^>]*)", "<p\\1 align='$justif'", trim($letexte));
    if ($letexte AND !ereg("^[[:space:]]*<p", $letexte)) {
        $letexte = "<p class='spip' align='$justif'>" . $letexte . "</p>";
    }
    */
    $letexte = eregi_replace("<p([^>]*)", "<p\\1 style=\"text-align: $justif;\"", trim($letexte));
    // ajout Olivier Mansour 
    // detection de la class du paragraphe et annulation de l'application du style 
    $letexte = eregi_replace ("(<p class=\"(spip_vignette|spip_titre_document|spip_descriptif|spip_complement)\")[^>]*>", "\\1>", $letexte);
    // fin ajout Olivier Mansour
    if ($letexte AND !ereg("^[[:space:]]*<p", $letexte)) {
        $letexte = '<p class="spip" style="text-align: '.$justif.';">'.$letexte.'</p>';
    }
    return $letexte;
}

function justifier($letexte) {
    return aligner($letexte,'justify');
}

function aligner_droite($letexte) {
    return aligner($letexte,'right');
}

function aligner_gauche($letexte) {
    return aligner($letexte,'left');
}

function centrer($letexte) {
    return aligner($letexte,'center');
}

//
// Export iCal
//

function filtrer_ical ($texte) {
    $texte = html2unicode($texte);
    $texte = unicode2charset(charset2unicode($texte, lire_meta('charset'), 1), 'utf-8');
    $texte = ereg_replace("\n", " ", $texte);
    $texte = ereg_replace(",", "\,", $texte);

    return $texte;
}

function date_ical ($date_heure, $minutes = 0) {
    return date ("Ymd\THis", mktime (heures($date_heure),minutes($date_heure)+$minutes,0,mois($date_heure),jour($date_heure),annee($date_heure)));
}



//
// Recuperation de donnees dans le champ extra
// Ce filtre n'a de sens qu'avec la balise #EXTRA
//

function extra($letexte, $champ) {
    $champs = unserialize($letexte);
    return $champs[$champ];
}


//
// array_push et array_pop pour php3 (a virer si on n'a pas besoin de la compatibilite php3
// et a passer dans inc_version si on a besoin de ces fonctions ailleurs qu'ici)
//
/*
 * Avertissement : Cette librairie de fonctions PHP est distribuee avec l'espoir 
 * qu'elle sera utile, mais elle l'est SANS AUCUNE GARANTIE; sans meme la garantie de 
 * COMMERCIALISATION ou d'UTILITE POUR UN BUT QUELCONQUE.
 * Elle est librement redistribuable tant que la presente licence, ainsi que les credits des 
 * auteurs respectifs de chaque fonctions sont laisses ensembles. 
 * En aucun cas, Nexen.net ne pourra etre tenu responsable de quelques consequences que ce soit
 * de l'utilisation ou la mesutilisation de ces fonctions PHP.
 */
/****
 * Titre : array_push() et array_pop() pour PHP3 
 * Auteur : Cedric Fronteau 
 * Email : charlie@nexen.net
 * Url : 
 * Description : Implementation de array_push() et array_pop pour PHP3
****/
function php3_array_push(&$stack,$value){
    if (!is_array($stack))
        return FALSE;
    end($stack);
    do {
        $k = key($stack);
        if (is_long($k));
            break;
    } while(prev($stack));

    if (is_long($k))
        $stack[$k+1] = $value;
    else
        $stack[0] = $value;
    return count($stack);
}

function php3_array_pop(&$stack){
    if (!is_array($stack) || count($stack) == 0)
        return NULL;
    end($stack);
    $v = current($stack);
    $k = key($stack);
    unset($stack[$k]);
    return $v;
}


// Ajout Olivier Mansour 
/****
 * titre : absolute_url 
 * Auteur : Olivier Mansour
 * Email : omansour@clever-age.com
 * Description : transforme les URLS relatives en URLS absolues 
 (utile pour la newsletter)
****/
function absolute_url ($chaine) {
    // TBI : quid si le href n'est pas en premier ?     
    $URL_SITE_SPIP = lire_meta ('adresse_site');
    
    // rajout d'un / ventuellement 
    if (substr ($URL_SITE_SPIP, strlen($URL_SITE_SPIP)-1, 1) != '/') $URL_SITE_SPIP .= '/';

    $chaine = eregi_replace ('<a href="' , '<a href="'.$URL_SITE_SPIP, $chaine); 
    $chaine = eregi_replace ('<a href="'.$URL_SITE_SPIP.'http://([^"]*)"', "<a href=\"http://\\1\"", $chaine);
    
    $chaine = eregi_replace ('<img src="' , '<img src="'.$URL_SITE_SPIP, $chaine); 
    $chaine = eregi_replace ('<img src="'.$URL_SITE_SPIP.'http://([^"]*)"', "<img src=\"http://\\1\"", $chaine);
    
     // virer les http:// devant les #nb (les notes)
    $chaine = eregi_replace ('<a href="'.$URL_SITE_SPIP.'(#nb[^"]*)"' , '<a href="\\1"', $chaine);
    
    return $chaine; 
}
// fin ajout Olivier Mansour

// Ajout Olivier Mansour 
/****
 * titre : version_texte
 * Auteur : Olivier Mansour
 * Email : omansour@clever-age.com
 * Description : transforme un texte au format HTML en texte brut, 
    par rapport a textebrut => traite les notes de bas de page, les liens, les intertitres, les images
    // Remplace tous les liens selon la logique suivante :
    //   '<a href="link">link</a>' devient 'link'
    //   '<a href="link">text</a>' devient 'text (link)'
  fonction issues de Clever Mail (-> NHoizey)  
  (utile pour la newsletter ? avec textebrut apres ? )
  ? a tester ? 
  ? gestion des images ? 
****/
function version_texte ($in) {
    // nettoyage des retours chariots
    $out = str_replace ("\n", '', $out);
    
    // Nettoyage des liens des notes de bas de page
    $out = ereg_replace("<a href=\"#n(b|h)[0-9]+-[0-9]+\" name=\"n(b|h)[0-9]+-[0-9]+\" class=\"spip_note\">([0-9]+)</a>", "\\3", $in);

    // les puces 
    $out = str_replace($GLOBALS['puce'], "\n".'-', $out);
 
    // Remplace tous les liens

    while (eregi("<a href=['\"]([^'\">]+)['\"][^>]*>([^<]+)</a>", $out, $regs)) {
		$cleanReg1 = ereg_replace("\\?", "\?", $regs[1]);
        $cleanReg1 = ereg_replace("\\+", "\+", $cleanReg1);
		$cleanReg1 = ereg_replace("\\(", "\(", $cleanReg1);
        $cleanReg1 = ereg_replace("\\)", "\)", $cleanReg1);
		
		$cleanReg2 = ereg_replace("\\?", "\?", $regs[2]);
        $cleanReg2 = ereg_replace("\\+", "\+", $cleanReg2);
        $cleanReg2 = ereg_replace("\\(", "\(", $cleanReg2);
        $cleanReg2 = ereg_replace("\\)", "\)", $cleanReg2);
		
		if ($regs[1] == $regs[2]) {
            $out = eregi_replace("<a href=['\"]".$cleanReg1."['\"][^>]*>".$cleanReg1."</a>", $regs[1], $out);
        } else {
            $out = eregi_replace("<a href=['\"]".$cleanReg1."['\"][^>]*>".$cleanReg2."</a>", $regs[2]." ( ".$regs[1]." )", $out);
        }
		
    }
    
    // les images 
    while (eregi("<img src=['\"]([^'\">]+)['\"][^>]*title=['\"]([^'\">]+)['\"][^>]*>", $out, $regs )) {
        $out = str_replace ($regs[0], basename($regs[1]).' ('.$regs[1].') '.$regs[2]."\n", $out);
    }
    while (eregi("<img src=['\"]([^'\">]+)['\"][^>]*>", $out, $regs )) {
        $out = str_replace ($regs[0], basename($regs[1]).' ('.$regs[1].') '."\n", $out);
    }
    
    //$out = translitteration($out, 'iso-8859-1');
    $out = str_replace('&oelig;', 'oe', $out."<br /><br /><br /><br />");
    $out = str_replace("<h3 class='spip'>", "\n----------------------------------------------------------------------\n", $out);
    $out = str_replace("<h3>", "\n----------------------------------------------------------------------\n", $out);
    $out = str_replace("</h3>", "\n----------------------------------------------------------------------", $out);
    $out = str_replace("</p>", "\n", $out);

    // Les notes de bas de page
    $out = str_replace("<p class=\"spip_note\">", "\n", $out);
    $out = ereg_replace("<sup>([0-9]+)</sup>", "[\\1]", $out);
   
    
    
    //$out = str_replace('<br /><img class=\'spip_puce\' src=\'img_pack/puce.gif\' alt=\'-\' border=\'0\'>', "\n".'-', $out);
    $out = ereg_replace ('<li[^>]>', "\n".'-', $out);
    //$out = str_replace('<li>', "\n".'-', $out);
    
    
    //$out = ereg_replace("<p align='center'><img src='([^']+)' border=0 width='[0-9]+' height='[0-9]+' align='center' hspace='[0-9]+' vspace='[0-9]+'>'", "\nIllustration : \\1\n", $out);
    
   
    // accentuation du gras - 
    // <b>texte</b> -> *texte*
    $out = ereg_replace ('<b[^>|r]*>','*' ,$out);
    $out = str_replace ('</b>','*' ,$out);
    
    // accentuation de l'italique
    // <i>texte</i> -> *texte*
    $out = ereg_replace ('<i[^>|mg]*>','*' ,$out);
    $out = str_replace ('</i>','*' ,$out);
   
    $out = supprimer_tags($out);
    $out = unhtmlentities($out);
   
    $out = str_replace("&nbsp;", " ", $out);
    $out = str_replace("&#8217;", "'", $out);
    $out = str_replace("&#171;", "", $out);
    $out = str_replace("&#187;", "", $out);
		$out = str_replace("&#8220;", "\"", $out);
		$out = str_replace("&#8221;", "\"", $out);
		$out = str_replace("&#176;", "", $out);
		$out = str_replace("&#8364;", "E", $out);
		$out = str_replace("&#36;", "E", $out);
    $out = wordwrap($out, 70, "\n");
    
    return $out;
        
}
// fin ajout Olivier Mansour


// For users prior to PHP 4.3.0 you may do this:
function unhtmlentities($string)
{
   $trans_tbl = get_html_translation_table(HTML_ENTITIES);
   $trans_tbl = array_flip($trans_tbl);
   //var_dump($trans_tbl);
   return strtr($string, $trans_tbl);
}

function texte_backend($texte) {

        // " -> &quot; et tout ce genre de choses
        $texte = entites_html($texte);
        $texte = str_replace("&nbsp;", " ", $texte);

        // verifier le charset
        $texte = entites_unicode($texte);

        // Caracteres problematiques en iso-latin 1
        if (lire_meta('charset') == 'iso-8859-1') {
            $texte = str_replace(chr(156), '&#156;', $texte);
            $texte = str_replace(chr(140), '&#140;', $texte);
            $texte = str_replace(chr(159), '&#159;', $texte);
        }

        // nettoyer l'apostrophe curly qui semble poser probleme a certains rss-readers
        $texte = str_replace("&#8217;","'",$texte);

        // corrige le pb de &nbsp;
        $texte = str_replace("&amp;nbsp;"," ",$texte);

        return $texte;
}

function date_rfc822($date_heure) {
    list($annee, $mois, $jour) = recup_date($date_heure);
    list($heures, $minutes, $secondes) = recup_heure($date_heure);
    $time = mktime($heures, $minutes, $secondes, $mois, $jour, $annee);
    return gmdate("D, d M Y H:i:s +0100", $time);
}

/**
 * Break word after size letters.
 * Simple version which works:)
 *
 * todo: zero inline when space occurs.
 */

function htmlwrap($str, $width, $break=' '){

    return preg_replace_callback("/(<[^>]*>)?([^(<.*>)\s\n\r]*)(<\/[^>]*>)?/",
        create_function('$matches, $width='.$width,
               'static $inline;

           $inline+=strlen($matches[2]);

           if($inline>$width){
                $inline=(integer)fmod($inline,$width);
                if(strlen($matches[2])>=$width){
                    $matches[2]=\' \'.wordwrap($matches[2],$width,\' \',true);
                }else{
                     $matches[2]=\' \'.$matches[2];
                }
                }

           return $matches[1].$matches[2].$matches[3];'),
            $str);
}


/* 
 * corrige des incohrences de dates
 * 
 * 
 */

function corriger_date ($date) {
    
    
    
    list ($annee, $mois, $jour, $heure, $minute, $seconde) = recup_date ($date);
    
    if (!ereg ("([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})", $heure.':'.$minute.':'.$seconde)) {
            // raise an error for further debugging
            include_once ('PEAR.php');
            PEAR::raiseError("inc_filtres.php3 why do I have such incorect date : ".$date.' ! '. print_r (debug_backtrace(), true), PEAR_LOG_DEBUG);
            // correct the date
            $date = sprintf("%04d-%02d-%02d", $annee, $mois, $jour).' 00:00:00';    
        }       
    
    // TODO check the validity of the date with Date::IsValidDate ?
        
    return $date;
}

?>
