<?php

//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_INDEX")) return;
define("_ECRIRE_INC_INDEX", "1");

require_once (dirname(__FILE__)."/include/indexer/inc_indexer_factory.php");

function indexer_objet($type, $id_objet, $forcer_reset = true, $full = true) {
	//echo 'type = ' . $type .'<br />';
	//echo 'id_objet = ' . $id_objet .'<br />';
	
	$indexer = &recuperer_instance_indexer($type);
	if ( PEAR::isError($indexer) ) {
		//die ( $indexer->getMessage() );
        PEAR::raiseError("indexer $type $id_object".$indexer->getMessage(), PEAR_LOG_ERR,
                null, null, null, null, false); 
	} else {
    	$indexer->setFull($full);
    	$indexer->index($id_objet, $forcer_reset);
	}
	
}

// API pour l'espace prive
function marquer_indexer ($objet, $id_objet) {
	global $dir_ecrire;
	$fichier_index = $dir_ecrire.'data/.index';
	if (!$f = @fopen($fichier_index, 'a')) {
		spip_log ("impossible d'ecrire dans $fichier_index !");
		@unlink ($fichier_index);	// on essaie de forcer
		$f = @fopen($fichier_index, 'a');
	}
	spip_log ("demande indexation $objet $id_objet");
	fputs($f, "$objet $id_objet 1\n");	// 1 = forcer reindexation
	fclose($f);
}
function indexer_article($id_article) {
	marquer_indexer('article', $id_article);
    // indexer les docs de l'article si c pas fait par le moteur externe 
    if (lire_meta('activer_recherche_document') != oui) {
        include_once (dirname(__FILE__).'/include/bd/inc_document_factory.php');
        $documentMetier = &recuperer_instance_document();
        $allDocumentIds = $documentMetier->getAlldocumentIdsForArticleId($id_article);
        foreach ($allDocumentIds as $allDocumentId) {
            indexer_document($allDocumentId);
        }
    }
}
function indexer_auteur($id_auteur) {
	marquer_indexer('auteur', $id_auteur);
}
function indexer_breve($id_breve) {
	marquer_indexer('breve', $id_breve);
}
function indexer_mot($id_mot) {
	marquer_indexer('mot', $id_mot);
}
function indexer_rubrique($id_rubrique) {
	marquer_indexer('rubrique', $id_rubrique);
    // indexer les docs de la rubrique si c pas fait par le moteur externe 
    if (lire_meta('activer_recherche_document') != oui) {
        include_once (dirname(__FILE__).'/include/bd/inc_document_factory.php');
        $documentMetier = &recuperer_instance_document();
        $allDocumentIds = $documentMetier->getAlldocumentIdsForRubriqueId($id_rubrique);
        foreach ($allDocumentIds as $allDocumentId) {
            indexer_document($allDocumentId);
        }
    }
}
function indexer_syndic($id_syndic) {
	marquer_indexer('syndic', $id_syndic);
}

function indexer_document($id_document) {
    marquer_indexer('document', $id_document);
}

function effectuer_une_indexation() {
 	$fichier_index = dirname(__FILE__).'/data/.index';
 	$suite = @file($fichier_index);
 	$s = @sizeof($suite);
	if ($suite && $s) {
        include_once (dirname(__FILE__)."/inc_texte.php3");
		include_once (dirname(__FILE__)."/inc_filtres.php3");
        
		$n = rand(0, $s-1);
		$s = $suite[$n];
		unset($suite[$n]);
		
		$f = fopen($fichier_index, 'wb');
		fwrite($f, join("", $suite));
		fclose($f);
		
		$s = explode(' ', trim($s));
		indexer_objet($s[0], $s[1], $s[2]);
	}
	else {
		@unlink($fichier_index);
	}
}

function executer_une_indexation_syndic() {
	$visiter_sites = lire_meta("visiter_sites");
	if ($visiter_sites == "oui") {
		//----------Modification Clever Age elebescond-------------
        $syndicMetier = &recuperer_instance_syndic();
        $allSyndicIds = $syndicMetier->getSyndicIdsForStatutAndDateIndex('publie');
        if(PEAR::isError($allSyndicIds)) {
            //die($allSyndicIds->getMessage());
        }
        while (list(,$id_syndic) = each($allSyndicIds)) {
            $loadOK = $syndicMetier->load($id_syndic);
            if (PEAR::isError($loadOK)) {
                die($loadOK->getMessage());
            }
            else {
                $maDate = new Date();
                $syndicMetier->setDateIndex($maDate->getDate());
                $updateOK = $syndicMetier->update();
                if (PEAR::isError($updateOK)) {
                    //die($updateOK->getMessage());
                }
            }

			indexer_syndic($id_syndic);
        }
        /*
        $query = "SELECT id_syndic FROM spip_syndic WHERE statut='publie' ".
			"AND date_index < DATE_SUB(NOW(), INTERVAL 7 DAY) ORDER BY date_index LIMIT 0,1";
		if ($result = spip_query($query)) {
			while ($row = spip_fetch_array($result)) {
				$id_syndic = $row['id_syndic'];
				spip_query("UPDATE spip_syndic SET date_index=NOW() WHERE id_syndic=$id_syndic");
				indexer_syndic($id_syndic);
			}
		}
	    */
        //----------Fin modification Clever Age---------
	}
}

function creer_liste_indexation() {
    include_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_breve_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_syndic_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_auteur_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_profil_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_rubrique_factory.php");
    include_once (dirname(__FILE__)."/include/bd/inc_document_factory.php");
	$fichier_index = dirname(__FILE__).'/data/.index';
	$elements = array('article', 'breve', 'mot', 'auteur', 'rubrique', 'syndic', 'document');

	while (list(,$element) = each ($elements)) {
		$table = $GLOBALS['table_prefix']."_".$element."s";
		if ($element == 'syndic') $table = $GLOBALS['table_prefix'].'_syndic';
		switch($element) {
            case 'rubrique':
            $rubriqueMetier = &recuperer_instance_rubrique();
            //$allRubriqueIds = $rubriqueMetier->getRubriqueidsForStatut('publie');
            $allRubriqueIds = $rubriqueMetier->getAllRubriqueId();
            if(PEAR::isError($allRubriqueIds)) {
                    die($allRubriqueIds->getMessage());
            }
            while(list( ,$rubriqueId) = each($allRubriqueIds)) {
                $liste .= "$element ".$rubriqueId."\n";
            }
            break;
			case 'article':
			$articleMetier = &recuperer_instance_article();
			    $allArticleIds = $articleMetier->getAllArticleIds();
                // $allArticleIds = $articleMetier->getAllArticleForStatutsOrderBy('publie, archive');
			    if(PEAR::isError($allArticleIds)) {
			        die($allArticleIds->getMessage());
			    }
			    while(list( ,$articleId) = each($allArticleIds)) {
			        $liste .= "$element ".$articleId."\n";
			    }
			    break;
			case 'breve':
			    $breveMetier = &recuperer_instance_breve();
			    $allBreveIds = $breveMetier->getAllBreveId();
			    if(PEAR::isError($allBreveIds)) {
			        die($allBreveIds->getMessage());
			    }
			    while(list( ,$breveId) = each($allBreveIds)) {
			        $liste .= "$element ".$breveId."\n";
			    }
                break;
			case 'syndic':
				//$statut = "WHERE statut='publie'";
				$syndicMetier = &recuperer_instance_syndic();
			    $allSyndicIds = $syndicMetier->getAllSyndicIdsForStatut('publie');
			    if(PEAR::isError($allSyndicIds)) {
			        die($allSyndicIds->getMessage());
			    }
			    while(list( ,$syndicId) = each($allSyndicIds)) {
			        $liste .= "$element ".$syndicId."\n";
			    }
				break;
			case 'auteur':
				//----------modification Clever Age elebescond---------
				$profilMetier = &recuperer_instance_profil();
				$allProfils = $profilMetier->getAllProfils();
				if(PEAR::isError($allProfils)) {
				    die($allprofils->getMessage);
				}

				while(list( ,$monProfil) = each($allProfils)) { 
				    $poids[] = $monProfil->getPoids();
				}

				//$statut = "WHERE profil IN (" . join(",", $poids) . ")";
				/*
				$statut = "WHERE statut IN ('minirezo', 'comite')";
				*/
				//----------Fin modification Clever Age---------
				$auteurMetier = &recuperer_instance_auteur();
			    $allAuteurIds = $auteurMetier->getAllAuteurIdForProfils($poids);
			    if(PEAR::isError($allAuteurIds)) {
			        die($allAuteurIds->getMessage());
			    }
			    while(list( ,$auteurId) = each($allAuteurIds)) {
			        $liste .= "$element ".$auteurId."\n";
			    }
				break;
            case 'document':
                $documentMetier = &recuperer_instance_document();
                $allDocumentIds = $documentMetier->getAllDocumentIds();
                if(PEAR::isError($allDocumentIds)) {
                    die($allDocumentIds->getMessage());
                }
                while(list( ,$documentId) = each($allDocumentIds)) {
                    $liste .= "$element ".$documentId."\n";
                }
			default:
				$statut = '';
		}
        
	}

	if ($f = @fopen("$fichier_index", "w")) {
		@fputs($f, $liste);
		@fclose($f);
	}
}

function purger_index() {
		require_once dirname(__FILE__)."/include/bd/inc_index_articles_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_auteurs_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_breves_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_dico_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_mots_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_rubriques_factory.php";
		require_once dirname(__FILE__)."/include/bd/inc_index_syndic_factory.php";
		
		//----------Modification Clever Age jguillot----------
        $indexArticleMetier = &recuperer_instance_index_articles();
        $indexArticleMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_articles");
        */
        $indexAuteurMetier = &recuperer_instance_index_auteurs();
        $indexAuteurMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_auteurs");
        */
        $indexBreveMetier = &recuperer_instance_index_breves();
        $indexBreveMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_breves");
        */
        $indexMotMetier = &recuperer_instance_index_mots();
        $indexMotMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_mots");
        */
        $indexRubriqueMetier = &recuperer_instance_index_rubriques();
        $indexRubriqueMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_rubriques");
        */
        $indexSyndicMetier = &recuperer_instance_index_syndic();
        $indexSyndicMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_syndic");
        */
        $indexDicoMetier = &recuperer_instance_index_dico();
        $indexDicoMetier->delete();
	    /*
        spip_query("DELETE FROM spip_index_dico");
        */
		//---------Fin modification Clever Age------------------
}

// cree la requete pour une recherche en txt integral
function requete_txt_integral($objet, $hash_recherche) {
	if ($objet == 'syndic') {
		$table = $GLOBALS['table_prefix']."_".$objet;
		$index_table = $GLOBALS['table_prefix']."_index_".$objet;
	} else {
		$table = $GLOBALS['table_prefix']."_".$objet."s";
		$index_table = $GLOBALS['table_prefix']."_".$objet."s";
	}
	$id_objet = "id_".$objet;
	return "SELECT objet.*, SUM(idx.points) AS points
		FROM $table AS objet, $index_table AS idx
		WHERE objet.$id_objet = idx.$id_objet
		AND idx.hash IN ($hash_recherche)
		GROUP BY objet.$id_objet
		ORDER BY points DESC
		LIMIT 0,10";
}

// rechercher un mot dans le dico
function requete_dico($val, $mode = 'IN') {
	
	// cas particulier translitteration vietnamien
	if (lire_meta('langue_site') == 'vi') {
		// 1. recuperer des accents passes sous la forme a`
		$val = strtr($val, "'`?~.^+(-","123456789");
		// 2. translitterer les accents passes en unicode
		$val = Indexer_Utils::nettoyer_chaine_indexation($val);
		// 3. composer la regexp pour les caracteres accentuables mais non accentues
		while (ereg("([aeiouyd])([a-z])", $val.' ', $match))
			$val = str_replace ($match[0], $match[1].'[-1-9]?[-1-9]?'.$match[2], $val);
		return "dico REGEXP '^$val'";     // TODO ca ne marche pas sous SPIP-Agora a !?
	}

    /*
	// cas normal
	if (strlen($val) > $min_long)
		return "dico LIKE '$val%'";
	else return "dico = '".$val."___'";
    */
    
    if (!$val) return false;
    
    if ($mode == 'IN') {
        return "dico LIKE '$val%'"; // doing %$val% gave us more results but cost much more in the bdd
    } else {
        return "dico = '$val'";
    }
}


// decode la chaine recherchee et la traduit en hash
function requete_hash ($rech, $mode = 'IN') {
    
	require_once dirname(__FILE__)."/include/indexer/Indexer_Utils.php";
	require_once dirname(__FILE__)."/include/bd/inc_index_dico_factory.php";

    $rech = Indexer_Utils::fabriquer_chaine_indexation($rech);
    $s = Indexer_Utils::spip_split(" +", $rech);
    unset($dico);
	unset($h);

	// cherche les mots dans le dico
	while (list(, $val) = each($s))
		if ($rq = requete_dico ($val, $mode)) {
            if ($rq) $dico[] = $rq;
        }
		

	// compose la recherche dans l'index
	if ($dico) {

		//----------Modification Clever Age jguillot----------

        $indexDicoMetier = &recuperer_instance_index_dico();
        $h = $indexDicoMetier->composeResearchInIndex($dico);

		/*
		$query2 = "SELECT HEX(hash) AS hx FROM spip_index_dico WHERE ".join(" OR ", $dico);
		$result2 = spip_query($query2);
		while ($row2 = spip_fetch_array($result2))
			$h[] = "0x".$row2["hx"];
		*/

		//----------Fin Modification Clever Age -------------
	}
  
    // si le nbre de hash est inferieur au nombre de mots et que l'on est pas en recherche std (IN), pas de recherche
    if ( (count($h) < count($s)) and ($mode != 'IN') ) {
        $hash_recherche = "'0'";
    } else { // on fabrique notre chaine de recherche
        if ($h)
            $hash_recherche = join(",", $h);
        else
            $hash_recherche = "'0'";
    }

	return $hash_recherche;
}

// ajoute des lignes au fichier contenant les donnees a indexer en fonction du contexte
function alimenter_fichier_index ($connect = true) {
    $elementList = array('id_article','id_auteur','id_breve','id_mot','id_rubrique');
    $fichier_index = dirname(__FILE__).'/data/.index';
    $tab = array ();
    while (list(,$val) = each($elementList)) { 
        global $$val;
        $type = str_replace ('id_', '', $val);
        if ($$val == "-1") { // protection pour les valeurs fixees a -1
            $$val = false;
        }
        if ($$val > 0) {
            if ($connect) {
                $indexer = &recuperer_instance_indexer($type);
                if ($$val AND !$indexer->alreadyIndex($$val))
                //if ($$val AND !deja_indexe($type, $$val))
                $tab[] = $type.' '.$$val."\n";
            } else {
                if ( ((@filesize($fichier_index) < 2048) and ( (time() - @filemtime($fichier_index)) < 60 ) ) or (!file_exists($fichier_index))) {  // bof bof
                    $tab[] = $type.' '.$$val."\n";   
                }   
            }
        }
    }   
    $tab = array_unique ($tab);
    if (count($tab) > 0) {
        if ($f = @fopen($fichier_index, 'a')) {
            foreach($tab as $s) {
                fwrite($f, $s);
            }
            fclose($f);
        }
    }
}


?>
