<?php

// $Id$

include_once ('inc_texte.php3');
require_once ('DB.php');
require_once ('include/bd/metier.php');
require_once ('include/bd/parameters.php');

function update_liens($contenu, $contenant)
{
	$liens = array();

	// Echapper les <a href>, <html>...< /html>, <code>...< /code>
	list($contenu, $tmp) = echappe_html($contenu, 'SOURCEPROPRE');
	// Corriger HTML
	$contenu = eregi_replace("</?p>", "\n\n\n", $contenu);

	// Raccourcis liens internes
	$types_liens = array('ar' => 'art', 'ru' => 'rub', 'br' => 'bre', 'au' => 'aut', 'mo' => 'mot', 'si' => 'sit', 'im' => 'img', 'do' => 'doc');
	$regexp = "\[([^][]*)->(>?)([^]]*)\]";
	$texte_a_voir = $contenu;
	$texte_vu = '';
	while (ereg($regexp, $texte_a_voir, $regs)) {
		$lien_url = trim($regs[3]);
		if (ereg("^(art(icle)?|rub(rique)?|br(.ve)?|aut(eur)?|mot|site|doc(ument)?|im(age|g))? *([[:digit:]]+)$", $lien_url, $match)) {
			$id_lien = $match[8];
			$type_lien = $types_liens[substr($match[1].'ar', 0, 2)];
			$lien = $type_lien.'-'.$id_lien;
			$liens[] = array('type' => 'interne', 'valeur' => $lien);
		} else {
			$liens[] = array('type' => 'externe', 'valeur' => $lien_url);
		}
		$zetexte = split($regexp, $texte_a_voir, 2);
		$texte_vu .= typo($zetexte[0]).$insert;
		$texte_a_voir = $zetexte[1];
	}
	$contenu = $texte_vu.typo($texte_a_voir); // typo de la queue du texte

	// Insertion d'images et de documents utilisateur
	while (eregi("<(IMG|DOC|EMB)([0-9]+)(\|[^>]+)?>", $contenu, $match)) {
		$tag = quotemeta($match[0]);
		$type_lien = strtolower($match[1]);
		$id_lien = $match[2];
		$lien = $type_lien.'-'.$id_lien;
		$liens[] = array('type' => 'interne', 'valeur' => $lien);
		$contenu = str_replace($tag, '', $contenu);
	}

	if (count($liens) > 0) {
		$dbMetier = new BD_metier;
		$dbMetier->setDbParameters($GLOBALS['bd_params']);
		$db = $dbMetier->_getDB();
		$db->query("DELETE FROM ".$GLOBALS['table_prefix']."_liens WHERE contenant = '".$contenant."'");
		reset($liens);
		while (list(, $lien) = each($liens)) {
			$db->query("INSERT INTO ".$GLOBALS['table_prefix']."_liens (contenant, lien_".$lien['type'].") VALUES ('".$contenant."', '".$lien['valeur']."')");
		}
	}

	return count($liens);
}

function afficher_liens($lien_interne)
{
	global $connect_id_auteur, $connect_statut;
	global $couleur_claire;

	$dbMetier = new BD_metier;
	$dbMetier->setDbParameters($GLOBALS['bd_params']);
	$db = $dbMetier->_getDB();

	// Y'a t'il des liens vers cet lment ?
    // contrib S Petit
    $nbLiens = $db->getOne("SELECT COUNT(*) AS nb FROM ".$GLOBALS['table_prefix']."_liens WHERE lien_interne = '".$lien_interne."'");
	//$nbLiens = $db->getOne("SELECT COUNT(*) nb FROM ".$GLOBALS['table_prefix']."_liens WHERE lien_interne = '".$lien_interne."'");
    // fin contrib 
	if ($nbLiens > 0) {
		// Affichage du cadre
		echo '<a name="liens" id="liens"></a>';
		echo debut_cadre_enfonce('liens-24.gif');
		echo '<table border="0" cellspacing="0" cellpadding="3" width="100%"><tr><td bgcolor="#EEEECC">';
		echo '<font size="2" face="Georgia,Garamond,Times,serif"><strong>'._T('liens_internes').'</strong></font>';
		echo aide('liens_internes');
		echo '</td></tr></table><br />';

		$typesLiens = array(
			'rub' => array(
				'table' => $GLOBALS['table_prefix'].'_rubriques',
				'key_field' => 'id_rubrique',
				'label_field' => 'titre',
				'label' => 'liens_depuis_rubriques',
				'url' => 'naviguer.php3?coll=%s'
			),
			'art' => array(
				'table' => $GLOBALS['table_prefix'].'_articles',
				'key_field' => 'id_article',
				'label_field' => 'titre',
				'label' => 'liens_depuis_articles',
				'url' => 'articles.php3?id_article=%s'
			),
			'bre' => array(
				'table' => $GLOBALS['table_prefix'].'_breves',
				'key_field' => 'id_breve',
				'label_field' => 'titre',
				'label' => 'liens_depuis_breves',
				'url' => 'breves_voir.php3?id_breve=%s'
			)
		);
		$ifond = 0;

		while (list($code, $data) = each($typesLiens)) {
			$result = $db->query("SELECT contenant FROM ".$GLOBALS['table_prefix']."_liens WHERE lien_interne = '".$lien_interne."' AND contenant LIKE '".$code."-%'");
			if ($result->numRows() > 0) {
				echo '<br /><font face="Verdana,Arial,Helvetica,sans-serif" size="2"><strong>'._T($data['label']).'&nbsp; </strong></font><br />';
				echo '<table border="0" cellspacing="0" cellpadding="3" width="100%">';
				while ($row = $result->fetchRow()) {
					ereg("-([0-9]+)$", $row['contenant'], $regs);
					$id_contenant = $regs[1];
                    
					// contrib S Petit
                    $titre = $db->getOne("SELECT ".$data['label_field']." AS titre FROM ".$data['table']." WHERE ".$data['key_field']." = ".$id_contenant);
                    //$titre = $db->getOne("SELECT ".$data['label_field']." titre FROM ".$data['table']." WHERE ".$data['key_field']." = ".$id_contenant);
                    // fin contrib 
					$ifond = $ifond ^ 1;
					$couleur = ($ifond) ? '#FFFFFF' : $couleur_claire;
					echo '<tr bgcolor="'.$couleur.'" width="100%">';
					echo '<td class="arial2"><a href="'.sprintf($data['url'], $id_contenant).'">'.$titre.'</a></td>';
					echo '</tr>';
				}
				echo '</table>';
			}
		}

		fin_cadre_enfonce();
	}
}
?>
