<?php
//
// Ce fichier ne sera execute qu'une fois
if (defined("_ECRIRE_INC_MOTS")) return;
define("_ECRIRE_INC_MOTS", "1");

/* Ajout Clever Age / Erwan LE BESCOND / Couche m�tier */
require_once ("PEAR.php");
require_once (dirname(__FILE__)."/include/bd/inc_groupe_mot_factory.php");
/* fin zone de modification Clever Age */

$GLOBALS['flag_mots_ressemblants'] = $GLOBALS['flag_levenshtein'];


function mots_ressemblants($mot, $table_mots, $table_ids='') {
	$lim = 2;
	$nb = 0;
	$opt = 1000000;
	$mot_opt = '';
	$mot = strtolower(trim($mot));
	$len = strlen($mot);

	if (!$table_mots) return '';

	while (!$nb AND $lim < 10) {
		reset($table_mots);
		if ($table_ids) reset($table_ids);
		while (list(, $val) = each($table_mots)) {
			if ($table_ids) list(, $id) = each($table_ids);
			else $id = $val;
			$val2 = trim($val);
			if ($val2) {
				if (!($m = $distance[$id])) {
					$val2 = strtolower($val2);
					$len2 = strlen($val2);
					if (substr($val2, 0, $len) == $mot) $m = -1;
					else if ($len2 > $len) $m = levenshtein($val2, $mot) + $len - $len2;
					else $m = levenshtein($val2, $mot);
					$distance[$id] = $m;
				}
				if ($m <= $lim) {
					$selection[$id] = $m;
					if ($m < $opt) {
						$opt = $m;
						$mot_opt = $val;
					}
					$nb++;
				}
			}
		}
		$lim += 2;
	}

	if (!$nb) return '';
	reset($selection);
	if ($opt != -1) {
		$moy = 1;
		while(list(, $val) = each($selection)) $moy *= $val;
		if($moy) $moy = pow($moy, 1.0/$nb);
		$lim = ($opt + $moy) / 2;
	}
	else $lim = -1;

	reset($selection);
	while (list($key, $val) = each($selection)) {
		if ($val <= $lim) {
			$result[] = $key;
		}
	}
	return $result;
}


/*
 * Affiche la liste des mots-cles associes a l'objet
 * specifie, plus le formulaire d'ajout de mot-cle
 */

function formulaire_mots($table, $id_objet, $nouv_mot, $supp_mot, $cherche_mot, $flag_editable, $id_javascript = 0) {
	global $flag_mots_ressemblants;
	global $connect_statut;
	global $connect_profil;
	global $spip_lang_rtl;
	global $delete_nodes;
    global $verif_granularite;
    global $id_table;



	$select_groupe = $GLOBALS['select_groupe'];
	if ($table == 'articles') {
		//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
        $authorization = &recuperer_instance_authorization('gererMotCleArticle', $GLOBALS['connect_id_auteur'], array('id_article' => $id_objet));
        if(!$authorization->isAuthorizedAction()) return;
        //----------------Fin Zone de modifications Clever Age elebescond@clever-age.com----------        
        $id_table = 'id_article';
		$url_base = "articles.php3?id_article=$id_objet";
	}
	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	// Mod par Johnny Muller
	else if ($table == 'articles_map') {
		//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
        $authorization = &recuperer_instance_authorization('gererMotCleArticle', $GLOBALS['connect_id_auteur'], array('id_article' => $id_objet));
        if(!$authorization->isAuthorizedAction()) return;
        //----------------Fin Zone de modifications Clever Age elebescond@clever-age.com----------        
        $id_table = 'id_article';
		$url_base = "mapping_articles.php3?id_article=$id_objet";
		$table = 'articles';
	}
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	else if ($table == 'breves') {
		$id_table = 'id_breve';
		$url_base = "breves_voir.php3?id_breve=$id_objet";
	}
	else if ($table == 'rubriques') {
		$id_table = 'id_rubrique';
		$url_base = "naviguer.php3?coll=$id_objet";
	}

	else if ($table == 'syndic') {
		$id_table = 'id_syndic';
		$url_base = "sites.php3?id_syndic=$id_objet";
	}
	else if ($table == 'visiteurs') {
		global $auteur_session;
		$id_table = 'id_auteur';
		//$url_base = "sites.php3?id_syndic=$id_objet";
		$auteurMetier = &recuperer_instance_auteur();
		$loadOK = $auteurMetier->load($auteur_session['id_auteur']);
		if (PEAR::isError($loadOK)) {
			die($loadOK->getMessage());			
		}
		$connect_profil = $auteurMetier->getProfil();
		//var_dump($connect_profil);
		$table = 'auteurs';
	}
	else if ($table == 'auteurs') {
		//----------------Zone de modifications Clever Age elebescond@clever-age.com----------
        $authorization = &recuperer_instance_authorization('gererMotCleAuteur', $GLOBALS['connect_id_auteur'], array('id_auteur' => $id_objet));
        //echo '===> ' . $GLOBALS['connect_id_auteur'];
        if(!$authorization->isAuthorizedAction()) return;
        //----------------Fin Zone de modifications Clever Age elebescond@clever-age.com----------        
		$id_table = 'id_auteur';
		$url_base = "auteurs_edit.php3?id_auteur=$id_objet";
	}
	//----------------Ajout Clever Age elebescond@clever-age.com----------
	else if ($table == 'cm_gabarit') {
		global $id_newsletter;
		$table = 'cm';
		$id_table = 'id_groupe';
		$url_base = "newsletter_admin_groups.php3?id_newsletter=$id_newsletter&id_groupe=$id_objet";
	}
	else if ($table == 'cm_specifique') {
		global $id_newsletter;
		global $id_post;
		$table = 'cm';
		$id_table = 'id_groupe';
		$url_base = "post_admin_groups.php3?id_post=$id_post&id_newsletter=$id_newsletter&id_groupe=$id_objet";
	}
	//-----------Fin ajout Clever Age ---------------
	
	if ($verif_granularite == 'oui') {
        include('verif_mot_granularite.php3');
        if (!$pas_changement_granularite) {
            unset($nouv_mot);
        }
    }
	
    $motMetier = &recuperer_instance_mot();
	$allMots = $motMetier->getAllFromMotsAndAnotherTable($table, $id_table, $id_objet);
	if(PEAR::isError($allMots)) {
		die($allMots->getMessage());
	}
	
	
	/**
	 * Gestion du brouteur de mots clefs
	 */
	 //echo "aurelien";
	 //return;
	
	
	
	
	
	$nombre_mots = sizeOf($allMots);
	/*
    $query = "SELECT mots.* FROM spip_mots AS mots, spip_mots_$table AS lien WHERE lien.$id_table=$id_objet AND mots.id_mot=lien.id_mot";
	$nombre_mots = spip_num_rows(spip_query($query));
	*/
    //--------Fin de zone de modification----------------------
	
	//-----------Zone de modification Clever Age ---------------
    $groupeMotMetier = &recuperer_instance_groupe_mot();
	$allGroupeMot = $groupeMotMetier->getAllForTableAndProfil($table, "'oui'", $connect_profil);
	if(PEAR::isError($allGroupeMot)) {
	    die($allGroupeMot->getMessage());
	}
	
	$nombre_groupes = sizeOf($allGroupeMot);
    /*
    $query_groupes = "SELECT * FROM spip_groupes_mots WHERE $table = 'oui' AND $connect_statut = 'oui'";
	$nombre_groupes = spip_num_rows(spip_query($query_groupes));
	*/
    //--------Fin de zone de modification----------------------

	if (!$nombre_mots AND (!$nombre_groupes OR !$flag_editable)) return;

        echo "<a name='mots'></a>";
	    debut_cadre_enfonce("mot-cle-24.gif");	
	
	    echo "<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=3 WIDTH=100% BACKGROUND=''><TR><TD BGCOLOR='#EEEECC'>";
	    if ($flag_editable){
    		if ($nouv_mot.$cherche_mot.$supp_mot)
			    echo bouton_block_visible("lesmots".$id_javascript);
		    else
	    		echo bouton_block_invisible("lesmots".$id_javascript);
        }
    	echo "<B>"._T('titre_mots_cles')."</B>";
    	echo aide ("artmots");
    	echo "</td></tr></TABLE>";

    	//////////////////////////////////////////////////////
    	// Recherche de mot-cle
    	//
    	if ($nouv_mot)
    		$nouveaux_mots[] = $nouv_mot;

    	$tous_les_mots = split(" *[,;] *", $cherche_mot);
    	while ((list(,$cherche_mot) = each ($tous_les_mots)) AND $cherche_mot) {
    		echo "<P ALIGN='left'>";
    		//-----------Zone de modification Clever Age ---------------
            $motMetier = &recuperer_instance_mot();
            $allMots = $motMetier->getAllMotsForGroupeId($select_groupe);
    	    if(PEAR::isError($allMots)) {
    	        die($allMots->getmesage());
            }
    	    unset($table_mots);
    		unset($table_ids);
    	    while (list(,$motMetier) = each($allMots)) {
    	        $table_ids[] = $motMetier->getMotId();
    			$table_mots[] = $motMetier->getTitre();
            }
    		/*
    		$query = "SELECT id_mot, titre FROM spip_mots WHERE id_groupe='$select_groupe'";
    		$result = spip_query($query);
    		unset($table_mots);
    		unset($table_ids);
    		while ($row = spip_fetch_array($result)) {
    			$table_ids[] = $row['id_mot'];
    			$table_mots[] = $row['titre'];
    		}
    		*/
    		//-----------Fin Zone de modification Clever Age ---------------
		
    		$resultat = mots_ressemblants($cherche_mot, $table_mots, $table_ids);
    		debut_boite_info();
    		if (!$resultat) {
    			echo "<B>"._T('info_non_resultat', array('cherche_mot' => $cherche_mot))."</B><BR>";
    		}
    		else if (count($resultat) == 1) {
    			list(, $nouv_mot) = each($resultat);
    			$nouveaux_mots[] = $nouv_mot;
    			echo "<B>"._T('info_mot_cle_ajoute')." ";
    			if ($table == 'articles') echo _T('info_l_article');
    			else if ($table == 'breves') echo _T('info_la_breve');
    			else if ($table == 'rubriques') echo _T('info_la_rubrique');
    			echo " : </B><BR>";
                //----------Modification Clever Age elebescond----------
                $motMetier = &recuperer_instance_mot();
                $loadOK = $motMetier->load($nouv_mot);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
    	        echo "<UL>";
    	        if(PEAR::isError($loadOK)) {
    	            die($loadOK->getMessage());
                }
    	        else {
        	        $id_mot = $motMetier->getMotId();
                    $titre_mot = $motMetier->getTitre();
    	            $type_mot = $motMetier->getType();
        	        $descriptif_mot = $motMetier->getDescriptif();
    
    				echo "<LI><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B><FONT SIZE=3>$titre_mot</FONT></B>";
    				echo "</FONT>\n";
                }
    	        /*
    			$query = "SELECT * FROM spip_mots WHERE id_mot=$nouv_mot";
    			$result = spip_query($query);
    			echo "<UL>";
    			while ($row = spip_fetch_array($result)) {
    				$id_mot = $row['id_mot'];
    				$titre_mot = $row['titre'];
    				$type_mot = $row['type'];
    				$descriptif_mot = $row['descriptif'];
    
    				echo "<LI><FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B><FONT SIZE=3>$titre_mot</FONT></B>";
    				echo "</FONT>\n";
    			}
                */
                //---------- Fin Modification Clever Age elebescond----------
                echo "</UL>";
            }
    		else if (count($resultat) < 16) {
    			reset($resultat);
    			unset($les_mots);
    			while (list(, $id_mot) = each($resultat)) $les_mots[] = $id_mot;
    			if ($les_mots) {
    				$les_mots = join(',', $les_mots);
    				echo "<B>"._T('info_plusieurs_mots_trouves', array('cherche_mot' => $cherche_mot))."</B><BR>";
                    
                    //-----------Zone de modification Clever Age ---------------
                    $motMetier = &recuperer_instance_mot();
    	            $allMots = $motMetier->getAllMotsForMotId($les_mots,"titre");
                    if(PEAR::isError($allMots)) {
    	                die($allMots->getmesage());
                    }
    	            echo "<UL>";
    	            while (list(,$motMetier) = each($allMots)) {
    	                $id_mot = $motMetier->getMotId();
    				    $titre_mot = $motMetier->getTitre();
    				    $type_mot = $motMetier->getType();
    				    $descriptif_mot = $motMetier->getDescriptif();
    				    echo "<LI><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B><FONT SIZE=3>$titre_mot</FONT></B>";
    
    					if ($type_mot) echo " ($type_mot)";
    					echo " | <A HREF=\"$url_base&nouv_mot=$id_mot\">"._T('info_ajouter_mot')."</A>";
    
    					if (strlen($descriptif_mot) > 1) {
                            echo "<BR><FONT SIZE=1>".propre(couper($descriptif_mot, 100))."</FONT>\n";
                        }
    					echo "</FONT><p>\n";
                    }
    	            echo "</UL>";
                    /*
    				$query = "SELECT * FROM spip_mots WHERE id_mot IN ($les_mots) ORDER BY titre";
    				$result = spip_query($query);
    				echo "<UL>";
    				while ($row = spip_fetch_array($result)) {
    					$id_mot = $row['id_mot'];
    					$titre_mot = $row['titre'];
    					$type_mot = $row['type'];
    					$descriptif_mot = $row['descriptif'];
    
    					echo "<LI><FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B><FONT SIZE=3>$titre_mot</FONT></B>";
    
    					if ($type_mot) echo " ($type_mot)";
    					echo " | <A HREF=\"$url_base&nouv_mot=$id_mot\">"._T('info_ajouter_mot')."</A>";
    
    					if (strlen($descriptif_mot) > 1) {
    						echo "<BR><FONT SIZE=1>".propre(couper($descriptif_mot, 100))."</FONT>\n";
    					}
    					echo "</FONT><p>\n";
    				}
    				echo "</UL>";
                    */
                    //--------Fin de zone de modification----------------------
    			}
    		}
    		else {
    		    echo "<B>"._T('info_trop_resultat', array('cherche_mot' => $cherche_mot))."<BR>";
            }
    		fin_boite_info();
    		echo "<P>";
    
    	}
    
    
    	//////////////////////////////////////////////////////
    	// Appliquer les modifications sur les mots-cles
    	//
    
        if ($delete_nodes && $flag_editable) {
            $motMetier = &recuperer_instance_mot();
    	    $unlinkMots = explode(',', $delete_nodes);
    	    while (list(, $motId) = each($unlinkMots)) {
                $deletMotTableOK = $motMetier->deleteMotTable($table, $id_table, $id_objet, $motId);
                if(PEAR::isError($deletMotTableOK)) {
                    die($deletMotTableOK->getMessage());
                }
            }
        }

    	if ($nouveaux_mots && $flag_editable) {
    		while ((list(,$nouv_mot) = each($nouveaux_mots)) AND $nouv_mot!='x') {
    			/**************** Modification elebescond@clever-age.com ********************/
    			$motMetier = &recuperer_instance_mot();
                $monBoolean = $motMetier->exist($table, $id_table, $nouv_mot, $id_objet);
                if(PEAR::isError($monBoolean)) {
                    die($monBoolean->getMessage());
                }
                if ($monBoolean == false) {
    			    $motMetier = &recuperer_instance_mot();
                    $addMotOK = $motMetier->addMot($table, $id_table, $nouv_mot, $id_objet);
                    if(PEAR::isError($addMotOK)) {
                        die($addMotOK->getMessage());
                    }
    			}
                /*
			    $query = "SELECT * FROM spip_mots_$table WHERE id_mot=$nouv_mot AND $id_table=$id_objet";
		        $result = spip_query($query);
		        if (!spip_num_rows($result)) {
    				$query = "INSERT INTO spip_mots_$table (id_mot,$id_table) VALUES ($nouv_mot, $id_objet)";
			        $result = spip_query($query);
		        }
			    */
    			/**************** Fin modification elebescond@clever-age.com ********************/
            }
        }

    	if ($supp_mot && $flag_editable) {
            //-----------Zone de modification Clever Age elebescond---------------
            $motMetier = &recuperer_instance_mot();
            $deleteMotTableOK = $motMetier->deleteMotTable($table, $id_table, $id_objet, $supp_mot);
            if(PEAR::isError($deleteMotTableOK)) {
                die($deleteMotTableOK->getMessage());
            }
            /*
            if ($supp_mot == -1)
    			$mots_supp = "";
    		else
    			$mots_supp = " AND id_mot=$supp_mot";
            $query = "DELETE FROM spip_mots_$table WHERE $id_table=$id_objet $mots_supp";
    		$result = spip_query($query);
        	*/
            //--------Fin de zone de modification----------------------
        }

    	//
    	// Afficher les mots-cles
    	//
    
        //-----------Zone de modification elebescond@clever-age.com ---------------
        $motMetier = &recuperer_instance_mot();
    	$types = $motMetier->getAllTypes();
        if(PEAR::isError($types)) {
            die($types->getMessage());
        }
        $plusieurs_types = (sizeOf($types) > 1);
        
    	unset($les_mots);
    
        
    	$motMetier = &recuperer_instance_mot();
        $allMots = $motMetier->getAllFromMotsAndAnotherTable($table, $id_table, $id_objet, true);
        if(PEAR::isError($allMots)) {
            die($allMots->getMessage());
        }        
    	echo "<table border=0 cellspacing=0 cellpadding=2 width=100% background=''>";
    
    	$ifond=0;    
        while (list(,$motMetier) = each($allMots)) {
            $id_mot = $motMetier->getMotId();
    		//Modification pour prise en compte arborescence de mot cl�
    		//On affiche le chemin du mot cl� en cours...
            $titre_mot = $motMetier->getTitre();
    		$chemin_mot = $motMetier->getCheminMot();
            $type_mot = $motMetier->getType();
    		$descriptif_mot = $motMetier->getDescriptif();
    		$id_groupe = $motMetier->getGroupeId();
    		
            $groupeMotMetier = &recuperer_instance_groupe_mot();
            $loadOK = $groupeMotMetier->load($id_groupe);
            
            if(PEAR::isError($loadOK)) {
                die($loadOK->getMessage());
            }
            else {
                $id_groupe = $groupeMotMetier->getGroupeId();
                $titre_groupe = entites_html($groupeMotMetier->getTitre());
                $unseul = $groupeMotMetier->getUnSeul();
                $obligatoire = $groupeMotMetier->getObligatoire();
                $profilMetier = &recuperer_instance_profil();
                $monProfilComite = $profilMetier->getProfilForIntitule('item_redacteur_en_chef');
                $monProfilMinirezo = $profilMetier->getProfilForIntitule('item_webmestre');                
                
                $flag_groupe = ($flag_editable AND $groupeMotMetier->isManagedByProfil($connect_profil));
            }
            
            $groupes_vus[$id_groupe] = true;
    		$id_groupes_vus[] = $id_groupe;
    
    		if ($ifond==0){
    			$ifond=1;
    			$couleur="#FFFFFF";
    		}else{
    			$ifond=0;
    			$couleur="#EDF3FE";
    		}
    
    		$url = "mots_edit.php3?id_mot=$id_mot&redirect=".rawurlencode($url_base.'#mots');
    
    		echo "<TR WIDTH=\"100%\">";
    		echo "<TD BGCOLOR='$couleur'>";
    		echo "<A HREF='$url'><img src='img_pack/petite-cle.gif' alt='' width='23' height='12' border='0'></A>";
    		echo "</TD>";
    		echo "<TD BGCOLOR='$couleur' width='100%' CLASS='arial2'>";	
    	    
    		// Changer
            // ICI CHOIX D'UN MOT CLE UNIQUE D'UN GROUPE AVEC UN MOT DEJA AFFECTE DU GROUPE		
    		if ($unseul == "oui" AND $flag_groupe) {
    			echo "<form action='$url_base#mots' method='post' style='margin:0px; padding: 0px'>";
    			echo "<INPUT TYPE='Hidden' NAME='$id_table' VALUE='$id_objet'>";
    			if ($table == 'rubriques') echo "<INPUT TYPE='Hidden' NAME='coll' VALUE='$id_objet'>";
    			if ($table == 'cm') {
    			    global $id_newsletter;
    				echo "<INPUT TYPE='Hidden' NAME='id_newsletter' VALUE='$id_newsletter'>";
    				global $id_post;
    				echo "<INPUT TYPE='Hidden' NAME='id_post' VALUE='$id_post'>";
                }
                echo "<select name='nouv_mot' CLASS='fondl' STYLE='font-size:10px; width:150px'>";
    
                $groupeMotMetier2 = &recuperer_instance_groupe_mot();
                $groupeMotMetier2->setGroupeId($id_groupe);
                $offset = '&nbsp;&nbsp;';
                $rootNodes = &$groupeMotMetier2->getMotArbre();
    			
    			while (list(, $rootNode) = each ($rootNodes)) {
                    while (list(, $node) = each($rootNode)) {
                        $le_mot = $node->id;
    			        $le_titre_mot = $node->name;
    			        for ($i = 1; $i < $node->level; $i++) {
    			            $le_titre_mot = $offset.$le_titre_mot;
    			        }
    			        if ($le_mot == $id_mot) $selected = "SELECTED";
    					else $selected = "";
    					echo "<option value='$le_mot' $selected> $le_titre_mot";
                    }
                }
    			echo "</select>";
    			echo "<INPUT TYPE='Hidden' NAME='supp_mot' VALUE='$id_mot'>";
    			echo "<INPUT TYPE='submit' NAME='Choisir' VALUE='"._T('bouton_changer')."' CLASS='fondo' style='font-size: 10px';>";
    			echo "</form>";
    		} else {
    			echo "$chemin_mot<A HREF='$url'>$titre_mot</A>";    			
    		}
    		echo "</TD>";
    
    		echo "<TD ALIGN='right' BGCOLOR='$couleur' ALIGN='right' CLASS='arial2'>";
    		echo "$type_mot";
    		echo "</TD>";
    
    		if ($flag_editable){
    			echo "<TD BGCOLOR='$couleur' ALIGN='right' CLASS='arial1'>";
    			if ($flag_groupe)
    				echo "<A HREF=\"$url_base&supp_mot=$id_mot#mots\">"._T('info_retirer_mot')."&nbsp;<img src='img_pack/croix-rouge.gif' alt='X' width='7' height='7' border='0' align='middle'></A>";
    			else echo "&nbsp;";
    			echo "</TD>";
    		}
    		echo "</TR>\n";
    
    		$les_mots[] = $id_mot;
        }
    

        echo "<tr><td></td><td></td><td><img src='img_pack/rien.gif' width=100 height=1></td><td><img src='img_pack/rien.gif' width=90 height=1></td></tr>";
    	echo "</TABLE>";
    
    	/**
    	 * Gestion du brouteur de mots cles
    	 */
    	
    	$nb_mots_meta = lire_meta('_nb_limite_kw_selecteur');
    	$motMetier = &recuperer_instance_mot();
    	$nombre_mots_affectables = $motMetier->howManyMotForType($table);
    	if (PEAR::isError($nombre_mots_affectables)) {
    		die($nombre_mots_affectables->getMessage());
    	}
    	if ($nb_mots_meta < $nombre_mots_affectables) { 
    		$form_mot = "<FORM ACTION='".$_SERVER['PHP_SELF']."' METHOD='get' STYLE='margin:1px;' name='affectationBrouteur'>"
            ."<input type='HIDDEN' name='coll' value='".$_GET['coll']."' >" 
						."<input type='hidden' name='url_post_check' value='$url'>"
            ."<input type='hidden' name='verif_granularite' value='oui'>"
            ."<input type='hidden' name='table' value='$table'>"
            ."<input type='hidden' name='id_table' value='$id_table'>"
            ."<input type='hidden' name='id_objet' value='$id_objet'>"
            ."<input type='hidden' name='$id_table' value='$id_objet'>"
            ."<input type='hidden' name='nouv_mot' value=''>"
			."<input type='hidden' name='Choisir' value='Choisir'>"
            ."</FORM>";
            echo $form_mot;
            echo "<a href=\"#\" onclick=\"window.open('brouteur_select_mot.php3?table=".$table."')\">" . _T('utiliser_brouteur_mots_cles') . "</a>";
			
    		// nouv_mot
    		
    		echo fin_block();
    		fin_cadre_enfonce();
			return;
    	}
		/**
		 * Fin de Gestion du brouteur de mot cles
		 */
    
    
    	if ($les_mots) {
            $nombre_mots_associes = count($les_mots);
            $les_mots_array = $les_mots;
            $les_mots = join($les_mots, ",");
    	}
    	if ($id_groupes_vus) $id_groupes_vus = join($id_groupes_vus, ",");
    	else $id_groupes_vus = "0";	    
            
        $groupeMotMetier = &recuperer_instance_groupe_mot();
        $allGroupeMot = $groupeMotMetier->getAllForTableAndStatutAndObligatoryAndIdGroupe($table, "'oui'", $connect_profil, "'oui'", $id_groupes_vus);
    	if(PEAR::isError($allGroupeMot)) {
            die($allGroupeMot->getMessage());
        }
    	$nb_groupes = sizeOf($allGroupeMot);


	//
	// Afficher le formulaire d'ajout de mots-cles
	//

    	if ($flag_editable) {
    		if ($nouveaux_mots.$cherche_mot.$supp_mot)
    			echo debut_block_visible("lesmots".$id_javascript);
    		else if ($nb_groupes > 0) {
    			echo debut_block_visible("lesmots".$id_javascript);
                // vilain hack pour redresser un triangle
                $couche_a_redresser = $GLOBALS['numero_block']['lesmots'.$id_javascript];
                if (test_layer()) echo "<script type='text/javascript'><!--
                triangle = MM_findObj('triangle' + $couche_a_redresser);
                if (triangle) triangle.src = 'img_pack/deplierbas$spip_lang_rtl.gif';
                //--></script>";
    		}
    		else
    			echo debut_block_invisible("lesmots".$id_javascript);

            // un menu par type de mot : mais une seule case "recherche"
            if ($table == 'articles') $url = 'articles.php3';
            else if ($table == 'breves') $url = 'breves_voir.php3';
            else if ($table == 'rubriques') $url = 'naviguer.php3';
            else if ($table == 'auteurs') $url = 'auteurs_edit.php3';
            $case_recherche = false;

            // Choix du mot cl� d'un groupe pour ajout
    
            //Modification Clever Age aangenieux
            //Passage par une page interm�diaire pour v�rification pas de changement de granularit�
            /********** Modification elebescond@clever-age.com ********/
            $form_mot = "<FORM ACTION='$url_base' METHOD='get' STYLE='margin:1px;'>"
                ."<input type='hidden' name='url_post_check' value='$url'>"
                ."<input type='hidden' name='verif_granularite' value='oui'>"
                ."<input type='hidden' name='table' value='$table'>"
                ."<input type='hidden' name='id_table' value='$id_table'>"
                ."<input type='hidden' name='id_objet' value='$id_objet'>"
                ."<input type='hidden' name='$id_table' value='$id_objet'>";
            /*
    		$form_mot = "<FORM ACTION='$url_base#mots' METHOD='post' STYLE='margin:1px;'>"
    			."<INPUT TYPE='Hidden' NAME='$id_table' VALUE='$id_objet'>";
    		*/
    		/********** Fin modification elebescond@clever-age.com ********/
    			                
            if ($table == 'rubriques') $form_mot .= "<INPUT TYPE='Hidden' NAME='coll' VALUE='$id_objet'>";
            if ($table == 'cm') {
    		    global $id_newsletter;
                $form_mot .= "<INPUT TYPE='Hidden' NAME='id_newsletter' VALUE='$id_newsletter'>";
                global $id_post;
                $form_mot .= "<INPUT TYPE='Hidden' NAME='id_post' VALUE='$id_post'>";
            }			
			
            $message_ajouter_mot = "<FONT FACE='Verdana,Arial,Helvetica,sans-serif' SIZE=2><B>"._T('titre_ajouter_mot_cle')." &nbsp; </B></FONT>\n";
            echo "<DIV align='right'>";

    		//////
    
    		if ($nombre_mots_associes > 3) {
    			echo "<div align='right' class='arial1'>";
    			echo "<a href=\"$url_base&supp_mot=-1#mots\">"._T('info_retirer_mots')."</a>";
    			echo "</div><br />\n";
    		}
    

    
    		if ($table == 'rubriques') $form_mot .= "<INPUT TYPE='Hidden' NAME='coll' VALUE='$id_objet'>";
    
    		$message_ajouter_mot = "<FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B>"._T('titre_ajouter_mot_cle')."</B></FONT> &nbsp;\n";
    		echo "<table border='0' align='right' style='white-space: nowrap'>";
    		
        $groupeMotMetier = &recuperer_instance_groupe_mot();
	    $allGroupeMot = $groupeMotMetier->getAllForTableAndStatutAndUnSeulAndIdGroupe($table, "'oui'", $connect_profil, "'oui'", $id_groupes_vus);
        if(PEAR::isError($allGroupeMot)) {
            die($allGroupeMot->getMessage());
	    }

		// Afficher un menu par groupe de mots

        while(list(,$groupeMotMetier) = each($allGroupeMot)) {
			$id_groupe = $groupeMotMetier->getGroupeId();
			$titre_groupe = entites_html($groupeMotMetier->getTitre());
			$unseul = $groupeMotMetier->getUnSeul();
			$obligatoire = $groupeMotMetier->getObligatoire();
			$articles = $groupeMotMetier->getArticles();
			$breves = $groupeMotMetier->getBreves();
			$rubriques = $groupeMotMetier->getRubriques();
			$syndic = $groupeMotMetier->getSyndic();
			//$acces_minirezo = $groupeMotMetier->getminirezo();
			//$acces_comite = $groupeMotMetier->getcomite();
			//$acces_forum = $groupeMotMetier->getforum();
		    
		    $motMetier = &recuperer_instance_mot();	        
	        $mots = $motMetier->getAllForGroupIdAndMotId($id_groupe, $les_mots);
       	
            if(PEAR::isError($mots)) {
                die($mots->getMessage());
            }
            
            if (sizeOf($mots) > 0) {
				if (sizeOf($mots) > 50 AND $flag_mots_ressemblants) {
    				echo "\n<tr>";
	    			echo $form_mot;
		    		echo "\n<td>";
			    	echo $message_ajouter_mot;
				   	$message_ajouter_mot = "";
    				echo "</td>\n<td>";
    	    	
    	    		if ($obligatoire == "oui" AND !$groupes_vus[$id_groupe])
		    			echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; background-color:#E86519;' VALUE=\"$titre_groupe\" SIZE='20'>";
				    else if ($unseul == "oui")
    					echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; background-color:#cccccc;' VALUE=\"$titre_groupe\" SIZE='20'>";
				    else
    					echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; ' VALUE=\"$titre_groupe\" SIZE='20'>";
				    
				    echo "</td>\n<td>";
				    echo "<INPUT TYPE='hidden' NAME='select_groupe'  VALUE='$id_groupe'>";
    			    
    			    echo " <INPUT TYPE='submit' NAME='Chercher' VALUE='"._T('bouton_chercher')."' CLASS='fondo' STYLE='font-size:10px'>";
				    echo "</td></FORM>";
				    echo "</tr>";
                }
				else {
				    echo "\n<tr>";
					echo "\n<td>";
					echo $form_mot;
					echo $message_ajouter_mot;
					$message_ajouter_mot = "";
					echo "</td>\n<td>";
                    if ($obligatoire == "oui" AND !$groupes_vus[$id_groupe])
		    		    echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; background-color:#E86519;' CLASS='fondl'>";
                    else if ($unseul == "oui")
				        echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; background-color:#cccccc;' CLASS='fondl'>";
                    else
    				    echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; ' CLASS='fondl'>";
    
                    $ifond == 0;
					echo "<OPTION VALUE='x' style='font-variant: small-caps;'>$titre_groupe";
					//Gestion arbo
                    $offset = '&nbsp;&nbsp;';
                    $rootNodes = &$groupeMotMetier->getMotArbre();
                    //$les_mots_exclus = $motMetier->getBranch($les_mots_array);

                    while (list(, $rootNode) = each ($rootNodes)) {
                        while (list(, $node) = each($rootNode)) {
                            $id_mot = $node->id;
    					    $titre_mot = $node->name;
    					    $texte_option = entites_html(couper($titre_mot.' ', 50));    					        
                            for ($i = 1; $i < $node->level; $i++) {
                                $texte_option = $offset.$texte_option;
                            }
    						echo "\n<OPTION VALUE=\"$id_mot\">";
    						echo "&nbsp;&nbsp;&nbsp;";
    						echo $texte_option;
                        }
                    }
					echo "</SELECT>";
                    echo "</td>\n<td>";
					echo " &nbsp; <INPUT TYPE='submit' NAME='Choisir' VALUE='"._T('bouton_choisir')."' CLASS='fondo'>";
					echo "</td></FORM>";
					echo "</tr>";
                }
            }
        }

		echo "</table>";
		echo fin_block();
	}
	/*
    $query = "SELECT DISTINCT type FROM spip_mots";
	$result = spip_query($query);
	$plusieurs_types = (spip_num_rows($result) > 1);

	unset($les_mots);

	$query = "SELECT mots.* FROM spip_mots AS mots, spip_mots_$table AS lien WHERE lien.$id_table=$id_objet AND mots.id_mot=lien.id_mot ORDER BY mots.type, mots.titre";
	$result = spip_query($query);

	echo "<table border=0 cellspacing=0 cellpadding=2 width=100% background=''>";

	$ifond=0;

	while ($row = spip_fetch_array($result)) {
		$id_mot = $row['id_mot'];
		$titre_mot = $row['titre'];
		$type_mot = $row['type'];
		$descriptif_mot = $row['descriptif'];
		$id_groupe = $row['id_groupe'];

		$query_groupe = "SELECT * FROM spip_groupes_mots WHERE id_groupe = $id_groupe";
		$result_groupe = spip_query($query_groupe);
		while($row_groupe = spip_fetch_array($result_groupe)) {
			$id_groupe = $row_groupe['id_groupe'];
			$titre_groupe = entites_html($row_groupe['titre']);
			$unseul = $row_groupe['unseul'];
			$obligatoire = $row_groupe['obligatoire'];
			$acces_admin =  $row_groupe['0minirezo'];
			$acces_redacteur = $row_groupe['1comite'];

			$flag_groupe = ($flag_editable AND (($connect_statut == '1comite' AND $acces_redacteur == 'oui') OR ($connect_statut == '0minirezo' AND $acces_admin == 'oui')));
		}

		$groupes_vus[$id_groupe] = true;
		$id_groupes_vus[] = $id_groupe;

		if ($ifond==0){
			$ifond=1;
			$couleur="#FFFFFF";
		}else{
			$ifond=0;
			$couleur="#EDF3FE";
		}

		$url = "mots_edit.php3?id_mot=$id_mot&redirect=".rawurlencode($url_base.'#mots');

		echo "<TR WIDTH=\"100%\">";
		echo "<TD BGCOLOR='$couleur'>";
		echo "<A HREF='$url'><img src='img_pack/petite-cle.gif' alt='' width='23' height='12' border='0'></A>";
		echo "</TD>";
		echo "<TD BGCOLOR='$couleur' width='100%' CLASS='arial2'>";


		// Changer
		if ($unseul == "oui" AND $flag_groupe) {
			echo "<form action='$url_base#mots' method='post' style='margin:0px; padding: 0px'>";
			echo "<INPUT TYPE='Hidden' NAME='$id_table' VALUE='$id_objet'>";
			if ($table == 'rubriques') echo "<INPUT TYPE='Hidden' NAME='coll' VALUE='$id_objet'>";
			echo "<select name='nouv_mot' CLASS='fondl' STYLE='font-size:10px; width:90px;'>";

			$query_autres_mots = "SELECT * FROM spip_mots WHERE id_groupe = $id_groupe";
			$result_autres_mots = spip_query($query_autres_mots);
			while ($row_autres = spip_fetch_array($result_autres_mots)) {
				$le_mot = $row_autres['id_mot'];
				$le_titre_mot = $row_autres['titre'];

				if ($le_mot == $id_mot) $selected = "SELECTED";
				else $selected = "";
				echo "<option value='$le_mot' $selected> $le_titre_mot";
			}
			echo "</select>";
			echo "<INPUT TYPE='Hidden' NAME='supp_mot' VALUE='$id_mot'>";
			echo " &nbsp; <INPUT TYPE='submit' NAME='Choisir' VALUE='"._T('bouton_changer')."' CLASS='fondo' style='font-size: 10px';>";
			echo "</form>";

		} else {
			echo "<A HREF='$url'>$titre_mot</A>";
		}
		echo "</TD>";

		echo "<TD ALIGN='right' BGCOLOR='$couleur' ALIGN='right' CLASS='arial2'>";
		echo "$type_mot";
		echo "</TD>";

		if ($flag_editable){
			echo "<TD BGCOLOR='$couleur' ALIGN='right' CLASS='arial1'>";
			if ($flag_groupe)
				echo "<A HREF=\"$url_base&supp_mot=$id_mot#mots\">"._T('info_retirer_mot')."&nbsp;<img src='img_pack/croix-rouge.gif' alt='X' width='7' height='7' border='0' align='middle'></A>";
			else echo "&nbsp;";
			echo "</TD>";
		}
		echo "</TR>\n";

		$les_mots[] = $id_mot;
	}
	
	echo "<tr><td></td><td></td><td><img src='img_pack/rien.gif' width=100 height=1></td><td><img src='img_pack/rien.gif' width=90 height=1></td></tr>";
	echo "</TABLE>";

	if ($les_mots) {
		$nombre_mots_associes = count($les_mots);
		$les_mots = join($les_mots, ",");
	}
	if ($id_groupes_vus) $id_groupes_vus = join($id_groupes_vus, ",");
	else $id_groupes_vus = "0";

	$query_groupes = "SELECT * FROM spip_groupes_mots WHERE $table = 'oui' AND $connect_statut = 'oui' AND obligatoire = 'oui' AND id_groupe NOT IN ($id_groupes_vus)";
	$nb_groupes = spip_num_rows(spip_query($query_groupes));

	//
	// Afficher le formulaire d'ajout de mots-cles
	//

	if ($flag_editable) {
		if ($nouveaux_mots.$cherche_mot.$supp_mot)
			echo debut_block_visible("lesmots");
		else if ($nb_groupes > 0) {
			echo debut_block_visible("lesmots");
			// vilain hack pour redresser un triangle
			$couche_a_redresser = $GLOBALS['numero_block']['lesmots'];
			if (test_layer()) echo "<script type='text/javascript'><!--
			triangle = MM_findObj('triangle' + $couche_a_redresser);
			if (triangle) triangle.src = 'img_pack/deplierbas$spip_lang_rtl.gif';
			//--></script>";
		}
		else
			echo debut_block_invisible("lesmots");

		if ($nombre_mots_associes > 3) {
			echo "<div align='right' class='arial1'>";
			echo "<a href=\"$url_base&supp_mot=-1#mots\">"._T('info_retirer_mots')."</a>";
			echo "</div><br />\n";
		}

		$form_mot = "<FORM ACTION='$url_base#mots' METHOD='post' STYLE='margin:1px;'>"
			."<INPUT TYPE='Hidden' NAME='$id_table' VALUE='$id_objet'>";

		if ($table == 'rubriques') $form_mot .= "<INPUT TYPE='Hidden' NAME='coll' VALUE='$id_objet'>";

		$message_ajouter_mot = "<FONT FACE='Verdana,Arial,Sans,sans-serif' SIZE=2><B>"._T('titre_ajouter_mot_cle')."</B></FONT> &nbsp;\n";
		echo "<table border='0' align='right' style='white-space: nowrap'>";

		$query_groupes = "SELECT * FROM spip_groupes_mots WHERE $table = 'oui' AND $connect_statut = 'oui' AND (unseul != 'oui'  OR (unseul = 'oui' AND id_groupe NOT IN ($id_groupes_vus))) ORDER BY titre";
		$result_groupes = spip_query($query_groupes);

		// Afficher un menu par groupe de mots

		while ($row_groupes = spip_fetch_array($result_groupes)) {
			$id_groupe = $row_groupes['id_groupe'];
			$titre_groupe = entites_html($row_groupes['titre']);
			$unseul = $row_groupes['unseul'];
			$obligatoire = $row_groupes['obligatoire'];
			$articles = $row_groupes['articles'];
			$breves = $row_groupes['breves'];
			$rubriques = $row_groupes['rubriques'];
			$syndic = $row_groupes['syndic'];
			$acces_minirezo = $row_groupes['0minirezo'];
			$acces_comite = $row_groupes['1comite'];
			$acces_forum = $row_groupes['6forum'];

			$query = "SELECT * FROM spip_mots WHERE id_groupe = '$id_groupe' ";
			if ($les_mots) $query .= "AND id_mot NOT IN ($les_mots) ";
			$query .= "ORDER BY type, titre";
			$result = spip_query($query);
			if (spip_num_rows($result) > 0) {
				if ((spip_num_rows($result) > 50 AND $flag_mots_ressemblants)) {
					echo "\n<tr>";
					echo $form_mot;
					echo "\n<td>";
					echo $message_ajouter_mot;
					$message_ajouter_mot = "";
					echo "</td>\n<td>";

					if ($obligatoire == "oui" AND !$groupes_vus[$id_groupe])
						echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; background-color:#E86519;' VALUE=\"$titre_groupe\" SIZE='20'>";
					else if ($unseul == "oui")
						echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; background-color:#cccccc;' VALUE=\"$titre_groupe\" SIZE='20'>";
					else
						echo "<INPUT TYPE='text' NAME='cherche_mot' CLASS='fondl' STYLE='width: 180px; ' VALUE=\"$titre_groupe\" SIZE='20'>";

					echo "</td>\n<td>";
					echo "<INPUT TYPE='hidden' NAME='select_groupe'  VALUE='$id_groupe'>";

					echo " <INPUT TYPE='submit' NAME='Chercher' VALUE='"._T('bouton_chercher')."' CLASS='fondo' STYLE='font-size:10px'>";
					echo "</td></FORM>";
					echo "</tr>";
				}
				else {
					echo "\n<tr>";
					echo $form_mot;
					echo "\n<td>";
					echo $message_ajouter_mot;
					$message_ajouter_mot = "";
					echo "</td>\n<td>";

					if ($obligatoire == "oui" AND !$groupes_vus[$id_groupe])
						echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; background-color:#E86519;' CLASS='fondl'>";
					else if ($unseul == "oui")
						echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; background-color:#cccccc;' CLASS='fondl'>";
					else
						echo "<SELECT NAME='nouv_mot' SIZE='1' STYLE='width: 180px; ' CLASS='fondl'>";

					$ifond == 0;
					echo "<OPTION VALUE='x' style='font-variant: small-caps;'>$titre_groupe";
					while($row = spip_fetch_array($result)) {
						$id_mot = $row['id_mot'];
						$titre_mot = $row['titre'];
						$texte_option = entites_html($titre_mot);
						echo "\n<OPTION VALUE=\"$id_mot\">";
						echo "&nbsp;&nbsp;&nbsp;";
						echo $texte_option;
					}
					echo "</SELECT>";
					echo "</td>\n<td>";
					echo " &nbsp; <INPUT TYPE='submit' NAME='Choisir' VALUE='"._T('bouton_choisir')."' CLASS='fondo'>";
					echo "</td></FORM>";
					echo "</tr>";
				}
			}
		}
		echo "</table>";
		echo fin_block();
	}	
	*/
    //-----------Zone de modification elebescond@clever-age.com ---------------

	fin_cadre_enfonce();
}


?>
