<?php

//  $Id$



require_once (dirname(__FILE__)."/inc_filtres.php3");
require_once (dirname(__FILE__)."/include/bd/inc_glossaire_services_factory.php");
/* Ajout Clever Age / Antoine Angeneux / Couche metier */
require_once (dirname(__FILE__)."/include/bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/include/bd/inc_rubrique_factory.php");
/* fin zone de modification Clever Age */

//
// Initialisation de quelques variables globales
// (on peut les modifier globalement dans mes_fonctions.php3,
//  OU individuellement pour chaque type de page dans article.php3,
//  rubrique.php3, etc. cf doc...)
// Par securite ne pas accepter les variables passees par l'utilisateur
//
function tester_variable($nom_var, $val){
	if (!isset($GLOBALS[$nom_var])
		OR $_GET[$nom_var] OR $GLOBALS['HTTP_GET_VARS'][$nom_var]
		OR $_PUT[$nom_var] OR $GLOBALS['HTTP_PUT_VARS'][$nom_var]
		OR $_POST[$nom_var] OR $GLOBALS['HTTP_POST_VARS'][$nom_var]
		OR $_COOKIE[$nom_var] OR $GLOBALS['HTTP_COOKIE_VARS'][$nom_var]
		OR $_REQUEST[$nom_var]) {
		$GLOBALS[$nom_var] = $val;
		return false;
	}
	return true;
}

tester_variable('debut_intertitre', "\n<h3 class=\"spip\">");
tester_variable('fin_intertitre', "</h3>\n");
tester_variable('ligne_horizontale', "\n<hr class=\"spip\" />\n");
tester_variable('ouvre_ref', '&nbsp;[');
tester_variable('ferme_ref', ']');
tester_variable('ouvre_note', '[');
tester_variable('ferme_note', '] ');
tester_variable('les_notes', '');
tester_variable('compt_note', 0);
tester_variable('nombre_surligne', 4);
tester_variable('url_glossaire_externe', "http://@lang@.wikipedia.org/wiki/");


// On ne prend la $puce_rtl par defaut que si $puce n'a pas ete redefinie

//if (!tester_variable('puce', "<li class='spip_puce' style='list-style-image: url(puce.gif)'>")) {
/* Correction S.PETIT / XHTML 1.0 */
/*
if (!tester_variable('puce', "<img class='spip_puce' src='puce.gif' alt='-' border='0'>&nbsp;")) {
	tester_variable('puce_rtl', "<img class='spip_puce' src='puce_rtl.gif' alt='-' border='0'>&nbsp;");
}
*/
if (!tester_variable('puce', "<img class='spip_puce' src='img_pack/puce.gif' alt='-' />&nbsp;")) {
       tester_variable('puce_rtl', "<img class='spip_puce' src='img_pack/puce_rtl.gif' alt='-' />&nbsp;");
}
/* Fin zone de correction */

//
// Trouver une locale qui marche
//
$lang2 = strtoupper($GLOBALS['spip_lang']);
setlocale(LC_CTYPE, $GLOBALS['spip_lang']) ||
setlocale(LC_CTYPE, $lang2.'_'.$GLOBALS['spip_lang']) ||
setlocale(LC_CTYPE, $GLOBALS['spip_lang'].'_'.$lang2);


//
// Vignette pour les documents lies
//

function vignette_par_defaut($type_extension) {
	if ($GLOBALS['flag_ecrire'])
		$img = "../IMG/icones";
	else
		$img = "IMG/icones";

	$filename = "$img/$type_extension";

	// Glurps !
	if (file_exists($filename.'.png')) {
		$vig = "$filename.png";
	}
	else if (file_exists($filename.'.gif')) {
		$vig = "$filename.gif";
	}
	else if (file_exists($filename.'-dist.png')) {
		$vig = "$filename-dist.png";
	}
	else if (file_exists($filename.'-dist.gif')) {
		$vig = "$filename-dist.gif";
	}
	else if (file_exists("$img/defaut.png")) {
		$vig = "$img/defaut.png";
	}
	else if (file_exists("$img/defaut.gif")) {
		$vig = "$img/defaut.gif";
	}
	else if (file_exists("$img/defaut-dist.png")) {
		$vig = "$img/defaut-dist.png";
	}
	else if (file_exists("$img/defaut-dist.gif")) {
		$vig = "$img/defaut-dist.gif";
	}

	if ($size = @getimagesize($vig)) {
		$largeur = $size[0];
		$hauteur = $size[1];
	}

	return array($vig, $largeur, $hauteur);
}


//
// Diverses fonctions essentielles
//

// ereg_ ou preg_ ?
function ereg_remplace($cherche_tableau, $remplace_tableau, $texte) {
	global $flag_pcre;

	if ($flag_pcre) return preg_replace($cherche_tableau, $remplace_tableau, $texte);

	$n = count($cherche_tableau);

	for ($i = 0; $i < $n; $i++) {
		$texte = ereg_replace(substr($cherche_tableau[$i], 1, -1), $remplace_tableau[$i], $texte);
	}
	return $texte;
}

// Ne pas afficher le chapo si article virtuel
function nettoyer_chapo($chapo){
	if (substr($chapo,0,1) == "="){
		$chapo = "";
	}
	return $chapo;
}

// points d'entree de pre- et post-traitement pour propre() et typo()
function spip_avant_propre ($letexte) {

	if (@function_exists('avant_propre'))
		return avant_propre ($letexte);
	return $letexte;
}

function spip_apres_propre ($letexte) {
	if (@function_exists('apres_propre'))
		return apres_propre ($letexte);

	return $letexte;
}

function spip_avant_typo ($letexte) {

	if (@function_exists('avant_typo'))
		return avant_typo ($letexte);

	return $letexte;
}

function spip_apres_typo ($letexte) {

	// caracteres speciaux
	$letexte = corriger_caracteres($letexte);
	$letexte = str_replace("'", "&#8217;", $letexte);

	// relecture des &nbsp;
	if ($GLOBALS['flag_ecrire'] AND $GLOBALS['revision_nbsp'])
		$letexte = ereg_replace('&nbsp;', '<span class="spip-nbsp">&nbsp;</span>', $letexte);

	if (@function_exists('apres_typo'))
		return apres_typo ($letexte);

	return $letexte;
}

// Mise de cote des echappements
function echappe_html($letexte,$source) {
	global $flag_pcre;

	if ($flag_pcre) {	// beaucoup plus rapide si on a pcre
		$regexp_echap_html = "<html>((.*?))<\/html>";
		$regexp_echap_code = "<code>((.*?))<\/code>";
		$regexp_echap_cadre = "<cadre>((.*?))<\/cadre>";
		$regexp_echap = "/($regexp_echap_html)|($regexp_echap_code)|($regexp_echap_cadre)/si";
	} else {
		$regexp_echap_html = "<html>(([^<]|<[^/]|</[^h]|</h[^t]|</ht[^m]|</htm[^l]|<\/html[^>])*)<\/html>";
		$regexp_echap_code = "<code>(([^<]|<[^/]|</[^c]|</c[^o]|</co[^d]|</cod[^e]|<\/code[^>])*)<\/code>";
		$regexp_echap_cadre = "<cadre>(([^<]|<[^/]|</[^c]|</c[^a]|</ca[^d]|</cad[^r]|</cadr[^e]|<\/cadre[^>])*)<\/cadre>";
		$regexp_echap = "($regexp_echap_html)|($regexp_echap_code)|($regexp_echap_cadre)";
	}

	while (($flag_pcre && preg_match($regexp_echap, $letexte, $regs))
		|| (!$flag_pcre && eregi($regexp_echap, $letexte, $regs))) {
		$num_echap++;

		if ($regs[1]) {
			// Echapper les <html>...</ html>
			$les_echap[$num_echap] = $regs[2];
		}
		else
		if ($regs[4]) {
			/*
			// Echapper les <code>...</ code>
			$lecode = entites_html($regs[5]);

			// supprimer les sauts de ligne debut/fin (mais pas les espaces => ascii art).
			$lecode = ereg_replace("^\n+|\n+$", "", $lecode);

			// ne pas mettre le <div...> s'il n'y a qu'une ligne
			if (is_int(strpos($lecode,"\n")))
				$lecode = nl2br("<div align='left' class='spip_code' dir='ltr'>".$lecode."</div>");
			else
				$lecode = "<span class='spip_code' dir='ltr'>".$lecode."</span>";

			$lecode = ereg_replace("\t", "&nbsp; &nbsp; &nbsp; &nbsp; ", $lecode);
			$lecode = ereg_replace("  ", " &nbsp;", $lecode);
			$les_echap[$num_echap] = "<tt>".$lecode."</tt>";
			*/
			$lecode = xhtml_highlight($regs[5]);
			$les_echap[$num_echap] = "<tt>".$lecode."</tt>";
		}
		else
		if ($regs[7]) {
			// Echapper les <cadre>...</cadre>
			$lecode = trim(entites_html($regs[8]));
			$total_lignes = count(explode("\n", $lecode));
			$les_echap[$num_echap] = "<form><textarea readonly='readonly' style='width: 100%;' rows='$total_lignes' wrap='off' class='spip_cadre' dir='ltr'>".$lecode."</textarea></form>";
		}

		$pos = strpos($letexte, $regs[0]);
		$letexte = substr($letexte,0,$pos)."@@SPIP_$source$num_echap@@"
			.substr($letexte,$pos+strlen($regs[0]));
	}


	//
	// Insertion d'images et de documents utilisateur
	//
	while (eregi("<(IMG|DOC|EMB)([0-9]+)(\|([^\>]*))?".">", $letexte, $match)) {
		include_once("inc_documents.php3");
		$num_echap++;

		$letout = quotemeta($match[0]);
		$letout = ereg_replace("\|", "\|", $letout);
		$id_document = $match[2];
		$align = $match[4];
		if (eregi("emb", $match[1])) {
			$rempl = embed_document($id_document, $align);
		} else {
			$rempl = integre_image($id_document, $align, $match[1]);
		}
		$letexte = ereg_replace($letout, "@@SPIP_$source$num_echap@@", $letexte);
		$les_echap[$num_echap] = $rempl;
	}

	//
	// Echapper les tags html contenant des caracteres sensibles a la typo
	//
	$regexp_echap = "<[a-zA-Z!][^<>!':;\?]*[!':;\?][^<>]*>";
	if ($flag_pcre)
		if (preg_match_all("/$regexp_echap/", $letexte, $regs, PREG_SET_ORDER))
			while (list(,$reg) = each($regs)) {
				$num_echap++;
				$les_echap[$num_echap] = $reg[0];
				//echo htmlspecialchars($reg[0])."<p>";
				$pos = strpos($letexte, $les_echap[$num_echap]);
				$letexte = substr($letexte,0,$pos)."@@SPIP_$source$num_echap@@"
					.substr($letexte,$pos+strlen($les_echap[$num_echap]));
			}
	else
		while (ereg($regexp_echap, $letexte, $reg)) {
			$num_echap++;
			$les_echap[$num_echap] = $reg[0];
			$pos = strpos($letexte, $les_echap[$num_echap]);
			$letexte = substr($letexte,0,$pos)."@@SPIP_$source$num_echap@@"
				.substr($letexte,$pos+strlen($les_echap[$num_echap]));
		}

	return array($letexte, $les_echap);
}

// Traitement final des echappements
function echappe_retour($letexte, $les_echap, $source) {
        
    // ajout Olivier Mansour : protection du champs title
    $letexte = ereg_replace("title=\"([^@\"])*@@SPIP_$source([0-9]+)@@([^\"]*\")", "title = \"\\1\\3 \"", $letexte);
    //echo "\n".'<letexte>'.$letexte.'</letexte>';
    // fin ajout Olivier Mansour
	while (ereg("@@SPIP_$source([0-9]+)@@", $letexte, $match)) {
		$lenum = $match[1];
		$cherche = $match[0];
		$pos = strpos($letexte, $cherche);
        $letexte = substr($letexte, 0, $pos). $les_echap[$lenum] . substr($letexte, $pos + strlen($cherche));
	}
    return $letexte; 
}

// correction S.PETIT
//function couper($texte, $long) {
function couper($texte, $taille) {
//fin correction S.PETIT
    $texte = substr($texte, 0, 400 + 2*$taille); /* eviter de travailler sur 10ko pour extraire 150 caracteres */

    // on utilise les \r pour passer entre les gouttes
    $texte = str_replace("\r\n", "\n", $texte);
    $texte = str_replace("\r", "\n", $texte);

    // sauts de ligne et paragraphes
    $texte = ereg_replace("\n\n+", "\r", $texte);
    $texte = ereg_replace("<(p|br)( [^>]*)?".">", "\r", $texte);

    // supprimer les traits, lignes etc
    $texte = ereg_replace("(^|\r|\n)(-[-#\*]*|_ )", "\r", $texte);

    // supprimer les tags
    $texte = supprimer_tags($texte);
    $texte = trim(str_replace("\n"," ", $texte));
    $texte .= "\n"; // marquer la fin

    // travailler en accents charset
    $texte = filtrer_entites($texte);

    // supprimer les liens
    $texte = ereg_replace("\[->([^]]*)\]","\\1", $texte); // liens sans texte
    $texte = ereg_replace ("\[(^\|)*|([^\[]*)->([^]]*)\]","\\1", $texte); // lien avec user title
    $texte = ereg_replace("\[([^\[]*)->([^]]*)\]","\\1", $texte);
    

    // supprimer les notes
    $texte = ereg_replace("\[\[([^]]|\][^]])*\]\]", "", $texte);

	// cas particulier pour les intertitres de niveau 2 et 3 
    $texte = str_replace ('{2{', '', $texte);
    $texte = str_replace ('{3{', '', $texte);
    $texte = str_replace ('}2}', '', $texte);
    $texte = str_replace ('}3}', '', $texte); 

    // supprimer les codes typos
    $texte = ereg_replace("[{}]", "", $texte);

    // supprimer les tableaux
    $texte = ereg_replace("(^|\r)\|.*\|\r", "\r", $texte);

    // couper au mot precedent
    $long = substr($texte, 0, max($taille-4,1));
    $court = ereg_replace("([^[:space:]][[:space:]]+)[^[:space:]]*\n?$", "\\1", $long);
    $points = '&nbsp;(...)';

    // trop court ? ne pas faire de (...)
    if (strlen($court) < max(0.75 * $taille,2)) {
        $points = '';
        $long = ereg_replace("&#?[a-z0-9]*;?$", "", substr($texte, 0, $taille));
        $texte = ereg_replace("([^[:space:]][[:space:]]+)[^[:space:]]*$", "\\1", $long);
        // encore trop court ? couper au caractere
        if (strlen($texte) < 0.75 * $taille)
            $texte = $long;
    } else
        $texte = $court;

    if (strpos($texte, "\n"))   // la fin est encore la : c'est qu'on n'a pas de texte de suite
        $points = '';

    // remettre les paragraphes
    $texte = ereg_replace("\r+", "\n\n", $texte);

    return trim($texte).$points;
}

// prendre <intro>...</intro> sinon couper a la longueur demandee
function couper_intro($texte, $long) {
	$texte = eregi_replace("(</?)intro>", "\\1intro>", $texte); // minuscules
	while ($fin = strpos($texte, "</intro>")) {
		$zone = substr($texte, 0, $fin);
		$texte = substr($texte, $fin + strlen("</intro>"));
		if ($deb = strpos($zone, "<intro>") OR substr($zone, 0, 7) == "<intro>")
			$zone = substr($zone, $deb + 7);
		$intro .= $zone;
	}

	if ($intro)
		$intro = $intro.' (...)';
	else
		$intro = couper($texte, $long);

	// supprimer un eventuel chapo redirecteur =http:/.....
	$intro = ereg_replace("^=[^[:space:]]+","",$intro);

	return $intro;
}


//
// Les elements de propre()
//

// Securite : empecher l'execution de code PHP
function interdire_scripts($source) {
	$source = eregi_replace("<(\%|\?|([[:space:]]*)script)", "&lt;\\1", $source);
	return $source;
}


// Correction typographique francaise
function typo_fr($letexte) {
	global $flag_strtr2;
	static $trans;

	// Nettoyer 160 = nbsp ; 187 = raquo ; 171 = laquo ; 176 = deg ; 147 = ldquo; 148 = rdquo
	if (!$trans) {
		$trans = array(
			"&nbsp;" => "~",
			"&raquo;" => "&#187;",
			"&laquo;" => "&#171;",
			"&rdquo;" => "&#148;",
			"&ldquo;" => "&#147;",
			"&deg;" => "&#176;"
		);
		$chars = array(160 => '~', 187 => '&#187;', 171 => '&#171;', 148 => '&#148;', 147 => '&#147;', 176 => '&#176;');
		$charset = lire_meta('charset');
		include_once('inc_charsets.php3');

		while (list($c, $r) = each($chars)) {
			$c = unicode2charset(charset2unicode(chr($c), 'iso-8859-1', 'forcer'));
			$trans[$c] = $r;
		}
	}

	if ($flag_strtr2)
		$letexte = strtr($letexte, $trans);
	else {
		reset($trans);
		while (list($c, $r) = each($trans))
			$letexte = str_replace($c, $r, $letexte);
	}

	$cherche1 = array(
		/* 1		'/{([^}]+)}/',  */
		/* 2 */ 	'/((^|[^\#0-9a-zA-Z\&])[\#0-9a-zA-Z]*)\;/',
		/* 3 */		'/&#187;|[!?]| -,|:([^0-9]|$)/',
		/* 4 */		'/&#171;|(M(M?\.|mes?|r\.?)|[MnN]&#176;) /'
	);
	$remplace1 = array(
		/* 1		'<i class="spip">\1</i>', */
		/* 2 */		'\1~;',
		/* 3 */		'~\0',
		/* 4 */		'\0~'
	);
	$letexte = ereg_remplace($cherche1, $remplace1, $letexte);
	$letexte = ereg_replace(" *~+ *", "~", $letexte);

	$cherche2 = array(
		'/(http|https|ftp|callto|mailto)~:/',
		'/~/'
	);
	$remplace2 = array(
		'\1:',
		'&nbsp;'
	);
	$letexte = ereg_remplace($cherche2, $remplace2, $letexte);

	return $letexte;
}

// rien sauf les ~ {}
function typo_en($letexte) {

	$cherche1 = array(
		/* 1 */		'/{([^}]+)}/'
	);
	$remplace1 = array(
		/* 1 */		'<i class="spip">\1</i>'
	);
	// $letexte = ereg_remplace($cherche1, $remplace1, $letexte);

	$letexte = str_replace("&nbsp;", "~", $letexte);

	return ereg_replace(" *~+ *", "&nbsp;", $letexte);
}

// Typographie generale : francaise si la langue est 'cpf', 'fr' ou 'eo',
// sinon anglaise (minimaliste)
function typo($letexte) {
	global $spip_lang, $lang_typo;

	// Appeler la fonction de pre-traitement
	$letexte = spip_avant_typo ($letexte);

	list($letexte, $les_echap) = echappe_html($letexte, "SOURCETYPO");

	if (!$lang = $lang_typo) {
		include_once('inc_lang.php3');
		$lang = lang_typo($spip_lang);
	}

	if ($lang == 'fr')
		$letexte = typo_fr($letexte);
	else
		$letexte = typo_en($letexte);
	// Appeler la fonction de post-traitement
	$letexte = spip_apres_typo ($letexte);

	$letexte = corriger_caracteres($letexte);
	$letexte = str_replace("'", "&#8217;", $letexte);
	$letexte = echappe_retour($letexte, $les_echap, "SOURCETYPO");

	return $letexte;
}


// cette fonction est tordue : on lui passe un tableau correspondant au match
// de la regexp ci-dessous, et elle retourne le texte a inserer a la place
// et le lien "brut" a usage eventuel de redirection...
function extraire_lien ($regs) {
	$lien_texte = $regs[1];

	//--------Modification Clever Age omansour--------------
	$user_title = '';
    $user_hreflang = '';
	$regexp = "([^\|]*)\|(.*)"; // si on a libelle|title 
	if (ereg($regexp, $lien_texte, $regs_lien_texte)) {
		$lien_texte = $regs_lien_texte[1]; 
		$user_title = $regs_lien_texte[2];
        // detection d'un eventuel hreflang []
        $regexp = "([^{]*){([^}]*)}$";
        if (ereg($regexp, $user_title, $regs_hreflang )) {
            $user_hreflang = $regs_hreflang[2];
            $user_title =  $regs_hreflang [1]; // on efface les [...] du usr_title
        }  		
	} 
	//--------Fin modification Clever Age-------------
	
	//--------Modification Clever Age nhoizey--------------
	$lien_ouvrant = ($regs[2] == '>');
	//--------Fin modification Clever Age-------------
	$lien_url = trim($regs[3]);
	$compt_liens++;
	$lien_interne = false;
    // Modification Olivier Mansour
    if (ereg('^(art(icle)?|rub(rique)?|br(.ve)?|aut(eur)?|mot|site|doc(ument)?|im(age|g))? *([[:digit:]]+)(#.*)*$', $lien_url, $match)) {
	//if (ereg('^(art(icle)?|rub(rique)?|br(.ve)?|aut(eur)?|mot|site|doc(ument)?|im(age|g))? *([[:digit:]]+)$', $lien_url, $match)) {
		// Traitement des liens internes
		if (file_exists('inc-urls.php3')) {
			include_once('inc-urls.php3');
		} elseif (file_exists('inc-urls-dist.php3')) {
			include_once('inc-urls-dist.php3');
		}
		else {
			include_once('inc_urls.php3');
		}
		
        
        // ajout Olivier Mansour
        $fin_lien = $match[9];
        // fin ajout
		$id_lien = $match[8];
		$type_lien = $match[1];
		$lien_interne=true;
		$class_lien = "in";
		switch (substr($type_lien, 0, 2)) {
			case 'ru':
				$lien_url = generer_url_rubrique($id_lien);
				if (!$lien_texte) {
					//--------Modification Clever Age elebescond--------------
		            $rubriqueMetier = &recuperer_instance_rubrique();
                    $loadOK = $rubriqueMetier->load($id_lien);
                    if (PEAR::isError($loadOK)) {
                        //die($loadOK->getMessage());
                        $lien_texte = $loadOK->getMessage();
                    }
                    else {                        
                        $lien_texte = $rubriqueMetier->getTitre();
                    }
		            /*
                    $req = "select titre from spip_rubriques where id_rubrique=$id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['titre'];
		            */
                    //--------Fin modification Clever Age-------------
				}
				break;
			case 'br':
				$lien_url = generer_url_breve($id_lien);
                $lien_url .= $fin_lien;
				if (!$lien_texte) {
                    //--------Modification Clever Age--------------
		            $breveMetier = &recuperer_instance_breve();
		            $loadOk = $breveMetier->load($id_lien);
		            if (PEAR::isError($loadOk)) {
                        //die($loadOK->getMessage());
                        $lien_texte = $loadOK->getMessage();
    		        }
		            else {    
		                $lien_texte = $breveMetier->getTitre();
		            }
                    /*
					$req = "select titre from spip_breves where id_breve=$id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['titre'];
                    */
                    //--------Fin modification Clever Age-------------							
				}
				break;
			case 'au':
				$lien_url = generer_url_auteur($id_lien);
				if (!$lien_texte) {
                    //----------Modification Clever Age elebescond----------
                    $auteurMetier = &recuperer_instance_auteur();
	                $loadOK = $auteurMetier->load($id_lien);
	                if(PEAR::isError($loadOK)) {
	                    //die($loadOK->getMessage());
                        $lien_texte = $loadOK->getMessage();
	                }
	                else {
                        $lien_texte = $auteurMetier->getNom();                        
                    }
                    /*
                    $req = "select nom from spip_auteurs where id_auteur = $id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['nom'];
        		    */
                    //---------Fin modification Clever Age-------	
				}
				break;
			case 'mo':
				$lien_url = generer_url_mot($id_lien);
				if (!$lien_texte) {
					//----------Modification Clever Age elebescond----------
                    $motMetier = &recuperer_instance_mot();
                    $loadOK = $motMetier->load($id_lien);
	                if(PEAR::isError($loadOK)) {
	                    //die($loadOK->getMessage());
                        $lien_texte = $loadOK->getMessage();
	                }
	                else {
                        $lien_texte = $motMetier->getTitre();
	                }    
	                /*
                    $req = "select titre from spip_mots where id_mot=$id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['titre'];
    	            */
                    //---------Fin modification Clever Age-------
				}
				break;
			case 'im':
			case 'do':
                $lien_url = generer_url_document($id_lien);
                $documentMetier = &recuperer_instance_document();
                $loadOK = $documentMetier->load($id_lien);
				if (!$lien_texte) {
                    //----------------Zone de modifications Clever Age elebescond----------
	                

            	    if (PEAR::isError($loadOK)) {
            	        //die($loadOK->getMessage());
                        $lien_texte = $loadOK->getMessage();
            	    }
            	    else {
                        $lien_texte = $documentMetier->getTitre();
                        if (!$lien_texte)
						    $lien_texte = ereg_replace("^.*/","",$documentMetier->getFichier());	    
                    }
                    
	                /*
                    $req = "select titre,fichier from spip_documents where id_document=$id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['titre'];
					if (!$lien_texte)
					*/
						//$lien_texte = ereg_replace("^.*/","",$row['fichier']);	    
    	            
                    //----------------Fin de zone de modifications-------------------------					
				}
                if (!$user_title) {
                    require_once (dirname(__FILE__)."/include/bd/inc_type_document_factory.php");
                    $typeDocumentMetier = &recuperer_instance_type_document();
                    $loadOK = $typeDocumentMetier->load($documentMetier->getTypeId());
                    if(PEAR::isError($loadOK)) {
                        $type = 'fichier';
                    } else {
                        $type = $typeDocumentMetier->getTitre();
                    }
                    $user_title = couper(typo($documentMetier->getTitre()), 35). ' - '. $type. ' '.taille_en_octets($documentMetier->getTaille()); 
                }
				break;
			case 'si':
				//------------MODIFICATION CLEVER AGE elebescond
                $syndicMetier = &recuperer_instance_syndic();
                $loadOK = $syndicMetier->load($id_lien);
                if (PEAR::isError($loadOK)) {
                    //die($loadOK->getMessage());
                    $lien_url = $loadOK->getMessage();
                }
                else {
                    $lien_url = $syndicMetier->getUrlSite();
					if (!$lien_texte)
						$lien_texte = typo($syndicMetier->getUrlSite());
                }

		        /*
				$row = @spip_fetch_array(@spip_query("SELECT nom_site,url_site FROM spip_syndic WHERE id_syndic=$id_lien"));
				if ($row) {
					$lien_url = $row['url_site'];
					if (!$lien_texte)
						$lien_texte = typo($row['nom_site']);
				}

	            */
	            //-----------FIN MODIFICATION CLEVER AGE
				
				break;
			default:
				$lien_url = generer_url_article($id_lien);
                $lien_url .= $fin_lien;
				if (!$lien_texte) {
                    //--------------------Modification Clever Age-----------------------
					$articleMetier = recuperer_instance_article();
					$resOk = $articleMetier->loadLightWeight($id_lien);
					if (!PEAR::isError($resOk)) {
                        $lien_texte = $articleMetier->getTitre();
					}
					/*
					$req = "select titre from spip_articles where id_article=$id_lien";
					$row = @spip_fetch_array(@spip_query($req));
					$lien_texte = $row['titre'];
					*/
//--------------------Fin modification Clever Age-------------------

				}
				break;
		}

		// supprimer les numeros des titres
		include_once("inc_filtres.php3");
		$lien_texte = supprimer_numero($lien_texte);
	} elseif (ereg('^\?(.*)$', $lien_url, $regs)) {
		// Liens glossaire
		$lien_url = substr($lien_url, 1);
		$class_lien = "glossaire";
	} else {
		// Liens non automatiques
		$class_lien = "out";
		// Ajout Olivier Mansour (detection des ancres ... liens internes)
		if ((substr($lien_url, 0,1)) == '#') {
			$class_lien = "in";
			$lien_url = $_SERVER['REQUEST_URI'] . $lien_url;
		}
		// fin ajout Olivier Mansour
		// texte vide ?
		if ((!$lien_texte) and (!$lien_interne)) {
			$lien_texte = ereg_replace('"', '', $lien_url);
			if (strlen($lien_texte) > 40) {
				$lien_texte = substr($lien_texte,0,35).'...';
			}
			$class_lien = 'url';
			// Modification Olivier Mansour 
			if (!$user_title) $user_title = $lien_texte;
			$lien_texte = '<html>'.$lien_texte.'</html>';
			//$lien_texte = '<html>$lien_texte</html>';
			// fin modifications Olivier Mansour 
		}
		// petites corrections d'URL
		if (ereg("^www\.[^@]+$",$lien_url)) {
			$lien_url = "http://".$lien_url;
		} else if (strpos($lien_url, "@") && email_valide($lien_url)) {
			$lien_url = "mailto:".$lien_url;
		}
	}

	//--------Modification Clever Age omansour--------------
	if ($user_title) {
		$lien_titre = attribut_html($user_title);	
	} else {
        $lien_titre = str_replace('{', '', $lien_texte); // on eleve le gras ou l'italique pour le title (en attendant mieux)
        $lien_titre = str_replace('}', '', $lien_titre);
        $lien_titre = attribut_html($lien_titre);
	}
    if ($user_hreflang) {
        $lien_hreflang = ' hreflang=\''.$user_hreflang.'\' ';   
    }
	//--------------------Fin modification Clever Age-------------------

	//--------Modification Clever Age nhoizey omansour --------------
    if ($lien_ouvrant) {
        $insert = '<a href="'.$lien_url.'" title="'.$lien_titre.' - '._T('info_nouvelle_fenetre')._T('info_lien_'.$class_lien).'" target="_blank" class="spip_blank"'.$lien_hreflang.'>'.typo($lien_texte).'</a>';
    } else {
        $insert = '<a href="'.$lien_url.'" title="'.$lien_titre.' - '._T('info_meme_fenetre')._T('info_lien_'.$class_lien).'" class="spip_'.$class_lien.'"'.$lien_hreflang.'>'.typo($lien_texte).'</a>';
    }
	//--------------------Fin modification Clever Age-------------------
	return array($insert, $lien_url);
}



//
// Traitement des listes (merci a Michael Parienti)
//
function traiter_listes ($texte) {  
	$parags = split ("\n[[:space:]]*\n", $texte);
	unset($texte);

	// chaque paragraphe est traite a part
	while (list(,$para) = each($parags)) {
		$niveau = 0;
		$lignes = explode("\n-", "\n" . $para);

		// ne pas toucher a la premiere ligne
		list(,$debut) = each($lignes);
		//$texte .= "</p>\n".$debut;
        $texte .= $debut;

		// chaque item a sa profondeur = nb d'etoiles
		unset ($type);
		while (list(,$item) = each($lignes)) {
			ereg("^([*]*|[#]*)([^*#].*)", $item, $regs);
			$profond = strlen($regs[1]);

			if ($profond > 0) {
				unset ($ajout);

				// changement de type de liste au meme niveau : il faut
				// descendre un niveau plus bas, fermer ce niveau, et
				// remonter
				$nouv_type = (substr($item,0,1) == '*') ? 'ul' : 'ol';
				$change_type = ($type AND ($type <> $nouv_type) AND ($profond == $niveau)) ? 1 : 0;
				$type = $nouv_type;

				// d'abord traiter les descentes
				while ($niveau > $profond - $change_type) {
					$ajout .= $pile_li[$niveau];
					$ajout .= $pile_type[$niveau];
					if (!$change_type)
						unset ($pile_li[$niveau]);
					$niveau --;
				}

				// puis les identites (y compris en fin de descente)
				if ($niveau == $profond && !$change_type) {
					$ajout .= $pile_li[$niveau];
				}

				// puis les montees (y compris apres une descente un cran trop bas)
				while ($niveau < $profond) {
					$niveau ++;
					$ajout .= "<$type class=\"spip\">";
					$pile_type[$niveau] = "</$type>";
				}

				$ajout .= "<li class=\"spip\">";
				$pile_li[$profond] = "</li>";
			}
			else {
				$ajout = "\n-";	// puce normale ou <hr>
			}

			$texte .= $ajout . $regs[2];
		}

		// retour sur terre
		unset ($ajout);
		while ($niveau > 0) {
			$ajout .= $pile_li[$niveau];
			$ajout .= $pile_type[$niveau];
			$niveau --;
		}
		//$texte .= $ajout."\n<p@>";
        $texte .= $ajout."\n";

		// paragraphe
		$texte .= "\n\n";
	}

	// sucrer les deux derniers \n
	return substr($texte, 0, -2);
}


// Nettoie un texte, traite les raccourcis spip, la typo, etc.
function traiter_raccourcis ($letexte, $les_echap = false, $traiter_les_notes = 'oui') {
	global $debut_intertitre, $fin_intertitre, $ligne_horizontale, $url_glossaire_externe;
	global $compt_note;
	global $les_notes;
	global $marqueur_notes;
	global $ouvre_ref;
	global $ferme_ref;
	global $ouvre_note;
	global $ferme_note;
	global $flag_pcre;
	global $lang_dir;

	// Appeler la fonction de pre_traitement
	$letexte = spip_avant_propre ($letexte);
	
	
    
	

	/**jpyrat
	**/
	// Puce
	if (!$lang_dir) {
		include_once('inc_lang.php3');
		$lang_dir = lang_dir($GLOBALS['spip_lang']);
	}
	if ($lang_dir == 'rtl' AND $GLOBALS['puce_rtl'])
		$puce = $GLOBALS['puce_rtl'];
	else
		$puce = $GLOBALS['puce'];

	// Harmoniser les retours chariot
	$letexte = ereg_replace ("\r\n?", "\n",$letexte);

	// echapper les <a href>, <html>...< /html>, <code>...< /code>
	if (!$les_echap)
		list($letexte, $les_echap) = echappe_html($letexte, "SOURCEPROPRE");

//
    // Raccourcis liens (cf. fonction extraire_lien ci-dessus)
    //
    $regexp = "\[([^][]*)->(>?)([^]]*)\]";
    $texte_a_voir = $letexte;
    $texte_vu = '';
    while (ereg($regexp, $texte_a_voir, $regs)) {
        list($insert, $lien) = extraire_lien($regs);
        $pos = strpos($texte_a_voir, $regs[0]); 
        $texte_vu .= typo(substr($texte_a_voir, 0, $pos)) . $insert;
        $texte_a_voir = substr($texte_a_voir, $pos + strlen($regs[0]));
    }
    $letexte = $texte_vu.typo($texte_a_voir); // typo de la queue du texte
    


	// Corriger HTML
	$letexte = eregi_replace("</?p>","\n\n\n",$letexte);

	// Traitement pour le glossaire automatique
	if (lire_meta('activer_glossaire') == 'oui') {
		$letexte = traiterGlossaire($letexte);
	}

	//
	// Notes de bas de page
	//
	$texte_a_voir = $letexte;
	$texte_vu = '';
	$regexp = "\[\[(([^]]|[^]]\][^]])*)\]\]";
	/* signifie : deux crochets ouvrants, puis pas-crochet-fermant ou
		crochet-fermant entoure de pas-crochets-fermants (c'est-a-dire
		tout sauf deux crochets fermants), puis deux fermants */
	while (ereg($regexp, $texte_a_voir, $regs)) {
		$note_source = $regs[0];
		$note_texte = $regs[1];
		$num_note = false;

		// note auto ou pas ?
		if (ereg("^ *<([^>]*)>", $note_texte, $regs)){
			$num_note = $regs[1];
			$note_texte = ereg_replace ("^ *<([^>]*)>", "", $note_texte);
		} else {
			$compt_note++;
			$num_note = $compt_note;
		}

		// preparer la note
		if ($num_note) {
			if ($marqueur_notes) // ??????
				$mn = $marqueur_notes.'-';
			$ancre = $mn.urlencode($num_note);
			/*
            $insert = "$ouvre_ref<a href=\"".$_SERVER['REQUEST_URI'] ."#nb$ancre\" name=\"nh$ancre\" class=\"spip_note\">$num_note</a>$ferme_ref";
            $appel = "<html>$ouvre_note<a href=\"".$_SERVER['REQUEST_URI'] ."#nh$ancre\" name=\"nb$ancre\" class=\"spip_note\">$num_note</a>$ferme_note</html>";
            */
            $insert = "$ouvre_ref<a href=\"" . $_SERVER['REQUEST_URI'] . "#nb$ancre\" name=\"nh$ancre\" class=\"spip_note\">$num_note</a>$ferme_ref";
			$appel = "<html>$ouvre_note<a href=\"" . $_SERVER['REQUEST_URI'] . "#nh$ancre\" name=\"nb$ancre\" class=\"spip_note\">$num_note</a>$ferme_note</html>";
		} else {
			$insert = '';
			$appel = '';
		}

		// l'ajouter "brut" dans les notes
		if ($note_texte) {
			if ($mes_notes)
				$mes_notes .= "\n\n";
			$mes_notes .= $appel . $note_texte;
		}

		// dans le texte, mettre l'appel de note a la place de la note
		$pos = strpos($texte_a_voir, $note_source);
		$texte_vu .= substr($texte_a_voir, 0, $pos) . $insert;
		$texte_a_voir = substr($texte_a_voir, $pos + strlen($note_source));
	}
	$letexte = $texte_vu . $texte_a_voir;

	//
	// Raccourcis automatiques vers un glossaire
	// (on traite ce raccourci en deux temps afin de ne pas appliquer
	//  la typo sur les URLs, voir raccourcis liens ci-dessous)
	//
	if ($url_glossaire_externe) {
		$regexp = "\[\?+([^][<>]+)\]";
		while (ereg($regexp, $letexte, $regs)) {
			$terme = trim($regs[1]);
			$terme_underscore = urlencode(ereg_replace('[[:space:]]+', '_', $terme));
			if (strstr($url_glossaire_externe,"%s"))
				$url = str_replace("%s", $terme_underscore, $url_glossaire_externe);
			else
				$url = $url_glossaire_externe.$terme_underscore;
			$url = str_replace("@lang@", $GLOBALS['spip_lang'], $url);
			$code = "[$terme->?$url]";
			$letexte = str_replace($regs[0], $code, $letexte);
		}
	}

    // Ajout Olivier Mansour omansour@clever-age.com 
    // gestion des acronymes 
    // $regexp = "\[([^][]*)\|([^][]*)\]";
    $regexp = "\[([^][]*)\|([^][]*)\]";
    $texte_a_voir = $letexte;
    $texte_vu = '';
    // traitement 
    while (ereg($regexp, $texte_a_voir, $regs)) {
        $pos = strpos($texte_a_voir, $regs[0]); 
        if (strstr ($regs[2], '->')) { // c'est un lien !! on ne fait rien  
        	$insert = $regs[0];
        } else { // c'est bien un acronyme
        	$insert = '<acronym title="'.attribut_html($regs[2]).'" class="spip_acronym">'.typo($regs[1]).'</acronym>';
        }
        $texte_vu .= typo(substr($texte_a_voir, 0, $pos)) . $insert;
        $texte_a_voir = substr($texte_a_voir, $pos + strlen($regs[0]));
    } 
    $letexte = $texte_vu.$texte_a_voir;
    // fin ajout Olivier Mansour
    
    
    // Ajout Olivier Mansour omansour@clever-age.com
    // gestion des ancres 
    $regexp = "\[([^][]*)<-\]"; 
    $texte_a_voir = $letexte;
    $texte_vu = '';
    // traitement 
    while (ereg($regexp, $texte_a_voir, $regs)) {
        $pos = strpos($texte_a_voir, $regs[0]); 
        if (function_exists('html_entity_decode')) 
            $regs[1] = html_entity_decode($regs[1]);
        $insert = '<a id="'.$regs[1].'"  name="'.$regs[1].'"></a>';    
        $texte_vu .= typo(substr($texte_a_voir, 0, $pos)) . $insert;
        $texte_a_voir = substr($texte_a_voir, $pos + strlen($regs[0]));
    } 
    $letexte = $texte_vu.$texte_a_voir;
    // fin ajout Olivier Mansour

	


    //
    // Tableaux
    //
    $letexte = ereg_replace("^\n?\|", "\n\n|", $letexte);
    $letexte = ereg_replace("\|\n?$", "|\n\n", $letexte);

    $tableBeginPos = strpos($letexte, "\n\n|");
    $tableEndPos = strpos($letexte, "|\n\n");
    while (is_integer($tableBeginPos) && is_integer($tableEndPos) && $tableBeginPos < $tableEndPos + 3) {
        $textBegin = substr($letexte, 0, $tableBeginPos);
        $textTable = substr($letexte, $tableBeginPos + 2, $tableEndPos - $tableBeginPos);
        $textEnd = substr($letexte, $tableEndPos + 3);

        $newTextTable = '</p><table class="spip" summary="'._T('info_summary_tab').'">'."\n";
        $rowId = 0;
		$tableHeaders = array();
        $lineEnd = strpos($textTable, "|\n");
        while (is_integer($lineEnd)) {
            $rowId++;
            $row = substr($textTable, 0, $lineEnd);
            $textTable = substr($textTable, $lineEnd + 2);
			if ($rowId == 1 && ereg("^\\|\\|([^\\|]+)\\|$", $row, $caption)) {
				$newTextTable .= '<caption>'.$caption[1].'</caption>';
				$rowId--;
			} else {
	            if ($rowId == 1 && ereg("^(\\|[[:space:]]*\\{\\{([^}]+)\\}\\}[[:space:]]*)+$", $row)) {
	                $newTextTable .= '<tr class="row_first">';
	                $rowTab = explode('|', substr($row, 1));
	                while (list(, $cell) = each($rowTab)) {
	                    $cell = substr($cell, 2, -2);
						$cellId = textToId($cell, $tableHeaders);
	                    $newTextTable .= '<th id="'.$cellId.'">'.$cell.'</th>';
						$tableHeaders[] = $cellId;
	                }
	            } else {
	                $newTextTable .= '<tr class="row_'.($rowId % 2 ? 'odd' : 'even').'">';
					if (count($tableHeaders) > 0) {
		                $newTextTable .= ereg_replace("\|([^\|]+)", "<td headers=\"__tempheader__\">\\1</td>", $row);
						for ($i = 0; $i < count($tableHeaders); $i++) {
							$newTextTable = substr_replace($newTextTable, $tableHeaders[$i], strpos($newTextTable, '__tempheader__'), 14);
						}
	                } else {
		                $newTextTable .= ereg_replace("\|([^\|]+)", "<td>\\1</td>", $row);
					}
	            }
	            $newTextTable .= '</tr>';
			}
            $lineEnd = strpos($textTable, "|\n");
        }
        $newTextTable .= '</table>'."\n\n";

        $letexte = $textBegin . $newTextTable . $textEnd;

        $tableBeginPos = strpos($letexte, "\n\n|");
        $tableEndPos = strpos($letexte, "|\n\n");
    }


	//
	// Ensemble de remplacements implementant le systeme de mise
	// en forme (paragraphes, raccourcis...)

	$letexte = trim($letexte);

	// les listes
	if (ereg("\n-[*#]", "\n".$letexte))
		$letexte = traiter_listes($letexte);

/**jpyrat, raccourcis typo supplmentaires  traiter *avant* l'italique !
    **/
    $chercher_raccourcis = array(
#       /*  1 */ "/\{0\{/",
#       /*  2 */ "/\}0\}/",
        /*  3 */ "/\{1\{/",
        /*  4 */ "/\}1\}/",
        /*  5 */ "/\{2\{/",
        /*  6 */ "/\}2\}/",
        /*  7 */ "/\{3\{/",
        /*  8 */ "/\}3\}/",
        /* 11 */ "/\{\{/",
        /* 12 */ "/\}\}/"
            );

    $remplacer_raccourcis = array(
        /*  3 */ "</p>\n@@SPIP_debut_intertitre@@",
        /*  4 */ "@@SPIP_fin_intertitre@@\n<p@>",
        /*  5 */ "</p>\n@@SPIP_debut_intertitre_2@@",
        /*  6 */ "@@SPIP_fin_intertitre_2@@\n<p@>",
        /*  7 */ "</p>\n@@SPIP_debut_intertitre_3@@",
        /*  8 */ "@@SPIP_fin_intertitre_3@@\n<p@>",
        /* 11 */ "<span style=\"font-variant: small-caps\">",
        /* 12 */ "</span>"
            );

    $letexte = ereg_remplace($chercher_raccourcis, $remplacer_raccourcis, $letexte);

	// autres raccourcis
	$cherche1 = array(
		/* 0 */ 	"/(^|\n)(----+|____+)\s*/",
		/* 1 */ 	"/^- */",
		/* 2 */ 	"/\n-- */",
		/* 2bis */ 	"/--/",
		/* 3 */ 	"/\n- */",
		/* 4 */ 	"/\n_ +/",
		/* 5 */ 	"/\{\{\{/",
		/* 6 */ 	"/\}\}\}/",
		/* 7 */ 	"/\{\{/",
		/* 8 */ 	"/\}\}/",
		/* 9 */ 	"/\{/",
		/* 10 */	"/\}/",
		/* 15 */	"/\n*<quote>\s*/",
		/* 16 */	"/\n*<\/quote>\s*/",
		/* 4 */ 	"/(( *)\n){2,}/",
		/* 11 */	"/(<br[[:space:]]*\/?".">){2,}/",
		/* 12 */	"/<p>([\n]*)(<br[[:space:]]*\/?".">)+/",
		/* 14 */	"/\n+/"
	);
	$remplace1 = array(
		/* 0 */ 	"</p>\n@@SPIP_ligne_horizontale@@\n<p@>",
		/* 1 */ 	"$puce&nbsp;",
		/* 2 */ 	"\n<br />&mdash;&nbsp;",
		/* 2bis */ 	"&mdash;",
		/* 3 */ 	"\n<br />$puce&nbsp;",
		/* 4 */ 	"\n<br />",
		/* 5 */ 	"</p>\n@@SPIP_debut_intertitre@@",
		/* 6 */ 	"@@SPIP_fin_intertitre@@\n<p@>",
		/* 7 */ 	"<strong class=\"spip\">",
		/* 8 */ 	"</strong>",
		/* 9 */ 	"<i class=\"spip\">",
		/* 10 */	"</i>",
		/* 15 */	"</p>\n<blockquote class=\"spip\"><p@>",
		/* 16 */	"</p>\n</blockquote>\n<p@>",
		/* 4 */ 	"\n<p>",
		/* 11 */	"\n<p>",
		/* 12 */	"\n<p>",
		/* 14 */	" "
	);
	$letexte = preg_replace($cherche1, $remplace1, $letexte);

/**jpyrat, raccourcis typo supplmentaires
    **/
    $chercher_raccourcis = array(
        /*  9 */ "/[[:space:]]--[[:space:]]/",
        /* 10 */ "/[[:space:]]--,[[:space:]]/",
        /* 13 */ "/<-->/",
        /* 14 */ "/-->/",
        /* 15 */ "/<--/",
        /* 16 */    "/\[\|/",
        /* 17 */    "/\|\]/"
            );

    $remplacer_raccourcis = array(
        /*  9 */ " &mdash; ",
        /* 10 */ " &mdash;, ",
        /* 13 */ "&harr;",
        /* 14 */ "&rarr;",
        /* 15 */ "&larr;",
        /* 16 */    "</p>\n<div style=\"text-align:center;\">",
        /* 17 */    "</div>\n<p@>"
            );

    $letexte = ereg_remplace($chercher_raccourcis, $remplacer_raccourcis, $letexte);




	// intertitres & hr compliants
	$letexte = str_replace('@@SPIP_debut_intertitre@@', $debut_intertitre, $letexte);
	$letexte = str_replace('@@SPIP_fin_intertitre@@', $fin_intertitre, $letexte);
	$letexte = str_replace('@@SPIP_ligne_horizontale@@', $ligne_horizontale, $letexte);

	
	
	/** jpyrat, raccourcis typo supplmentaires
	**/
	# Intertitre de deuxime niveau
	global $debut_intertitre_2, $fin_intertitre_2;
	if(!$debut_intertitre_2) $debut_intertitre_2 = "<h4 class=\"spip\">";
	if(!$fin_intertitre_2) $fin_intertitre_2 = "</h4>";
	$letexte = ereg_replace('(<p class="spip">)?[[:space:]]*@@SPIP_debut_intertitre_2@@', $debut_intertitre_2, $letexte);
	$letexte = ereg_replace('@@SPIP_fin_intertitre_2@@[[:space:]]*(</p>)?', $fin_intertitre_2, $letexte);

	# Intertitre de troisime niveau
	global $debut_intertitre_3, $fin_intertitre_3;
	if(!$debut_intertitre_3) $debut_intertitre_3 = "<h5 class=\"spip\">";
	if(!$fin_intertitre_3) $fin_intertitre_3 = "</h5>";
	$letexte = ereg_replace('(<p class="spip">)?[[:space:]]*@@SPIP_debut_intertitre_3@@', $debut_intertitre_3, $letexte);
	$letexte = ereg_replace('@@SPIP_fin_intertitre_3@@[[:space:]]*(</p>)?', $fin_intertitre_3, $letexte);
	
	$cherche1 = array(
		/* 15 */ 	"/\[\//",
		/* 16 */	"/\/\]/",
	//	/* 17 */ 	"/\[\|/",
	//	/* 18 */	"/\|\]/",
		/* 19 */ 	"/\[\(/",
		/* 20 */	"/\)\]/",
		/* 21 */ 	"/\[\*/",
		/* 22 */	"/\*\]/",
		/* 23 */ 	"/\[\^/",
		/* 24 */	"/\^\]/",
		/* 25 */    	"/<p class=\"spip\"><ul class=\"spip\">/",
		/* 26 */	"/<\/ul>( *)<\/p>/",
		/* 27 */    	"/<p class=\"spip\"><ol class=\"spip\">/",
		/* 28 */	"/<\/ol>( *)<\/p>/",
		/* 29 */    	"/<p class=\"spip\"><table class=\"spip\">/",
		/* 30 */	"/<\/table>( *)<\/p>/",
		/* 31 */    	"/<p class=\"spip\">( *)<div/",
		/* 32 */	"/<\/div>( *)<\/p>/",
		/* 33 */	"/<p class=\"spip\"><h([0-6])>/",
		/* 34 */	"/<\/h([0-6])>( *)<\/p>/",
		/* 35 */    	"/<table cellpadding=5 cellspacing=0 border=0 align=''> <tr><td align='center'> <div class='spip_documents'>/",
		/* 36 */    	"/<\/div> <\/td><\/tr> <\/table>/",
		/* 37 */    	"/<p class=\"spip\"><div/",
		/* 38 */    	"/<p class=\"spip\"><blockquote class=\"spip\">/",
		/* 39 */    	"/<\/blockquote>( *)<\/p>/",
	);
	$remplace1 = array(
		/* 15 */ 	"</p>\n<div style=\"text-align:right;\">",
		/* 16 */	"</div>\n<p@>",
	//	/* 17 */ 	"</p>\n<div style=\"text-align:center;\">",
	//	/* 18 */	"</div>\n<p@>",
		/* 19 */ 	"</p>\n<div class=\"texteencadre-spip\">",
		/* 20 */	"</div>\n<p@>",
		/* 21 */ 	"<span class=\"caractencadre-spip\">",
		/* 22 */	"</span>",
		/* 23 */ 	"<sup>",
		/* 24 */	"</sup>",
		/* 25 */	"<ul class=\"spip\">",
		/* 26 */	"</ul>",			
		/* 27 */	"<ol class=\"spip\">",
		/* 28 */	"</ol>",			
		/* 29 */	"<table class=\"spip\">",
		/* 30 */	"</table>",			
		/* 31 */	"<div",
		/* 32 */	"</div>",			
		/* 33 */	"<h$1>",
		/* 34 */	"</h$1>",
		/* 35 */	"<div class='spip_documents'>",
		/* 36 */	"</div>",			
		/* 37 */	"<div",
		/* 38 */    	"<blockquote class=\"spip\"><p class=\"spip\">",
		/* 39 */    	"</p></blockquote>",
	);
	

	$letexte = preg_replace($cherche1, $remplace1, $letexte);
    
	/** jpyrat
	**/

	// Reinserer les echappements
	$letexte = echappe_retour($letexte, $les_echap, "SOURCEPROPRE");
	
	// Rajoute un <p> autour d'un simple paragraphe
	$letexte = trim($letexte);
    if($letexte!="") {
        if(substr($letexte, 0, 2)!="<p") {
            $letexte = "<p>" . $letexte;
        }
        if(substr($letexte, strlen($letexte)-4, 4)!="</p>") {
            $letexte .= "</p>";
        }
    }
	
	// Paragrapher
	if (preg_match(',<p@?>,', $letexte)) {
		$letexte = '<p>'.preg_replace(',<p( [^>]*)?>,', "</p>\n<p\\1>", $letexte).'</p>';
		$letexte = preg_replace(',</p>(\s*</p>)+,', '</p>', $letexte);
		$letexte = preg_replace(',<p@?>\s*<p( [^>]*)?>,', '<p\\1>', $letexte);
		$letexte = preg_replace(',<p@?>\s*</p>\s*,', "\n", $letexte);
		$letexte = preg_replace(',<p@?>,', "\n<p class=\"spip\" dir=\"$lang_dir\">", $letexte);
		$letexte = preg_replace(',<p( [^>]*)?><tt>,', "\n<tt>", $letexte);
		$letexte = preg_replace(',</tt>( )*</p>,', "\n</tt>", $letexte);
        
        $letexte = preg_replace(',<p([^>]*)><ul([^>]*)>,', "\n<ul \\2>", $letexte);
        $letexte = preg_replace(',</ul>( )*</p>,', "\n</ul>", $letexte);
        $letexte = preg_replace(',<p([^>]*)><ol([^>]*)>,', "\n<ol \\2>", $letexte);
        $letexte = preg_replace(',</ol>( )*</p>,', "\n</ol>", $letexte);
        
        $letexte = preg_replace (',<p([^>]*)><div([^>]*)>,', "\n<div \\2>",$letexte);
        $letexte = preg_replace(',</div>( )*</p>,', "\n</div>", $letexte);
        
        $letexte = preg_replace(',</table>( )*</p>,', "\n</table>", $letexte);
        
	}

	if ($mes_notes) {
		$mes_notes = traiter_raccourcis($mes_notes, $les_echap, 'non');
		if (ereg('<p class="spip">',$mes_notes))
			$mes_notes = ereg_replace('<p class="spip">', '<p class="spip_note">', $mes_notes);
		else
			/* Dbut modification tbeaumanoir@clever-age.com */
			$mes_notes = '<div class="spip_note">'.$mes_notes."</div>\n";
			/* Fin modification tbeaumanoir@clever-age.com */
		$mes_notes = echappe_retour($mes_notes, $les_echap, "SOURCEPROPRE");
		$les_notes .= interdire_scripts($mes_notes);
	}
	
	// Appeler la fonction de post-traitement
    $letexte = spip_apres_propre ($letexte);

	return $letexte;
}


// Filtre a appliquer aux champs du type #TEXTE*
function propre($letexte) {
	return interdire_scripts(traiter_raccourcis(trim($letexte)));
//	$a=time(); $b=microtime();
//	interdire_scripts(traiter_raccourcis(trim($letexte)));
//	return time()-$a + microtime()-$b;
}


function textToId($text, $idArray)
{
    include_once("inc_charsets.php3");
    $motsMuets = array(
        ' s ',
        ' l ',
        ' d ',
        ' c ',
        ' le ',
        ' la ',
        //' les ', // Probleme rewrite rules sur rubrique 2 'Les articles'
        ' de ',
        ' des ',
        ' a ',
        ' et ',
        ' en ',
        '-',
        ' que ',
        ' qu ',
        ' ce ',
        ' ou '
        );
    $sys = $text;

    // Translit�ration et mise en minuscules
    $sys = strtolower(translitteration($sys, 'iso-8859-1'));

    // Suppression des num�ros en d�but de titre
    $sys = ereg_replace("^[0-9]+\. ", "", $sys);

    // Suppression des catact�res non alphanum�riques ou ., _, = et -
    $sys = ereg_replace("[^.a-z0-9_=-]+", " ", $sys);

    // Suppression des mots muets
    $sys = str_replace($motsMuets, ' ', ' '.$sys);

    // Remplacement des s�quences d'espaces par un unique _
    $sys = ereg_replace(" +", "_", trim($sys));

    // Raccourcissement des titres � 4 mots maximum
    $sys = ereg_replace("^([^_]+_){3}([^_]+)_.*$", "\\1\\2", $sys);

	if (in_array($sys, $idArray)) {
		$cpt = 1;
		while (in_array($sys.$cpt, $idArray)) {
			$cpt++;
		}
		$sys .= $cpt;
	}
	
    return $sys;
}

// Ajout Aurelien Vialet <avialet@clever-age.com>
function traiterGlossaire($texte) {
	$glossaire = &recuperer_instance_glossaire_services();
	$aGlossaire = $glossaire->loadAllGlossaire();
	if (is_array($aGlossaire)) {
		while (list($word, $val) = each($aGlossaire)) {
			//$mot = " ".$word." ";
			$replace = " <a href='".$val."' class='spip_glossaire' title=''>";
			$texte = preg_replace('`(.*?)('.$word.')(.*?)`si', '\\1<html>'.$replace.'\\2</a></html>\\3', $texte);
		}
	}
	return $texte;
}

function xhtml_highlight($code) {
	$str = highlight_string($code, true);
	$Color['html'] = '#000000';
	$Color['commentaires'] = '#FF8000';
	$Color['defaut'] = '#0000BB';
	$Color['keyword'] = '#007700';
	$Color['string'] = '#DD0000';
	$in = array(
		'`</?code>`i',
		'`<font color="' . ini_get('highlight.html') . '">(.+)</font>`si',
		'`<font color="' . ini_get('highlight.comment') . '">(.+?)</font>`si',
		'`<font color="' . ini_get('highlight.default') . '">(.+?)</font>`si',
		'`<font color="' . ini_get('highlight.keyword') . '">(.+?)</font>`si',
		'`<font color="' . ini_get('highlight.string') . '">(.+?)</font>`si',
		'` `si'
		);
		
	$out = array(
		'',
		'$1',
		'<span style="color:'.$Color['commentaires'].'">$1</span>',
		'<span style="color:'.$Color['defaut'].'">$1</span>',
		'<span style="color:'.$Color['keyword'].'">$1</span>',
		'<span style="color:'.$Color['string'].'">$1</span>',
		' '
		);
		
	$arr[] = preg_replace($in, $out, $str);
	return implode('', $arr);
}
?>