<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Action authorization
//

class Action {

	// {{{ properties
    
    /**
     * action Name.
     * @var     ActionName
     * @access  private
     */
    var $_actionName;
    
    /**
     * User.
     * @var     Auteur
     * @access  private
     */
    var $_user;
    
    /**
     * Parameters.
     * @var     Array
     * @access  private
     */
    var $_parameters;
    
    // }}}

	// {{{ getActionName()
   
   	/**
     * Get Action name
     * @access public
     * @return String
     */

    function getActionName() {
        return $this->_actionName;
    }

    // }}}

    // {{{ setActionName()

   /**
     * Set Action name
     * @param $actionName
     * @access public
     */

    function setActionName($actionName) {
        $this->_actionName = $actionName;
    }

    // }}}

	// {{{ getUser()
   
   	/**
     * Get User to be checked
     * @access public
     * @return Auteur
     */

    function getUser() {
        return $this->_user;
    }

    // }}}

    // {{{ setUser()

   /**
     * Set User to be checked
     * @param $user
     * @access public
     */

    function setUser($user) {
        $this->_user = $user;
    }

    // }}}

	// {{{ getParameters()
   
   	/**
     * Get Parameters used to check authorization
     * @access public
     * @return Array
     */

    function getParameters() {
        return $this->_parameters;
    }

    // }}}

    // {{{ setParameters()

   /**
     * Set Parameters used to check authorization
     * @param $parameters
     * @access public
     */

    function setParameters($parameters) {
        $this->_parameters = $parameters;
    }

    // }}}

    // {{{ factory($actionName, $user, $parameters)
    
    /**
     * Action Factory.
     *
     * @access public
     */
    function &factory($actionName, $user, $parameters) {

        // inclusion de mes_options.php3 ou le type_authorisation peut tre defini
        if (file_exists(dirname(__FILE__)."/../../mes_options.php3")) {
            include_once (dirname(__FILE__)."/../../mes_options.php3" );
        }

        if(!file_exists(dirname(__FILE__)."/".$GLOBALS['type_authorization']."/".$actionName."_".$GLOBALS['type_authorization'].".php")) {
            @include_once(dirname(__FILE__)."/common/".$actionName."_common.php");
            $classname = $actionName."_common";
        } else {
            @include_once(dirname(__FILE__)."/".$GLOBALS['type_authorization']."/".$actionName."_".$GLOBALS['type_authorization'].".php");
            $classname = $actionName."_".$GLOBALS['type_authorization'];            
        }

        // rien trouv ? on va tenter dans les modules
        if (!class_exists($classname)) {
            
            if (is_array ($GLOBALS['modules']) ) {
                foreach ($GLOBALS['modules'] as $module) {
                    if (file_exists(dirname(__FILE__)."/../../modules/".$module."/authorization/".$actionName."_".$module.".php" )) {
                        include_once (dirname(__FILE__)."/../../modules/".$module."/authorization/".$actionName."_".$module.".php");
                        $classname = $actionName.'_'.$module;
                        break;
                    }
                }
            }
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }
		
        $obj = & new $classname($actionName, $user, $parameters);
        
        //var_dump($obj);
        
        return $obj;

    }

    // }}}

    // {{{ constructor

    /**
     * Action constructor.
     *
     * @access public
     */

    function Action($actionName, $user, $parameters) {
    	$this->_actionName = $actionName;
    	$this->_user = $user;
    	$this->_parameters = $parameters;
    }

    // }}}
    
    // {{{ isAuthorizedAction()

    /**
     * Get if a user is authorized to access to a command
     * @param $idUser
     * @param $parameters
     * @access public
     * @return bool
     */

    function isAuthorizedAction() {
    	//Test que le profil de l'utilisateur est suffisant pour effectuer l'action
		if (is_null($this->_user)) return false;
		//echo '---->'.$GLOBALS["auth_".$this->_user->getProfil()][$this->_actionName].'<--';
		if (is_null($GLOBALS["auth_".$this->_user->getProfil()][$this->_actionName])) {
			// peut etre le fichier d'authorisation n'existe pas ou n'est pas inclus ! 
			include_once (dirname(__FILE__)."/../../authorization.php");
			create_auth($this->_user->getProfil());
		}
        
		
		if (!$GLOBALS["auth_".$this->_user->getProfil()][$this->_actionName] ) {
			return false;
		}
		else {
			return $this->_isAuthorized();
		}
	}

    // }}}    
    
    
    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
    	return true;
    }

    // }}}


    // {{{
    
    /**
    * @author olivier
    * @access public
    * @return bool si l'auteur a acces  la rubrique
    **/
    
    function cacheAllowsRubrique($idRubrique)
    {
    	/*
        if (isset($_SESSION['AgoraRubriquesCache'][$rubriqueId])) {
			return ($_SESSION['AgoraRubriquesCache'][$rubriqueId] == $rubriqueId);
    	}
    	else 
    		return false;
        */    
        if ($GLOBALS['connect_id_auteur'] != $this->_user->getAuteurId() ) {
        	    // sur cette partie du code, on a pas le cache des rubriques en session
        	    $rubriqueMetier = &recuperer_instance_rubrique();
        	    return $rubriqueMetier->isManagedByAuteurId($idRubrique, $this->_user->getAuteurId());
        	}
        if (isset($_SESSION['AgoraRubriquesCache'][$idRubrique])) {
            //ok, we know the answer
            return ($_SESSION['AgoraRubriquesCache'][$idRubrique] != 0);
        }
        else {
            //we don't know the answer 'cause the cache
            //is apparently no longer up-to-date
            $rubriqueMetier = &recuperer_instance_rubrique();
            return ($rubriqueMetier->updateAgoraCacheForId($this->_user->getAuteurId(), $idRubrique));
        }
	}
    
    // }}}

}

?>