<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Stephane PETIT                                    |
// +----------------------------------------------------------------------+
// | Author: Stephane PETIT <stephane@petit-fr.net>                       |
// +----------------------------------------------------------------------+
//
// Base class for ListeAction authorization
//

class ListeAction {
    
    // {{{ properties

    /**
     * action DataBase.
     * @var     ActionDB
     * @access  private
     */
    var $_actionDB;

    // }}}

    // {{{ factory()
    
    /**
     * ListeAction Factory.
     *
     * @access public
     */
    function &factory() {
        $obj = &new ListeAction() ;
        return $obj;
    }

    // }}}

    // {{{ constructor

    /**
     * ListeAction constructor.
     *
     * @access public
     */

    function ListeAction() {
       $actiondb = array() ;
       include_once(dirname(__FILE__)."/common/ActionDB_common.php") ;
        if(file_exists(dirname(__FILE__)."/".$GLOBALS['type_authorization']."/ActionDB_".$GLOBALS['type_authorization'].".php")) {
        include_once(dirname(__FILE__)."/".$GLOBALS['type_authorization']."/ActionDB_".$GLOBALS['type_authorization'].".php");
       }
       
       // je vais aussi chercher dans les modules
        if (file_exists(dirname(__FILE__). '/../../mes_options.php3' )) {
            include_once (dirname(__FILE__). '/../../mes_options.php3');
        }
        if (is_array ($GLOBALS['modules']) ) {
            foreach ($GLOBALS['modules'] as $module) {
                if (file_exists(dirname(__FILE__)."/../../modules/".$module."/authorization/ActionDB_".$module.".php" )) {
                    include_once (dirname(__FILE__)."/../../modules/".$module."/authorization/ActionDB_".$module.".php" );
                }
            }
        }
     
       
       $this->_actionDB = $actiondb ;
    }

    // }}}
    
    // {{{ getActionForProfilisTrue($poids)

    /**
     * Get list of actions user is authorized to access to
     * @param $poids
     * @access public
     * @return array
     */

    function getActionForProfilisTrue($poids) {
        reset ( $this->_actionDB ) ;
        while (list($key, $val) = each($this->_actionDB)) {
    	   if ( $val<= $poids ) $trueactions[] = array ( 'action'=>$key, 'poids'=>$val ) ;
    	}
        return $trueactions ;
    }

    // }}}    
    
    
    // {{{ getActionForProfilisFalse($poids)

    /**
     * Get list of actions user is not authorized to access to
     * @param $poids
     * @access public
     * @return array
     */

    function getActionForProfilisFalse($poids) {
    	reset ( $this->_actionDB ) ;
        while (list($key, $val) = each($this->_actionDB)) {
    	   if ( $val > $poids ) $falseactions[] = array ( 'action'=>$key, 'poids'=>$val ) ;
    	}
        return $falseactions ;
    }

    // }}}

}

?>
