<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Matthieu Belge <mbelge@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Authorization abstraction.
//

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/trivial_authorization.php";

// {{{ authorization:: class

/**
 * AbstractAuthorizationManager is a base class for authorization abstraction manager, and must be
 * inherited by all such.
 *
 * @package	authorizarion
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

// }}}
class AbstractAuthorizationManager {
    // {{{ properties
    
    // }}}

    // {{{ factory()
    function &factory() {
    	$obj = &new TrivialAuthorizationManager();
    	return $obj;
    }

    // }}}

    // {{{ constructor

    /**
     * AbstractAuthorizationManager constructor.
     *
     * @access public
     */

    function AbstractAuthorizationManager() {
    }

    // }}}
    
    // {{{ getAllProfiles()

    /**
     * Get all the available profiles into an array
     * @access public
     * @return array
     */

    function getAllProfiles() {
    }

    // }}}

    // {{{ isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @param $idUser
     * @param $command
     * @param $parameters
     * @access public
     * @return bool
     */

    function isAuthorized($idUser, $command, $parameters = null) {
    }

    // }}}

}
?>