<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "afficherSelectBreveStatut   ".
//

if (defined("_AUTHORIZATION_AFFICHER_SELECT_BREVE_STATUT_COMMON")) return;
define("_AUTHORIZATION_AFFICHER_SELECT_BREVE_STATUT_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_breve_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");

/**
 * afficherSelectBreveStatut   is an implementation for Common of "afficherSelectBreveStatut   Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class afficherSelectBreveStatut_common extends Action {
  // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
        
        $breveMetier = &recuperer_instance_breve();
        $loadOK = $breveMetier->load($this->_parameters['id_breve']);
        if(PEAR::isError($loadOK)) {
            return false;
        }
        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
        if(PEAR::isError($monProfil)) {
            die($monProfil->getMessage());
        }
        if($breveMetier->getStatut() !='prop' and $profilMetier->getPoids() == $this->_user->getProfil()) return false;
        else return true;
        
    }

    // }}}
}

?>