<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "afficherSelectProfilAuteurPossible".
//

if (defined("_AUTHORIZATION_AFFICHER_SELECT_AUTEUR_POSSIBLE_COMMON")) return;
define("_AUTHORIZATION_AFFICHER_SELECT_AUTEUR_POSSIBLE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");

/**
 * afficherSelectProfilAuteurPossible is an implementation for Common of "afficherSelectProfilAuteurPossible" Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class afficherSelectProfilAuteurPossible_common extends Action {
    
    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
    	
        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule($this->_parameters['intitule']);
        if(PEAR::isError($monProfil)) {
            die($monProfil->getMessage());
        }
        $monProfil2 = $profilMetier->getProfilForIntitule('item_administrateur');
        return ($this->_user->getProfil() > $monProfil->getPoids() OR ($this->_user->getProfil() == $monProfil2->getPoids()));

    }
    
    // }}}
}

?>