<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "afficherSelectProfilAuteur".
//

if (defined("_AUTHORIZATION_SELECT_PROFIL_AUTEUR_COMMON")) return;
define("_AUTHORIZATION_SELECT_PROFIL_AUTEUR_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");

/**
 * afficherSelectProfilAuteur is an implementation for Common of "afficherSelectProfilAuteur" Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class afficherSelectProfilAuteur_common extends Action {
    
    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
	
		$profilMetier = &recuperer_instance_profil();
		$monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
		if(PEAR::isError($monProfil)) {
		    die($monProfil->getMessage());
		}
		$authorization = &recuperer_instance_authorization('isAuthorizedToManageAuteur', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
		return( ( ( $authorization->isAuthorizedAction() AND $this->_parameters['profil'] < $this->_user->getProfil() ) OR $this->_user->getProfil() == $monProfil->getPoids()) AND $this->_user->getAuteurId() != $this->_parameters['id_auteur'] );
	
	}


    // }}} 
    
    
}

?>