<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "changerStatutMessage".
//

if (defined("_AUTHORIZATION_CHANGER_STATUT_MESSAGE_COMMON")) return;
define("_AUTHORIZATION_CHANGER_STATUT_MESSAGE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_rubrique_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_forum_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_breve_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_article_factory.php");

/**
 * changerStatutMessage   is an implementation for Common of "changerStatutMessage    Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class changerStatutMessage_common extends Action {
    
        // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {

                //Recuperation du type de forum
                $forumMetier = &recuperer_instance_forum();
                $loadOK = $forumMetier->load($this->_parameters['id_forum']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }

                if($forumMetier->getArticleId())    $typeForum = 'article';
                if($forumMetier->getBreveId())    $typeForum = 'breve';
                if($forumMetier->getRubriqueId())    $typeForum = 'rubrique';

                switch($typeForum) {
                    case 'article':
                
                        //verification si l'auteur peut acceder a la rubrique contenant l'article
                        $articleMetier = &recuperer_instance_article();
                        $loadOK = $articleMetier->load($forumMetier->getArticleId());
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        //$accesOK = $rubriqueMetier->isManagedByAuteurId($articleMetier->getRubriqueId(), $this->_user->getAuteurId());
                        $accesOK = $this->cacheAllowsRubrique($articleMetier->getRubriqueId());
                    break;
                    case 'rubrique':
                        //verification si l'auteur peut acceder a la rubrique
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        // $accesOK = $rubriqueMetier->isManagedByAuteurId($forumMetier->getRubriqueId(), $this->_user->getAuteurId());
                        $accesOK = $this->cacheAllowsRubrique($forumMetier->getRubriqueId());
                    break;
                    case 'breve':
                        //verification si l'auteur peut acceder a la rubrique contenant la breve
                        $breveMetier = &recuperer_instance_breve();
                        $loadOK = $breveMetier->load($forumMetier->getBreveId());
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        // $accesOK = $rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $this->_user->getAuteurId());
                        $accesOK = $this->cacheAllowsRubrique($breveMetier->getRubriqueId());
                    break;
                    default:
                        $accesOK = false;
                    break;
                }

                if($accesOK) {
                	switch($this->_parameters['statut']) {
                        case 'publie':
                            $authorization = &recuperer_instance_authorization('publierMessage', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
                            return $authorization->isAuthorizedAction();
                        break;
                        case 'off':
                            $authorization = &recuperer_instance_authorization('refuserMessage', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
                            return $authorization->isAuthorizedAction();
                        break;
                        case 'poubelle':
                            $authorization = &recuperer_instance_authorization('mettrePoubelleMessage', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
                            return $authorization->isAuthorizedAction();
                        break;
                        default:
                            return false;
                        break;
                    }
                }
                else {
                    return false;
                }
       }


    // }}} 
    
    
}

?>