<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "controlerForum2          ".
//

if (defined("_AUTHORIZATION_CONTROLER_FORUM_2_COMMON")) return;
define("_AUTHORIZATION_CONTROLER_FORUM_2_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_rubrique_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_breve_factory.php");

/**
 * controlerForum2   is an implementation for Common of "controlerForum2    Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class controlerForum2_common extends Action {
    
        // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
               global $connect_toutes_rubriques;
                if($connect_toutes_rubriques) return true;

                switch($this->_parameters['type_forum']) {
                    case 'article':
                        //verification si l'auteur peut acceder a la rubrique contenant l'article
                        $articleMetier = &recuperer_instance_article();
                        $loadOK = $articleMetier->load($this->_parameters['id_current_forum']);
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        // return $rubriqueMetier->isManagedByAuteurId($articleMetier->getRubriqueId(), $auteurMetier->getAuteurId());
                        return $this->cacheAllowsRubrique($articleMetier->getRubriqueId());
                    break;
                    case 'rubrique':
                        //verification si l'auteur peut acceder a la rubrique
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        return $rubriqueMetier->isManagedByAuteurId($parameters['id_current_forum'], $auteurMetier->getAuteurId());
                        // return $this->cacheAllowsRubrique($articleMetier->getRubriqueId()); gasp !
                    break;
                    case 'breve':
                        //verification si l'auteur peut acceder a la rubrique contenant la breve
                        $breveMetier = &recuperer_instance_breve();
                        $loadOK = $breveMetier->load($parameters['id_current_forum']);
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        // return $rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $auteurMetier->getAuteurId());
                        return $this->cacheAllowsRubrique($breveMetier->getRubriqueId());
                    break;
                    default:
                        return false;
                    break;
                }

       }


    // }}} 
    
    
}

?>