<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "creerBreve".
//

if (defined("_AUTHORIZATION_CREER_BREVE_COMMON")) return;
define("_AUTHORIZATION_CREER_BREVE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_rubrique_factory.php");

/**
 * creerBreve is an implementation for Common of "creerBreve" Action.
 * @package	authorization/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class creerBreve_common extends Action {

    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
		
		$rubriqueMetier = &recuperer_instance_rubrique();
		$secteurs = $rubriqueMetier->getAllSecteurs();
		if (PEAR::isError($secteurs)) {
		    die($secteurs->getMessage());
		}
		while (list(, $secteur) = each($secteurs)) {
		    $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $this->_user->getAuteurId(), array('rubriqueId' => $secteur->getRubriqueId()));
		    if ($authorization->isAuthorizedAction()) return true;
		}
		return false;
		
    }

    // }}}
    
}

?>