<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>            |
// +----------------------------------------------------------------------+
//
// Base class for Action "gererMotCleAuteur".
//

if (defined("_AUTHORIZATION_GERER_MOT_CLE_AUTEUR_COMMON")) return;
define("_AUTHORIZATION_GERER_MOT_CLE_AUTEUR_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_auteur_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");

/**
 * gererMotCleAuteur  is an implementation for Common of "gererMotCleAuteur" Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class gererMotCleAuteur_common extends Action {

	// {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
    	
		$monAuteur = &recuperer_instance_auteur();
	    $loadOK = $monAuteur->load($this->_parameters['id_auteur']);
	    if(PEAR::isError($loadOK)) {
	        die($loadOK->getMessage());
	    }
	    $profilMetier = &recuperer_instance_profil();
	    $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
	    $authorization = &recuperer_instance_authorization('isAuthorizedToManageAuteur', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
		return ( ( $authorization->isAuthorizedAction() AND $monAuteur->getProfil() < $this->_user->getProfil() ) OR $this->_user->getProfil() == $monProfil->getPoids());
		
    }
    
    // }}}
}

?>