<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "isAuthorizedToManageAuteur       ".
//

// $Id$

require_once (dirname(__FILE__)."/../Action.php");
require_once (dirname(__FILE__)."/../../bd/inc_auteur_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_rubrique_factory.php");

/**
 * isAuthorizedToManageAuteur is an implementation for Common of "isAuthorizedToManageAuteur  Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class isAuthorizedToManageAuteur_common extends Action {

    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */
     
     function _isAuthorized() {
		
		$rubriqueMetier = &recuperer_instance_rubrique();
		$monAuteur = &recuperer_instance_auteur();
		if($this->_parameters['id_auteur_slave'] == 0) return true;
		$loadOK = $monAuteur->load($this->_parameters['id_auteur_slave']);
		if(PEAR::isError($loadOK)) {
		    die($loadOK->getMessage());
		}
		return ($rubriqueMetier->isAuthorizedToManageAuteur($this->_user->getAuteurId(), $this->_parameters['id_auteur_slave']));
		
	}

	// }}}
}

?>