<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Francois Xavier LACROIX <fxlacroix@clever-age.com>            |
// +----------------------------------------------------------------------+
//
// Base class for Action "modifierArticle".
//

// $Id$

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_article_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");

/**
 * modifierArticle   is an implementation for Common of "modifierArticle   Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */

class modifierArticle_common extends Action {
    
	// {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
        $articleMetier = &recuperer_instance_article();
        $loadOK = $articleMetier->load($this->_parameters['id_article']);
        if(PEAR::isError($loadOK)) {
            echo $loadOK->getMessage();
            return false;
        }

		$profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
        if(PEAR::isError($monProfil)) {
            die($monProfil->getMessage());
        }
        // un redacteur ne peut modifier un article qu'en cours de rdaction et lui appartenant
        if ($this->_user->getProfil() == $monProfil->getPoids()) {
            if($articleMetier->getStatut() != 'prepa') return false; 
            if (!in_array ($this->_user->getAuteurId() , $articleMetier->getAuteurIdsForArticleId($this->_parameters['id_article']) ) ) return false; 
        }
        // le cas du redacteur en chef 
        $monProfil = $profilMetier->getProfilForIntitule('item_redacteur_en_chef');
        if($this->_user->getProfil() == $monProfil->getPoids() AND $articleMetier->getStatut() != 'prepa' AND $articleMetier->getStatut() != 'prop' AND $articleMetier->getStatut() != 'vali' AND $articleMetier->getStatut() != 'refuse') return false;

        
        // on a passe tous les cas faux donc on teste juste l'authorisation sur la rubrique
        $authorization = & recuperer_instance_authorization('isManagedRubriqueByAuteurId', $this->_user->getAuteurId(), array ('rubriqueId' => intval($articleMetier->getRubriqueId())));
        return $authorization->isAuthorizedAction();

    }

    // }}} 
    
}