<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "modifierBreve ".
//

if (defined("_AUTHORIZATION_MODIFIER_BREVE_COMMON")) return;
define("_AUTHORIZATION_MODIFIER_BREVE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_profil_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_rubrique_factory.php");
require_once (dirname(__FILE__)."/../../bd/inc_breve_factory.php");

/**
 * modifierBreve  is an implementation for Common of "modifierBreve " Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class modifierBreve_common extends Action {
    
	// {{{ _isAuthorized()

	/**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
		$breveMetier = &recuperer_instance_breve();
        $loadOK = $breveMetier->load($this->_parameters['id_breve']);
        if(PEAR::isError($loadOK)) {
            echo $loadOK->getMessage();
            return false;
        }

        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
        if(PEAR::isError($monProfil)) {
            die($monProfil->getMessage());
        }
        if($this->_user->getProfil() == $monProfil->getPoids() AND ($breveMetier->getStatut() == 'publie' OR  $breveMetier->getStatut() == 'refuse'))  return false;
        
        $rubriqueMetier = &recuperer_instance_rubrique();
        // return ($rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $this->_user->getAuteurId()));
        return $this->cacheAllowsRubrique($breveMetier->getRubriqueId());
    }
    
    // }}}
    
}

?>