<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "refuserBreve".
//

if (defined("_AUTHORIZATION_REFUSER_BREVE_COMMON")) return;
define("_AUTHORIZATION_REFUSER_BREVE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";
require_once (dirname(__FILE__)."/../../bd/inc_breve_factory.php");

/**
 * refuserBreve is an implementation for Common of "refuserBreve" Action.
 * @package	authorization/common
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class refuserBreve_common extends Action {

    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
		
        $breveMetier = &recuperer_instance_breve();
        $loadOK = $breveMetier->load($this->_parameters['id_breve']);
        if(PEAR::isError($loadOK)) {
            echo $loadOK->getMessage();
            return false;
        }
        $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $this->_user->getAuteurId(), array('rubriqueId' => $breveMetier->getRubriqueId()));
        return ( ($this->_parameters['statut']=='prop' or $this->_parameters['statut']=='publie' or $this->_parameters['statut']=='prepa') and $authorization->isAuthorizedAction());
		
    }

    // }}}
    
}

?>