<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author:Franois Xavier LACROIX <fxlacroix@clever-age.com>                 |
// +----------------------------------------------------------------------+
//
// Base class for Action "supprimerLienAuteurRubrique           ".
//

if (defined("_AUTHORIZATION_SUPPRIMER_LIEN_AUTEUR_RUBRIQUE_COMMON")) return;
define("_AUTHORIZATION_SUPPRIMER_LIEN_AUTEUR_RUBRIQUE_COMMON", "1");

require_once dirname(__FILE__)."/../Action.php";


/**
 * supprimerLienAuteurRubrique    is an implementation for Common of "supprimerLienAuteurRubrique     Action.
 * @package	authorization/common
 * @author 	Franois Xavier LACROIX <fxlacroix@clever-age.com>
 * @access	public
 */
class supprimerLienAuteurRubrique_common extends Action {
    
    // {{{ _isAuthorized()

    /**
     * Get if a user is authorized to access to a command
     * @access private
     * @return bool
     */

    function _isAuthorized() {
        
        // suis je un admin ? 
        $profilMetier = &recuperer_instance_profil();
        $profilMetier->load($this->_parameters['profil']);
        if ($profilMetier->getIntitule() == 'item_administrateur') return true;
    
        $authorization = &recuperer_instance_authorization('isAuthorizedToManageAuteur', $this->_user->getAuteurId(), array('id_auteur_slave' => $this->_parameters['id_auteur']));
        return ($authorization->isAuthorizedAction() AND $this->_user->getAuteurId() != $this->_parameters['id_auteur'] AND $this->_parameters['profil'] < $this->_user->getProfil() );

       }


    // }}} 
    
    
}

?>