<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Matthieu Belge <mbelge@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Trivial class for Authorization abstraction.
//

require_once "PEAR.php";
require_once "DB.php";
require_once (dirname(__FILE__)."/../bd/inc_action_factory.php");
require_once (dirname(__FILE__)."/../bd/inc_profil_factory.php");
require_once (dirname(__FILE__)."/../bd/inc_forum_factory.php");

/**
 * TrivialAuthorizationManager is a simple class for authorization abstraction manager
 * @package	authorizarion
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class TrivialAuthorizationManager extends AbstractAuthorizationManager {
    // {{{ properties

    // }}}

    // {{{ constructor

    /**
     * TrivialAuthorizationManager constructor.
     *
     * @access public
     */

    function TrivialAuthorizationManager() {
    }

    // }}}

    // {{{ getAllProfiles()

    /**
     * Get all the available profiles into an array
     * @access public
     * @return array
     */

    function getAllProfiles() {
    	/*
    	return array(
    			array('1','item_redacteur','comite'),
    			array('2','item_correspondant','comite'),
    			array('4','item_administrateur_local','minirezo'),
    			array('8','item_administrateur_global','minirezo'),
    			array('0','texte_statut_poubelle','5poubelle')
    		);
        */

        /*
        return array(
    			array('1','item_redacteur','comite'),
    			array('2','item_redacteur_en_chef','comite'),
    			array('4','item_webmestre','minirezo'),
    			array('8','item_administrateur','minirezo'),
    			array('0','texte_statut_poubelle','5poubelle')
        );
        */


        $profilMetier = &recuperer_instance_profil();
        $allProfils = $profilMetier->getAllProfils();
        if(PEAR::isError($allProfils)) {
            die($allProfils->getMessage());
        }
        return($allProfils);
    }

    // }}}

    // {{{ isAuthorized()

    /**
     * Returns true if a user is authorized to access to a command,
     * false otherwise. Certain commands need the parameters, so
     * be careful.
     * @param $idUser
     * @param $action
     * @param $parameters
     * @access public
     * @return bool
     */
    function isAuthorized($idUser, $action, $parameters = null) {
        global $connect_id_rubrique, $connect_id_auteur;
		
        //Recuperation du profil de l'auteur 
		$profil = $GLOBALS['auteur_session']['profil'];
		
		
        switch ($action) {
			case 'isManagedRubriqueByAuteurId':
                if ($parameters['rubriqueId'] == null) 
                	return true;
                $idRubrique = $parameters['rubriqueId'];
                
				//XXX Pourquoi ca:
                if( !isset($_SESSION['AgoraRubriquesCache']) )
					return true;
					
				if (isset($_SESSION['AgoraRubriquesCache'][$idRubrique])) {
					//ok, we know the answer
					return ($_SESSION['AgoraRubriquesCache'][$idRubrique] != 0);
				}
				else {
					//we don't know the answer 'cause the cache
					//is apparently no longer up-to-date
	                $rubriqueMetier = &recuperer_instance_rubrique();
                	return ($rubriqueMetier->updateAgoraCacheForId($idUser, $idRubrique));
				}
			break;
            
			//naviguer.php3
            case 'editerContenuRubrique':
                $authorization = &recuperer_instance_authorization();
                return (($authorization->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $parameters['id_parent']))) 
                		OR ($authorization->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $parameters['coll']))));
            break;
            case 'supprimerRubrique':
                $authorization = &recuperer_instance_authorization();
                return ($authorization->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $parameters['supp_rubrique'])));
            break;

            //auteur.php
            case 'afficherAuteursVisiteurs':
                return ($parameters['visiteurs'] == 'oui');
            break;
            case 'afficherAuteurs':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return ($profil != $monProfil->getPoids());
            break;

            case 'afficherNombreArticle':
                return $GLOBALS["auth_$profil"]['afficherNombreArticle'];
            break;
            case 'afficherAdminRestreint':
                return $GLOBALS["auth_$profil"]['afficherAdminRestreint'];
            break;

            //auteurs.php3
            case 'isAuthorizedToManageAuteur':
                $rubriqueMetier = &recuperer_instance_rubrique();
                $monAuteur = &recuperer_instance_auteur();
                if($parameters['id_auteur_slave'] == 0) return true;
                $loadOK = $monAuteur->load($parameters['id_auteur_slave']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                return ($rubriqueMetier->isAuthorizedToManageAuteur($idUser, $parameters['id_auteur_slave']));
            break;

            case 'modifierAuteur':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return( ( $this->isAuthorized($idUser, 'isAuthorizedToManageAuteur', array('id_auteur_slave' => $parameters['id_auteur'])) AND $parameters['auteurProfil'] < $profil AND $parameters['nouveauAuteurProfil'] < $profil) OR $idUser == $parameters['id_auteur'] OR $profil == $monProfil->getPoids());
            break;

            case 'afficherSelectProfilAuteur':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return( ( ( $this->isAuthorized($idUser, 'isAuthorizedToManageAuteur', array('id_auteur_slave' => $parameters['id_auteur'])) AND $parameters['profil'] < $profil ) OR $profil == $monProfil->getPoids())   AND $idUser != $parameters['id_auteur'] );
            break;

            case 'afficherSelectProfilAuteurPossible':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule($parameters['intitule']);
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                $monProfil2 = $profilMetier->getProfilForIntitule('item_administrateur');
                return ($profil > $monProfil->getPoids() OR ($profil == $monProfil2->getPoids()));
            break;

            case 'afficherEmailAuteur':
                return $GLOBALS["auth_$profil"]['afficherEmailAuteur'];
            break;

            case 'modifierEmailAuteur':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return ($profil == $monProfil->getPoids() OR $parameters['new'] == 'oui' OR $parameters['creation'] == 'oui');
            break;

            case 'afficherLoginMdp':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return ($profil == $monProfil->getPoids() OR $parameters['new'] == 'oui' OR $parameters['creation'] == 'oui');
            break;

            case 'supprimerLienAuteurRubrique':
	            return ($this->isAuthorized($idUser, 'isAuthorizedToManageAuteur', array('id_auteur_slave' => $parameters['id_auteur'])) AND $idUser != $parameters['id_auteur'] AND $parameters['profil'] < $profil );
            break;

            case 'ajouterLienAuteurRubrique':
                return ($this->isAuthorized($idUser, 'isAuthorizedToManageAuteur', array('id_auteur_slave' => $parameters['id_auteur'])) AND $idUser != $parameters['id_auteur'] AND $parameters['profil'] < $profil );
            break;

            case 'InsererAuteursCSV':
                return $GLOBALS["auth_$profil"]['InsererAuteursCSV'];
            break;

            case 'afficherBoiteIconeGestionAuteurs':
                return $GLOBALS["auth_$profil"]['afficherBoiteIconeGestionAuteurs'];
            break;

            case 'afficherInfoGaucheAuteursExterieur':
                return $GLOBALS["auth_$profil"]['afficherInfoGaucheAuteursExterieur'];
            break;

            case 'afficherOngletAuteur':
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                return ($profil >= $monProfil->getPoids() OR $idUser == $parameters['id_auteur']);
            break;

            //inc_presentation.php3
            case 'afficherImageRedacteur':
                return ($parameters['source'] == 'spip' AND !($parameters['pass'] AND $parameters['login']));
            break;
            case 'afficherSuiviPetition':
                return $GLOBALS["auth_$profil"]['afficherSuiviPetition'];
            break;
            case 'afficherIconeAdminSite':
				return $parameters['connect_toutes_rubriques'];
            break;
            case 'afficherIconeStatistique':
                return ($parameters['connect_toutes_rubriques']==false);
            break;
            case 'afficherIconeTousAuteur':
                return ($parameters['options'] == "avancees");
            break;
            case 'afficherSuiviForum':
                return $GLOBALS["auth_$profil"]['afficherSuiviForum'];
            break;

            case 'afficherAuteursConnectes':
                return ($parameters['activer_imessage'] != "non" AND ($parameters['connect_activer_imessage'] != "non" OR $GLOBALS["auth_$profil"]['afficherAuteursConnectes']));
            break;
            case 'afficherLienNouvelleAnnonce':
                return $GLOBALS["auth_$profil"]['afficherLienNouvelleAnnonce'];
            break;

            case 'annoncerNouvelleGenerale':
                return $GLOBALS["auth_$profil"]['afficherLienNouvelleAnnonce'];
            break;

            //inc_meta.php3
            case 'verifierDroitEcritureRepEcrire':
                return $GLOBALS["auth_$profil"]['afficherLienNouvelleAnnonce'];
            break;

            //spip_cookie.php3
            case 'forcerCookie':
                return $parameters['login'];
            break;

            //inc_auth.php3
            case 'recupererRubriqueAuteur':
				return $GLOBALS["auth_$profil"]['recupererRubriqueAuteur'];
            break;

            //controle_forum.php3,
            case 'controlerForum':
                global $connect_toutes_rubriques;
                if($connect_toutes_rubriques) return true;
                //verification si l'auteur peut acceder a la rubrique
                $rubriqueMetier = &recuperer_instance_rubrique();
                return $rubriqueMetier->isManagedByAuteurId($parameters['id_rubrique'], $idUser);
            break;


            //inc_mots.php3
            case 'gererMotCleAuteur':
                $monAuteur = &recuperer_instance_auteur();
                $loadOK = $monAuteur->load($parameters['id_auteur']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_administrateur');
                return( ( $this->isAuthorized($idUser, 'isAuthorizedToManageAuteur', array('id_auteur_slave' => $parameters['id_auteur'])) AND $monAuteur->getProfil() < $profil ) OR $profil == $monProfil->getPoids());
            break;

            case 'gererMotCleArticle':
                $monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
				if($GLOBALS["auth_$profil"]['gererMotCleArticle'] AND $this->cacheAllowsRubrique($monArticle->getRubriqueId()))
					return true;
				else 
					return false;
                /**GCH
				$profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                //if(!$monArticle->isAuthor($auteurMetier->getAuteurId())) return false;
                if( ( $monArticle->getStatut() == 'valid' OR $monArticle->getStatut() == 'publie' OR $monArticle->getStatut() == 'poubelle' OR $monArticle->getStatut() == 'refuse') AND $profil == $monProfil->getPoids()) return false;
                return true;
				**/
            break;


            //index.php3 rubrique_edit.php3
            case 'afficherIconeCreerSecteur':
                /**GCH
				$rubriqueMetier = &recuperer_instance_rubrique();
                $allRubriques = $rubriqueMetier->getRubriqueIdForAuteurIdExceptRoot($auteurMetier->getAuteurId());
                return (sizeOf($allRubriques) == 0);
				**/
				return $GLOBALS["auth_$profil"]['afficherIconeCreerSecteur'];
            break;

            //rubrique_edit.php3
            case 'creerRubrique':
                return $GLOBALS["auth_$profil"]['creerRubrique'];
            break;

            //index.php3
            case 'afficherIconeSupprimerCookie':
                return $GLOBALS["auth_$profil"]['afficherIconeSupprimerCookie'];
            break;

            case 'afficherForumPriveAdmin':
                return $GLOBALS["auth_$profil"]['afficherForumPriveAdmin'];
            break;
            case 'viderCache':
                return $GLOBALS["auth_$profil"]['viderCache'];
            break;

			//configuration.php3
            case 'configurerSite':
                return $GLOBALS["auth_$profil"]['configurerSite'];
            break;
            case 'adminStatId' :
            	return $GLOBALS["auth_$profil"]['adminStatId'];
            break;

            case 'activerCookie':
                return $GLOBALS["auth_$profil"]['activerCookie'];
            break;
            case 'afficherSiteProblematique':
                return $GLOBALS["auth_$profil"]['afficherSiteProblematique'];
            break;

            //rubrique_edit.php3
            case 'modifierRubrique':
                return $GLOBALS["auth_$profil"]['modifierRubrique'];
            break;

            //articles.php3
            case 'validerArticle':
                /**
				$monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                if($monArticle->getStatut() == 'prop') return true;
                if($monArticle->getStatut() == 'refuse') return true;
                if($monArticle->getStatut() == 'valid') return true;
                return false;
				**/
				return $GLOBALS["auth_$profil"]['validerArticle'];
            break;

            case 'publierArticle':
                /*
                $monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                if($monArticle->getStatut() != 'valid') return false;
                */
                return $GLOBALS["auth_$profil"]['publierArticle'];
            break;

            case 'archiverArticle':
                /*
                $monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                if($monArticle->getStatut() != 'valid') return false;
                */
                return $GLOBALS["auth_$profil"]['archiverArticle'];
            break;

            case 'jeterArticle':
                /*
                $monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                if($monArticle->getStatut() == 'prepa') return false;
                */
                return $GLOBALS["auth_$profil"]['jeterArticle'];
            break;

            case 'refuserArticle':
                $articleMetier = &recuperer_instance_article();
                $loadOK = $articleMetier->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
				/*
                if($monArticle->getStatut() == 'prepa') return false;
                */
				if($profil<4 AND in_array($connect_id_auteur,$articleMetier->getAuteurIdsForArticleId($parameters['id_article'])) AND $articleMetier->getStatut()=="refuse")
					return true;
				else
				    return $GLOBALS["auth_$profil"]['refuserArticle'];
            break;

            case 'modifierArticle':
            case 'modifierStatutArticle':
                $articleMetier = &recuperer_instance_article();
                $loadOK = $articleMetier->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                
                if (!$this->cacheAllowsRubrique($articleMetier->getRubriqueId()))
                	return false;

                if (!$GLOBALS["auth_$profil"]['modifierArticle'])
                	return false;
                
				$statutArt = $GLOBALS['refStatutArticle'][$articleMetier->getStatut()];
				//XXX Profil 4 hardcoded??
				if ($profil < 4 
				  AND in_array($connect_id_auteur,$articleMetier->getAuteurIdsForArticleId($parameters['id_article'])) 
				  AND ($GLOBALS["auth_$profil"]["$statutArt"] OR $articleMetier->getStatut()=="refuse")) {
					return true;
				}
				elseif ($profil>=4 AND $GLOBALS["auth_$profil"]["$statutArt"])	{
					return true;
				}
				else return false;
            break;

            case 'modifierDatePublicationArticle':
                $articleMetier = &recuperer_instance_article();
                $loadOK = $articleMetier->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                return $articleMetier->getStatut() == 'publie';
            break;


            case 'modifierDateAnterieurPublicationArticle':
                $articleMetier = &recuperer_instance_article();
                $loadOK = $articleMetier->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                return $articleMetier->getStatut() == 'publie';
            break;

            case 'ajouterAuteurArticle':
                return $GLOBALS["auth_$profil"]['ajouterAuteurArticle'];
            break;

            //mots_tous.php3
            case 'modifierMotCle':
                return ($GLOBALS["auth_$profil"]['modifierMotCle'] AND $this->authGroupProfils($profil,$parameters));
            break;
            case 'modifierGroupeMot':
				/**GCH
				 *
				 **/
				return ($GLOBALS["auth_$profil"]['modifierGroupeMot'] AND $this->authGroupProfils($profil,$parameters));
                /**
				return $GLOBALS["auth_$profil"]['modifierGroupeMot'];
				**/
            break;
            case 'supprimerMotCle':
                /**GCH
				$rubriqueMetier = &recuperer_instance_rubrique();
                $allRubriques = $rubriqueMetier->getRubriqueManagementForAuteurId($idUser);
                return (sizeOf($allRubriques) == 0);
				**/
				return ($GLOBALS["auth_$profil"]['supprimerMotCle'] AND $this->authGroupProfils($profil,$parameters));
            break;
            case 'supprimerGroupeMot':
                /**GCH
				$rubriqueMetier = &recuperer_instance_rubrique();
                $allRubriques = $rubriqueMetier->getRubriqueManagementForAuteurId($idUser);
                return (sizeOf($allRubriques) == 0);
				**/
				return ($GLOBALS["auth_$profil"]['supprimerGroupeMot'] AND $this->authGroupProfils($profil,$parameters));
            break;
            case 'creerMotCle':
                /**GCH
				return $GLOBALS["auth_$profil"]['creerMotCle'];
				**/
				return ($GLOBALS["auth_$profil"]['creerMotCle'] AND $this->authGroupProfils($profil,$parameters));           
            break;
            case 'creerGroupeMot':
                return $GLOBALS["auth_$profil"]['creerGroupeMot'];
            break;

            //breves_edit.php3
            case 'creerBreve':
                $rubriqueMetier = &recuperer_instance_rubrique();
                $secteurs = $rubriqueMetier->getAllSecteurs();
                if (PEAR::isError($secteurs)) {
                    die($secteurs->getMessage());
                }
                while (list(, $secteur) = each($secteurs)) {
                    if ($this->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $secteur->getRubriqueId()))) return true;
                }
                return false;
            break;
            case 'afficherDocumentsColonneBreve':
                return ($parameters['new'] != 'oui' AND ($GLOBALS["auth_$profil"]['afficherDocumentsColonneBreve'] OR $parameters['statut'] == 'prop'));
            break;
            case 'afficherFormulaireBreve':
                return ($GLOBALS["auth_$profil"]['afficherFormulaireBreve'] OR $parameters['statut'] == 'prop' OR $parameters['new'] == 'oui');
            break;
            case 'afficherSelectionStatutBreve':
                return (acces_rubrique($parameters['id_rubrique']));
            break;

            //breves.php3
            case 'definirStatutBreve':
                return $GLOBALS["auth_$profil"]['definirStatutBreve'];
            break;

            //breves_voir.php3
            case 'modificationDateBreve':
            	return ($GLOBALS["auth_$profil"]['modificationDateBreve'] AND $parameters['jour']);
            break;
            case 'flagEvaluationBreve':
                return (acces_rubrique($parameters['id_rubrique']) OR $parameters['statut'] == 'prop');
            break;
            case 'afficherBoiteLogoBreve':
                return (acces_rubrique($parameters['id_rubrique']) AND ($parameters['statut'] == 'prop' OR $parameters['statut'] == 'prepa'));
            break;
            case 'publierBreve':
                $breveMetier = &recuperer_instance_breve();
                $loadOK = $breveMetier->load($parameters['id_breve']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                return ( ($parameters['statut']=='prop' or $parameters['statut']=='prepa' or $parameters['statut']=='refuse') and $this->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $breveMetier->getRubriqueId())));
            break;

            case 'refuserBreve':
                $breveMetier = &recuperer_instance_breve();
                $loadOK = $breveMetier->load($parameters['id_breve']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                return ( ($parameters['statut']=='prop' or $parameters['statut']=='publie' or $parameters['statut']=='prepa') and $this->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $breveMetier->getRubriqueId())));
            break;

            case 'afficherSelectBreveStatut':
                $breveMetier = &recuperer_instance_breve();
                $loadOK = $breveMetier->load($parameters['id_breve']);
                if(PEAR::isError($loadOK)) {
                    return false;
                }
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                if($breveMetier->getStatut() !='prop' and $profilMetier->getPoids == $auteurMetier->getprofil()) return false;
                else return true;
            break;
            //articles.php3
            case 'afficherSuiviForumArticle':
                return (acces_rubrique($parameters['id_rubrique']));
            break;

            case 'afficherStatistiques':
                return $GLOBALS["auth_$profil"]['afficherStatistiques'];
            break;

            case 'afficherIconeEvolutionVisites':
                return ($parameters['statut_article'] == 'publie' AND $parameters['visites'] > 0 AND $parameters['activer_statistiques'] != "non" AND $parameters['options'] == "avancees");
            break;
            case 'afficherBoiteConfigurationAvancee':
                return ($parameters['options'] == "avancees" && $parameters['flag_editable']);
            break;
            case 'afficherRaccourcis':
                return (acces_rubrique($parameters['rubrique_article']) AND $parameters['options'] == "avancees");
            break;
            case 'creerNouvelAuteurArticle':
                return ($parameters['creer_auteur']);
            break;
            case 'afficherLienRetirerAuteurArticle':
                return ($parameters['flag_editable'] AND ($parameters['$connect_id_auteur'] != $parameters['id_auteur'] OR $GLOBALS["auth_$profil"]['afficherLienRetirerAuteurArticle']) AND $parameters['options'] == 'avancees');
            break;
            case 'traitementEmail':
                die('<pre>You hit a bug! Please signal it via http://bogues.agora.gouv</pre>');
                //Maciek c'est pas utilise ca:???
                return ($GLOBALS["auth_$profil"]['traitementEmail']);
            break;
            /*
            case 'afficherFormulaireStatutArticle':
                $monArticle = &recuperer_instance_article();
                $loadOK = $monArticle->load($parameters['id_article']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if( ( $monArticle->getStatut() == 'valid' OR $monArticle->getStatut() == 'publie' OR $monArticle->getStatut() == 'poubelle' OR $monArticle->getStatut() == 'refuse') AND $profil == $monProfil->getPoids()) return false;
                return true;
            break;
            */
            //editer_message.php3 and affichage_message.php3
            case 'controlerForum2':
                global $connect_toutes_rubriques;
                if($connect_toutes_rubriques) return true;

                switch($parameters['type_forum']) {
                    case 'article':
                        //verification si l'auteur peut acceder a la rubrique contenant l'article
                        $articleMetier = &recuperer_instance_article();
                        $loadOK = $articleMetier->load($parameters['id_current_forum']);
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        return $rubriqueMetier->isManagedByAuteurId($articleMetier->getRubriqueId(), $idUser);
                    break;
                    case 'rubrique':
                        //verification si l'auteur peut acceder a la rubrique
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        return $rubriqueMetier->isManagedByAuteurId($parameters['id_current_forum'], $idUser);
                    break;
                    case 'breve':
                        //verification si l'auteur peut acceder a la rubrique contenant la breve
                        $breveMetier = &recuperer_instance_breve();
                        $loadOK = $breveMetier->load($parameters['id_current_forum']);
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        return $rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $idUser);
                    break;
                    default:
                        return false;
                    break;
                }
            break;
            case 'afficherNombreMessageParStatut':
                return $GLOBALS["auth_$profil"]['afficherNombreMessageParStatut'];
            break;

            //breve_edit.php3
            case 'modifierBreve':
                $breveMetier = &recuperer_instance_breve();
                $loadOK = $breveMetier->load($parameters['id_breve']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }

                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                if($auteurMetier->getProfil() == $monProfil->getPoids() AND ($breveMetier->getStatut() == 'publie' OR  $breveMetier->getStatut() == 'refuse'))  return false;
                
                $rubriqueMetier = &recuperer_instance_rubrique();
                return ($rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $idUser));
            break;

            //inc.php3
            case 'changerStatutMessage':

                //Recuperation du type de forum

                $forumMetier = &recuperer_instance_forum();
                $loadOK = $forumMetier->load($parameters['id_forum']);
                if(PEAR::isError($loadOK)) {
                    die($loadOK->getMessage());
                }

                if($forumMetier->getArticleId())    $typeForum = 'article';
                if($forumMetier->getBreveId())    $typeForum = 'breve';
                if($forumMetier->getRubriqueId())    $typeForum = 'rubrique';

                switch($typeForum) {
                    case 'article':
                        //verification si l'auteur peut acceder a la rubrique contenant l'article
                        $articleMetier = &recuperer_instance_article();
                        $loadOK = $articleMetier->load($forumMetier->getArticleId());
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        $accesOK = $rubriqueMetier->isManagedByAuteurId($articleMetier->getRubriqueId(), $idUser);
                    break;
                    case 'rubrique':
                        //verification si l'auteur peut acceder a la rubrique
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        $accesOK = $rubriqueMetier->isManagedByAuteurId($forumMetier->getRubriqueId(), $idUser);
                    break;
                    case 'breve':
                        //verification si l'auteur peut acceder a la rubrique contenant la breve
                        $breveMetier = &recuperer_instance_breve();
                        $loadOK = $breveMetier->load($forumMetier->getBreveId());
                        if(PEAR::isError($loadOK)) {
                            echo $loadOK->getMessage();
                            return false;
                        }
                        $rubriqueMetier = &recuperer_instance_rubrique();
                        $accesOK = $rubriqueMetier->isManagedByAuteurId($breveMetier->getRubriqueId(), $idUser);
                    break;
                    default:
                        $accesOK = false;
                    break;
                }

                if($accesOK) {
                    switch($parameters['statut']) {
                        case 'publie':
                            return $this->isAuthorized($idUser, 'publierMessage');
                        break;
                        case 'off':
                            return $this->isAuthorized($idUser, 'refuserMessage');
                        break;
                        case 'poubelle':
                            return $this->isAuthorized($idUser, 'mettrePoubelleMessage');
                        break;
                        default:
                            return false;
                        break;
                    }
                }
                else {
                    return false;
                }
            break;

            case 'publierMessage':
                return $GLOBALS["auth_$profil"]['publierMessage'];
            break;

            case 'refuserMessage':
                return $GLOBALS["auth_$profil"]['refuserMessage'];
            break;

            case 'mettrePoubelleMessage':
                return $GLOBALS["auth_$profil"]['mettrePoubelleMessage'];
            break;

            //sites_tous.php3
            case 'supprimerSite':
                $syndicMetier = &recuperer_instance_syndic();
                $loadOK = $syndicMetier->load($parameters['id_syndic']);
                if(PEAR::isError($loadOK)) {
                    return false;
                }
                $authorization = &recuperer_instance_authorization();
                return ($authorization->isAuthorized($idUser, 'isManagedRubriqueByAuteurId', array('rubriqueId' => $syndicMetier->getRubriqueId())));
            break;

            case 'creerSite':
                return $GLOBALS["auth_$profil"]['creerSite'];
            break;

            case 'modifierStatutSyndic':
                $syndicMetier = &recuperer_instance_syndic();
                $loadOK = $syndicMetier->load($parameters['id_syndic']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }

                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                if($auteurMetier->getProfil() == $monProfil->getPoids()) {
                    if($parameters['statut_nouv'] == 'publie' OR $parameters['statut_nouv'] == 'refuse' OR $parameters['statut_nouv'] == 'poubelle') return false;
                    if($syndicMetier->getStatut() == 'publie' OR $syndicMetier->getStatut() == 'refuse' OR $syndicMetier->getStatut() == 'poubelle') return false;
                }

                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur_en_chef');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                if($auteurMetier->getProfil() == $monProfil->getPoids()) {
                    if($parameters['statut_nouv'] == 'poubelle') return false;
                    if($syndicMetier->getStatut() == 'poubelle') return false;
                }
                return true;
            break;
            case 'modifierDatePublicationSite':
                return $GLOBALS["auth_$profil"]['modifierDatePublicationSite'];
            break;

            case 'proposerSite':
                return $GLOBALS["auth_$profil"]['proposerSite'];
            break;
            case 'publierSite':
                return $GLOBALS["auth_$profil"]['publierSite'];
            break;
            case 'refuserSite':
                return $GLOBALS["auth_$profil"]['refuserSite'];
            break;
            case 'jeterSite':
                return $GLOBALS["auth_$profil"]['jeterSite'];
            break;

            case 'modifierSite':
                $syndicMetier = &recuperer_instance_syndic();
                $loadOK = $syndicMetier->load($parameters['id_syndic']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }

                //if(!$articleMetier->isAuthor($auteurMetier->getAuteurId())) return false;
                $profilMetier = &recuperer_instance_profil();
                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                //var_dump($syndicMetier);
                if($auteurMetier->getProfil() == $monProfil->getPoids() AND $syndicMetier->getStatut() != 'prop') return false;

                $monProfil = $profilMetier->getProfilForIntitule('item_redacteur_en_chef');
                if(PEAR::isError($monProfil)) {
                    die($monProfil->getMessage());
                }
                if($auteurMetier->getProfil() == $monProfil->getPoids() AND $syndicMetier->getStatut() != 'prop' AND $syndicMetier->getStatut() != 'publie' AND $syndicMetier->getStatut() != 'refuse') return false;

                $rubriqueMetier = &recuperer_instance_rubrique();
                return $rubriqueMetier->isManagedByAuteurId($syndicMetier->getRubriqueId(), $idUser);
            break;

            case 'effacerBase':
                return $GLOBALS["auth_$profil"]['effacerBase'];
            break;

            case 'sauverBase':
                return $GLOBALS["auth_$profil"]['sauverBase'];
            break;

            case 'gestionPetition':
                return $GLOBALS["auth_$profil"]['gestionPetition'];
            break;

            case 'uploadDocument':
                return $GLOBALS["auth_$profil"]['uploadDocument'];
            break;

            case 'afficherArticleAParaitre':
                return $GLOBALS["auth_$profil"]['afficherArticleAParaitre'];
            break;

            case 'afficherNombreSyndicationOff':
                return $GLOBALS["auth_$profil"]['afficherNombreSyndicationOff'];
            break;

            case 'afficherLesAuteurs':
                return $GLOBALS["auth_$profil"]['afficherLesAuteurs'];
            break;

            case 'afficherArticleVisites':
                return ($parameters['$afficher_visites'] AND $parameters['$activer_statistiques'] != "non");
            break;

            case 'afficherBoiteLogo':
                $rubriqueMetier = &recuperer_instance_rubrique();
                return $rubriqueMetier->isManagedByAuteurId($parameters['id_rubrique'], $idUser);
            break;

            case 'afficherArticleEnRedaction':
                return $GLOBALS["auth_$profil"]['afficherArticleEnRedaction'];
            break;

            case 'traiterEmail':
                return $GLOBALS["auth_$profil"]['traiterEmail'];
            break;

            case 'afficherFormulaireMessage':
                return ($parameters['id_auteur'] == $idUser OR $parameters['type'] == "affich");
            break;

            case 'configurerContenu':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;
            case 'configurerFonctions':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;

			/************ Ajout odouarche@sqli.com *****************************/
            case 'configurerModules':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;
			/************ Fin Ajout odouarche@sqli.com *****************************/         

            case 'configurerLang':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;            

            case 'configurerMultiLang':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;  

            case 'afficherStatistiqueTrad':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;
            
            case 'afficherStatistiqueLang':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;

            case 'afficherDetailsTraductions':
                if(!$parameters['connect_toutes_rubriques']) return false;
                return true;
            break;

			case 'creerCMuserGroupe':
				return true;
			break;
			case 'modifierCMuserGroupe':
				return true;
			break;
            case 'creerCMuserGroupeInstance':
				return true;
			case 'modifierCMuserGroupeInstance':
				return true;
            
            case 'associerMotCleElement':
                $groupeMotMetier = &recuperer_instance_groupe_mot();
                $loadOK = $groupeMotMetier->load($parameters['id_groupe']);
                if(PEAR::isError($loadOK)) {
                    echo $loadOK->getMessage();
                    return false;
                }
                switch ($parameters['type']) {
                	case 'articles':
                		if ($groupeMotMetier->getArticles() != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'breves':
                		if ($groupeMotMetier->getBreves() != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'rubriques':
                		if ($groupeMotMetier->getRubriques != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'syndic':
                		if ($groupeMotMetier->getSyndic() != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'auteurs':
                		if ($groupeMotMetier->getAuteurs() != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'forum':
                		if ($groupeMotMetier->getForum != 'oui') {
                			return false;                		
                		}
                	break;
                	case 'cm':
                		if ($groupeMotMetier->getCm() != 'oui') {
                			return false;                		
                		}
                	break;
            		default:
                		return false;
            		break;
                }
                return $groupeMotMetier->isManagedByProfil($auteurMetier->getProfil());
            break;
            case 'configurerLettresInfos' : 
                return true;
            break;
            case 'creerLettresInfos' : 
                return true;
            break;
            case 'envoyerLettresInfos' : 
                return true;
            break;
            default:
                return false;
            break;
        }

    }

    
    //private helper function
    function cacheAllowsRubrique($rubriqueId)
    {
    	if (isset($_SESSION['AgoraRubriquesCache'][$rubriqueId])) {
			return ($_SESSION['AgoraRubriquesCache'][$rubriqueId] == $rubriqueId);
    	}
    	else 
    		return false;
	}
}
?>