<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2004 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Olivier Mansour                                                   |
// +----------------------------------------------------------------------+
//
// Singleton
// $Id$


class DBManager {

    /**
    * Name.
    * @var     Array of PEAR::DB 
    * @access  private
    */
    var $_dbs;


    // {{{ _getDB()

    /**
     * method used to get an PEAR::DB depending on a dsn
     *
     * @return      PEAR::DB
     * @access public
     */    
    function &getDB($dsn, $dbOptions) {
        
        /*
        return $this->_dbs[$dsn];
        */
        if (is_object ($this->_dbs[$dsn])) {
            return $this->_dbs[$dsn];
        } else {
			$this->_registerDBManager ($dsn, $dbOptions) ;
        }
        return $this->_dbs[$dsn];
    }
    
    // }}}
    
    // {{{ DBManager constructor.

    /**
     * DBManager constructor.
     *
     * @access public
     */
    function DBManager($dsn, $dbOptions) {
        $this->_dbs[$dsn] = $this->getDB($dsn, $dbOptions);
        return $this->_dbs[$dsn];
    }
   
   // }}}
   
   // {{{ _registerDBManager
   
   /**
   * methode enregistrant un acces a une base de donnees 
   * 
   * @return  DBManager object
   * @access private
   */
   function _registerDBManager ($dsn, $dbOptions)  {
   	
        require_once "DB.php";
        $this->_dbs[$dsn] = &DB::connect($dsn, $dbOptions);
        $obj = &$this->_dbs[$dsn];
        if (!DB::isError($obj)) {
	        $obj->setOption('portability', DB_PORTABILITY_ALL ^ DB_PORTABILITY_RTRIM);
	        $obj->setFetchMode(DB_FETCHMODE_ASSOC);
        }    
   }
   
   // }}}
   
   // {{{ getDBManager
   
    /**
     * method used to get an singleton of DBManager instance
     *
     * @return      Singleton of DBManager objec
     * @access public
     */    
    function &getDBManager($dsn, $dbOptions) {
        static $singleton;
        if (!isset($singleton[$dsn])) {
            $singleton[$dsn] = new DBManager($dsn, $dbOptions);
        }
        return $singleton[$dsn];    
    }
    
    // }}}
}
?>