<?php

//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003-2005 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// $Id$



require_once (dirname(__FILE__)."/DBWrapper.php");
require_once ("PEAR.php");


class DBSearchWrapper extends DBWrapper {

    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/DBSearchWrapper_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/DBSearchWrapper_common.php");
            $classname = "DBSearchWrapper_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/DBSearchWrapper_".$dbParameters->_dbEngine.".php");
            $classname = "DBSearchWrapper_".$dbParameters->_dbEngine;
        }
        
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", PEAR_LOG_ALERT,
                                    null, null, null, null, false);
        }           
        
        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }        
    }

        
    function query($query) {


        $db = $this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        
        if(ereg("<!spipDATE_COURANTEspip!>", $query)) {
	        $maDate = new Date();
	        $query = ereg_replace("<!spipDATE_COURANTEspip!>", $maDate->getDate(DATE_FORMAT_ISO), $query);
        }        
        


        if(eregi("SELECT (.*) FROM (.*) WHERE (.*)", $query, $params)) {
            $champs = explode(",", $params[1]);
            $champs2 = explode(" AS ", $champs[0]);
            $champs3 = explode(".", $champs2[0]);
            //En attendant d'avoir une vraie grammaire pour virer ces cochonneries
            $champs3[1] = str_replace(')', '', $champs3[1]);
            
            $id_object = $champs3[1];

            $champs = explode(",", $params[2]);
            $champs2 = explode(" ", $champs[0]);
            $table = $champs2[0];
        }

    
        // construction du tableau de rsultats
        $rows = array ();
        
        // test du parametre 
        $mes_params =$this->getParams(); 
        // var_dump ($mes_params); 
        if ($mes_params['mode']) {
            // extraction des parametres de hash idx.hash IN (...)
            if (ereg('idx\.hash[[:space:]]IN[[:space:]]\(([^\)]+)\)', $query, $match)) {
                $tab_hash = split (',', str_replace ("'", '', $match[1]));
            }
            // extraction du parametre emplacement
            /*
            if (ereg("emplacement[[:space:]]=[[:space:]]\'([^\']+)\'", $query, $match )) {
                $emplacement = $match[1];
            }
            */
            
            if (count($tab_hash) < 2) {
                $mes_params['mode'] = 'IN'; // un seul mot tap donc c'est une recherche normale
            }
            
            if ($tab_hash[0] != '0') {
                // ********** //
                
                // recherche exclusive
                if (($mes_params['mode'] == 'AND') or ($mes_params['mode'] == 'FULL'))  { 
                    include_once 'PHP/Compat.php';
                    PHP_Compat::loadFunction ('array_intersect_key'); // dont on a besoin pour la recherche exclusive
                    $first = true; // 
                    $ids = array(); // tableau des id d'objets
                    $tab_to_intersect = array (); // 
                    foreach ($tab_hash as $hash) { // parcourt du tableau de mots recherch
                        $var_hash = '_'.$hash; // le hash commence par 0x ....
                        $$var_hash = array ();
                        $tmp = array (); // dsol :-(  
                        $query_one = ereg_replace ('idx\.hash[[:space:]]IN[[:space:]]\((.+)\)', 'idx.hash = \''.$hash.'\' ' , $query);
                        $dbResult_one = $db->query($query_one);
                        if(DB::isError($dbResult_one)) {
                           return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] ".$dbResult_one->getMessage()." requete : ".$query_one, PEAR_LOG_CRIT,
                        null, null, null, null, false);        
                        }
                        while ($row = $dbResult_one->fetchRow()) {
                            // echo '--->'.$row['id_object'].'=>'.$hash."\n";
                            $ids[$row['id_object']] = $row['points'] + $ids[$row['id_object']];
                            $tmp[$row['id_object']] = $row['points'];
                        }
                        $$var_hash  = $tmp;
                        // if (count($$var_hash) > 0 ) {  // la requete a renvoye des resultats                
                        if ($first) {
                            $rows = $ids; 
                            $first = false;
                            //var_dump ($rows);
                        } else {
                            $rows = array_intersect_key ($rows, $$var_hash); // intersection des donnes
                             
                        }
                        // }
                   }
                   // gestion des points
                   foreach ($rows as $val_id_object => $points) {
                        $rows[$val_id_object] = $ids [$val_id_object];
                   }
                   
                }
                reset ($tab_hash);
                // fin recherche exclusive
                
                // ********** //
                
                // recherche full texte (note : on est dj pass par le code de la recherche exclusive)
                if (($mes_params['mode'] == 'FULL') and ($tab_hash[0] != '0')) {  // on affine le traitement par un bon vieux like en PHP :-)
                    include_once ( dirname(__FILE__).'/../../../mes_options.php3'); 
                    $object = str_replace ($GLOBALS['table_prefix'].'_', '', $table);
                    include_once ( dirname(__FILE__).'/../metier.php');
                    $objetMetier = BD_metier::getChildObject($object);
                    if (! Pear::isError($objetMetier)) {
                        $tmp = array (); // dsol :-( 
                        foreach ($rows as $val_id_object => $points) {
                            $objetMetier->load ($val_id_object);
                            // *** Recuperation du parametre de recherche pass en GET *** //
                            // je trouve pas ca gnial mais pas mieux 
                            if ($_GET['recherche']) { 
                                include_once ( dirname(__FILE__).'/../../indexer/Indexer_Utils.php');
                                if (strpos (Indexer_Utils::fabriquer_chaine_indexation(serialize($objetMetier)), Indexer_Utils::fabriquer_chaine_indexation($_GET['recherche'])) !== false) {
                                    $tmp[$val_id_object] = $points;
                                }
                            }
                        }
                        $rows = $tmp;
                    } else {
                        return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] impossible d'instancier un objet $object", PEAR_LOG_CRIT,
                        null, null, null, null, false); 
                    }
                }
                
                reset ($tab_hash);
                // fin recherche full texte
                
                // intersection avec la recherche standard (pour la gestion des doublons et autres filtres)
                if (($mes_params['mode'] == 'AND') or ($mes_params['mode'] == 'FULL'))  {
                    $rows_min = array(); 
                    $dbResult = $db->query($query);
                    if(DB::isError($dbResult)) {
                        return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] ".$dbResult->getMessage()."", PEAR_LOG_CRIT,
                        null, null, null, null, false);        
                    }
                    while ($row = $dbResult->fetchRow()) {
                        $rows_min[$row['id_object']] = $row['points'];
                    }
                    // intersection avec notre tableau de recherche
                    $rows = array_intersect_key ($rows_min, $rows); // intersection des donnes
                }
                //
                
                
                // ********** //
                
                // recherche std SPIP
                if ($mes_params['mode'] == 'IN') { 
                    $dbResult = $db->query($query);
                    if(DB::isError($dbResult)) {
                        return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] ".$dbResult->getMessage()."", null,
                        null, null, null, null, false);        
                    }
                    while ($row = $dbResult->fetchRow()) {
                        $rows[$row['id_object']] = $row['points'];
                    }
                }
                reset ($tab_hash);
                // fin recherche std
                
            }
        }

        
        
        foreach ($rows as $val_id_object => $points) {
            $query = "SELECT $table.*, ".$points." points from $table WHERE $id_object=".$val_id_object."";
            // echo $query; 
            $this->_dbResult = $db->query($query);
            $dbResult2 = $this->_dbResult;
            if(DB::isError($this->_dbResult)) {
                return PEAR::raiseError("[".get_class($this)." DBSearchWrapper : query] ".$dbResult2->getMessage()."", null,
                    null, null, null, null, false);        
            }
            $this->_rowsBuilder();
        }
        $this->_limitRows();
    }
    
}



?>