<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
//

if (defined("_DB_WRAPPER")) return;
define("_DB_WRAPPER", "1");

require_once dirname(__FILE__)."/../DBManager.php";

// on pourrait pas auto-dcrouvrir ces filtres

require_once dirname(__FILE__)."/../parameters.php";
require_once dirname(__FILE__)."/../inc_config_metier.php";
require_once dirname(__FILE__)."/Filters/ShuffleFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionMonthFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionYearFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionLeastFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionRegexpFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionRegexpNotFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionFieldFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionPersonnalisationFilter.php";
require_once dirname(__FILE__)."/Filters/FunctionIdAuteur.php";
require_once dirname(__FILE__)."/Filters/FunctionIdAuteur.php";
require_once dirname(__FILE__)."/Filters/FunctionNullFilter.php";

// test si on active le moteur de recherche externe : 
// le DBWrapper est utilis via le front SPIP AGORA et est dpendant du moteur de SPIP
// on peut donc inclure une mta : 
/*
require_once dirname(__FILE__)."/../../../inc_meta.php3";
if (lire_meta('activer_recherche_document') == 'oui') {
*/
    require_once dirname(__FILE__)."/Filters/FunctionSevenseasFilter.php";
// }

class DBWrapper {
    // {{{ properties
    /** Parameters instance used for PEAR::DB factory and
        Metier subclasses factories. */
    var $_dbParameters;

    var $_dbOptions = false;

    var $_filterList = array();
    var $_params = array();
    var $_filterObj = array();

    var $_dbResult;
    var $_rows = array();
    var $_currentPointer = 0;

    var $_limitStart = -1;
    var $_limitSize = -1;

    // }}}

    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/DBWrapper_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/DBWrapper_common.php");
            $classname = "DBWrapper_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/DBWrapper_".$dbParameters->_dbEngine.".php");
            $classname = "DBWrapper_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ _traiteQuery()

    /**
     * This protected method is used to keep SPIP compatibility.
     * This is the method where table prefixes must be handled.
     *
     * @param $query        The SQL query that must be "SPIP"ed
     * @return              String representing the modified SQL query
     *
     */

    function _traiteQuery($query) {
        if ($GLOBALS['mysql_rappel_connexion'] AND $db = $this->_dbParameters->_dbName) {
		    $db = '`'.$db.'`.';
		}
    	// changer les noms des tables ($table_prefix)
    	if (eregi('[[:space:]](VALUES|WHERE)[[:space:]].*$', $query, $regs)) {
    		$suite = $regs[0];
    		$query = substr($query, 0, -strlen($suite));
    	}
    	$query = ereg_replace('([[:space:],])'.$GLOBALS['table_prefix'].'_', '\1'.$db.$GLOBALS['table_prefix'].'_', $query) . $suite;

    	return $query;
    }

    // }}}
    
    // {{{ _getDB()
    /**
     * Protected method used to get an PEAR::DB instance
     * using the parameters stored in the _dbParameters field
     *
     * @return      Newly creating PEAR::DB object
     *              according to the instance parameters
     */
    function &_getDB() {
        
        $DBManager = &DBManager::getDBManager($this->_dbParameters->getDSN(), $this->_dbOptions);
        $db = $DBManager->getDB($this->_dbParameters->getDSN(), $this->_dbOptions);
        
        if(DB::isError($db)) {
            die($db->getMessage);
        }
        
        return $db;
        
    }
    // }}}

    // {{{ getDbParameters()

    /**
     * Getter method to retreive the instance Parameters object
     *
     * @return      DB parameters
     * @access      public
     */

    function getDbParameters() {
        return $this->_dbParameters;
    }



    function setDbParameters($dbParameters) {
        if (strtolower(get_class($dbParameters)) == "bd_parameters") { // c un peu le souk dans le nommage des variables non ? 
            $this->_dbParameters = $dbParameters;
        } else {
            return PEAR::raiseError("Erreur! le parametre de la methode setDbParameters doit �tre un objet de la hierarchie DB_parameters !",
                              null, null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getDbParameters()

    /**
     * Getter method to retreive the instance Options array
     *
     * @return      array
     * @access      public
     */

    function getDbOptions() {
        return $this->_dbOptions;
    }

    // }}}

    // {{{ setDbOptions()

    /**
     * Setter method to set the instance Parameters object
     *
     * @param array     array of PEAR::DB options
     */

    function setDbOptions($dbOptions) {
        $this->_dbOptions = $dbOptions;
    }

    // {{{ setFilterList()

    function getFilterList() {
        return $this->_filterList;
    }

    // }}}

    // {{{ setFilterList()

    function setFilterlist($filterList) {
        $this->_filterList = $filterList;
    }

    // }}}

    function setParams($params) {
        $this->_params = $params;
    }

    function getParams() {
        return($this->_params);
    }

    function _queryFilter($query) {

        //echo '<br><br><br>Debut du filtre '.$query;
		if(ereg("<!spipDATE_COURANTEspip!>", $query)) {
	        $maDate = new Date();
	        $query = ereg_replace("<!spipDATE_COURANTEspip!>", $maDate->getDate(DATE_FORMAT_ISO), $query);
        }

        while(list(, $myFilter) = each($this->_filterList)) {

            $classFilterName = $myFilter.'Filter';
            //echo '<br><font color=red>' . $classFilterName . '</font><br>';
            if (!class_exists($classFilterName)) {
                die('le filtre '.$classFilterName.' ne peut pas etre chargee');
            }

            $this->_filterObj[$classFilterName] =& new $classFilterName;

            $myObj = &$this->_filterObj[$classFilterName];
            
            $myObj->setParams($this->getParams());
            $query = $myObj->queryFilter($query);
            //echo '<br><br><br>resultat du filtre '.$classFilterName.' :  '.$query;
        }


        //echo '<br><br><br>Fin du filtre '.$query;

        return $query;
    }

    function query($query) {

        $db = $this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DBWrapper : query] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = $this->_queryFilter($query);
        $this->_dbResult = $db->query($query);
        $dbResult = $this->_dbResult;



        if(DB::isError($this->_dbResult)) {
            //echo '<font color=green>PB EXECUTION REQUETE</font><br>'.$query.'<br>';
            return PEAR::raiseError("[".get_class($this)." DBWrapper : query => $query ] ".$dbResult->getMessage()."", null,
                null, null, null, null, false);
        }
        $this->_rowsBuilder();
        $this->_limitRows();
        
    }

    function limitQuery($query, $limitStart, $limitSize) {
        $this->_limitStart = eval('return ' . $limitStart.';');
        $this->_limitSize = $limitSize;
        $this->query($query);

    }

    function insertQuery($query) {
        $db = $this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DBWrapper : insertQuery] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
         
        
        $query = $this->_queryFilter($query);

        $this->_dbResult = $db->query($query);
        $dbResult = $this->_dbResult;

        if(DB::isError($this->_dbResult)) {
            return PEAR::raiseError("[".get_class($this)." DBWrapper : insertQuery => $query ] ".$dbResult->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    function numRows() {
        return sizeOf($this->_rows);
    }

    function _rowsBuilder() {
        $dbResult = $this->_dbResult;

        while($row = $dbResult->fetchRow()) {
            $this->_rows[] = $row;
        }

        $this->_currentPointer = 0;

        while(list(, $myFilter) = each($this->_filterObj)) {
            $this->_rows = $myFilter->rowsFilter($this->_rows);
        }
    }

    function fetchRow() {
        $row = $this->_rows[$this->_currentPointer];
        $this->_currentPointer++;
        return $row;
    }

    function free() {
        $dbResult = &$this->_dbResult;
        if($dbResult)   $dbResult->free();
    }

    function _limitRows() {

        if(($this->_limitStart != -1)&&($this->_limitSize != -1)) {
            $this->_rows = array_splice($this->_rows, $this->_limitStart, $this->_limitSize);
        }
        
        $this->_limitStart = -1;
        $this->_limitSize = -1;
    }

    function quoteString($string) {
        $db = &$this->_getDB();
        return $db->quoteString($string);
    }

}
?>
