<?php
//
// +----------------------------------------------------------------------+
// | NestedSetHelper_NestedSet                                            |
// +----------------------------------------------------------------------+
// | Copyright (c) 1997-2003 The PHP Group                                |
// +----------------------------------------------------------------------+
// | This source file is subject to version 2.0 of the PHP license,       |
// | that is bundled with this package in the file LICENSE, and is        |
// | available at through the world-wide-web at                           |
// | http://www.php.net/license/2_02.txt.                                 |
// | If you did not receive a copy of the PHP license and are unable to   |
// | obtain it through the world-wide-web, please send a note to          |
// | license@php.net so we can mail you a copy immediately.               |
// +----------------------------------------------------------------------+
// | Authors: Antoine Angnieux <aangenieux@clever-age.com> - Olivier Mansour              |
// +----------------------------------------------------------------------+
//
//

//require_once dirname(__FILE__).'/../../NestedSet/NestedSet/DB.php';
require_once 'DB/NestedSet.php';
require_once 'DB/NestedSet/DB.php';

// {{{ NestedSetHelper_NestedSet:: class

/**
 * Wrapper class for DB_NestedSet_DB class
 *
 * @author       Antoine Angnieux <aangenieux@clever-age.com>
 * @package      NestedSetHelper
 * @version      $Revision$
 * @access       public
 */

// }}}
class NestedSetHelper_NestedSet extends DB_NestedSet_DB {
    function &NestedSetHelper_NestedSet($db, $params) {
		$this->_debugMessage('DB_NestedSet_DB($db)');
		$this->DB_NestedSet($params);
		$this->db = $db;
		$this->db->setFetchMode(DB_FETCHMODE_ASSOC);
	}

	// {{{ getBranch()

    /**
     * Fetch the whole branch where a given node id is in
     *
     * @param int  $id The node ID
     * @param bool $keepAsArray (optional) Keep the result as an array or transform it into
     *             a set of NestedSet_Node objects?
     * @param bool $aliasFields (optional) Should we alias the fields so they are the names
     *             of the parameter keys, or leave them as is?
     *
     * @access public
     * @return mixed False on error, or an array of nodes
     */
    function getBranch($id, $keepAsArray = false, $aliasFields = true)
    {
        $this->_debugMessage('getBranch($id)');
        if (!($thisnode = $this->_getNodeObject($id))) {
            return false;
        }

        $sql = sprintf('SELECT %s FROM %s WHERE %s=%s ORDER BY %s, %s ASC',
                            $this->_getSelectFields($aliasFields),
                            $this->node_table,
                            $this->flparams['rootid'],
                            $this->db->quote($thisnode->rootid),
                            $this->flparams['l'],
                            $this->secondarySort
               );
        // modifs Olivier Mansour 
        // mais qui m'a chang mon API ???? :-(
        //return $this->_processResultSet($this->db->getAll($sql), $keepAsArray, $aliasFields);
        return $this->_processResultSet($sql, $keepAsArray, $aliasFields);
        // fin modifs 
    }

    // }}}
    
    
    // {{{ _getNodeObject()

    /**
     * Gets the node to work on based upon an id
     *
     * @param mixed $id The id which can be an object or integer
     *
     * @access private
     * @return mixed The node object for an id or false on error
     */
    function _getNodeObject($id)
    {
        if (!is_object($id) || !$id->id) {
            return $this->pickNode($id);
        }
        else {
            return $id;
        }
    }

    // }}}
    
}
?>
