<?php
/**
 * Classe de base pour les renderers d'objets mtier.
 *
 * @version      $Id$
 * @author       Tristan Rivoallan <trivoallan@clever-age.com>
 *
 */
class Metier_Renderer {

    /** Objet mtier  traiter
     * @var     object bd_metier
     * @access  private
     */
    var $_visited = null;
    
    /**  
     * Cette mthode est appele par la mthode accept() de l'objet mtier.
     * 
     * @param     object bd_metier      $obj
     */
    function visit( &$obj ) {
        if ( ! is_a($obj, 'bd_metier') ) {
            trigger_error( 'Erreur renderer' );
        }

        $this->_visited = $obj;
    }

    /** 
     * @abstract   Cette mthode doit tre surcharge par les renderers.
     * @return     string 
     */
    function render() {}

}
?>