<?php
/** 
 * Fabrique de renderers d'objets mtier.
 *
 * @version      $Id$
 * @author       Tristan Rivoallan <trivoallan@clever-age.com>
 */
class Metier_Renderer_Factory {
    

    /** 
     * @param      string      $ressource        Type de ressource  rendre.
     * @param      string      $representation   Type de reprsentation (csv, atom, ...)
     */
    function create( $ressource, $representation ) {
        
        $r_classname = sprintf( "Metier_Renderer_%s_%s", $ressource, $representation );
        $r_classpath = realpath( sprintf("%s/%s/%s.php", 
                                         dirname(__FILE__), ucfirst($ressource), ucfirst($representation)) );

        if ( $r_classpath ) {
            require_once $r_classpath;
            if ( class_exists($r_classname) ) {
                return new $r_classname;
            }
        }

        trigger_error( 'Pas de renderer pour ce couple ressource / reprsentation.' );

        return;
        
    }
}
?>