<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Action business persistence abstraction.
//

if (defined("_BD_ACTION")) return;
define("_BD_ACTION", "1");

require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";
define("ACTION_ALL_FIELDS", " action, poids ");

/**
 * BD_action is a base class for action business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_action extends BD_metier {
    // {{{ properties

    /**
    * Name.
    * @var     String
    * @access  private
    */
    var $_action;

    /**
    * Poids.
    * @var     Int
    * @access  private
    */
    var $_poids;

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/action_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/action_common.php");
            $classname = "BD_action_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/action_".$dbParameters->_dbEngine.".php");
            $classname = "BD_action_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_action constructor.
     *
     * @access public
     */

    function BD_action() {
    }

    // }}}

    // {{{ getAction()

    function getAction() {
        return $this->_action;
    }

    // }}}

    // {{{ setAction()

    function setAction($action) {
        $this->_action = corriger_caracteres($action);
    }

    // }}}

    // {{{ getPoids()

    function getPoids() {
        return  $this->_poids;
    }

    // }}}

    // {{{ setPoids()

    function setPoids($poids) {
        $this->_poids = corriger_caracteres($poids);
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_actions (".ACTION_ALL_FIELDS.") VALUES "
                ."('".$db->quoteString($this->_action)."', "
                .$this->_poids.")";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ delete()

    function delete($action) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_actions WHERE action = $action";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_actions "
                ."SET action = '".$db->quoteString($this->_action)."', "
                ."poids = ".$this->_poids." "
                ."WHERE action = ".$this->_action;

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    function load($action) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".ACTION_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_actions WHERE action = '$action'";
        //echo $query;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." Db_action : load(".$action.")] Aucune action ne correspond pas  ce nom!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setAction($row['action']);
        $this->setPoids($row['poids']);
    }

    // }}}

    // {{{ getAllAction()

    function &getAllAction() {
        $actions = array();
        $db = &$this->_getDB();


        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getAllAction()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT " . ACTION_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_actions";
         
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getAllAction()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $resultAction = &BD_action::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAction->_fetchData($row);
            $actions[] = &$resultAction;
        }
        $result->free();
        return $actions;
    }

    // }}}

    // {{{ getProfilForAction($action)

    function &getProfilForAction($action) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getProfilForAction()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT " . ACTION_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_actions WHERE action=" . $action;
         
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getProfilForAction()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            $resultAction = &BD_action::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAction->_fetchData($row);
        }
        $result->free();
        return $resultAction;
    }

    // }}}

	// {{{ getActionForProfilisTrue($action)

    function &getActionForProfilisTrue($profil) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getActionForProfilisTrue()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = 'SELECT ' . ACTION_ALL_FIELDS . ' FROM '.$GLOBALS['table_prefix'].'_actions WHERE poids<=' . $profil.' ORDER BY action ASC';
		//echo $query."\n";
		$query = $this->_traiteQuery($query);
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getActionForProfilisTrue()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
			$resultAction = &BD_action::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAction->_fetchData($row);
            $actions[] = $row;
        }
        $result->free();
        return $actions;
    }
	 // }}}
	/**GCH
	**/
	// {{{ getActionForProfilisFalse($action)
	function &getActionForProfilisFalse($profil) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getActionForProfilisFalse()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = 'SELECT ' . ACTION_ALL_FIELDS . ' FROM '.$GLOBALS['table_prefix'].'_actions WHERE poids>' . $profil.' ORDER BY action ASC';
		//echo $query."\n";
		$query = $this->_traiteQuery($query);
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_action : getActionForProfilisFalse()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
			$resultAction = &BD_action::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAction->_fetchData($row);
            $actions[] = $row;
        }
        $result->free();
        return $actions;
    }
    // }}}

}