<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article business persistence abstraction.
//

/* Ajout Clever Age / Erwan LE BESCOND / Couche mtier */
require_once (dirname(__FILE__)."/inc_visite_factory.php");
require_once (dirname(__FILE__)."/inc_referer_factory.php");
require_once (dirname(__FILE__)."/inc_auteur_factory.php");
/* fin zone de modification Clever Age */

/*
 Ajout Clever Age / Aurelien Vialet
 Mise en place de l'historique sur les articles
*/
require_once(dirname(__FILE__)."/inc_article_historique_factory.php");

 
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_meta.php3";

define("ARTICLE_ALL_FIELDS", " id_article, surtitre, titre, soustitre, id_rubrique, descriptif, chapo, texte, "
                            ."ps, date_heure, statut, id_secteur, maj, export, date_redac, visites, referers, popularite, "
                            ."accepter_forum, auteur_modif, date_modif, extra, lang, langue_choisie, id_trad, nom_site, url_site, version_id, activer_historique, date_expiration ");
define("ARTICLE_LIGHT_FIELDS" , " id_article, surtitre, titre, soustitre, id_rubrique, chapo, "
                               ."date_heure, statut, id_secteur, maj, export, date_redac, visites, referers, popularite, "
                               ."accepter_forum, auteur_modif, date_modif, extra, lang, langue_choisie, id_trad, nom_site, url_site ");

/**
 * BD_article is a base class for article business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */

class BD_article extends BD_metier {

    // {{{ properties


    /**
     * Article ID.
     * @var     int
     * @access  private
     */
    var $_articleId;

    /**
     * Extra title.
     * @var     String
     * @access  private
     */
    var $_surtitre;

    /**
     * Title.
     * @var     String
     * @access  private
     */
    var $_titre;

    /**
     * Under title.
     * @var     String
     * @access  private
     */
    var $_soustitre;

    /**
     * Rubrique ID.
     * @var     int
     * @access  private
     */
    var $_rubriqueId;

    /**
     * Description.
     * @var     String
     * @access  private
     */
    var $_descriptif;

    /**
     * .chapo
     * @var     int
     * @access  private
     */
    var $_chapo;

    /**
     * texte.
     * @var     string
     * @access  private
     */
    var $_texte;

    /**
     * ps
     * @var     string
     * @access  private
     */
    var $_ps;

    /**
     * date (date_heure)
     * @var     date
     * @access  private
     */
    var $_date;

     /**
     * date d'expiration.
     * @var    date
     * @access  private
     */
    var $_expirationDate = null;

    /**
     * statut
     * @var     string
     * @access  private
     */
    var $_statut;

    /**
     * secteur ID.
     * @var     int
     * @access  private
     */
    var $_secteurId;

    /**
     * date de maj .
     * @var     date
     * @access  private
     */
    var $_majDate;

    /**
     * ?
     * @var     int
     * @access  private
     */
    var $_export;

    /**
     * redaction date
     * @var     date
     * @access  private
     */
    var $_redactionDate;

    /**
     * 
     * @var     
     * @access  private
     */
    var $_visites;

    /**
     * 
     * @var     
     * @access  private
     */
    var $_referers;

    /**
     * popularite
     * @var     int
     * @access  private
     */
    var $_popularite;

    /**
     * accepter forum
     * @var     bool ?
     * @access  private
     */
    var $_accepterForum;

    /**
     * 
     * @var     int
     * @access  private
     */
    var $_auteurModif;

    /**
     * date de modification
     * @var     date
     * @access  private
     */
    var $_modificationDate;

    /**
     * 
     * @var     
     * @access  private
     */
    var $_computedLastModified;

    /**
     * 
     * @var     
     * @access  private
     */
    var $_lastModifiedUserName;

    /**
     * 
     * @var     
     * @access  private
     */
    var $_whenWasModified;


    /**
     * extra field.
     * @var     String
     * @access  private
     */
    var $_extra;

    /**
     * Lang.
     * @var     String
     * @access  private
     */
    var $_lang;

    /**
     * Lang functions activation.
     * @var     String
     * @access  private
     */
    var $_langue_choisie;
    
    /**
     * ???.
     * @var     int
     * @access  private
     */    
    var $_tradId;
    
    /**
     * Site name.
     * @var     String
     * @access  private
     */
    var $_nomSite;
    
    /**
     * Site URL.
     * @var     String
     * @access  private
     */    
    var $_urlSite;
    
    /**
     * Version ID
     * @var		int
     * @access	private
     */
    var $_versionId;
    

	 /**
     * Active Historique
     * @var		string
     * @access	private
     */
    var $_activerHistorique = 'non';
	

    /** 
    * isLoaded
    * nous dit si l'objet est charg ou pas 
    * @access private
    */
    var $_isLoaded = false;

    /**
    * _statutsHisto
    * historique des statuts pour cet instance d'objet
    * @access private
    * @var Array 
    **/
    var $_statutsHisto = array ();
    

    /**
    * _datesHisto
    * historique des dates pour cet instance d'objet
    * @access private
    * @var Array 
    **/
    var $_datesHisto = array ();

    // }}}


    /**
    * _rubriqueIdsHisto
    * historique des rubriques pour cet instance d'objet
    * @access private
    * @var Array 
    **/
    var $_rubriqueIdsHisto = array ();
    


    // {{{ factory()

    /**
     * This method is a factory static method. It should be used to get any
     * specific implementation instace of Article business data type.
     * @param   BD_parameters DB connection parameters
     * @access public
     */
    function &factory($dbParameters, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/article_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/article_common.php");
            $classname = "BD_article_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/article_".$dbParameters->_dbEngine.".php");
            $classname = "BD_article_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_article constructor.
     *
     * @access public
     */

    function BD_article() {
    }

    // }}}

    // {{{ getArticleId()

    function getArticleId() {
        return $this->_articleId;
    }

    // }}}

    // {{{ setArticleId()

    function setArticleId($articleId) {
        $this->_articleId = $articleId;
    }

    // }}}

    // {{{ getSurtitre()

    function getSurtitre() {
        return $this->_surtitre;
    }

    // }}}

    // {{{ setSurtitre()

    function setSurtitre($surtitre) {
         $this->_surtitre = $this->corriger_caracteres($surtitre);
    }

    // }}}

    // {{{ getTitre()

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    function setTitre($titre) {
        $this->_titre = $this->corriger_caracteres($titre);
    }

    // }}}

    // {{{ getSoustitre()

    function getSoustitre() {
        return $this->_soustitre;
    }

    // }}}

    // {{{ setSoustitre()

    function setSoustitre($soustitre) {
        $this->_soustitre = $this->corriger_caracteres($soustitre);
    }

    // }}}

    // {{{ getRubriqueId

    function getRubriqueId() {
        return $this->_rubriqueId;
    }

    // }}}

    // {{{ setRubriqueId()
    function setRubriqueId($rubriqueId) {
        // $this->_rubriqueId = $rubriqueId;
        if (isset($this->_rubriqueId) and ($this->_rubriqueId != $rubriqueId) ) {
            // on sauvegarde cette rubrique
            $this->_rubriqueIdsHisto[] = $this->_rubriqueId;
        }
         $this->_rubriqueId = $rubriqueId;
    }
    // }}}

    // {{{ getRubriqueIdsHisto

    function getRubriqueIdsHisto() {
        return $this->_rubriqueIdsHisto;
    }

    // }}}




    // {{{ getDescriptif()

    function getDescriptif() {
        return $this->_descriptif;
    }

    // }}}

    // {{{ setDescriptif()

    function setDescriptif($descriptif) {
        $this->_descriptif = $this->corriger_caracteres($descriptif);
    }

    // }}}

    // {{{ getChapo()

    function getChapo() {
        return $this->_chapo;
    }

    // }}}

    // {{{ setChapo()

    function setChapo($chapo) {
        $this->_chapo = $this->corriger_caracteres($chapo);
    }

    // }}}

    // {{{ getTexte()

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    function setTexte($texte) {
        $this->_texte = $this->corriger_caracteres($texte);
    }

    // }}}

    // {{{ getPs()

    function getPs() {
        return $this->_ps;
    }

    // }}}

    // {{{ setPs()

    function setPs($ps) {
        $this->_ps = $this->corriger_caracteres($ps);
    }

    // }}}

    // {{{ getDate()

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    function setDate($date) {
        if (isset($this->_date) and ($this->_date != $date) ) {
            // on sauvegarde cette date
            $this->_datesHisto[] = $this->_date;
        }
        $this->_date = $date;
    }

    // }}}

    // {{{ getStatut()

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    function setStatut($statut) {
        if (isset($this->_statut) and ($statut != $this->_statut)) {
            // on sauvegarde ce statut
            $this->_statutsHisto[] = $this->_statut;
        }
        $this->_statut = $statut;
    }

    // }}}

    // {{{ getSecteurId()

    function getSecteurId() {
        return $this->_secteurId;
    }

    // }}}

    // {{{ setSecteurId()

    function setSecteurId($secteurId) {
        $this->_secteurId = $secteurId;
    }

    // }}}

    // {{{ getMajDate()

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ getMajDateIso()

    function getMajDateIso() {
        $madate = new Date($this->_majDate);
        return $madate->getDate(DATE_FORMAT_ISO);
    }

    // }}}



    // {{{ setMajDate()

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // }}}

    // {{{ getExport()

    function getExport() {
        return $this->_export;
    }

    // }}}

    // {{{ setExport()

    function setExport($export) {
        $this->_export = $export;
    }

    // }}}

    // {{{ getRedactionDate()

    function getRedactionDate() {
        return $this->_redactionDate;
    }

    // }}}

    // {{{ setRedactionDate()

    function setRedactionDate($redactionDate) {
        $this->_redactionDate = $redactionDate;
    }

    // }}}

    // {{{ getVisites()

    function getVisites() {
        return $this->_visites;
    }

    // }}}

    // {{{ setVisistes()

    function setVisites($visites) {
        $this->_visites = $visites;
    }

    // }}}

    // {{{ getReferers()

    function getReferers() {
        return $this->_referers;
    }

    // }}}

    // {{{ setReferers()

    function setReferers($referers) {
        $this->_referers = $referers;
    }

    // }}}

    // {{{ getPopularite()

    function getPopularite() {
        return $this->_popularite;
    }

    // }}}

    // {{{ setPopularite()

    function setPopularite($popularite) {
        $this->_popularite = $popularite;
    }

    // }}}

    // {{{ getAccpeterForum()

    function getAccepterForum() {
        return $this->_accepterForum;
    }

    // }}}

    // {{{ setAccepterForum()

    function setAccepterForum($accepterForum) {
        $this->_accepterForum = $accepterForum;
    }

    // }}}

    // {{{ getAuteurModif()

    function getAuteurModif() {
        return $this->_auteurModif;
    }

    // }}}

    // {{{ setAuteurModif()

    function setAuteurModif($auteurModif) {
        $this->_auteurModif = $auteurModif;
    }

    // }}}

    // {{{ getModificationDate()

    function getModificationDate() {
        return $this->_modificationDate;
    }

    // }}}

    // {{{ setModificationDate()

    function setModificationDate($modificationDate) {
        $this->_modificationDate = $modificationDate;
    }

    // }}}

    // {{{ getExtra()

    function getExtra() {
        return $this->_extra;
    }

    // }}}

   // {{{ setExtra()

   function setExtra($extra) {
        $this->_extra = $extra;
   }

   // }}}

    // {{{ getLang()

    /**
     * Returns the lang fields
     * @return  String
     * @access  public
     */

    function getLang() {
        return $this->_lang;
    }

    // }}}

    // {{{ setLang()

    /**
     * Sets the lang fields
     * @param   String
     * @access  public
     */

    function setLang($lang) {
        $this->_lang = $lang;
    }

    // }}}

    // {{{ getLangChoisie()

    /**
     * get Lang functions activation.
     * @var     String
     * @access  private
     */

    function getLangChoisie() {
        return $this->_langChoisie;
    }

    // }}}
    
    // {{{ setLangChoisie()


    /**
     * Set Lang functions activation.
     * @var     String
     * @access  private
     */

    function setLangChoisie($langChoisie) {
        $this->_langChoisie = $langChoisie;
    }

    // }}}
        
    // {{{ getTradId()

    /**
     * get Trad id.
     * @var     int
     * @access  private
     */

    function getTradId() {
        return $this->_tradId;
    }

    // }}}
    
    // {{{ setTradId()


    /**
     * Set Trad Id.
     * @var     int
     * @access  private
     */

    function setTradId($tradId) {
        $this->_tradId = $tradId;
    }

    // }}}

    // {{{ getNomSite()

    /**
     * get Site Name.
     * @var     String
     * @access  private
     */

    function getNomSite() {
        return $this->corriger_null($this->_nomSite);
    }

    // }}}
    
    // {{{ setNomSite()


    /**
     * Set Site Name.
     * @var     String
     * @access  private
     */

    function setNomSite($nomSite) {
        $this->_nomSite = $nomSite;
    }

    // }}}
    
    // {{{ getUrlSite()

    /**
     * get Site Url.
     * @var     String
     * @access  private
     */

    function getUrlSite() {
        return $this->corriger_null($this->_urlSite);
    }

    // }}}
    
    // {{{ setUrlSite()


    /**
     * Set Site Url.
     * @var     String
     * @access  private
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = $urlSite;
    }

    // }}}
    
    
    // {{{ getVersionId
    /**
     * Get the version Id
     * 
     */
    
    function getVersionId() {
    	return $this->_versionId;
    }
    
    // }}}
    
    // {{{ setVersionId
    
    /**
     * Set the Version Id
     */
    
    function setVersionId($versionId) {
    	$this->_versionId = $versionId; 
    }
    
    // }}}
    
    
    // {{{ getActiverHistorique()
	
	function getActiverHistorique() {
        return $this->_activerHistorique;
    }
        
    // }}}

	// {{{ setActiverHistorique()
	
    function setActiverHistorique($activerHistorique) {
        $this->_activerHistorique = $activerHistorique;
    }
    
    // }}}
    
    function getIsLoaded () {
        return $this->_isLoaded;
    }
    
    // }}}
    
    // {{{
    
    function setIsLoaded($isLoaded) {
        $this->_isLoaded = $isLoaded;
    }
    
    // }}}
    
    
    // {{{ getDateExpiration 
    function getExpirationDate() {
        return $this->_expirationDate;
    }
    // }}}
    
    // {{{ setExpirationDate 
    function setExpirationDate($date) {
        $this->_expirationDate = $date;
    }
    // }}}
    
    // {{{ create()

    /**
     * This method is used to create a new article in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_articles";
        
        $articleId = $db->nextId($string_prefix, true);
        if (DB::isError($articleId)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : create()] ".$articleId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_articleId = $articleId;

        /*
        if ($this->_date == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_date)."'";
        if ($this->_modificationDate == "NOW()") $dateModifValue = "NOW()"; else $dateModifValue = "'".$db->quoteString($this->_date)."'";
        */

        $maDate = new Date();
        $isoDate = $maDate->getDate(DATE_FORMAT_ISO);
	    $this->setDate($isoDate);
        $this->setModificationDate($isoDate);

        if($this->_rubriqueId == null) $this->_rubriqueId = 0;
        if($this->_secteurId == null) $this->_secteurId = 0;
        if($this->_visites == null) $this->_visites = 0;
        if($this->_referers == null) $this->_referers = 0;
        if($this->_popularite == null) $this->_popularite = 0;
        if($this->_auteurModif == null) $this->_auteurModif = 0;

	if($this->_ps == null) $this->_ps = '';
	if($this->_surtitre == null) $this->_surtitre= '';
	if($this->_titre == null) $this->_titre = '';
	if($this->_soustitre == null) $this->_soustitre = '';
	if($this->_descriptif == null) $this->_descriptif = '';
	if($this->_chapo == null) $this->_chapo = '';
	if($this->_texte == null) $this->_texte = '';


        // Ajout Aurelien Vialet <avialet@clever-age.com>
        // Gestion du versionning articles
        if ($this->_versionId == null) $this->_versionId = 0;
        
        //Modification fxlacroix@clever-age.com
        if($this->_tradId == null) $this->_tradId=0;
        //Fin de modification

	
	// calcul du secteur
        require_once 'inc_rubrique_factory.php';
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->_rubriqueId);
        // $this->_secteurId = $rubriqueMetier->findSectorId();
        $this->_secteurId = $rubriqueMetier->getSecteurId();

        // positionnement de la langue si non explicite
        if (!isset($this->_lang)) $this->setLang($rubriqueMetier->getLang());

        // vrification de la date d'expiration 
        if (!is_null($this->_expirationDate)) {
            include_once (dirname(__FILE__).'/../date.php');
            // la date d'expiration doit tre suprieure a la date de publication en ligne     
            if (Date::compare(new Date($this->getExpirationDate()), new Date($this->getDate())) < 0) {
                $this->_expirationDate  = null; // cette date n'est pas valide 
            }
        }
        

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_articles (".ARTICLE_ALL_FIELDS.") VALUES "
                ."(".$this->_articleId.", "
                ."'".$db->quoteString($this->_surtitre)."', "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_soustitre)."', "
                ."'".$this->_rubriqueId."', "
                ."'".$db->quoteString($this->_descriptif)."', "
                ."'".$db->quoteString($this->_chapo)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."'".$db->quoteString($this->_ps)."', "
                ."'".$db->quoteString($this->_date)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$this->_secteurId."', "
                ."'".$db->quoteString($this->_majDate)."', "
                ."'".$db->quoteString($this->_export)."', "
                ."'".$db->quoteString($this->_redactionDate)."', "
                ."'".$this->_visites."', "
                ."'".$this->_referers."', "
                ."'".$this->_popularite."', "
                ."'".$db->quoteString($this->_accepterForum)."', "
                ."'".$this->_auteurModif."', "
                ."'".$db->quoteString($this->_modificationDate)."', "
                ."'".$db->quoteString($this->_extra)."', "
                ."'".$db->quoteString($this->_lang)."', "
                ."'".$db->quoteString($this->_langChoisie)."', "
                ."'".$db->quoteString($this->_tradId)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$this->_versionId."', "
                ."'".$db->quoteString($this->_activerHistorique)."', "
                ."'".$db->quoteString($this->_expirationDate)."')";


        //die($query);
         
        //        echo"<br /><br />$query<br><br />";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Ajout dans la version des mots cles
        $this->updateVersionComponent($this->_versionId,$this->_articleId,$GLOBALS['table_prefix']."_mots_articles"," id_mot", "oui");
        // Ajout dans la version des auteurs
        //$this->updateVersionComponent($this->_versionId,$this->_articleId,$GLOBALS['table_prefix']."_auteurs_articles"," id_auteur");
        
        // on considere l'article charg 
        $this->_isLoaded = true;
	/******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	if (($this->getStatut()=='publie') or ($this->getStatut()=='archi') or ($this->getStatut()=='mappe')) { // il faut mettre  jour la rubrique
        //if (($this->getStatut()=='publie') or ($this->getStatut()=='archi')) { // il faut mettre  jour la rubrique
             /******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
            $rubriqueMetier->load($this->getRubriqueId());
            $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueId());
            if ($statut != $rubriqueMetier->getStatut()) {
                $rubriqueMetier->setStatut($statut);
                $rubriqueMetier->update();
            }
            // on remet aussi la date  jour
            $dateCalcul = $rubriqueMetier->getDateFromRubrique($rubriqueMetier->getRubriqueId());
            $dateRubrique = new Date ($rubriqueMetier->getDate());
            if (Date::compare($dateCalcul, $dateRubrique) != 0) {
                $rubriqueMetier->setDate($dateCalcul->getDate());
                $rubriqueMetier->update(); // va enclencher la recursivite
                $update_date = true;
            }
            unset ($rubriqueMetier);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this article in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        /*
        if ($this->_date == "NOW()") $dateValue = "NOW()"; else $dateValue = "'".$db->quoteString($this->_date)."'";
        if ($this->_modificationDate == "NOW()") $dateModifValue = "NOW()"; else $dateModifValue = "'".$db->quoteString($this->_date)."'";
        */

        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));
        
        
        // calcul du secteur ...  chaque fois 
        $rubriqueMetier = &recuperer_instance_rubrique();
        $rubriqueMetier->load($this->_rubriqueId);
        $this->_secteurId = $rubriqueMetier->findSectorId();
        
        
        // vrification de la date d'expiration 
        if (!is_null($this->_expirationDate) and ($this->_expirationDate != '0000-00-00 00:00:00')) {
            include_once (dirname(__FILE__).'/../date.php');
            // la date d'expiration doit tre suprieure a la date de publication en ligne     
            if (Date::compare(new Date($this->getExpirationDate()), new Date($this->getDate())) < 0) {
                $this->_expirationDate  = null; // cette date n'est pas valide 
            }
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles "
                ."SET surtitre = '".$db->quoteString($this->_surtitre)."', "
                ."titre = '".$db->quoteString($this->_titre)."', soustitre = '".$db->quoteString($this->_soustitre)."', "
                ."id_rubrique = ".$this->_rubriqueId.", descriptif = '".$db->quoteString($this->_descriptif)."', "
                ."chapo = '".$db->quoteString($this->_chapo)."', texte = '".$db->quoteString($this->_texte)."', "
                ."ps = '".$db->quoteString($this->_ps)."', date_heure = '".$db->quoteString($this->_date)."', "
                ."statut = '".$db->quoteString($this->_statut)."', id_secteur = ".$this->_secteurId.", "
                ."maj = '".$db->quoteString($this->_majDate)."', export = '".$db->quoteString($this->_export)."', "
                ."date_redac = '".$db->quoteString($this->_redactionDate)."', visites = ".$this->_visites.", "
                ."referers = ".$this->_referers.", popularite = ".$this->_popularite.", "
                ."accepter_forum = '".$db->quoteString($this->_accepterForum)."', auteur_modif = ".$this->_auteurModif.", "
                ."date_modif = '".$db->quoteString($this->_modificationDate)."', extra = '".$db->quoteString($this->_extra)."', "
                ."lang = '".$db->quoteString($this->_lang)."', langue_choisie= '" . $db->quoteString($this->_langChoisie) . "', "
                ."id_trad = '".$this->_tradId."', nom_site= '" . $db->quoteString($this->_nomSite) . "', "
                ."url_site = '".$db->quoteString($this->_urlSite)."',"
                ."activer_historique = '".$this->_activerHistorique."',"
                ."date_expiration = '".$this->_expirationDate."' "
                ." WHERE id_article = ".$this->_articleId;

         

        //echo "<br><br>$query<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : update() $query => $query ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        // vrification de la non expiration de l'article
        if ($this->isExpired()) {
            // je dois repasser sur la rubrique - j'ai dj un objet rubriqueMetier
            if ( $rubriqueMetier->checkForExpired() ) { // va modifier mon objet rubrique
                $update = $rubriqueMetier->update();
                if ( PEAR::isError($update) ) {         
                    PEAR::raiseError("Rubrique::update $id error".$update->getMessage(), PEAR_LOG_ERR); 
                } else {
                    // je dois recharger mon article si je compte utiliser mon objet apres
                    $this->setIsLoaded(false);
                    $this->load($this->getArticleId());
                }
            }
        }


        // Mise  jour des objets lis
        $this->updateRelatedObjects();
        
        // Mise  jour de l'embargo
        $this->updateEmbargo();

	/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
	if ($this->getStatut()=='mappe') { // il faut mettre  jour la rubrique
            $rubriqueMetier->load($this->getRubriqueId());
            $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueId());
            if ($statut != $rubriqueMetier->getStatut()) {
                $rubriqueMetier->setStatut($statut);
                $rubriqueMetier->update();
            }
            unset ($rubriqueMetier);
        }
	/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an article from the database
     * @access  public
     * @param   int $idArticle id of article to load
     */

    function load($idArticle) {
        if (($this->_isLoaded) and ($this->_articleId == $idArticle)) return; // l'article est charg 
    
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".ARTICLE_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle";
         

        //echo "<br>" . $query . "<br>";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : load() $query => $query ] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_article : load($idArticle)] Aucun article ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        
        // l'article est charg 
        $this->_isLoaded = true;
    }

    // }}}

    // {{{ loadLightWeight()

    /**
     * This method is used to load an article from the database
     * selecting only small size fields from the DB
     * @access  public
     * @param   int $idArticle id of article to load
     */
    function loadLightWeight($idArticle) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : loadLightWeight()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".ARTICLE_LIGHT_FIELDS."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle";

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : loadLightWeight()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchLightWeightData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_article : loadLightWeight($idArticle)] Aucun article ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ loadLightWeightIfStatut($idArticle, $statut)

    /**
     * This method is used to load an article from the database
     * selecting only small size fields from the DB
     * @access  public
     * @param   int $idArticle id of article to load
     * @param   String $statut of article to load
     */
    function loadLightWeightIfStatut($idArticle, $statut) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : loadLightWeightIfStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".ARTICLE_LIGHT_FIELDS."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle AND statut='$statut'";
		//echo  '<br>' . $query . '<br>';
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : loadLightWeightIfStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchLightWeightData($row);
                return 1;
            } else {
                return -1;
            }
            $result->free();
        }
    }

    // }}}


    // {{{ delete()

    /**
     * This method is used to delete an article from the database
     * @access  public
     * @param   int $idArticle id of article to delete
     */

    function delete($idArticle) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article = $idArticle";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // mise a jour des statuts et des dates
        $rubriqueMetier = &recuperer_instance_rubrique();
	    $rubriqueMetier->load($this->getRubriqueId());
        $statut = $rubriqueMetier->getStatutFromRubrique($this->getRubriqueId());
        if ($statut != $rubriqueMetier->getStatut()) {
            $rubriqueMetier->setStatut($statut);
            $rubriqueMetier->update();
        }
        $rubriqueMetier->load($this->getRubriqueId());
        $dateCalcul = $rubriqueMetier->getDateFromRubrique($rubriqueMetier->getRubriqueId());
        $dateRubrique = new Date ($rubriqueMetier->getDate());
        if (Date::compare($dateCalcul, $dateRubrique) != 0) {
            $rubriqueMetier->setDate($dateCalcul->getDate());
            $rubriqueMetier->update();
        }  
        unset ($rubriqueMetier);
        
    }

    // }}}

    // {{{ unlock()

    /**
     * This method unlock an Article
     * @access  public
     * @param   int $idArticle id of article to unlock
     */
    function unlock($idArticle, $connect_id_auteur) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : unlock()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET auteur_modif='0' WHERE auteur_modif=$connect_id_auteur AND id_article=" . intval($idArticle);
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : unlock()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }
    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     * @access  private
     * @param   int $idArticle id of article to load
     */

    function _fetchData($row) {
        $this->setArticleId($row['id_article']);
        $this->setSurtitre($row['surtitre']);
        $this->setTitre($row['titre']);
        $this->setSoustitre($row['soustitre']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setDescriptif($row['descriptif']);
        $this->setChapo($row['chapo']);
        $this->setTexte($row['texte']);
        $this->setPs($row['ps']);
        $this->setDate($row['date_heure']);
        $this->setStatut($row['statut']);
        $this->setSecteurId($row['id_secteur']);
        $this->setMajDate($row['maj']);
        $this->setExport($row['export']);
        $this->setRedactionDate($row['date_redac']);
        $this->setVisites($row['visites']);
        $this->setReferers($row['referers']);
        $this->setPopularite($row['popularite']);
        $this->setAccepterForum($row['accepter_forum']);
        $this->setAuteurModif($row['auteur_modif']);
        $this->setModificationDate($row['date_modif']);
        $this->setExtra($row['extra']);
        $this->setLang($row['lang']);
        $this->setLangChoisie($row['langue_choisie']);
        $this->setTradId($row['id_trad']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setVersionId($row['version_id']);
        $this->setActiverHistorique($row['activer_historique']);
        $this->setExpirationDate($row['date_expiration']);
    }

    // }}}

    // {{{ _fetchLightWeightData()

    /**
     * This method is used to fetch result set fields into the object fields
     * used with loadLightWeight
     * @access  private
     * @param   int $idArticle id of article to load
     * @see     loadLightWeight($idArticle)
     */
    function _fetchLightWeightData($row) {
        $this->setArticleId($row['id_article']);
        $this->setSurtitre($row['surtitre']);
        $this->setTitre($row['titre']);
        $this->setChapo($row['chapo']);
        $this->setSoustitre($row['soustitre']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setDate($row['date_heure']);
        $this->setStatut($row['statut']);
        $this->setSecteurId($row['id_secteur']);
        $this->setMajDate($row['maj']);
        $this->setExport($row['export']);
        $this->setRedactionDate($row['date_redac']);
        $this->setVisites($row['visites']);
        $this->setReferers($row['referers']);
        $this->setPopularite($row['popularite']);
        $this->setAccepterForum($row['accepter_forum']);
        $this->setAuteurModif($row['auteur_modif']);
        $this->setModificationDate($row['date_modif']);
        $this->setExtra($row['extra']);
        $this->setLang($row['lang']);
        $this->setLangChoisie($row['langue_choisie']);
        $this->setTradId($row['id_trad']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);        
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all articles former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // {{{ deleteArticleForStatut($statut, $maj)

    /**
     * This method is used to delete all deleted articles
     * @access  public
     */

    function deleteArticleForStatut($statut, $maj) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteArticleForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($maj);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='poubelle' AND maj < '".$dateTmp->getDate(DATE_FORMAT_ISO)."'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteArticleForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // {{{ deleteAuteurs()

    /**
     * This method is used to delete all authors attached to this article
     * @access  public
     */

    function deleteAuteurs() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAuteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_article = ".$this->_articleId;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAuteurs()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAuteur()

     /**
     * This method is used to delete a given author attached to this article
     * @param   int $authorId author to delete
     * @access  public
     */
    function deleteAuteur($authorId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_auteur=$authorId AND id_article = ".$this->_articleId;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptArticleIds($articles)

     /**
     * This method is used to delete authors not attached to a list of articleIds
     * @param   int list of rubriqueIds
     * @access  public
     */
    function deleteAllAuteurIdsExceptArticleIds($articles) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAllAuteurIdsExceptArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_article NOT IN ($articles)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAllAuteurIdsExceptArticleIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAllAuteurIdsExceptAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_auteur NOT IN ($auteurs)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteAllAuteurIdsExceptAuteurIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ addAuteur()

     /**
     * This method is used to attach an author to this article
     * @param   int $authorId autor to attach
     * @access  public
     */
    function addAuteur($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : addAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs_articles (id_auteur, id_article) VALUES ($auteurId, ".$this->_articleId.")";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : addAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ isAuthor()

     /**
     * This method determines whether or not a given author is an author
     * of this article
     * @param   int $auteurId author to check
     * @return  boolean
     * @access  public
     */
    function isAuthor($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isAuthor()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_article=".$this->_articleId." AND id_auteur=$auteurId";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isAuthor()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $isAuthor = ($result->numRows() > 0);
        $result->free();
        return $isAuthor;
    }

    // }}}

    // {{{ getRubriqueIdsByStatus()

     /**
     * This method is used to get all "rubrique" containing published articles
     * @param   String  status to look for
     * @param   boolean look for postdated articles ?
     * @return  mixed   result array of IDs or PEAR::Error object
     * @access  public
     */
    function getRubriqueIdsByStatus($statut, $postDated) {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIdsByStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_articles WHERE statut = '$statut'";
        if ($postDated == "non") {
            $maDate = new Date();
            $query .= " AND date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
            //$query .= " AND date <= NOW()";
        }
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIdsByStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ getRubriqueIds()

     /**
     * This method is used to get all "rubrique" containing published articles
     * @access  public
     */
    function getRubriqueIds() {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_articles";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRubriqueIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ getMaxDateByRubriqueAndStatus()

    /**
     * This method is used to the latest date of a published article for a given rubrique
     * with a given status and a flag to determine whether or not to handle postdated articles
     * @param   int     $rubriqueId
     * @param   String  status to look for
     * @param   boolean look for postdated articles ?
     * @return  mixed   Date or PEAR::Error object
     * @access  public
     */
    function getMaxDateByRubriqueAndStatus($rubriqueId, $statut, $postDated) {
        $dateResult = '';
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateByRubriqueAndStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_articles ".
				 "WHERE id_rubrique=$rubriqueId AND statut = '$status'";

        if ($postDated == "non") {
            $maDate = new Date();
            $query .= " AND date_heure <= '" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
            //$query .= " AND date <= NOW()";
        }

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateByRubriqueAndStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $dateResult = $row['date_h'];
        }
        $result->free();
        return $dateResult;
    }

    // }}}

    // {{{ getRecentArticleIds()

    /**
     * This method returns an array of article ids, representing the 10 most recent ones
     *
     * @return  Array   containing the wished IDs
     * @access  public
     */

    function &getRecentArticleIds() {
        $articleIds = array();
        $articleIds[] = '0';
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRecentArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND popularite > 0 ORDER BY date_heure DESC";
         
        $result = $db->limitQuery($query, 0, 10);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRecentArticleIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {
            $articleIds[] = $row['id_article'];
        }

        $result->free();
        return $articleIds;

    }

    // }}}

    // {{{ updateSecteursForRubriques()

    /**
     * This method is used to update the sector racttached to different articles
     * @param   int     id sector
     * @param   array   Rubriques id list
     * @return  mixed   nothing or PEAR::Error object
     * @access  public
     */
    function updateSecteursForRubriques($secteurId, $listRubriques) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateSecteursForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET id_secteur=$secteurId WHERE id_rubrique IN ($listRubriques)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateSecteursForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateTradIdForTradId($idTradOld, $idTradNew)

    /**
     * This method is used to update the sector racttached to different articles
     * @param   int     id sector
     * @param   array   Rubriques id list
     * @return  mixed   nothing or PEAR::Error object
     * @access  public
     */
    function updateTradIdForTradId($idTradOld, $idTradNew) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateTradIdForTradId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET id_trad = '$idTradNew' WHERE id_trad = $idTradOld";
         
        
        //echo '<br />' . $query . '<br />';
        
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateTradIdForTradId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateAccepterForum()

    /**
     * This method is used to update the forum acceptation flag for an article subset
     * @param   String  update type
     * @param   boolean accept forum ?
     * @return  mixed   void or PEAR::Error object
     * @access  public
     */
    function updateAccepterForum($updateType, $acceptForum) {
        $result = '';
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateAccepterForum()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($updateType == 'saufnon') {
		    $query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET accepter_forum='$acceptForum' WHERE accepter_forum != 'non'";
             
		    $result = $db->query($query);
    	} else if ($updateType == 'tous') {
    		$query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET accepter_forum='$acceptForum'";
             
    		$result = $db->query($query);
    	}
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateAccepterForum()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ isPostDated()

    /**
     * This method tests whether or not this article is postdated.
     * @return  mixed   boolean or PEAR::Error object
     * @access  public
     */
    function isPostDated() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isPostDated()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article=".$this->_articleId." AND date_heure<='".$maDate->getDate(DATE_FORMAT_ISO)."'";
        //$query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article=".$this->_articleId." AND date_heure<=NOW()";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isPostDated()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $isPostDated = !($result->numRows());
        $result->free();
        return $isPostDated;
    }

    // }}}
    
    // {{{ isExpired
    
    /**
     * This method test wheter or not this article is expired
     * @param int id_article
     * @return mixed boolean or PEAR::Error object
     * @access public
     */
    
    function isExpired ($id_article = null) {
        
        if (is_null($this->getExpirationDate()) or (ereg('0000-00-00', $this->getExpirationDate() ) ) or ($this->getExpirationDate() == '') ) return false;
        
    	/*
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isExpired()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        */
        
        $maDate = new Date();
        
        if (!$this->getIsLoaded()) {
            $loadOK = $this->load($id_article);
            if (PEAR::isError($loadOK)) {
                return $loadOK;
            }
        }
        // ok j'ai un article charg
        
        if (Date::compare(new Date($this->getExpirationDate()), $maDate) < 0) {
            return true;
        } else {
            return false;
        }
        
        /*
        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article=".$this->_articleId." AND date_expiration <='".$maDate->getDate(DATE_FORMAT_ISO)."'";
          
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isExpired()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $isExpired = !($result->numRows());
        
        
        
        $result->free();
        return $isExpired;
        */   	
    }

    // }}}	
    
    
	// {{{ hasLastModified()
    /**
     * This method tests whether a given author has last modified this article
     * @return  mixed   boolean or PEAR::Error object
     * @access  public
     */
    function hasLastModified($auteurId) {
        $hasLastModified = true;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //$query = "SELECT auteur_modif, UNIX_TIMESTAMP(date_modif) AS modification, UNIX_TIMESTAMP(NOW()) AS maintenant FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article='".$db->quoteString($this->_articleId)."'";
        $query = "SELECT auteur_modif, date_modif AS modification FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article=".$this->_articleId."";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            $auteur_modif = $row["auteur_modif"];
            $this->_auteurModif = $auteur_modif;

    		$maDate = new Date($row["modification"]);
    		$modification = $maDate->getDate(DATE_FORMAT_UNIXTIME);

    		$maDate = new Date();
    		$maintenant = $maDate->getDate(DATE_FORMAT_UNIXTIME);

            /*
            $modification = $row["modifications"];
    		$maintenant = $row["maintenant"];
            */

    		$result->free();
        	$date_diff = floor(($maintenant - $modification)/60);
        	$this->_whenWasModified = $date_diff;

    		if ($date_diff >= 0 AND $date_diff < 60 AND $auteur_modif > 0 AND $auteur_modif != $auteurId) {
    			$hasLastModified = false;
    			$query_auteur = "SELECT nom FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur='$auteur_modif'";
                 
    			$result_auteur = $db->query($query_auteur);
                if (DB::isError($result_auteur)) {
                    return PEAR::raiseError("[".get_class($this)." DB_article : hasLastModified()] ".$result_auteur->getMessage()."", null,
                        null, null, null, null, false);
                }
    			if ($row_auteur = $result_auteur->fetchRow()) {
    				$this->_computedLastModified = true;
    				$this->_lastModifiedUserName = $row_auteur["nom"];
    			}
    		}
        }
        return $hasLastModified;
    }

    // }}}

    // {{{ getMaxDateHeure($id_rubrique,$statut, $post_dates)

    function getMaxDateHeure($id_rubrique,$statut, $post_dates = 'non') {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateHeure()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($post_dates != "non") {
			$query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_articles ".
				"WHERE id_rubrique='$id_rubrique' AND statut='$statut'";
		}
		else {
			$maDate = new Date();
			$query = "SELECT MAX(date_heure) AS date_h FROM ".$GLOBALS['table_prefix']."_articles ".
				"WHERE id_rubrique='$id_rubrique' AND statut='$statut' AND date_heure <= '" . trim($maDate->getDate(DATE_FORMAT_ISO)) . "'";
		}
                                      //                                      echo '<br>' . $query . '<br>';
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getMaxDateHeure()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if ($row = $result->fetchRow()) {
            $result->free();
            if ($row["date_h"] == null) {
                return new Date('1970-01-01 00:00:00');
            }
            else {
                return new Date($row["date_h"]);
            }
        }
        $result->free();
    }

    // }}}

    // {{{ getLastModifiedUserName()

    /**
     * This method returns the last contributor of this article name
     * @return  mixed   String or PEAR::Error object
     * @access  public
     */
    function getLastModifiedUserName() {
        if (!$this->_computedLastModified) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getLastModifiedUserName()] La mthode hasLastModified doit tre appele avant cette mthode!", null,
                                    null, null, null, null, false);
        } else {
            $this->_computedLastModified = false;
            return $this->_lastModifiedUserName;
        }
    }

    // }}}

    // {{{ whenWasModified

    function whenWasModified() {
        return $this->_whenWasModified;
    }

    // }}}

    // {{{ howManyWritten()

    /**
     * This method returns the number of article written by a given author
     * @return  int
     * @access  public
     */
    function howManyWritten($authorId, $allowedStatus = '') {
        $howManyWritten = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyWritten()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(articles.id_article) AS compteur ".
			"FROM ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles ".
			"WHERE lien.id_auteur=$authorId AND articles.id_article=lien.id_article ";
		if ($allowedStatus != '') {
		    $query .= "AND articles.statut IN $allowedStatus ";
		}
		$query .= "GROUP BY lien.id_auteur";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyWritten()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyWritten = intval($row["compteur"]);
        }

        $result->free();
        return $howManyWritten;
    }

    // }}}

    // {{{ howManyPublished()

    /**
     * This method returns the number of published articles
     * @return  int
     * @access  public
     */
    function howManyPublished() {
        $howManyPublished = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyPublished()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(id_article) AS cnt FROM ".$GLOBALS['table_prefix']."_articles where statut='publie'";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyPublished()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyPublished = $result;
        }

        return $howManyPublished;
    }

    // }}}


    // {{{ howManyProposed()

    /**
     * This method returns the number of proposed articles
     * @return  int
     * @access  public
     */
    function howManyProposed() {
        $howManyProposed = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyProposed()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(id_article) AS cnt FROM ".$GLOBALS['table_prefix']."_articles where statut='prop'";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyProposed()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyProposed = $result;
        }

        return $howManyProposed;
    }

    // }}}

    // {{{ hasDocument()

    /**
     * This method tests whether or not this article contains any document
     * @return  boolean
     * @access  public
     */
    function hasDocument($documentId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasDocument()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //----------------Zone de modifications Clever Age elebescond----------
	    $documentMetier = &recuperer_instance_document();
        $allDocumentArticle = $documentMetier->getAllDocumentArticle($documentId, $this->articleId);
        if(PEAR::isError($allDocumentArticle)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : hasDocument()] ".$allDocumentArticle->getMessage()."", null,
                null, null, null, null, false);
        }
	    $hasDocument = (sizeOf($allDocumentArticle) > 0);

        /*
        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_documents_articles WHERE id_document=$documentId AND id_article=".$this->articleId;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return $result;
        }
        $hasDocument = ($result->numRows() > 0);
        $result->free();
	    */
	    //----------------Fin de zone de modifications-------------------------


        return $hasDocument;
    }

    // }}}

    // {{{ getToday()

    /**
     * Returns an array of Article representing
     * the current day published articles.
     *
     * This method is abstract and will be implemented
     * in a future version, when the data model has been
     * updated.
     *
     * @return Array of Article
     * @param $month
     * @param $year
     * @access public
     */

    function &getToday($month, $year) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getToday()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        $maDate = new Date("$year-$month-01 00:00:00");
        $maDate->addSeconds(intval(3600*24*31));
        $maDate->setDay(01);

        $query = "SELECT id_article, titre, date_heure FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date_heure >='$year-$month-0' AND date_heure < '".$maDate->getDate(DATE_FORMAT_ISO)."' ORDER BY date_heure";
        
        //echo '<br />' . $query . '<br />';
        
        //$query = "SELECT id_article, titre, date FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date >='$year-$month-0' AND date < DATE_ADD('$year-$month-1', INTERVAL 1 MONTH) ORDER BY date";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getToday()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $resultArticle->setDate($row['date_heure']);
            $result[] = &$resultArticle;

        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getPublishedAndPopular()

    /**
     * This method returns an array of Article objects that are published
     * and that have already been visited
     *
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getPublishedAndPopular() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getPublishedAndPopular()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, titre, popularite, visites FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND popularite > 0 ORDER BY popularite DESC";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getPublishedAndPopular()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $resultArticle->setPopularite($row['popularite']);
            $resultArticle->setVisites($row['visites']);
            $result[] = &$resultArticle;
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getRecentPublishedAndPopularButNotSeen()

    /**
     * This method returns an array of Article objects that are published
     * and that have already been visited
     *
     * @param   String  $recentIds comma separated ids of recent articles
     * @param   String  $seenIds comma separated ids of seen articles
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getRecentPublishedAndPopularButNotSeen($recentIds, $seenIds) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRecentPublishedAndPopularButNotSeen()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, titre, popularite, visites FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND id_article IN ($recentIds) AND id_article NOT IN ($seenIds) ORDER BY popularite DESC";
        //echo $query;
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getRecentPublishedAndPopularButNotSeen()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $resultArticle->setPopularite($row['popularite']);
            $resultArticle->setVisites($row['visites']);
            $result[] = &$resultArticle;
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getPublishedAndPopularFromBeginning()

    /**
     * This method returns an array of Article objects
     *
     * @return  Array   wished array of articles
     * @access  public
     */

    function &getPublishedAndPopularFromBeginning() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getPublishedAndPopularFromBeginning()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, titre, popularite, visites FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND popularite > 0 ORDER BY visites DESC";
         
        $queryResult = $db->limitQuery($query, 0, 30);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getPublishedAndPopularFromBeginning()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $resultArticle->setPopularite($row['popularite']);
            $resultArticle->setVisites($row['visites']);
            $result[] = &$resultArticle;
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getOpened()

    /**
     * Returns an array of Article representing
     * the currently opened articles for a given author
     *
     * This method is abstract and will be implemented
     * in a future version, when the data model has been
     * updated.
     *
     * @return Array of Article
     * @param int $authorId
     * @access public
     */

    function &getOpened($authorId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getOpened()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(3600));

        
        $query = "SELECT id_article, titre FROM ".$GLOBALS['table_prefix']."_articles WHERE auteur_modif = $authorId AND id_rubrique > 0 AND date_modif > '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_modif DESC";
        //$query = "SELECT id_article, titre FROM ".$GLOBALS['table_prefix']."_articles WHERE auteur_modif = '$authorId' AND id_rubrique > 0 AND date_modif > DATE_SUB(NOW(), INTERVAL 1 HOUR) ORDER BY date_modif DESC";
        
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getOpened()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
            $resultArticle->setArticleId($row['id_article']);
            $resultArticle->setTitre($row['titre']);
            $result[] = &$resultArticle;

        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getExtract()

    /**
     * Returns an extract of this article instance
     *
     * @return String representing the extract of the article
     * @access public
     */

    function getExtract() {
        include_once(dirname(__FILE__)."/../../inc_texte.php3");

    	$adresse_site = lire_meta("adresse_site");
    	$id_article = $this->getArticleId();
    	$titre = $this->getTitre();
    	$chapo = $this->getChapo();
    	$texte = $this->getTexte();
    	$date = $this->getDate();
    	$statut = $this->getStatut();

    	$les_auteurs = "";

    	// Attention, il faudra imprativement faire appel  la couche d'abstraction auteur
    	// une fois qu'elle sera crite !

    	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getExtract()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

     	$query = "SELECT auteurs.* FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE lien.id_article=$id_article AND auteurs.id_auteur=lien.id_auteur";
             	
    	$result_auteurs = $db->query($query);
    	if (DB::isError($result_auteurs)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getExtract()] ".$result_auteurs->getMessage()."", null,
                null, null, null, null, false);
    	}

    	while ($row = $result_auteurs->fetchRow()) {
    	    $nom_auteur = $row['nom'];

    		if ($les_auteurs) {
    		    $les_auteurs .= ', ';
    		}
    		$les_auteurs .= $nom_auteur;
    	}

        $result_auteurs->free();

    	/*
    	$result_auteurs = ".$GLOBALS['table_prefix']."_query($query);

    	while ($row = ".$GLOBALS['table_prefix']."_fetch_array($result_auteurs)) {
    		$nom_auteur = $row['nom'];

    		if ($les_auteurs) $les_auteurs .= ', ';
    		$les_auteurs .= $nom_auteur;
    	}
        */

    	$extrait = "** $titre **\n";
    	if ($les_auteurs) $extrait .= _T('info_les_auteurs_1', array('les_auteurs' => $les_auteurs));
    	if ($statut == 'publie') $extrait .= " "._T('info_les_auteurs_2')." ".nom_jour($date)." ".filtrer_entites(affdate($date));
    	$extrait .= "\n\n".textebrut(propre(couper_intro("$chapo<p>$texte", 700)))."\n\n";
    	if ($statut == 'publie') $extrait .= "-> ".$adresse_site."/spip_redirect.php3?id_article=$id_article\n\n";
    	return $extrait;
    }

    // }}}

    // {{{ updateVisites())

    /**
     * Updates a set of articles visites
     *
     * @param array $articleIds containing all article IDs of articles to update
     * @param int $visites representing the add value to visites
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */

    /**
     * xxx clever-age xxx
     * lzachulski@clever-age.com
     */
    function updateVisites($articleIds, $visits) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateVisites()]".
                $db->getMessage()."", null, null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles
                     SET visites = ".$GLOBALS['table_prefix']."_articles.visites + " . $visits . "
                     WHERE ".$GLOBALS['table_prefix']."_articles.id_article
                        IN (" . join(", ", $articleIds) . ")";

        //$query = "UPDATE ".$GLOBALS['table_prefix']."_articles
        //             SET visites = visites + " . $visits . "
        //             WHERE id_article IN (" . join(", ", $articleIds) . ")";
        //echo "<br><br>\n\n$query\n<br><br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateVisites()]".
                $result->getMessage()."", null, null, null, null, null, false);
        }
    }

    // }}}


    // {{{ updateReferers())

    /**
     * Updates a set of articles referers
     *
     * @param array $articleIds containing all article IDs of articles to update
     * @param int $visites representing the add value for referers
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */
    function updateReferers($articleIds, $referers) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateReferes()]
                 ".$db->getMessage()."", null, null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_articles
                     SET referers = ".$GLOBALS['table_prefix']."_articles.referers + " . $referers . "
                     WHERE ".$GLOBALS['table_prefix']."_articles.id_article
                        IN (" . join(", ", $articleIds) . ")";

    $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateReferers()]".
                $result->getMessage()."", null, null, null, null, null, false);
        }
    }

    // }}}



    // {{{ computePopularity())

    // {{{ computePopularity())

    /**
     * Updates all articles to compute new popularity value
     *
     * @return mixed DB::Error if an error occured, nothin otherwise
     * @access public
     */

    //Dsol pour le code, mais c'est toujours parail : on essaye de garder
    //au maximum le code original...

    function computePopularity() {
    	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

     	$date = lire_meta('date_stats_popularite');
    	include_once(dirname(__FILE__)."/../../inc_meta.php3");

    	ecrire_meta("date_stats_popularite", time());
    	ecrire_metas();	// il faut le marquer de suite pour eviter les acces concurrents

    	$duree = time() - $date;
    	// duree de demi-vie d'une visite dans le calcul de la popularite (en jours)
    	$demivie = 1;
    	// periode de reference en jours
    	$periode = 1;
    	// $a est le coefficient d'amortissement depuis la derniere mesure
    	$a = pow(2, - $duree / ($demivie * 24 * 3600));
    	// $b est la constante multiplicative permettant d'avoir
    	// une visite par jour (periode de reference) = un point de popularite
    	// (en regime stationnaire)
    	// or, magie des maths, ca vaut log(2) * duree journee/demi-vie
    	// si la demi-vie n'est pas trop proche de la seconde ;)
    	$b = log(2) * $periode / $demivie;

    	// oublier un peu le passe
    	$query = "UPDATE ".$GLOBALS['table_prefix']."_articles SET popularite = popularite * $a";
        //echo "<br><br>$query\n\n<br><br>";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

    	// ajouter les points visites
    	$count_article = array();

        //----------Modification Clever Age elebescond----------
        $visiteMetier = &recuperer_instance_visite();
	    $allVisites = $visiteMetier->getAllVisiteForTypeSinceXsec($duree, 'article');
        if (DB::isError($allVisites)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$allVisites->getMessage()."", null,
                null, null, null, null, false);
        }
	    $updatePopQuery = "UPDATE ".$GLOBALS['table_prefix']."_articles "
                        // contrib S Petit 
    			         //."SET popularite = GREATEST(1,popularite) + $b * ! "
                         ."SET popularite = CASE WHEN popularite>1 THEN popularite ELSE 1 END + $b * ! "
                         // fin contrib
    			         ."WHERE id_article IN (0!)";
        //echo "<br><br>$query\n\n<br><br>";
	    while (list(, $maVisite) = each($allVisites)) {
    		$count_article[$maVisite['count']] .= ','.$maVisite['id_objet'];	// l'objet a count visites
    	}
	    /*
        $query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_visites_temp WHERE maj > DATE_SUB(NOW(), INTERVAL $duree SECOND) AND type='article' GROUP BY id_objet";
    	$result = $db->query($query);
    	if (DB::isError($result)) {
    	    return $result;
    	}

    	$updatePopQuery = "UPDATE ".$GLOBALS['table_prefix']."_articles "
    			         ."SET popularite = GREATEST(1,popularite) + $b * ! "
    			         ."WHERE id_article IN (0!)";

    	while ($row = $result->fetchRow()) {
    		$count_article[$row['count']] .= ','.$row['id_objet'];	// l'objet a count visites
    	}
	    */
        //---------Fin modification Clever Age-------


    	reset ($count_article);
    	while (list($count,$articles) = each($count_article)) {
    		$params = array();
    		$params[] = $count;
    		$params[] = $articles;
            $query = $this->_traiteQuery($updatePopQuery);
    		$db->query($updatePopQuery, $params);
    	}

    	// ajouter les points referers
    	$count_article = array();

        //----------Modification Clever Age elebescond----------
        $refererMetier = &recuperer_instance_referer();
	    $allReferers = $refererMetier->getAllRefererForTypeSinceXsec($duree, 'article');
        if (DB::isError($allReferers)) {
            die($allReferers->getMessage());
        }
	    while (list(, $monReferer) = each($allReferers)) {
    		$count_article[$monReferer['count']] .= ','.$monReferer['id_objet'];	// l'objet a count visites
    	}
	    /*
    	$query = "SELECT COUNT(*) as count,id_objet FROM ".$GLOBALS['table_prefix']."_referers_temp WHERE maj > DATE_SUB(NOW(), INTERVAL $duree SECOND) AND type='article' GROUP BY id_objet";
    	$result = $db->query($query);
    	if (DB::isError($result)) {
    	    return $result;
    	}

    	while ($row = $result->fetchRow()) {
    		$count_article[$row['count']] .= ','.$row['id_objet'];	// l'objet a count visites
    	}
	    */
        //---------Fin modification Clever Age-------


    	reset ($count_article);
    	while (list($count,$articles) = each($count_article)) {
    		$params = array();
    		$params[] = $count;
    		$params[] = $articles;
            $query = $this->_traiteQuery($updatepopQuery);
    		$db->query($updatePopQuery, $params);
    	}

    	// et enregistrer les metas...

    	$query = "SELECT MAX(popularite) AS maxpop, SUM(popularite) AS sumpop FROM ".$GLOBALS['table_prefix']."_articles";
    	//echo "<br><br>$query\n\n<br><br>";
	
    	$result = $db->query($query);
    	if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : computePopularity()] ".$result->getMessage()."", null,
                null, null, null, null, false);
    	}
    	if ($row = $result->fetchRow()) {
    	    $maxpop = $row['maxpop'];
    	    $totalpop = $row['sumpop'];
    	    ecrire_meta("popularite_max", $maxpop);
        	ecrire_meta("popularite_total", $totalpop);
        	ecrire_metas();
    	}
    	$result->free();
    }

    // }}}

    // {{{ getAuteurIdsForArticleId($articleId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $articleId
     * @access public
     */

    function &getAuteurIdsForArticleId($articleId) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAuteurIdsForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_article=$articleId";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAuteurIdsForArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) $auteurs[] = $row['id_auteur'];
        $queryResult->free();
        return $auteurs;
    }

    // }}}

    // {{{ getAllForRubriqueIds($rubriques)

    /**
     * Returns an array of Article.
     *
     *
     * @return Array of Article
     * @param $rubriques
     * @access public
     */

    function &getAllForRubriqueIds($rubriques) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, statut, maj FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique IN ($rubriques)";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForRubriqueIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultArticle->_fetchData($row);
        $articles[] = &$resultArticle;
    }
    $queryResult->free();
    return $articles;
    }

    // }}}

    // {{{ getArticleIdsForAuteurId($auteurId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $auteurId
     * @access public
     */

    function &getArticleIdsForAuteurId($auteurId) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticleIdsForAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_auteur=$auteurId";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticleIdsForAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) $auteurs[] = $row['id_article'];
        $queryResult->free();
        return $auteurs;
    }

    // }}}

    // {{{ getAuteursForArticleId($articleId)

    /**
     * Returns an array of Author.
     *
     *
     * @return Array of Author
     * @param $articleId
     * @access public
     */

    function &getAuteursForArticleId($articleId) {
        require_once (dirname(__FILE__)."/inc_auteur_factory.php");        
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAuteursForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.* FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE lien.id_article=$articleId AND auteurs.id_auteur=lien.id_auteur";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAuteursForArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            // modification Olivier Mansour  
            $resultAuteur = &recuperer_instance_auteur();
            //$resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());
            // fin modification auteur"

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $auteurs[] = &$resultAuteur;
        }
        $queryResult->free();
        return $auteurs;
    }

    // }}}

    // {{{ howManyArticleForMot($conf_mot, $aff_articles, $statut)

    function HowManyArticleForMot($conf_mot, $aff_articles, $statut)    {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE lien.id_mot=$conf_mot AND article.id_article=lien.id_article AND article.statut LIKE '%$aff_articles%' AND article.statut!='$statut'";
		//$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_articles lien, ".$GLOBALS['table_prefix']."_articles article WHERE lien.id_mot=$conf_mot AND article.id_article=lien.id_article AND FIND_IN_SET(article.statut,'$aff_articles')>0 AND article.statut!='$statut'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticle = intval($row["cnt"]);
        }
        $result->free();
        return $howManyArticle;
    }
    // }}}

    // {{{ howManyArticlesForStatut($statut)

    function howManyArticlesForStatut($statut) {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(id_article) as cnt FROM ".$GLOBALS['table_prefix']."_articles WHERE statut LIKE '".$statut."'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : HowManyArticleForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticle = intval($row["cnt"]);
        }
        $result->free();
        return $howManyArticle;
    }
    // }}}

    // {{{ getAllDocumentsLies($id_article, $mode)

    /**
     * Returns an array of Document.
     *
     *
     * @return Array of Document
     * @param $id_article
     * @access public
     */

    function &getAllDocumentsLies($id_article, $mode, $docs_exclus = "", $id_doublons = null) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllDocumentLies()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_articles l WHERE l.id_article=$id_article AND l.id_document=docs.id_document ".$docs_exclus." AND docs.mode_spip='$mode'";
        if ($id_doublons) $query .= " AND docs.id_document NOT IN (".$id_doublons.") ";
        $query .= " ORDER BY docs.id_document";

        //echo $query;
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllDocumentLies()] ".$queryResult->getMessage(), null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $documentIds[] = $row['id_document'];
    }
    $queryResult->free();
    return $documentIds;
    }

    // }}}


    function &getAllForArticleIds($ids) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . ARTICLE_LIGHT_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles WHERE id_article IN (" . join(", ",$ids) . ")";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForArticleIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultArticle->_fetchData($row);
            $articles[] = &$resultArticle;
        }
        $queryResult->free();
        return $articles;
    }

    // }}}

    function &getAllArticleIds() {
        $ids = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_articles";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $ids[] = $row['id_article'];

        }
        $queryResult->free();
        return $ids;
    }

    function &getAllForRubriqueId($rubriqueId, $statut = null) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . ARTICLE_LIGHT_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=$rubriqueId";
		if($statut != null) $query .= " AND statut='$statut'";


		//echo '<br>' . $query . '<br>';

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForRubriqueIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultArticle->_fetchData($row);
        $articles[] = &$resultArticle;
    }
    $queryResult->free();
    return $articles;
    }

    // }}}

	// {{{ addBookmark($id_auteur)

	function addBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : addBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_bookmarks (id_auteur, id_objet, type_bookmark) VALUES (" . $id_auteur . "," . $this->getArticleId() . ", 'article')";
		
		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : addBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
				
	}
	
	// }}}

	// {{{ deleteBookmark($id_auteur)

	function deleteBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_bookmarks WHERE id_auteur=" . $id_auteur . " AND id_objet=" . $this->getArticleId() . " AND type_bookmark='article'";
		
		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : deleteBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
				
	}
	
	// }}}

	// {{{ isBookmark($id_auteur)

	function isBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_bookmarks WHERE id_auteur=" . $id_auteur . " AND id_objet=" . $this->getArticleId() . " AND type_bookmark='article'";
		
		//echo '<br>' . $query . '<br>';
                 
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isBookmark()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            if($row["cnt"] > 0) return true;
        }		
		return false;
				
	}
	
	// }}}
	
    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Article.
     *
     * @return Array of Article
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut, $orderBy = null, $desc = null) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='$statut'";
        
        if ($orderBy != null)   $query .= " ORDER BY $orderBy";
        
        if ($desc != null)   $query .= " DESC";
        
        //echo "<br><br>$query<br><br>";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultArticle->_fetchData($row);
            $articles[] = &$resultArticle;
        }
        $queryResult->free();
        return $articles;
    }

    // }}}	

    // {{{ getArticlesOfTheDay($date)

    /**
     * Returns an array of Articles Of The Day..
     *
     * @return Array of Article
     * @param $date
     * @access public
     */

    function &getArticlesOfTheDay($date) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesOfTheDay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date($date);
        $maDate->addSeconds(intval(3600*24));
        
        $query = "SELECT ".ARTICLE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date_heure >='$date' AND date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_heure";

        //echo "<br><br>$query<br><br>";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesOfTheDay()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultArticle->_fetchData($row);
            $articles[] = &$resultArticle;
        }
        $queryResult->free();
        return $articles;
    }

    // }}}

	// {{{ getAllMotherLang()

    /**
     * This method return la langue des rubriques mere pour chaque article fils
     * @return	Array
     */

    function getAllMotherLang() {
        die ('article.php getAllMotherLang ... obsolete');
        $articles = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllMotherLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }


        // requete de malade aussi !!!!!!!  faire sur une seule rubrique ? une branche
        $query = "SELECT fils.id_article AS id_article, mere.lang AS lang FROM ".$GLOBALS['table_prefix']."_articles fils, ".$GLOBALS['table_prefix']."_rubriques mere WHERE fils.id_rubrique = mere.id_rubrique AND fils.langue_choisie != 'oui' AND mere.lang<>'' AND mere.lang<>fils.lang";
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllMotherLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $articles[] = $row;
            }
        }
        
        return $articles;
        
    }

	// }}}

	// {{{ getAllArticleForStatutsOrderBy

    /**
     * This method return la liste des rubriques
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getAllArticleForStatutsOrderBy($statuts, $critere = 'titre') {
        
        $articles = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleForStatutsOrderBy()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT " . ARTICLE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles WHERE statut IN ($statuts) ORDER BY $critere";
        
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleForStatutsOrderBy()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
    
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
    
                $resultArticle->_fetchData($row);
                $articles[] = &$resultArticle;
            }
            $result->free();
        }
        
        return $articles;
        
    }

	// }}}

    // {{{ howManyArticleForTradID($id_trad)

    function howManyArticleForTradID($id_trad) {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyArticleForTradID()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(id_article) AS total FROM ".$GLOBALS['table_prefix']."_articles WHERE id_trad = $id_trad";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyArticleForTradID()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticle = intval($row["total"]);
        }
        $result->free();
        return $howManyArticle;
    }
    // }}}

    // {{{ howManyXForRubriqueId($critere)

    function howManyXForRubriqueId($critere) {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyXForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT SUM(".$critere.") AS cnt FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=\"$id_rubrique\"";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyXForRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyArticle = intval($row["cnt"]);
        }
        $result->free();
        return $howManyArticle;
    }
    // }}}

    // {{{ howManyX($critere)

    function howManyX($critere) {
        $howManyX = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyX()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT SUM(".$critere.") AS cnt FROM ".$GLOBALS['table_prefix']."_articles";
         
		//echo $query;
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyX()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyX = intval($row["cnt"]);
        }
        $result->free();
        return $howManyX;
    }
    // }}}

    // {{{ howManyXGroupByLang($critere)

    function howManyXGroupByLang($critere) {
        $rows = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyXGroupByLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT lang, SUM(".$critere.") AS cnt FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' GROUP BY lang";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : howManyXGroupByLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $rows = $row;
        }
        $result->free();
        return $rows;
    }
    // }}}

	// {{{ getAllArticleForTradId

    /**
     * This method return la liste des articles
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getAllArticleForTradId($tradId) {
        
        $articles = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleForTradId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT " . ARTICLE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles WHERE id_trad = $tradId";
        
         

        //echo '<br />' . $qeury . '<br />';

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllArticleForTradId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
    
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
    
                $resultArticle->_fetchData($row);
                $articles[] = &$resultArticle;
            }
            $result->free();
        }
        
        return $articles;
        
    }

	// }}}
    
	// {{{ getArticlesForStatutAndAuteur($statut, $auteurId)

    /**
     * This method return la liste des articles prpars par un auteur donn
     * @param statuts String
     * @param critere 
     * @return	Array
     */

    function getArticlesForStatutAndAuteur($statut, $auteurId) {
        
        $articles = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForStatutAndAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $query = "SELECT articles.id_article, articles.titre, articles.statut FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE articles.statut = '$statut' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId GROUP BY id_article ORDER BY articles.date_heure DESC";
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForStatutAndAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());
    
                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
    
                $resultArticle->_fetchData($row);
                $articles[] = &$resultArticle;
            }
            $result->free();
        }
        
        return $articles;
        
    }

	// }}}

	// {{{ getArticlesForRubriqueId($rubriqueId, $orderBy = null, $desc = null)

    /**
     * This method return la liste des articles d'une rubrique
     * @return	Array
     */

    function &getArticlesForRubriqueId($rubriqueId, $orderBy = null, $desc = null) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT " . ARTICLE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=$rubriqueId";
		if($orderBy != null) $query .= " ORDER BY $orderBy";
        if ($desc != null)   $query .= " DESC";

		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForRubriqueId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultArticle->_fetchData($row);
        $articles[] = &$resultArticle;
    }
    $queryResult->free();
    return $articles;
    }

    // }}}


	// {{{ getArticlesForRubriqueIdAndAuteurIdAndStatuts($rubriqueId, $auteurId)

    /**
     * This method return la liste des articles d'une rubrique en fonction de l'auteur ou de leurs statuts.
     * @return	Array
     */

    function &getArticlesForRubriqueIdAndAuteurIdAndIDontKnowWhyButIloveYou($rubriqueId, $auteurId) {
        $articles = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForRubriqueIdAndAuteurIdAndIDontKnowWhyButIloveYou()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //$query = "SELECT " . ARTICLE_ALL_FIELDS . " FROM ".$GLOBALS['table_prefix']."_articles AS articles, ".$GLOBALS['table_prefix']."_auteurs_articles AS lien WHERE articles.id_rubrique=$rubriqueId AND (articles.statut = 'publie' OR articles.statut = 'prop' OR (articles.statut = 'prepa' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId)) ORDER BY articles.date_heure DESC";
         /* Modification CPSQY / Stphane PETIT */
       /*$query = "SELECT articles.id_article, surtitre, titre, soustitre, id_rubrique, descriptif, chapo, texte, ps,
FROM ".$GLOBALS['table_prefix']."_articles AS articles, ".$GLOBALS['table_prefix']."_auteurs_articles AS lien WHERE articles.id_rubrique=$rubriqueId AND (articles.statut = 'publie' OR articles.statut = 'prop' OR (articles.statut = 'prepa' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId)) GROUP BY articles.id_article ORDER BY articles.date_heure DESC";
        */
       
       $query = "SELECT articles.id_article, surtitre, titre, soustitre, id_rubrique, descriptif, chapo, texte, ps, date_heure, statut, id_secteur, maj, export, date_redac, visites, referers, popularite, accepter_forum, auteur_modif, date_modif, extra, lang, langue_choisie, id_trad, nom_site, url_site
          FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien
          WHERE articles.id_rubrique=$rubriqueId AND (articles.statut = 'publie' OR articles.statut = 'prop' OR (articles.statut = 'prepa' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId))
          GROUP BY articles.id_article, surtitre, titre, soustitre, id_rubrique, descriptif, chapo, texte, ps, date_heure, statut, id_secteur, maj, export, date_redac, visites, referers, popularite, accepter_forum, auteur_modif, date_modif, extra, lang, langue_choisie, id_trad, nom_site, url_site
          ORDER BY articles.date_heure DESC";
        /* fin zone de modification CPSQY */
		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getArticlesForRubriqueIdAndAuteurIdAndIDontKnowWhyButIloveYou()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultArticle->_fetchData($row);
        $articles[] = &$resultArticle;
    }
    $queryResult->free();
    return $articles;
    }

    // }}}
    
    // {{{ isStatutDoneArticleByAuteur($statut, $auteurId)

    /**
     * This method returns
     * @return  int
     * @access  public
     */
    function isStatutDoneArticleByAuteur($statut, $auteurId) {
        $howManyArticle = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isStatutDoneArticleByAuteur()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(articles.id_article) AS cnt FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE articles.statut = '$statut' AND articles.id_article = lien.id_article AND lien.id_auteur = $auteurId GROUP BY lien.id_article";
		
        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : isStatutDoneArticleByAuteur()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyArticle = $result;
        }

        return $howManyArticle;
    }

    // }}}    

	// {{{ getLangUsed()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &getLangUsed() {
        $langues = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getLangUsed()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT lang FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie'";
		
         
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getLangUsed()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $langues[] = $row['lang'];
    }
    $queryResult->free();
    return $langues;
    }

    // }}}
    
	// {{{ calculatePublishedRubrique()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &calculatePublishedRubrique($trad_lang) {
        return PEAR::raiseError("[".get_class($this)." DB_article : calculatePublishedRubrique()] PAS D'IMPLEMENTATION DE CETTE METHODE", null,
                null, null, null, null, false);
    }

    // }}}
    
    // {{{ calculatepublishedRubrique()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &calculateNoTraductionForRubrique($trad_lang) {
        return PEAR::raiseError("[".get_class($this)." DB_article : calculateNoTraductionForRubrique()] PAS D'IMPLEMENTAION DE CETTE METHODE", null,
                null, null, null, null, false);
    }

    // }}}

    // {{{ getTradStatistics()

    /**
     * This method return la liste des langues utiliss par les articles.
     * @return	Array
     */

    function &getTradStatistics($trad_lang) {
        return PEAR::raiseError("[".get_class($this)." DB_article : calculateNoTraductionForRubrique()] PAS D'IMPLEMENTAION DE CETTE METHODE", null,
                null, null, null, null, false);
    }

    // }}}


	// {{{ switchVersion
	
	/**
	 * This method switch an article with another version of itself
	 * @return	Void  
	 */ 
	
	function switchVersion($id_article, $id_article_version) {
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : switchVersion()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        if ( (!isset($this->_statut)) or (!isset($this->_articleId))) {
        // if(true) { 
        // charger les infos ds la base
            $this->loadLightWeight($id_article);
        }
        if ($this->getStatut() == 'publie') {
            // j'ai besoin des metas
            include_once (dirname(__FILE__).'/../utils/meta.php');
        	$statut = lire_meta('statut_article_old_version');
        } else {
        	$statut = $articleSource->getStatut();
        }
        
		$string_prefix = $GLOBALS['table_prefix']."_articles";
        
        $articleNewId = $db->nextId($string_prefix, true);
        
        // Gestion des conservation des composant (auteur et mot cles) pour el versionning
        $this->updateVersionComponent($id_article, $articleNewId, $GLOBALS['table_prefix']."_mots_articles"," id_mot");
        $this->updateVersionComponent($id_article, $articleNewId, $GLOBALS['table_prefix']."_auteurs_articles"," id_auteur");
        //exit();
        
        $sqlUpdateOriginal = "UPDATE ".$GLOBALS['table_prefix']."_articles ";
        $sqlUpdateOriginal .= "SET id_article=$articleNewId, ";
        $sqlUpdateOriginal .= " version_id = $id_article, ";
        $sqlUpdateOriginal .= " statut='".$statut."' ";
        $sqlUpdateOriginal .= "WHERE id_article=$id_article ";
        $rsUpdateOriginal = $db->query($sqlUpdateOriginal);
        if (DB::isError($rsUpdateOriginal)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : switchVersion()] ".$rsUpdateOriginal->getMessage()."", null,
                null, null, null, null, false);
        }
        
        
        
        $sqlUpdateVersion = "UPDATE ".$GLOBALS['table_prefix']."_articles ";
        $sqlUpdateVersion .= "SET id_article=$id_article, ";
        $sqlUpdateVersion .= " statut='publie', ";
        $sqlUpdateVersion .= " version_id = 0 ";
        $sqlUpdateVersion .= "";
        $sqlUpdateVersion .= "WHERE id_article=$id_article_version ";
        $rsUpdateVersion = $db->query($sqlUpdateVersion);
         if (DB::isError($rsUpdateVersion)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : switchVersion()] ".$rsUpdateVersion->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Gestion des conservation des composant (auteur et mot cles) pour el versionning
        $this->updateVersionComponent($id_article_version, $id_article, $GLOBALS['table_prefix']."_mots_articles"," id_mot");
        $this->updateVersionComponent($id_article_version, $id_article, $GLOBALS['table_prefix']."_auteurs_articles"," id_auteur");
        
        
        //exit();
        
        
	}
	 
	// }}}
	
	// {{{ getAllForVersion
	
	/**
	 * This method return an all articles for one version
	 */
	function getAllForVersion($orderby) {
		$articles = array();
        $db = &$this->_getDB();
        
        $version_id = $this->_articleId;

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForVersion()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_articles WHERE version_id='$version_id'";
        
        if ($orderBy != null)   $query .= " ORDER BY $orderBy";
        
        if ($desc != null)   $query .= " DESC";
        
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : getAllForVersion()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultArticle = &BD_article::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultArticle->_fetchData($row);
            $articles[] = &$resultArticle;
        }
        $queryResult->free();
        return $articles;
	}
	// }}}

	// {{{

    

	/**
     * fabrique un historique
     * @access public
     */

	function create_historique () {
		if ($this->getActiverHistorique() == 'oui') {
			// activation de l'historique 
		    $articleHistorique = recuperer_instance_article_historique();
		    $articleHistorique->loadFromArticle($this);
		    $articleHistorique->create();
	    }
	}
	
	
	
	
	
	// }}}
	
	
	// {{{
	
	/**
	* compte le nbre dentree ds la table historique pour cet article
	* @access public
	*/
	
	function countHistorique() {
		$db = &$this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article : countHistorique()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$query = "SELECT "
			."count(id_article_historique)"
			."FROM ".$GLOBALS['table_prefix']."_articles_historique "
			."WHERE "
			."  id_article = ".$this->getArticleId();
		return $db->getOne($query);
	}
	// }}}
	
	
	// {{{
	
	/**
	* modifie l'article  partir d'un historique
	*/
	function switchHistorique ($id_article_historique) {
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : switchVersion()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $articleHistoriqueMetier = recuperer_instance_article_historique();
        $articleHistoriqueMetier->load($id_article_historique); 
        if (Pear::isError($articleHistoriqueMetier)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : switchVersion()] ".$articleHistoriqueMetier->getMessage()."", null,
                null, null, null, null, false);
        }
        $this->setArticleId($articleHistoriqueMetier->_articleId);
		$this->setSurtitre($articleHistoriqueMetier->_surtitre);
		$this->setTitre($articleHistoriqueMetier->_titre);
		$this->setSoustitre($articleHistoriqueMetier->_soustitre);
		$this->setDescriptif($articleHistoriqueMetier->_descriptif);
		$this->setChapo($articleHistoriqueMetier->_chapo);
		$this->setTexte($articleHistoriqueMetier->_texte);
		$this->setPs($articleHistoriqueMetier->_ps);
		$this->setExtra($articleHistoriqueMetier->_extra);
		$this->setDate($articleHistoriqueMetier->_date);
		$this->update();
	}
	
	// }}}
	
	// {{{ updateVersionComponent
	/**
	 * Update a new article version with all component around itself
	 * (mot cles, auteurs...) 
	 */
	
	function updateVersionComponent($id_source, $id_destination, $table_name, $field_name, $nouvelle_version="non") {
		$db = &$this->_getDB();
		if (DB::isError($db)) {
			return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Selection des infos de la source
        $sqlGetSource = "";
        $sqlGetSource .= "SELECT ";
        $sqlGetSource .= "id_article, ".$field_name." as id_source ";
        $sqlGetSource .= "FROM ".$table_name." ";
        $sqlGetSource .= "WHERE id_article = ".$id_source;
        $rsGetSource = $db->query($sqlGetSource);
        

        if (DB::isError($rsGetSource)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

		$aInfosSource = array();
        while ($row = $rsGetSource->fetchRow()) {
        	$aInfosSource[] = $row['id_source'];
        }
        $rsGetSource->free();
        
        
        // Selection des infos de la destination
        $sqlGetDest = "";
        $sqlGetDest .= "SELECT ";
        $sqlGetDest .= "id_article, ".$field_name." as id_dest ";
        $sqlGetDest .= "FROM ".$table_name." ";
        $sqlGetDest .= "WHERE id_article = ".$id_destination;
        $rsGetDest = $db->query($sqlGetDest);
        

        if (DB::isError($rsGetDest)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$rsGetDest->getMessage()."", null,
                null, null, null, null, false);
        }

		$aInfosDest = array();
        while ($row = $rsGetDest->fetchRow()) {
        	$aInfosDest[] = $row['id_dest'];
        }
        $rsGetSource->free();
        
        // Suppression des infos sources et destination
        if ($nouvelle_version != "oui") {
	        $sqlDeleteSource = "";
	        $sqlDeleteSource .= "DELETE FROM ".$table_name." ";
	        $sqlDeleteSource .= "WHERE id_article=".$id_source." ";
	        $rsDeleteSource = $db->query($sqlDeleteSource);
	         if (DB::isError($rsGetDest)) {
	            return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$rsDeleteSource->getMessage()."", null,
	                null, null, null, null, false);
	        }
        }
        
        $sqlDeleteDest = "";
        $sqlDeleteDest .= "DELETE FROM ".$table_name." ";
        $sqlDeleteDest .= "WHERE id_article=".$id_destination." ";
        $rsDeleteDest = $db->query($sqlDeleteDest);
         if (DB::isError($rsGetDest)) {
            return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$rsDeleteDest->getMessage()."", null,
                null, null, null, null, false);
        }
               
        
        
        // Insertion des infos de la source
        while (list(,$id_field) = each($aInfosSource)) {
        	$sqlUpdate = "";
        	$sqlUpdate .= "INSERT INTO ".$table_name."(id_article, ".$field_name.")";
        	$sqlUpdate .= "VALUES(".$id_destination.",".$id_field.")";
        	$rsUpdate = $db->query($sqlUpdate);

        	if (DB::isError($rsUpdate)) {
            	return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$rsUpdate->getMessage()."", null,
                	null, null, null, null, false);
        	}
        }
        
        // Insertion des infos de la destination
        while (list(,$id_field) = each($aInfosDest)) {
        	$sqlUpdate = "";
        	$sqlUpdate .= "INSERT INTO ".$table_name."(id_article, ".$field_name.")";
        	$sqlUpdate .= "VALUES(".$id_destination.",".$id_field.")";
        	$rsUpdate = $db->query($sqlUpdate);

        	if (DB::isError($rsUpdate)) {
            	return PEAR::raiseError("[".get_class($this)." DB_article : updateVersionComponent()] ".$rsUpdate->getMessage()."", null,
                	null, null, null, null, false);
        	}
        }
        
	}
	
	// }}}

    // {{{ setPublicationDate

    /** Change la date de publication de l'article 
     * @param      array      $date
     * @param      array      $time
     * @return     true ou PEAR_Error
     */
     function setPublicationDate( $date, $time = null ) {
         if (is_null($time[0])) $time = null; // si le premier arg de time (l'heure) est null on nullifie le reste
         //
         $date[1] = (int) $date[0] ? $date[1] : '00';
         $date[2] = (int) $date[1] ? $date[2] : '00';

         // Cr?ation d'une chaine au format 'YYYY-MM-DD HH:MM:SS'
         $datetime = implode( '-', $date ) .' '. ( $time ? implode(':', $time) : '00:00:00' );

         // Mise ? jour de l'objet
         $this->setDate( $datetime );
         $status = $this->update();

         if ( PEAR::isError($status) ) return $status;
         else return true;
    }

    // }}}

    //{{{ setExpirationDate
    
    /** Change la date d expiration de l'article 
     * @param      array      $date
     * @param      array      $time
     * @return     true ou PEAR_Error
     */
     function setExpirationDateWithArray ( $date, $time = null ) {
         if (is_null($time[0])) $time = null; // si le premier arg de time (l'heure) est null on nullifie le reste
         //
         $date[1] = (int) $date[0] ? $date[1] : '00';
         $date[2] = (int) $date[1] ? $date[2] : '00';

         // Cr?ation d'une chaine au format 'YYYY-MM-DD HH:MM:SS'
         $datetime = implode( '-', $date ) .' '. ( $time ? implode(':', $time) : '00:00:00' );

         // Mise ? jour de l'objet
         $this->setExpirationDate( $datetime );
         $status = $this->update();

         if ( PEAR::isError($status) ) return $status;
         else return true;
    }
    
    // }}}
    
    // {{{ countAuteurs

     /** Compte le nombre d'auteurs associs  l'article.
      * @return int
      */
     function countAuteurs() {
         $auteur =& recuperer_instance_auteur();
         $auteurs = $auteur->getAllForArticleId( $this->getArticleId() );
         return is_array($auteurs) ? count($auteurs) : 0;
     }
     
     // }}}

	// {{{ updateEmbargo()
	
	/**
	 * Cette mthode retourne la date de publication d'un article la plus proche de la date courante
	 */
	function updateEmbargo() {
        // le faire que si $this->getDate() est dans le futur
        $now = new Date();
        if (Date::compare(new Date($this->getDate()), $now) > 0) {
		    include_once (dirname(__FILE__).'/../embargo/embargo.php');
            writeEmbargo($this->getDate(), $this->getArticleId());
        }
        // le faire si $this->getExpirationDate est dans le futur
        if (Date::compare(new Date($this->getExpirationDate()), $now) > 0) {
		    include_once (dirname(__FILE__).'/../embargo/embargo.php');
            writeEmbargo($this->getExpirationDate(), $this->getArticleId());
        }
        
	}
	// }}}

    // {{{
    
    function getArticleIds( $criteres = array() ) {
        $db = &$this->_getDB();
		if (DB::isError($db)) {
			return PEAR::raiseError("[".get_class($this)." ".__FUNCTION__."()] ".$db->getMessage()."", null,
                                    null, null, null, null, false);
        }

        $q = sprintf( "SELECT %s FROM %s WHERE %s;", 
                      'id_article', 'spip_articles', '1' );

        $res = $db->query( $q );

		if (DB::isError($res)) {
			return PEAR::raiseError("[".get_class($this)." ".__FUNCTION__."()] ".$res->getMessage()."", null,
                                    null, null, null, null, false);
        }

        $articles_ids = array();
        while ( $r = $res->fetchRow(DB_FETCHMODE_ASSOC) ) {

            $articles_ids[] = $r['id_article'];
        }
        
        
        
        $res->free();

        return $articles_ids;
    }

    // }}}
    
    // {{{

    /** Voir bd_metier::getUrl() */
    function getUrl( $edit = false ) {
         if ($edit) {
            include_once (dirname(__FILE__).'/../utils/meta.php');
            return lire_meta('adresse_site').'/ecrire/articles.php3?id_article=' . $this->getRubriqueId();
        } else {
            die ('je ne sais pas encore faire');
        }
    }
    
    // }}}
}

?>
