<?php    
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Aurelien Vialet  <avialet@clever-age.com>                    |
// +----------------------------------------------------------------------+
//
// Base class for Article Historique business persistence abstraction.
// $Id$

require_once (dirname(__FILE__)."/inc_visite_factory.php");
require_once (dirname(__FILE__)."/inc_referer_factory.php");
require_once (dirname(__FILE__)."/inc_auteur_factory.php");


require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_meta.php3";

define("ARTICLE_HISTORIQUE_ALL_FIELDS", " id_article_historique, id_article, id_auteur, surtitre, titre, soustitre, descriptif, chapo, texte, ps, extra, date_heure, nom_site, url_site  ");

/**
 * BD_article_historique is a base class for article historique business 
 * persistence abstraction implementations, and must be inherited by all such.
 * @package	BD
 * @author  Aurelien Vialet <avialet@clever-age.com>
 * @access	public
 */

class BD_article_historique extends BD_metier {

	// {{{ properties

	/**
	 * Article  Historique ID
	 * @var		int
	 * @access private
	 */
	var $_articleHistoriqueId;

	/**
	 * Article ID.
	 * @var     int
	 * @access  private
	 */
	var $_articleId;

	/**
	 * Auteur de la modification.
	 * @var     int
	 * @access  private
	 */
	var $_auteurId;

	/**
	 * Surtitre
	 * @var		String
	 * @access	private
	 */
	var $_surtitre;

	/**
	 * Titre
	 * @var		String
	 * @access	private
	 */
	var $_titre;

	/**
	 * Sous Titre
	 * @var		String
	 * @access	private
	 */
	var $_descriptif;

	/**
	 * Chapo
	 * @var 	String
	 * @access private
	 */
	var $_chapo;

	/**
	 * Texte
	 * @var 	String
	 * @access	private
	 */
	var $_texte;

	/**
	 * PS
	 * @var		String
	 * @access	private
	 */
	var $_ps;

	/**
	 * date_heure
	 * @var 	int
	 * @access	private
	 */
	var $_date;

	/**
	 * $_extra
	 * @var		String
	 * @access private
	 */
	var $_extra;

	// }}}

    /**
     * Site name.
     * @var     String
     * @access  private
     */
    var $_nomSite;
    
    /**
     * Site URL.
     * @var     String
     * @access  private
     */    
    var $_urlSite;

	// {{{ factory()

	/**
	 * This method is a factory static method. It should be used to get any
	 * specific implementation instace of Article HIstorique business data type.
	 * @param   BD_parameters DB connection parameters
	 * @access public
	 */
	function &factory($dbParameters, $dbOptions = null) {

		if (file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/article_historique_".$dbParameters->_dbEngine.".php") == false) {
			include_once (dirname(__FILE__)."/common/article_historique_common.php");
			$classname = "BD_article_historique_common";
		} else {
			include_once (dirname(__FILE__)."/".$dbParameters->_dbEngine."/article_historique_".$dbParameters->_dbEngine.".php");
			$classname = "BD_article_historique_".$dbParameters->_dbEngine;
		}

		if (!class_exists($classname)) {
			return PEAR :: raiseError("Cannot instanciate class $classname", null, null, null, null, null, false);
		}

		$obj = & new $classname;
		$result = $obj->setDbParameters($dbParameters);
		if ($dbOptions != null) {
			$obj->setDbOptions($dbOptions);
		}
		if (PEAR :: isError($result)) {
			return $result;
		} else {
			return $obj;
		}
	}

	// }}}

	// {{{ constructor

	/**
	 * DB_article_historique constructor.
	 *
	 * @access public
	 */

	function BD_article_historique() {
	}

	// }}}

	//  {{{ getArticleHistoriqueId()
	function getArticleHistoriqueId() {
		return $this->_articleHistoriqueId;
	}
	// }}}

	// {{{ setArticleHistoriqueId()
	function setArticleHistoriqueId($articleHistoriqueId) {
		$this->_articleHistoriqueId = $articleHistoriqueId;
	}
	// }}}

	// {{{ getArticleId()

	function getArticleId() {
		return $this->_articleId;
	}

	// }}}

	// {{{ setArticleId()

	function setArticleId($articleId) {
		$this->_articleId = $articleId;
	}

	// }}}

	function getAuteurId() {
		return $this->_auteurId;
	}

	function setAuteurId($auteurId) {
		$this->_auteurId = $auteurId;
	}

	// {{{ getSurtitre()

	function getSurtitre() {
		return $this->_surtitre;
	}

	// }}}

	// {{{ setSurtitre()

	function setSurtitre($surtitre) {
		$this->_surtitre = $this->corriger_caracteres($surtitre);
	}

	// }}}

	// {{{ getTitre()

	function getTitre() {
		return $this->_titre;
	}

	// }}}

	// {{{ setTitre()

	function setTitre($titre) {
		$this->_titre = $this->corriger_caracteres($titre);
	}

	// }}}

	// {{{ getSoustitre()

	function getSoustitre() {
		return $this->_soustitre;
	}

	// }}}

	// {{{ setSoustitre()

	function setSoustitre($soustitre) {
		$this->_soustitre = $this->corriger_caracteres($soustitre);
	}

	// }}}

	// {{{ getDescriptif()

	function getDescriptif() {
		return $this->_descriptif;
	}

	// }}}

	// {{{ setDescriptif()

	function setDescriptif($descriptif) {
		$this->_descriptif = $this->corriger_caracteres($descriptif);
	}

	// }}}

	// {{{ getChapo()

	function getChapo() {
		return $this->_chapo;
	}

	// }}}

	// {{{ setChapo()

	function setChapo($chapo) {
		$this->_chapo = $this->corriger_caracteres($chapo);
	}

	// }}}

	// {{{ getTexte()

	function getTexte() {
		return $this->_texte;
	}

	// }}}

	// {{{ setTexte()

	function setTexte($texte) {
		$this->_texte = $this->corriger_caracteres($texte);
	}

	// }}}
    // {{{ getNomSite()

    /**
     * get Site Name.
     * @var     String
     * @access  private
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}
    
    // {{{ setNomSite()


    /**
     * Set Site Name.
     * @var     String
     * @access  private
     */

    function setNomSite($nomSite) {
        $this->_nomSite = $nomSite;
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * get Site Url.
     * @var     String
     * @access  private
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}
    
    // {{{ setUrlSite()


    /**
     * Set Site Url.
     * @var     String
     * @access  private
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = $urlSite;
    }

    // }}}


	// {{{ getPs()

	function getPs() {
		return $this->_ps;
	}

	// }}}

	// {{{ setPs()

	function setPs($ps) {
		$this->_ps = $this->corriger_caracteres($ps);
	}

	// }}}

	// {{{ getDate()

	function getDate() {
		return $this->_date;
	}

	// }}}

	// {{{ setDate()

	function setDate($date) {
		$this->_date = $date;
	}

	// }}}

	// {{{ getExtra()

	function getExtra() {
		return $this->_extra;
	}

	// }}}

	// {{{ setExtra()

	function setExtra($extra) {
		$this->_extra = $extra;
	}

	// }}}
	
	
	// {{{ _fetchData()
	function _fetchData($row) {
		$this->setArticleHistoriqueId($row['id_article_historique']);
		$this->setArticleId($row['id_article']);
		$this->setSurtitre($row['surtitre']);
		$this->setTitre($row['titre']);
		$this->setSoustitre($row['soustitre']);
		$this->setDescriptif($row['descriptif']);
		$this->setChapo($row['chapo']);
		$this->setTexte($row['texte']);
		$this->setPs($row['ps']);
		$this->setExtra($row['extra']);
		$this->setDate($row['date_heure']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setAuteurId($row['id_auteur']);
	}
	// }}}

	// {{{ loadFromArticle()
	function loadFromArticle($obj) {
		$obj->load($obj->_articleId);
		$this->setArticleId($obj->_articleId);
		$this->setSurtitre($obj->_surtitre);
		$this->setTitre($obj->_titre);
		$this->setSoustitre($obj->_soustitre);
		$this->setDescriptif($obj->_descriptif);
		$this->setChapo($obj->_chapo);
		$this->setTexte($obj->_texte);
		$this->setPs($obj->_ps);
		$this->setExtra($obj->_extra);
		//$this->setDate($obj->_date);
        $this->setNomSite($obj->_nomSite);
        $this->setUrlSite($obj->_urlSite);
        $this->setAuteurId($obj->_auteurModif);
	}
	// }}}

	// {{{ create()
	function create() {
		if ($this->exists()) {
			return false;
		}

		$db = & $this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article : create()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$string_prefix = $GLOBALS['table_prefix']."_articles_historique";

		// date de maintentant 
		$maDate = new Date();
		$this->setDate($maDate->getDate(DATE_FORMAT_ISO));

		$articleHistoriqueId = $db->nextId($string_prefix, true);
		if (DB :: isError($articleHistoriqueID)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : create()] ".$articleId->getMessage()."", null, null, null, null, null, false);
		}

		$this->_articleHistoriqueId = $articleHistoriqueId;

		$query = "INSERT INTO ".$GLOBALS['table_prefix']."_articles_historique (".ARTICLE_HISTORIQUE_ALL_FIELDS
		.") VALUES "
		."(".$this->_articleHistoriqueId.", "
		."".$this->_articleId.", "
		."".$this->_auteurId.", "
		."'".$db->quoteString($this->_surtitre)."', "
		."'".$db->quoteString($this->_titre)."', "
		."'".$db->quoteString($this->_soustitre)."', "
		."'".$db->quoteString($this->_descriptif)."', "
		."'".$db->quoteString($this->_chapo)."', "
		."'".$db->quoteString($this->_texte)."', "
		."'".$db->quoteString($this->_ps)."', "
		."'".$db->quoteString($this->_extra)."', "
		."'".$db->quoteString($this->_date)."', "
		."'".$db->quoteString($this->_nomSite)."', "
        ."'".$db->quoteString($this->_urlSite)."')";

		
		$result = $db->query($query);

		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article : create()] ".$result->getMessage()."", null, null, null, null, null, false);
	    }
	}
	// }}}

	// {{{ exists
	function exists() {
		$db = & $this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : create()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$query = "SELECT count(*) AS nbHisto FROM "
		.$GLOBALS['table_prefix']."_articles_historique "
		." WHERE  1=1 "
		." AND    id_article = ".$this->_articleId." "
		." AND    id_auteur = ".$this->_auteurId." "
		." AND    surtitre = '".$db->quoteString($this->_surtitre)."' "
		." AND    titre = '".$db->quoteString($this->_titre)."' "
		." AND    soustitre = '".$db->quoteString($this->_soustitre)."' "
		." AND    descriptif = '".$db->quoteString($this->_descriptif)."' "
		." AND    chapo = '".$db->quoteString($this->_chapo)."' "
		." AND    texte = '".$db->quoteString($this->_texte)."' "
		." AND    ps = '".$db->quoteString($this->_ps)."' "
		." AND    extra = '".$db->quoteString($this->_extra)."' "
		." AND    date_heure = '".$db->quoteString($this->_date)."' ";
		$result = $db->query($query);
		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : exists()] ".$result->getMessage()."", null, null, null, null, null, false);
		} else {
			if ($row = $result->fetchRow()) {
				$result->free();
				if ($row['nbHisto'] > 0) {
					return true;
				} else {
					return false;
				}
			} else {
				return PEAR :: raiseError("[".get_class($this)." DB_article_historique : exists] ", null, null, null, null, null, false);
			}
		}
	}
	// }}}
	
	// {{{ loadHistoForArticle()
	function loadHistoForArticle($idArticle, $idHisto = false) {
		$db = &$this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : loadHistoForArticle()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$query = "SELECT "
		.ARTICLE_HISTORIQUE_ALL_FIELDS
		."FROM ".$GLOBALS['table_prefix']."_articles_historique "
		."WHERE "
		."  id_article = ".$idArticle
		." ORDER BY id_article_historique desc ";
		$result = $db->query($query);
		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : loadHistoForArticle()] ".$result->getMessage()."", null, null, null, null, null, false);
		} else {
			$aArticles = array();
			while ($row = $result->fetchRow()) {
				$currentArticle = &recuperer_instance_article_historique();
				$currentArticle->_fetchData($row);
            	$aArticles[] = $currentArticle;
        	}
        $result->free();
        return $aArticles;
		}
	}
	// }}}
	
	// {{{ load
	function load($idArticleHistorique) {
		$db = &$this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : load()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$query = "SELECT "
		.ARTICLE_HISTORIQUE_ALL_FIELDS
		."FROM ".$GLOBALS['table_prefix']."_articles_historique "
		."WHERE "
		."  id_article_historique = ".$idArticleHistorique;
		$result = $db->query($query);
		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : load()] ".$result->getMessage()."", null, null, null, null, null, false);
		} else {
			$aArticles = array();
			$row = $result->fetchRow();
			$this->_fetchData($row);
            $result->free();
		}
	}
	// }}}
	
	// {{{ purgeHisto
	function purgeHisto($articleHisto) {
		$db = &$this->_getDB();
		if (DB :: isError($db)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : purgeHisto()] ".$db->getMessage()."", null, null, null, null, null, false);
		}
		$query = "DELETE FROM ".$GLOBALS['table_prefix']."_articles_historique "
		. "WHERE id_article_historique IN (";
		while (list(,$val) = each($articleHisto)) {
			$query .= $val.",";
		}
		$query .= "-10 )";
		$result = $db->query($query);
		if (DB :: isError($result)) {
			return PEAR :: raiseError("[".get_class($this)." DB_article_historique : purgeHisto()] ".$result->getMessage()."", null, null, null, null, null, false);
		}
	}
	// }}}


    /** Renvoie la reprsentation littrale de l'objet 
     * @return string
     * @todo   Splitter ca dans un systme de renderers (avec pattern visitor et tout et tout,
     *         mais en attendant...
     */
    function toString() {
        $str = array();
        $str[] = $this->getSurtitre() 
            ? $this->_formatData( $this->getSurtitre(), 'surtitre' )
            : '';
        $str[] = $this->getTitre() 
            ? $this->_formatData( $this->getTitre(), 'titre' )
            : '';
        $str[] = $this->getDescriptif()
            ? $this->_formatData( $this->getDescriptif(), 'descriptif' )
            : '';
        $str[] = $this->getSoustitre() 
            ? $this->_formatData( $this->getSoustitre(), 'soustitre' )
            : '';
        // TODO : site
        $str[] = $this->getChapo()
            ? $this->_formatData( $this->getChapo(), 'chapo' )
            : '';
        $str[] = $this->getTexte()
            ? propre( $this->_formatData($this->getTexte(), 'texte') )
            : '';
        $str[] = $this->getPs() 
            ?$this->_formatData( $this->getPs(), 'ps' )
            : '';
        // TODO : extras
        
        return implode( "\n", $str );
    }

    /** Formatte les donnes en fonction de leur type.
     * @param   string    $data
     * @param   string    $type
     * @return  string
     * @todo    C'est moche !
     */
    function _formatData( $data, $type ) {
        $patterns = array( 'texte' => '%s',
                           'surtitre' => '<p><font face="arial,helvetica" size="3"><b>%s</b></font></p>',
                           'soustitre' => '<p><font face="arial,helvetica" size="3"><b>%s</b></font></p>',
                           'titre' => '<p><span style="border-bottom: 1px dashed rgb(56, 116, 176);"><font color="#3874b0" face="Verdana,Arial,Sans,sans-serif" size="4"><b>%s</b></font></span></p>',
                           'descriptif' => '<div style="border: 1px dashed rgb(170, 170, 170); padding: 5px; background-color: rgb(228, 228, 228);"><font face="Verdana,Arial,Sans,sans-serif" size="2"><strong class="spip">Descriptif : </strong>%s</font></div>',
                           'site' => '<p><font face="Verdana,Arial,Sans,sans-serif" size="2"><strong class="spip">Lien hypertexte : </strong>%s</font></p>',
                           'chapo' => '<p><strong>%s</strong></p>',
                           'ps' => '<p><font size="2" face="Verdana,Arial,Sans,sans-serif"><strong>PS : </strong>&nbsp;%s</font></p>'
                           );

        if ( ! isset($patterns[$type]) ) { $type = 'texte'; };
        return sprintf( $patterns[$type], $data );
    }

}
