<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Antoine Angnieux <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Article List Data abstraction.
//

// $Id$

/* Ajout Clever Age / Erwan LE BESCOND */
require_once (dirname(__FILE__)."/inc_petition_factory.php");
/* fin zone de modification Clever Age */


require_once (dirname(__FILE__)."/objectlistdata.php");
require_once (dirname(__FILE__)."/inc_listdata_querytypes_constants.php");

/**
 * This class implements data lists for Article business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_articleListData extends BD_objectListData {

    /**
     * Create a new article list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     * @return mixed a newly created ArticleListData object, or a PEAR error code on
     *               error
     * @access public
     */
    function &factory($dbParameters = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/articlelistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/articlelistdata_common.php");
            $classname = "BD_articlelistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/articlelistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_articleListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Abstract Constructor.
     *
     * @access public
     */


    function BD_articleListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ getHTMLList($titre_table, $queryType, $afficher_visites = false, $afficher_auteurs = true, $toujours_afficher = false, $afficher_cadre = true)

    /**
     * returns the HTML List for the various article data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $afficher_visites = false, $afficher_auteurs = true, $toujours_afficher = false, $afficher_cadre = true, $firstElement = 0, $lastElement = 0, $url = 'articles.php3', $urlParams = '') {
        global $connect_id_auteur, $connect_statut;
        $activer_messagerie = lire_meta("activer_messagerie");
        $activer_statistiques = lire_meta("activer_statistiques");
        $activer_statistiques_ref = lire_meta("activer_statistiques_ref");

        $authorization = &recuperer_instance_authorization('afficherArticleVisites', $GLOBALS['connect_id_auteur'], array('afficher_visites' => $afficher_visites, 'activer_statistiques' => $activer_statistiques));
        $afficher_visites = $authorization->isAuthorizedAction();

        $copyParams = $params;
        
		$requete = $this->_getQuery($queryType, false, $copyParams);

        //        echo '<br>' . $requete . '<br>';
        

        $tranches = $this->_getHTMLNavigation($queryType, $params, $afficher_auteurs ? 3 : 2);
        if (strlen($tranches) OR $toujours_afficher) {
            $db = &$this->_getDB();
            if (DB::isError($db)) {
                die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
            }

            if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result = $db->limitQuery($requete, $limitStart, $limitCount, $copyParams);
            } else {
                if($lastElement > 0) {
                    $result = $db->limitQuery($requete, $firstElement, $lastElement, $copyParams);
                }
                else {
                    $result = $db->query($requete, $copyParams);
                }
            }
            /*
            $result = ".$GLOBALS['table_prefix']."_query($requete);
            */

            
            if (DB::isError($result)) {
                die("la requete a choue! ".$result->getMessage());
            }
            
            if ($afficher_cadre) debut_cadre_relief("article-24.gif");
            echo "<table width=100% cellpadding=0 cellspacing=0 border=0><tr><td width=100% background=''>";
            echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";
			
            bandeau_titre_boite_articles($titre_table, $afficher_auteurs);

            echo $tranches;

            while ($row = $result->fetchRow()) {
                $vals = '';

                switch($queryType) {
                    case ARTICLES_FORUM_MESSAGE:
						$id_article = $row['id_article'];
                        $forumMetier = &recuperer_instance_forum();
						$nbMessageTotal = $forumMetier->howManyForumForArticleId($id_article) . ' message(s)';
                        $id_rubrique = $row['id_rubrique'];
                        $titre = $row['titre'];
                        $statut = $row['statut'];

                        switch ($statut) {
                        case 'publie':
                            $puce = 'verte';
                            $title = _T('info_article_publie');
                            break;
                        case 'prepa':
                            $puce = 'blanche';
                            $title = _T('info_article_redaction');
                            break;
                        case 'valid':
                            $puce = 'jaune';
                            $title = _T('info_article_valide');
                            break;
                        case 'prop':
                            $puce = 'orange';
                            $title = _T('info_article_propose');
                            break;
                        case 'archi':
                            $puce = 'marron';
                            $title = _T('info_article_archive');
                            break;
                        case 'refuse':
                            $puce = 'rouge';
                            $title = _T('info_article_refuse');
                            break;
                        case 'poubelle':
                            $puce = 'poubelle';
                            $title = _T('info_article_supprime');
                            break;
                        }

                        $authorization = &recuperer_instance_authorization('controlerForum', $GLOBALS['connect_id_auteur'], array('id_rubrique' => $id_rubrique));
                        if($authorization->isAuthorizedAction()) {
    	                    $s = "<a href=\"$url?id_article=$id_article&$urlParams\" title=\"$title\">";
                            $puce = "puce-$puce.gif";

                            $s .= "<img src=\"img_pack/$puce\" alt='' width=\"13\" height=\"14\" border=\"0\"></a>&nbsp;&nbsp;";
                            if (acces_restreint_rubrique($id_rubrique))
                                $s .= "<img src='img_pack/admin-12.gif' alt='' width='12' height='12' title='"._T('titre_image_admin_article')."'>&nbsp;";
                            $s .= "<a href=\"$url?id_article=$id_article&$urlParams\"$descriptif>".typo($titre)."</a>";
                            $forumMetier = &recuperer_instance_forum();
                            $nbMessProp = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'prop'");
                            $s .= "<td align='right' colspan=2><img src=\"img_pack/puce-orange.gif\" alt='"._T('message_attente_validation')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=prop&vierge=1&id_current_forum=$id_article&type_forum=article'>$nbMessProp message(s) en attente</a></td>";


                            $s .= "<tr><td align=center colspan=3>";

                            $nbMessPublie = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'publie'");
                            $s .= "<img src=\"img_pack/puce-verte.gif\" alt='"._T('message_publie')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=tout&vierge=1&id_current_forum=$id_article&type_forum=article'>$nbMessPublie mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                            $nbMessOff = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'off'");
                            $s .= "<img src=\"img_pack/puce-rouge.gif\" alt='"._T('message_off')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=off&vierge=1&id_current_forum=$id_article&type_forum=article'>$nbMessOff mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                            $nbMessPoubelle = $forumMetier->howManyForumForArticleIdAndStatuts($id_article, "'poubelle'");
                            $s .= "<img src=\"img_pack/puce-poubelle.gif\" alt='"._T('message_poubelle')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=poubelle&vierge=1&id_current_forum=$id_article&type_forum=article'>$nbMessPoubelle mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

                            $s .= "</td></tr>";

                            $vals[] = $s;

                            $table[] = $vals;
                        }
                    break;
                    default:
                        $id_rubrique = $row['id_rubrique'];
                        $authorization = &recuperer_instance_authorization('isManagedRubriqueByAuteurId', $GLOBALS['connect_id_auteur'], array('rubriqueId' => $id_rubrique));
                        if($authorization->isAuthorizedAction()) {
                            $id_article = $row['id_article'];
                            $tous_id[] = $id_article;
                            $titre = $row['titre'];
                            $date = $row['date_heure'];
                            $statut = $row['statut'];
                            $visites = $row['visites'];
                            $popularite = ceil(min(100,100 * $row['popularite'] / max(1, 0 + lire_meta('popularite_max'))));
                            $descriptif = $row['descriptif'];
                            if ($descriptif) $descriptif = ' title="'.attribut_html(typo($descriptif)).'"';

                            $petition = $this->_articleHasPetition($id_article);

                            /*
                            $query_petition = "SELECT id_article FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article=$id_article";
                            $result_petition = ".$GLOBALS['table_prefix']."_query($query_petition);
                            $petition = (@".$GLOBALS['table_prefix']."_num_rows($result_petition) > 0);
                            */

                            if ($afficher_auteurs) {
                                $les_auteurs = $this->_getArticleAuthors($id_article);
                                /*
                                $les_auteurs = "";
                                $query2 = "SELECT auteurs.id_auteur, nom, messagerie, login, en_ligne ".
                                    "FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
                                    "WHERE lien.id_article=$id_article AND auteurs.id_auteur=lien.id_auteur";
                                $result_auteurs = ".$GLOBALS['table_prefix']."_query($query2);

                                while ($row = ".$GLOBALS['table_prefix']."_fetch_array($result_auteurs)) {
                                    $id_auteur = $row['id_auteur'];
                                    $nom_auteur = typo($row['nom']);
                                    $auteur_messagerie = $row['messagerie'];

                                    $les_auteurs .= ", $nom_auteur";
                                    if ($id_auteur != $connect_id_auteur AND $auteur_messagerie != "non" AND $activer_messagerie != "non") {
                                        $les_auteurs .= "&nbsp;".bouton_imessage($id_auteur, $row);
                                    }
                                }
                                $les_auteurs = substr($les_auteurs, 2);
                                */
                            }

                            switch ($statut) {
                            case 'publie':
                                $puce = 'verte';
                                $title = _T('info_article_publie');
                                break;
			/******* Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			case 'mappe':
				$puce = 'map-verte';
				$title = _T('info_article_mappe');
				break;
			case 'map_off':
				$puce = 'map-blanche';
				$title = _T('info_article_mappe_inactif');
				break;
			/******* Fin Ajout MAPPING guillaume.grason@diplomatie.gouv.fr *******/
                            case 'prepa':
                                $puce = 'blanche';
                                $title = _T('info_article_redaction');
                                break;
                            case 'valid':
                                $puce = 'jaune';
                                $title = _T('info_article_valide');
                                break;
                            case 'prop':
                                $puce = 'orange';
                                $title = _T('info_article_propose');
                                break;
                            case 'archi':
                                $puce = 'marron';
                                $title = _T('info_article_archive');
                            break;
                            case 'refuse':
                                $puce = 'rouge';
                                $title = _T('info_article_refuse');
                                break;
                            case 'poubelle':
                                $puce = 'poubelle';
                                $title = _T('info_article_supprime');
                                break;
                            }

                            $s = "<a href=\"$url?id_article=$id_article&$urlParams\" title=\"$title\">";
                            $puce = "puce-$puce.gif";

                            $s .= "<img src=\"img_pack/$puce\" alt='' width=\"13\" height=\"14\" border=\"0\"></a>&nbsp;&nbsp;";
                            if (acces_restreint_rubrique($id_rubrique))
                                $s .= "<img src='img_pack/admin-12.gif' alt='' width='12' height='12' title='"._T('titre_image_admin_article')."'>&nbsp;";
                            $s .= "<a href=\"$url?id_article=$id_article&$urlParams\"$descriptif>".typo($titre)."</a>";
                            if ($petition) $s .= " <Font size=1 color='red'>"._T('lien_petitions')."</font>";

                            $vals[] = $s;
							
                            if ($afficher_auteurs) $vals[] = $les_auteurs;
							
                            $s = affdate($date);
                            //----------------Zone de modifications Clever Age elebescond@clever-age.com----------
                            $authorization = &recuperer_instance_authorization('afficherStatistiques', $GLOBALS['connect_id_auteur']);
                            if ($authorization->isAuthorizedAction() AND $activer_statistiques != "non" AND $afficher_visites AND $visites > 0) {
	                        /*
	                        if ($connect_statut == "minirezo" AND $activer_statistiques != "non" AND $afficher_visites AND $visites > 0) {
                            */
                            //----------------Fin Zone de modifications Clever Age elebescond@clever-age.com----------
                                $s .= "<br><font size=\"1\"><a href='statistiques_visites.php3?id_article=$id_article'>"._T('lien_visites', array('visites' => $visites))."</a></font>";
                                if ($popularite > 0) $s .= "<br><font size=\"1\"><a href='statistiques_visites.php3?id_article=$id_article'>"._T('lien_popularite', array('popularite' => $popularite))."</a></font>";
                            }
                            $vals[] = $s;
			    /******* Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/
			    // Mod par Johnny Muller
			    $vals[] = _T('numero_article').$id_article . (isset($row['article_parent']) ? ' (<a href="articles.php3?id_article=' . $row['article_parent'].'&">'._T('editer_article_parent') . '</a>)' : '');
			    //$vals[] = _T('numero_article').$id_article;
			    /******* Fin Modification MAPPING guillaume.grason@diplomatie.gouv.fr *******/

			    //$vals[] = _T('numero_article').$id_article;
                $table[] = $vals;
                            //$table[] = $id_article;
                            //die(var_dump($table));;
                        }
                    break;
                }
            }
            $result->free();
            /*
            ".$GLOBALS['table_prefix']."_free_result($result);
            */

            if ($afficher_auteurs) {
                $largeurs = array('', 100, 90);
                $styles = array('arial2', 'arial1', 'arial1');
            }
            else {
                $largeurs = array('', 90);
                $styles = array('arial2', 'arial1');
            }
            
            //die(var_dump($table));
            //afficher_liste_articles($largeurs, $table, $styles);

			afficher_liste($largeurs, $table, $styles);
            
            echo "</table></td></tr></table>";
            if ($afficher_cadre) fin_cadre_relief();

        }
        return $tous_id;
    }

    // }}}

    // {{{ _articleHasPetition($articleId)

    /**
     * returns whether or not there is an attached petition to a given article
     * This method should be overloaded whenever the SQL request would not
     * be compatible with de DB engine used.
     * This method is "protected"
     *
     * @return boolean representing where or not there is a petition attached to the article
     * @param int $articleId representing the article id
     * @access private
     */

    function _articleHasPetition($articleId) {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die($db->getMessage());
        }

        //-------------MODIFICATION CLEVER AGE elebescond
        $petitionMetier = &recuperer_instance_petition();
        $loadOK = $petitionMetier->load($articleId);

        if(DB::isError($loadOK)) {
            die($loadOK->getMessage());
        }
        else {
            $returnValue = ($petitionMetier->getArticleId() == $articleId);
        }
        /*
        $result = @$db->query("SELECT id_article FROM ".$GLOBALS['table_prefix']."_petitions WHERE id_article=$articleId");
        $returnValue = ($result->numRows() > 0);
        $result->free();
        */
        //-------------FIN MODIFICATION
        return $returnValue;
    }

    // }}}

    // {{{ _getArticleAuthors($articleId)

    /**
     * returns a formatted HTML String representing the article authors
     * This method should be overloaded whenever the SQL request would not
     * be compatible with de DB engine used.
     * this method is "protected"
     * @return String
     * @param int $articleId representing the article id
     * @access private
     */

    function _getArticleAuthors($articleId) {
        global $connect_id_auteur, $connect_statut;

        $returnValue = "";

        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die($db->getMessage());
        }

        $query = "SELECT auteurs.id_auteur, nom, messagerie, login, en_ligne ".
                 "FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
                 "WHERE lien.id_article=$articleId AND auteurs.id_auteur=lien.id_auteur";

        $result = $db->query($query);
        if (DB::isError($result)) {
            die($result->getMessage());
        }

        while ($row = $result->fetchRow()) {
            if ($row['nom']  == '') $row['nom'] = $row['login'];
            $id_auteur = $row['id_auteur'];
            $nom_auteur = typo($row['nom']);
            $auteur_messagerie = $row['messagerie'];

            $returnValue .= ", $nom_auteur";
            if ($id_auteur != $connect_id_auteur AND $auteur_messagerie != "non" AND $activer_messagerie != "non") {
                $returnValue .= "&nbsp;".bouton_imessage($id_auteur, $row);
            }
        }

        $returnValue = substr($returnValue, 2);
        $result->free();
        return $returnValue;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[ARTICLES_ALL_BY_STATE] = "SELECT id_article, titre, id_rubrique, statut, date_heure "
                                          ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[ARTICLES_ALL_BY_STATE] = "SELECT COUNT(id_article) "
                                          ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=? AND "
                                          ."statut IN (!)";

        $this->_queries[ARTICLES_BY_STATE] = 
            "SELECT articles.id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
            "WHERE articles.id_article=lien.id_article AND lien.id_auteur=? AND articles.statut=? ORDER BY articles.date_heure DESC";

        $this->_queriesCount[ARTICLES_BY_STATE] = 
            "SELECT count(articles.id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
            "WHERE articles.id_article=lien.id_article AND lien.id_auteur=? AND articles.statut=?";

        $this->_queries[ARTICLES_BY_AUTHOR] = 
            "SELECT article.id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE lien.id_auteur=? ".
            "AND lien.id_article=article.id_article AND article.statut IN (!) ORDER BY article.date_heure DESC";

        $this->_queriesCount[ARTICLES_BY_AUTHOR] =
            "SELECT COUNT(article.id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE lien.id_auteur=? ".
            "AND lien.id_article=article.id_article AND article.statut IN (!)";

        $this->_queries[ARTICLES_TOCOME] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date_heure><!spipNOW_DATE_FORMAT_ISOspip!> ORDER BY date_heure";
        $this->_queriesCount[ARTICLES_TOCOME] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='publie' AND date_heure><!spipNOW_DATE_FORMAT_ISOspip!>";
        
        $this->_queries[ARTICLES_PROPOSED] =
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut LIKE 'prop' ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_PROPOSED] =
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut LIKE 'prop'";

        $this->_queries[ARTICLES_PROPOSED_FILTERED] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut LIKE 'prop' AND id_article NOT IN (!) ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_PROPOSED_FILTERED] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut LIKE 'prop' AND id_article NOT IN (!)";

        $this->_queries[ARTICLES_BY_KEYWORD] = 
            "SELECT article.* ".
            "FROM ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_mots_articles lien WHERE lien.id_mot=? ".
            "AND lien.id_article=article.id_article AND article.statut IN (!) ORDER BY article.date_heure DESC";

        $this->_queriesCount[ARTICLES_BY_KEYWORD] = 
            "SELECT count(article.id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles article, ".$GLOBALS['table_prefix']."_mots_articles lien WHERE lien.id_mot=? ".
            "AND lien.id_article=article.id_article AND article.statut IN (!)";

        $this->_queries[ARTICLES_BY_AUTHOR_STATE_AND_RUBRIQUE] = 
            "SELECT articles.id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
            "WHERE articles.id_article=lien.id_article AND id_rubrique=? ".
            "AND lien.id_auteur=? AND articles.statut=? ORDER BY articles.date_heure DESC";

        $this->_queriesCount[ARTICLES_BY_AUTHOR_STATE_AND_RUBRIQUE] = 
            "SELECT count(articles.id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_auteurs_articles lien ".
            "WHERE articles.id_article=lien.id_article AND id_rubrique=? ".
            "AND lien.id_auteur=? AND articles.statut=?";

        $this->_queries[ARTICLES_BY_STATE_AND_RUBRIQUE] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut=? AND id_rubrique=? ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_BY_STATE_AND_RUBRIQUE] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut=? AND id_rubrique=?";

        $this->_queries[ARTICLES_RECHERCHE] =
            "SELECT ".$GLOBALS['table_prefix']."_articles.id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE <!spipARTICLE_CONSTRUCTION_RECHERCHEspip!> ORDER BY maj DESC";

        $this->_queriesCount[ARTICLES_RECHERCHE] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE  <!spipARTICLE_CONSTRUCTION_RECHERCHEspip!>";

        /*
        $this->_queries[ARTICLES_RECHERCHE_INT] = "SELECT objet.*, SUM(idx.points) AS points ".
                                                    "FROM ".$GLOBALS['table_prefix']."_articles objet, ".$GLOBALS['table_prefix']."_index_articles idx ".
                                                    "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!) GROUP BY objet.id_article ORDER BY points DESC ";
        */

        $this->_queries[ARTICLES_RECHERCHE_INT] = 
            "SELECT objet.id_article, objet.titre, objet.date_heure, objet.statut, SUM(idx.points) AS points ".
            "FROM ".$GLOBALS['table_prefix']."_articles objet, ".$GLOBALS['table_prefix']."_index_articles idx ".
            "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!) GROUP BY objet.id_article, objet.titre, objet.date_heure, objet.statut ORDER BY points DESC ";

        $this->_queriesCount[ARTICLES_RECHERCHE_INT] =
            "SELECT COUNT(*) ".
            "FROM ".$GLOBALS['table_prefix']."_articles objet, ".$GLOBALS['table_prefix']."_index_articles idx ".
            "WHERE objet.id_article = idx.id_article AND idx.hash IN (!) AND objet.id_article NOT IN (!)";

        $this->_queries[ARTICLES_ALL_BY_STATE_NOT_SELECTED] = 
            "SELECT id_article, titre, id_rubrique, statut, date_heure "
            ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=? AND "
            ."statut IN (!) AND id_article NOT IN(!) ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_ALL_BY_STATE_NOT_SELECTED] = 
            "SELECT COUNT(id_article) "
            ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=? AND "
            ."statut IN (!) AND id_article NOT IN(!)";

        // -- Slection d'articles en fonction de leur statut sur une priode de x  aujourd'hui
        $this->_queries[ARTICLES_ALL_BY_STATE_NOT_SELECTED_ASOF] = 
            "SELECT id_article, titre, id_rubrique, statut, date_heure "
            ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=! AND "
            ."statut IN (!) AND id_article NOT IN(!) AND date_heure >= DATE_SUB(NOW(), INTERVAL ! DAY) ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_ALL_BY_STATE_NOT_SELECTED_ASOF] = 
            "SELECT COUNT(id_article) "
            ."FROM ".$GLOBALS['table_prefix']."_articles WHERE id_rubrique=! AND "
            ."statut IN (!) AND id_article NOT IN(!) AND date_heure >= DATE_SUB(CURDATE(), INTERVAL ! DAY)";
        // --

        //$this->_queries[ARTICLES_FORUM_MESSAGE] = "SELECT count(id_forum) as count, ".$GLOBALS['table_prefix']."_articles.* FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article GROUP BY ".$GLOBALS['table_prefix']."_forum.id_article ORDER BY ".$GLOBALS['table_prefix']."_forum.date_heure DESC";
		//$this->_queries[ARTICLES_FORUM_MESSAGE] = "SELECT ".$GLOBALS['table_prefix']."_articles.* FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article  GROUP BY ".$GLOBALS['table_prefix']."_forum.id_article ORDER BY ".$GLOBALS['table_prefix']."_forum.date_heure DESC";
		//$this->_queries[ARTICLES_FORUM_MESSAGE] = "SELECT DISTINCT(ART.ID_ARTICLE), ART.SURTITRE, ART.TITRE, ART.ID_RUBRIQUE, ART.DATE_HEURE, ART.STATUT FROM ".$GLOBALS['table_prefix']."_ARTICLES ART, ".$GLOBALS['table_prefix']."_FORUM FORUM WHERE ( (ART.ID_ARTICLE = FORUM.ID_ARTICLE) )";

		$this->_queries[ARTICLES_FORUM_MESSAGE] =
            "SELECT DISTINCT(".$GLOBALS['table_prefix']."_articles.id_article), ".$GLOBALS['table_prefix']."_articles.surtitre, ".$GLOBALS['table_prefix']."_articles.titre, ".$GLOBALS['table_prefix']."_articles.id_rubrique, ".$GLOBALS['table_prefix']."_articles.date_heure, ".$GLOBALS['table_prefix']."_articles.statut FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_forum WHERE ( (".$GLOBALS['table_prefix']."_articles.id_article = ".$GLOBALS['table_prefix']."_forum.id_article) ) ORDER BY ".$GLOBALS['table_prefix']."_articles.date_heure";

        $this->_queriesCount[ARTICLES_FORUM_MESSAGE] = 
            "SELECT count(DISTINCT(".$GLOBALS['table_prefix']."_forum.id_article)) FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_article=".$GLOBALS['table_prefix']."_articles.id_article GROUP BY ".$GLOBALS['table_prefix']."_forum.id_article";

		$this->_queries[ARTICLES_VALIDED] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='valid' ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_VALIDED] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='valid'";

        $this->_queries[ARTICLES_VALIDED_FILTERED] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='valid' AND id_article NOT IN (!) ORDER BY date_heure DESC";

        $this->_queriesCount[ARTICLES_VALIDED_FILTERED] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles WHERE statut='valid' AND id_article NOT IN (!)";

        $this->_queries[ARTICLES_IN_NL] = 
            "SELECT id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut ".
            "FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_cm_posts_articles WHERE ".$GLOBALS['table_prefix']."_cm_posts_articles.article_id = ".$GLOBALS['table_prefix']."_articles.id_article AND id_article IN (!) AND pst_id =? ORDER BY art_order ASC";

        $this->_queriesCount[ARTICLES_IN_NL] = 
            "SELECT count(id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles, ".$GLOBALS['table_prefix']."_cm_posts_articles WHERE ".$GLOBALS['table_prefix']."_cm_posts_articles.article_id = ".$GLOBALS['table_prefix']."_articles.id_article AND id_article IN (!) AND pst_id =?";

        $this->_queries[ARTICLES_BY_MULTIPLE_STATE_AND_RUBRIQUE] = 
            "SELECT articles.id_article, surtitre, titre, soustitre, descriptif, chapo, date_heure, visites, id_rubrique, statut, articles_mapping.id_article as article_parent ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_articles_mapping as articles_mapping ".
			"WHERE articles.id_article = articles_mapping.id_map AND statut IN (!) AND id_rubrique=? ORDER BY date_heure DESC";
            
        $this->_queriesCount[ARTICLES_BY_MULTIPLE_STATE_AND_RUBRIQUE] = 
            "SELECT count(articles.id_article) ".
            "FROM ".$GLOBALS['table_prefix']."_articles articles, ".$GLOBALS['table_prefix']."_articles_mapping as articles_mapping ".
            "WHERE articles.id_article = articles_mapping.id_map AND statut IN (!) AND id_rubrique=? ORDER BY date_heure DESC";    

    }

    // }}}

}
?>
