<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Matthieu Belge <mbelge@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Auteur business persistence abstraction.
//

// $Id$


require_once ("PEAR.php");
require_once ("DB.php");
require_once (dirname(__FILE__)."/metier.php");
require_once (dirname(__FILE__)."/../../inc_filtres.php3");
require_once (dirname(__FILE__)."/../../inc_meta.php3");
require_once (dirname(__FILE__)."/../authorization/inc_authorization_factory.php");

/** Pattern d'url menant  la page d'dition de l'auteur */
define( 'SA_URL_AUTEUR', '/ecrire/auteurs_edit.php3?id_auteur=%s' );

/** Noms de tous les champs de la table dans la base de donnes */
define("AUTEUR_ALL_FIELDS", " id_auteur, nom, bio, email, nom_site, url_site, login, pass, statut, profil, maj, pgp, htpass, "
							."en_ligne , imessage, messagerie, alea_actuel, alea_futur,prefs, cookie_oubli, source, extra, lang, low_sec ");


/**
 * BD_auteur is a base class for auteur business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_auteur extends BD_metier {
    // {{{ properties

    /**
    * Auteur ID.
    * @var     int
    * @access  private
    */
    var $_auteurId;

    /**
    * Name.
    * @var     String
    * @access  private
    */
    var $_nom;

    /**
    * Description of the user.
    * @var     String
    * @access  private
    */
    var $_bio;

    /**
    * Email.
    * @var     String
    * @access  private
    */
    var $_email;

    /**
    * Site name.
    * @var     String
    * @access  private
    */
    var $_nomSite;

    /**
    * Site url.
    * @var     String
    * @access  private
    */
    var $_urlSite;

    /**
    * login.
    * @var     String
    * @access  private
    */
    var $_login;

    /**
    * password.
    * @var     String
    * @access  private
    */
    var $_pass;

    /**
    * Statute.
    * @var     String
    * @access  private
    */
    var $_statut;

    /**
    * Profil.
    * @var     int
    * @access  private
    */
    var $_profil;

    /**
    * last update.
    * @var     Date
    * @access  private
    */
    var $_maj;

    /**
    * signature.
    * @var     String
    * @access  private
    */
    var $_pgp;

    /**
    * htpass.
    * @var     String
    * @access  private
    */
    var $_htpass;

    /**
    * online.
    * @var     Date
    * @access  private
    */
    var $_enLigne;

    /**
    * internal message
    * @var     String
    * @access  private
    */
    var $_imessage;

    /**
    * message
    * @var     String
    * @access  private
    */
    var $_messagerie;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_aleaActuel;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_aleaFutur;

    /**
    * preferences.
    * @var     String
    * @access  private
    */
    var $_prefs;

    /**
    * useful variable.
    * @var     String
    * @access  private
    */
    var $_cookieOubli;

    /**
    * source.
    * @var     String
    * @access  private
    */
    var $_source;

    /**
    * extra.
    * @var     String
    * @access  private
    */
    var $_extra;

    /**
    * lang.
    * @var     String
    * @access  private
    */
    var $_lang;

    /**
    * lowSec.
    * @var     String
    * @access  private
    */
    var $_lowSec;
    
        /** 
    * isLoaded
    * nous dit si l'objet est charg ou pas 
    * @access private
    */
    var $_isLoaded = false;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/auteur_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/auteur_common.php");
            $classname = "BD_auteur_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/auteur_".$dbParameters->_dbEngine.".php");
            $classname = "BD_auteur_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_auteur constructor.
     *
     * @access public
     */

    function BD_auteur() {
    }

    // }}}

    // {{{ getAuteurId()

    /**
     * Returns the Author's ID
     * @return  int
     * @access  public
     */

    function getAuteurId() {
        return $this->_auteurId;
    }

    // }}}

    // {{{ setAuteurId()

    /**
     * Sets the Author's ID
     * @param   int
     * @access  public
     */

    function setAuteurId($auteurId) {
        $this->_auteurId = $auteurId;
    }

    // }}}

    // {{{ getNom()

    /**
     * Returns the Author's Name
     * @return  String
     * @access  public
     */

    function getNom() {
        return empty($this->_nom) ? $this->getLogin() : $this->_nom;
    }

    // }}}

    // {{{ setNom()

    /**
     * Sets the Author's Name
     * @param  String
     * @access  public
     */

    function setNom($nom) {
        $this->_nom = $nom;
    }

    // }}}

    // {{{ getBio()

    /**
     * Returns the Author's Biography
     * @return  String
     * @access  public
     */

    function getBio() {
        return $this->_bio;
    }

    // }}}

    // {{{ setBio()

    /**
     * Sets the Author's Biography
     * @param  String
     * @access  public
     */
    function setBio($bio) {
        $this->_bio = $this->corriger_caracteres($bio);
    }

    // }}}

    // {{{ getEmail()

    /**
     * Returns the Author Email
     * @return  String
     * @access  public
     */

    function getEmail() {
        return $this->_email;
    }

    // }}}

    // {{{ setEmail()

    /**
     * Sets the Author Email
     * @param  String
     * @access  public
     */

    function setEmail($email) {
        $this->_email = $email;
    }

    // }}}

    // {{{ getNomSite()

    /**
     * Returns the Author's Site Name
     * @return  String
     * @access  public
     */

    function getNomSite() {
        return $this->_nomSite;
    }

    // }}}

    // {{{ setNomSite()

    /**
     * Sets the Author's Site Name
     * @param  String
     * @access  public
     */

    function setNomSite($nomSite) {
        $this->_nomSite = $nomSite;
    }

    // }}}

    // {{{ getUrlSite()

    /**
     * Returns the Author's Site URL
     * @return  String
     * @access  public
     */

    function getUrlSite() {
        return $this->_urlSite;
    }

    // }}}

    // {{{ setUrlSite()

    /**
     * Sets the Author's Site URL
     * @param  String
     * @access  public
     */

    function setUrlSite($urlSite) {
        $this->_urlSite = $urlSite;
    }

    // }}}

    // {{{ getLogin()

    /**
     * Returns the Author's Login
     * @return  String
     * @access  public
     */

    function getLogin() {
        return $this->_login;
    }

    // }}}

    // {{{ setLogin()

    /**
     * Sets the Author's Login
     * @param  String
     * @access  public
     */

    function setLogin($login) {
        $this->_login = $login;
    }

    // }}}

    // {{{ getPass()

    /**
     * Returns the Author's Password
     * @return  String
     * @access  public
     */

    function getPass() {
        return $this->_pass;
    }

    // }}}

    // {{{ setPass()

    /**
     * Sets the Author's Password
     * @param  String
     * @access  public
     */

    function setPass($pass) {
        $this->_pass = $pass;
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the Author's Statute
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the Author's Statute
     * @param  String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = $statut;
    }

    // }}}

    // {{{ getProfil()

    /**
     * Returns the Author's Profile
     * @return  int
     * @access  public
     */

    function getProfil() {
        return $this->_profil;
    }

    // }}}

    // {{{ setProfil()

    /**
     * Sets the Author's Profil
     * @param  int
     * @access  public
     */

    function setProfil($profil) {
        $this->_profil = $profil;
    }

    // }}}


    // {{{ getMaj()

    /**
     * Returns the last update
     * @return  Date
     * @access  public
     */

    function getMaj() {
        return $this->_maj;
    }

    // }}}

    // {{{ setMaj()

    /**
     * Sets the last update
     * @param  Date
     * @access  public
     */

    function setMaj($maj) {
        $this->_maj = $maj;
    }

    // }}}

    // {{{ getPgp()

    /**
     * Returns the Author's Pgp
     * @return  String
     * @access  public
     */

    function getPgp() {
        return $this->_pgp;
    }

    // }}}

    // {{{ setPgp()

    /**
     * Sets the Author's Pgp
     * @param  String
     * @access  public
     */

    function setPgp($pgp) {
        $this->_pgp = $pgp;
    }

    // }}}

    // {{{ getHtpass()

    /**
     * Returns the Author's HtPassword
     * @return  String
     * @access  public
     */

    function getHtpass() {
        return $this->_htpass;
    }

    // }}}

    // {{{ setHtpass()

    /**
     * Sets the Author's HtPassword
     * @param  String
     * @access  public
     */

    function setHtpass($htpass) {
        $this->_htpass = $htpass;
    }

    // }}}

    // {{{ getEnLigne()

    /**
     * Returns the date since the moment author is on line
     * @return  String
     * @access  public
     */

    function getEnLigne() {
        return $this->_enLigne;
    }

    // }}}

    // {{{ setEnLigne()

    /**
     * Sets the date since the moment author is on line
     * @param  String
     * @access  public
     */
    function setEnLigne($enLigne) {
        $this->_enLigne = $enLigne;
    }

    // }}}

    // {{{ getImessage()

    /**
     * Returns if the Author uses Imessage
     * @return  String
     * @access  public
     */

    function getImessage() {
        return $this->_imessage;
    }

    // }}}

    // {{{ setImessage()

    /**
     * Sets if the Author uses Imessage
     * @param  String
     * @access  public
     */

    function setImessage($imessage) {
        $this->_imessage = $imessage;
    }

    // }}}

    // {{{ getMessagerie()

    /**
     * Returns the Author uses Message
     * @return  String
     * @access  public
     */

    function getMessagerie() {
        return $this->_messagerie;
    }

    // }}}

    // {{{ setMessagerie()

    /**
     * Sets the Author uses Message
     * @param  String
     * @access  public
     */

    function setMessagerie($messagerie) {
        $this->_messagerie = $messagerie;
    }

    // }}}

    // {{{ getAleaActuel()

    /**
     * Returns the Current alea
     * @return  String
     * @access  public
     */

    function getAleaActuel() {
        return $this->_aleaActuel;
    }

    // }}}

    // {{{ setAleaActuel()

    /**
     * Sets the Current alea
     * @param  String
     * @access  public
     */

    function setAleaActuel($aleaActuel) {
        $this->_aleaActuel = $aleaActuel;
    }

    // }}}

    // {{{ getAleaFutur()

    /**
     * Returns the Future alea
     * @return  String
     * @access  public
     */

    function getAleaFutur() {
        return $this->_aleaFutur;
    }

    // }}}

    // {{{ setAleaFutur()

    /**
     * Sets the Future alea
     * @param  String
     * @access  public
     */

    function setAleaFutur($aleaFutur) {
        $this->_aleaFutur = $aleaFutur;
    }

    // }}}

    // {{{ getPrefs()

    /**
     * Returns the Author's preferences
     * @return  String
     * @access  public
     */

    function getPrefs() {
        return $this->_prefs;
    }

    // }}}

    // {{{ setPrefs()

    /**
     * Sets the Author's preferences
     * @param  String
     * @access  public
     */

    function setPrefs($prefs) {
        $this->_prefs = $prefs;
    }

    // }}}

    // {{{ getCookieOubli()

    /**
     * Returns the cookie forgotten
     * @return  String
     * @access  public
     */

    function getCookieOubli() {
        return $this->_cookieOubli;
    }

    // }}}

    // {{{ setCookieOubli()

    /**
     * Sets the cookie forgotten
     * @param  String
     * @access  public
     */

    function setCookieOubli($cookieOubli) {
        $this->_cookieOubli = $cookieOubli;
    }

    // }}}

    // {{{ getSource()

    /**
     * Returns the Source
     * @return  String
     * @access  public
     */

    function getSource() {
        return $this->_source;
    }

    // }}}

    // {{{ setSource()

    /**
     * Sets the Source
     * @param  String
     * @access  public
     */

    function setSource($source) {
        $this->_source = $source;
    }

    /**
     * Returns the Extra
     * @return  String
     * @access  public
     */

    function getExtra() {
        return $this->_extra;
    }

    // }}}

    // {{{ setExtra()

    /**
     * Sets the Extra
     * @param  String
     * @access  public
     */

    function setExtra($extra) {
        $this->_extra = $extra;
    }

    // }}}

    /**
     * Returns the lang
     * @return  String
     * @access  public
     */

    function getLang() {
        return $this->_lang;
    }

    // }}}

    // {{{ setLang()

    /**
     * Sets the Lang
     * @param  String
     * @access  public
     */

    function setLang($lang) {
        $this->_lang = $lang;
    }

    // }}}

    /**
     * Returns the low sec
     * @return  String
     * @access  public
     */

    function getLowSec() {
        return $this->_lowSec;
    }

    // }}}

    // {{{ setLowSec()

    /**
     * Sets the Low sec
     * @param  String
     * @access  public
     */

    function setLowSec($lowSec) {
        $this->_lowSec = $lowSec;
    }

    // }}}

    // }}}
    
    function getIsLoaded () {
        return $this->_isLoaded;
    }
    
    // }}}
    
    // {{{
    
    function setIsLoaded($isLoaded) {
        $this->_isLoaded = $isLoaded;
    }
    
    // }}}

    /** Renvoie l'url vers la page de l'auteur */
    function getUrl() { 
        return sprintf( lire_meta('adresse_site') . SA_URL_AUTEUR, $this->getAuteurId() ); 
    }

    // {{{ create()

    /**
     * This method is used to create a new author in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_auteurs";
        $auteurId = $db->nextId($string_prefix, true);
        if (DB::isError($auteurId)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$auteurId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->setEnLigne('0000-00-00 00:00:00');
        $this->_auteurId = $auteurId;
        if($this->_profil == null) $this->_profil = 0;
        if($this->_urlSite == null) $this->_urlSite = '';
        if($this->_nomSite == null) $this->_nomSite ='';
        if($this->_bio == null) $this->_bio = '';
        if($this->_statut == null) $this->_statut = '';
        if($this->_pgp == null) $this->_pgp = '';
        $this->_aleaActuel = '';
        $this->_aleaFutur = '';

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs (".AUTEUR_ALL_FIELDS.") VALUES "
                ."(".$this->_auteurId.", "
                ."'".$db->quoteString($this->_nom)."', "
                ."'".$db->quoteString($this->_bio)."', "
                ."'".$db->quoteString($this->_email)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_login)."', "
                ."'".$db->quoteString($this->_pass)."', "
                ."'".$db->quoteString($this->_statut)."', "
                .$this->_profil.", "
                ."'".$db->quoteString($this->_maj)."', "
                ."'".$db->quoteString($this->_pgp)."', "
                ."'".$db->quoteString($this->_htpass)."', "
                ."'".$db->quoteString($this->_enLigne)."', "
                ."'".$db->quoteString($this->_imessage)."', "
                ."'".$db->quoteString($this->_messagerie)."', "
                ."'".$db->quoteString($this->_aleaActuel)."', "
                ."'".$db->quoteString($this->_aleaFutur)."', "
                ."'".$db->quoteString($this->_prefs)."', "
                ."'".$db->quoteString($this->_cookieOubli)."', "
                ."'".$db->quoteString($this->_source)."', "
                ."'".$db->quoteString($this->_extra)."', "
                ."'".$db->quoteString($this->_lang)."', "
                ."'".$db->quoteString($this->_lowSec)."' )";

         
        //echo "$query<br>";

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $this->_isLoaded = true;
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete an author from the database
     * @access  public
     * @param   int $idAuteur id of author to delete
     */

    function delete($auteurId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur = $auteurId";

         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this author in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
	    $this->setMaj($maDate->getDate(DATE_FORMAT_ISO));
		if ($this->getEnLigne() == null) {
			$this->setEnLigne('0000-00-00 00:00:00');
		}
        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs "
                ."SET nom = '".$db->quoteString($this->_nom)."', "
                ."bio = '".$db->quoteString($this->_bio)."', email = '".$db->quoteString($this->_email)."', "
                ."nom_site = '".$db->quoteString($this->_nomSite)."', url_site = '".$db->quoteString($this->_urlSite)."', "
                ."login = '".$db->quoteString($this->_login)."', pass = '".$db->quoteString($this->_pass)."', "
                ."statut = '".$db->quoteString($this->_statut)."', profil= ".$this->_profil.", maj = '".$db->quoteString($this->_maj)."', "
                ."pgp = '".$db->quoteString($this->_pgp)."', htpass = '".$db->quoteString($this->_htpass)."', "
                ."en_ligne = '".$db->quoteString($this->_enLigne)."', imessage = '".$db->quoteString($this->_imessage)."', "
                ."messagerie = '".$db->quoteString($this->_messagerie)."', alea_actuel = '".$db->quoteString($this->_aleaActuel)."', "
                ."alea_futur = '".$db->quoteString($this->_aleaFutur)."', "
                ."cookie_oubli = '".$db->quoteString($this->_cookieOubli)."', source = '".$db->quoteString($this->_source)."', "
                ."extra = '" . $db->quoteString($this->_extra) . "', lang = '".$db->quoteString($this->_lang)."', "
                ."low_sec = '" . $db->quoteString($this->_lowSec)."' ";

        if ($this->_prefs != '') $query .= ", prefs = '".$db->quoteString($this->_prefs)."' ";
        
        $query .= " WHERE id_auteur = ".$this->_auteurId;
         
        //echo "<br>".$query."<br>";

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load an author from the database
     * @access  public
     * @param   int $idAuteur id of author to load
     */

    function load($auteurId) {
        if (($this->_isLoaded) and ($this->_auteurId == $auteurId)) return; // l'auteur est charg 
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : load()1] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT".AUTEUR_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur = $auteurId";
         
        
        //echo '<br />' . $query . '<br />';
        
        $result = $db->query($query);
		
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
				return 1;
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : load(".$auteurId.")] Aucun auteur ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
        
        $this->_isLoaded = true;
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     *
     * @param   $row    resultset row
     * @access  private
     */
    function _fetchData($row) {
        $this->setAuteurId($row['id_auteur']);
        $this->setNom($row['nom']);
        $this->setBio($row['bio']);
        $this->setEmail($row['email']);
        $this->setNomSite($row['nom_site']);
        $this->setUrlSite($row['url_site']);
        $this->setLogin($row['login']);
        $this->setPass($row['pass']);
        $this->setStatut($row['statut']);
        $this->setProfil($row['profil']);
        $this->setMaj($row['maj']);
        $this->setPgp($row['pgp']);
        $this->setHtpass($row['htpass']);
        $this->setEnLigne($row['en_ligne']);
        $this->setImessage($row['imessage']);
        $this->setMessagerie($row['messagerie']);
        $this->setAleaActuel($row['alea_actuel']);
        $this->setAleaFutur($row['alea_futur']);
        $this->setPrefs($row['prefs']);
        $this->setCookieOubli($row['cookie_oubli']);
        $this->setSource($row['source']);
        $this->setExtra($row['extra']);
        $this->setLang($row['lang']);
        $this->setLowSec($row['low_sec']);
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all authors former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs WHERE maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteAllAuteurIdsExceptAuteurIds($auteurs)

    function deleteAllAuteurIdsExceptAuteurIds($auteurs)  {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteAllAuteurIdsExceptAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_auteurs_articles WHERE id_auteur NOT IN ($auteurs)";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : deleteAllAuteurIdsExceptAuteurIds()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllAuteurId()

    function getAllAuteurId() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $auteurs[] = $row['id_auteur'];}
        $result->free();
        return $auteurs;
    }


    // }}}

    // {{{ getAllAuteurIdForProfils($profil)

    function getAllAuteurIdForProfils($profils) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurIdForProfils()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs WHERE profil IN (" . join(",", $profils) . ")";
        
        //echo $query;
        
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurIdForProfils ()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $auteurs[] = $row['id_auteur'];}
        $result->free();
        return $auteurs;
    }


    // }}}

    // {{{ getHtpassWithLoginExceptStatuts($statut1, $statut2)

    /**
     * Returns an array of htpass.
     *
     *
     * @return an array of htpass
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function getHtpassWithLoginExceptStatuts($statut1, $statut2) {
        $logins = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginExceptStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT login, htpass FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut != '$statut1' AND statut!='$statut2'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginExceptStatuts()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $logins[$row['login']] = $row['htpass'];}
        $result->free();
        return $loginss;
    }

    // }}}

    // {{{ getHtpassWithLoginForStatut($statut)

    /**
     * Returns an array of htpass.
     *
     *
     * @return an array of htpass
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function getHtpassWithLoginForStatut($statut) {
        $logins = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT login, htpass FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut = '$statut'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $logins[$row['login']] = $row['htpass'];}
        $result->free();
        return $loginss;
    }

    // }}}

    // {{{ getHtpassWithLoginForProfil($profil)

    /**
     * Returns an array of htpass.
     *
     *
     * @return an array of htpass
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function getHtpassWithLoginForProfil($profil) {
        $logins = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForProfil()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule($profil);

        $query = "SELECT login, htpass FROM ".$GLOBALS['table_prefix']."_auteurs WHERE profil =" . $monProfil->getPoids();
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getHtpassWithLoginForProfil()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $logins[$row['login']] = $row['htpass'];}
        $result->free();
        return $loginss;
    }

    // }}}

    // {{{ getAllForLoginAndSource($login, $source)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $source
     * @access public
     */

    function &getAllForLoginAndSource($login, $source) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndSource()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND source='$source'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndSource()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLogin($login)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @access public
     */

    function &getAllForLogin($login) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLogin()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLoginExceptStatuts($login, $statut1, $statut2)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut1
     * @param $statut2
     * @access public
     */

    function &getAllForLoginExceptStatuts($login, $statut1, $statut2) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginExceptStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND statut!='$statut1' AND statut!='$statut2'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginExceptStatuts()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLoginandPassAndSourceExceptStatut($login, $pass, $source, $statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $pass
     * @param $source
     * @param $statut
     * @access public
     */

    function &getAllForLoginAndPassAndSourceExceptStatut($login, $pass, $source, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='".addslashes($login)."' AND pass='".addslashes($pass)."' AND statut<>'$statut' AND source='$source'";
         
        //echo "<br>$query<br>";
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

// {{{ getAllForLoginandPassAndSourceExceptProfil($login, $pass, $source, $profil)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $pass
     * @param $source
     * @param $profil
     * @access public
     */

    function &getAllForLoginAndPassAndSourceExceptProfil($login, $pass, $source, $profil) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptProfil()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login LIKE '".addslashes($login)."' AND pass LIKE '".addslashes($pass)."' AND profil<>$profil AND source='$source'";
         
		//echo "<br>$query<br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndPassAndSourceExceptProfil()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllExceptMessagerieAndAuteurIdAndPassAndLogin($messagerie, $auteurId, $pass , $login)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messagerie
     * @param $auteurId
     * @param $pass
     * @param $login
     * @access public
     */

    function &getAllExceptMessagerieAndAuteurIdAndPassAndLogin($messagerie, $auteurId, $pass , $login) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptMessagerieAndAuteurIdAndPassAndLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE messagerie<>'$messagerie' AND id_auteur<>$auteurId AND pass<>'$pass' AND login<>'$login'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptMessagerieAndAuteurIdAndPassAndLogin()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForEmail($email)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $email
     * @access public
     */

    function &getAllForEmail($email) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE email='$email'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForEmail()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForStatut($statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForStatutAndMaj($statut, $myDate)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $statut
     * @param $myDate
     * @access public
     */

    function &getAllForStatutAndMaj($statut, $myDate) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatutAndMaj()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($myDate);
        $myDate = $dateTmp->getDate(DATE_FORMAT_ISO);

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut' AND maj < '$mydate'";
        //$query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE statut='$statut' AND maj < $mydate";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForStatutAndMaj()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ getAllForLoginAndNotStatut($login, $statut)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut
     * @access public
     */

    function &getAllForLoginAndNotStatut($login, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='$login' AND statut!='$statut'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForLoginAndNotProfil($login, $profil)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $profil
     * @access public
     */

    function &getAllForLoginAndNotProfil($login, $profil) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotProfil()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

/*
     $query = "SELECT ".AUTEUR_ALL_FIELDS."
             FROM ".$GLOBALS['table_prefix']."_auteurs
             WHERE login='$login' AND profil!=$profil";
*/

        $query = "SELECT ".AUTEUR_ALL_FIELDS."
             FROM ".$GLOBALS['table_prefix']."_auteurs
             WHERE login='$login' AND profil!='$profil'";
		//echo '<br>' . $query . '<br>';
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotProfil()]
                 ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());
			$maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);
			//var_dump($row);
            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();

        return $result;
    }

    // }}}

    // {{{ getAllForCookieOubliAndNotStatutAndNotPass($p, '5poubelle', "")

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $statut
     * @access public
     */

    function &getAllForCookieOubliAndNotStatutAndNotPass($cookieOubli, $statut, $pass)  {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotStatutAndNotPass()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE cookie_oubli='$cookieOublie' AND statut!='$statut' AND pass!='$pass'";
         
		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotStatutAndNotPass()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForCookieOubliAndNotProfilAndNotPass($p, '5poubelle', "")

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $login
     * @param $profil
     * @access public
     */

    function &getAllForCookieOubliAndNotProfilAndNotPass($cookieOubli, $profil, $pass)  {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotProfilAndNotPass()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE profil!=$profil AND pass!='$pass'"; //cookie_oubli='$cookieOublie' AND 
         //die($query);
		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForCookieOubliAndNotProfilAndNotPass()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForRubriqueIds($rubriques)

    /**
     * Returns an array of Breve.
     *
     *
     * @return Array of Breve
     * @param $rubriques
     * @access public
     */

    function &getAllForArticleIds($articles) {
        $auteurs = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT ".$GLOBALS['table_prefix']."_auteurs.id_auteur, maj FROM ".$GLOBALS['table_prefix']."_auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE id_article IN ($articles) AND ".$GLOBALS['table_prefix']."_auteurs.id_auteur=lien.id_auteur";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultAuteur->_fetchData($row);
        $auteurs[] = &$resultAuteur;
    }
    $queryResult->free();

    return $auteurs;
    }

    // }}}

    // {{{ getAllForArticleId($articleId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $articleId
     * @access public
     */

    function &getAllForArticleId($articleId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.id_auteur AS id_auteur, nom, bio, email, nom_site, url_site, login, pass, statut, profil, maj, pgp, htpass, en_ligne ,imessage,messagerie,alea_actuel,alea_futur,prefs,cookie_oubli,source  FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien WHERE lien.id_article=$articleId AND auteurs.id_auteur=lien.id_auteur";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForArticleId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForMessageId($messageId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messageId
     * @access public
     */

    function &getAllForMessageId($messageId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.* FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_message=$messageId AND lien.id_auteur=auteurs.id_auteur";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForMessageIdExceptAuteurId($messageId, $auteurId)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $messageId
     * @param $auteurId
     * @access public
     */

    function &getAllForMessageIdExceptAuteurId($messageId, $auteurId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageIdExceptAuteurId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT auteurs.nom FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_messages lien WHERE lien.id_message=$messageId AND lien.id_auteur!=$auteurId AND lien.id_auteur=auteurs.id_auteur";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForMessageIdExceptAuteurId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());
            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllForAuteurIds($les_auteurs, $critere)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $les_auteurs
     * @param $critere
     * @access public
     */

    function &getAllForAuteurIds($les_auteurs, $critere) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForAuteurIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur IN ($les_auteurs) ORDER BY $critere";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForAuteurIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllParticipants($ze_auteurs, $les_auteurs)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $les_auteurs
     * @param $critere
     * @access public
     */

    function &getAllParticipants($ze_auteurs, $les_auteurs) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllParticipants()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        /*
        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
		if ($les_auteurs) $query .= "id_auteur NOT IN ($ze_auteurs) AND ";
		$query .= " messagerie<>'non' AND statut IN ('minirezo', 'comite') ORDER BY statut, nom";
        */

        $profilMetier = &recuperer_instance_profil();
        $allProfils = $profilMetier->getAllProfils();
        while (list (,$monProfil) = each($allProfils)) {
            $poids[] = $monProfil->getPoids();

        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
		if ($les_auteurs) $query .= "id_auteur NOT IN ($ze_auteurs) AND ";
		$query .= " messagerie<>'non' AND profil IN (" . join(",", $poids) . ") ORDER BY profil, nom";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllParticipants()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ getAllExceptAuteurIdsAndStatuts($lesAuteurs)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $lesAuteurs
     * @access public
     */

    function &getAllExceptAuteurIdsAndStatuts($lesAuteurs) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndStatuts()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
	    if ($lesAuteurs) $query .= "id_auteur NOT IN ($lesAuteurs) AND ";
	    $query .= "statut<>'5poubelle' AND statut<>'nouveau' ORDER BY statut, nom";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndStatuts()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllExceptAuteurIdsAndProfils($lesAuteurs)

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $lesAuteurs
     * @access public
     */

    function &getAllExceptAuteurIdsAndProfils($lesAuteurs) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndProfils()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE ";
	    if ($lesAuteurs) $query .= "id_auteur NOT IN ($lesAuteurs) AND ";
	    $profilMetier = &recuperer_instance_profil();
	    $monProfil = $profilMetier->getProfilForIntitule('texte_statut_poubelle');

	    $query .= "profil<>" . $monProfil->getPoids() . " ORDER BY profil, nom";
         
		//echo '<br>' . $query . '<br>';

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllExceptAuteurIdsAndProfils()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ getAllAuteurs()

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @access public
     */

    function &getAllAuteurs() {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurs()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllAuteurs()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli($htpass, $pass, $aleaActuel, $newCookieOubli , $cookieOubli)

    /**
     * Update HTpass Pass AleaActuel and cookieOublie fro CookieOublie.
     *
     *
     * @return an array of Autors
     * @param $htpass
     * @param $mdpass
     * @param $aleaActuel
     * @param $newCookieOubli
     * @param $cookieOubli
     * @access public
     */

    function updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli($htpass, $pass, $aleaActuel, $newCookieOubli , $cookieOubli) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET htpass='$htpass', pass='$pass', alea_actuel='$aleaActuel', cookie_oubli='$newCookieOubli' WHERE cookie_oubli='$cookieOubli'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateHtPassAndPassAndAleaActuelAndCookieOubliForCookieOubli()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateCookieOubliForEmail($cookie, $email)

    /**
     * Update CookieOublie for email.
     *
     *
     * @return an array of Autors
     * @param $Cookie
     * @param $email
     * @access public
     */

    function updateCookieOubliForEmail($cookie, $email) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateCookieOubliForEmail()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET cookie_oubli = '$cookie' WHERE email ='$email'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateCookieOubliForEmail()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateStatutForLogin($statut, $login)

    /**
     * Update Statut for login.
     *
     *
     * @update Statut
     * @param $statut
     * @param $login
     * @access public
     */

    function updateStatutForLogin($statut, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateStatutForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET statut='$statut' WHERE login='$login'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateStatutForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateProfilForLogin($profil, $login)

    /**
     * Update profil for login.
     *
     *
     * @update profil
     * @param $profil
     * @param $login
     * @access public
     */

    function updateProfilForLogin($profil, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateProfilForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET profil='$profil' WHERE login='$login'";

         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updateProfilForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}


    // {{{ updatePassAndAleaFuturForLogin($pass, $aleaFutur, $login)

    /**
     * Update Pass and Alea for login.
     *
     *
     * @update Pass and Alea Futeur
     * @param $pass
     * @param $aleaFutur
     * @param $login
     * @access public
     */

    function updatePassAndAleaFuturForLogin($pass, $aleaFutur, $login) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updatePassAndAleaFuturForLogin()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_auteurs SET alea_actuel = alea_futur, ".
				"pass = ".$db->quote($pass).", alea_futur = '$aleaFutur' ".
				"WHERE login LIKE ". $db->quote($login);



         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : updatePassAndAleaFuturForLogin()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllInfosForDisplay($visiteurs, $connect_profil, &$tri, &$auteurs, &$nombre_auteurs)

    /**
     * get All infos for display list of writters.
     *
     *
     * @return tri, auteurs and nombre_auteurs
     * @param $visiteur
     * @param $connect_statut
     * @param $tri
     * @param $auteurs
     * @param $nombre_auteurs

     * @access public
     */

    function getAllInfosForDisplay($visiteurs, $connect_profil, &$tri, &$auteurs, &$nombre_auteurs)   {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //
        // Construire la requete
        //

        // limiter les statuts affiches
        /********Modification Authorization elebescond@clever-age.com***************************/
        $profilMetier = &recuperer_instance_profil();
        $profilPoubelle = $profilMetier->getProfilForIntitule('texte_statut_poubelle');
        $profilVisiteur = $profilMetier->getProfilForIntitule('item_non_abonne');
        $profilRedacteur = $profilMetier->getProfilForIntitule('item_redacteur');
        $profilRedacteurEnChef = $profilMetier->getProfilForIntitule('item_redacteur_en_chef');
        $profilWebmestre = $profilMetier->getProfilForIntitule('item_webmestre');
        $profilAdministrateur = $profilMetier->getProfilForIntitule('item_administrateur');
        
        $authorization = &recuperer_instance_authorization('afficherAuteursVisiteurs', $GLOBALS['connect_id_auteur'], array('visiteurs' => $visiteurs));
        if($authorization->isAuthorizedAction()) {
            //$sql_statut_auteurs = " AND auteurs.statut like 'forum' OR auteurs.profil IN (". $profilPoubelle->getPoids().")";
            $sql_statut_auteurs = " AND auteurs.statut like 'forum' OR auteurs.profil IN (". $profilVisiteur->getPoids().")";
            //$sql_statut_auteurs = " AND auteurs.profil IN ('forum', 0)";
    	    $sql_statut_articles = '';
    	    $tri = 'nom';
        } else {
        	$authorization = &recuperer_instance_authorization('afficherAuteurs', $GLOBALS['connect_id_auteur']);
        	/*if($authorization->isAuthorizedAction()) {
        		$sql_statut_auteurs = " AND auteurs.profil IN (". $profilAdministrateur->getPoids().", ". $profilWebmestre->getPoids().", ". $profilRedacteurEnChef->getPoids().", ". $profilRedacteur->getPoids().")";
    	    	$sql_statut_articles = " AND articles.statut IN ('prop', 'publie')";
        	}
        	else {
        		$sql_statut_auteurs = " AND auteurs.profil IN (". $profilAdministrateur->getPoids().", ". $profilWebmestre->getPoids().", ". $profilRedacteurEnChef->getPoids().", ". $profilRedacteur->getPoids().", ". $profilPoubelle->getPoids().")";
    	    	$sql_statut_articles = "";
        	}*/
            
            if($authorization->isAuthorizedAction()) {
                $sql_statut_auteurs = " AND auteurs.profil IN (". $profilAdministrateur->getPoids().", ". $profilWebmestre->getPoids().", ". $profilRedacteurEnChef->getPoids().", ". $profilRedacteur->getPoids().", ". $profilPoubelle->getPoids().")";
                $sql_statut_articles = " AND articles.statut IN ('prop', 'publie')";
            } else {
                $sql_statut_auteurs = " AND auteurs.profil IN (". $profilAdministrateur->getPoids().", ". $profilWebmestre->getPoids().", ". $profilRedacteurEnChef->getPoids().", ". $profilRedacteur->getPoids().",  ".$profilPoubelle->getPoids().")";
                $sql_statut_articles = "";
            }
            
        }
        /*
        if (($visiteurs == "oui") AND ($connect_statut == 'minirezo')) {
    	    $sql_statut_auteurs = " AND auteurs.statut IN ('forum', '5poubelle')";
    	    $sql_statut_articles = '';
    	    $tri = 'nom';
        } else if ($connect_statut != 'minirezo') {
        	$sql_statut_auteurs = " AND auteurs.statut IN ('minirezo', 'comite')";
    	    $sql_statut_articles = " AND articles.statut IN ('prop', 'publie')";
        } else {
        	$sql_statut_auteurs = " AND auteurs.statut IN ('minirezo', 'comite', '5poubelle')";
    	    $sql_statut_articles = "";
        }
        */
        /*****************FIN modif authorization***********************************************/
        // tri
        switch ($tri) {
        case 'nombre':
    	    $sql_order = ' ORDER BY compteur DESC, nom';
    	    $type_requete = 'nombre';
    	    break;

        case 'statut':
    	    /*****************Modif authorization***********************************************/
    	    $sql_order = ' ORDER BY auteurs.profil, nom';
    	    //$sql_order = ' ORDER BY auteurs.statut, nom';
    	    /*****************FIN modif authorization***********************************************/
    	    $type_requete = 'auteur';
	        break;

        case 'nom':
        default:
    	    $sql_order = ' ORDER BY nom';
	        $type_requete = 'auteur';
        }


        // si on doit afficher les auteurs par statut ou par nom,
        // la requete principale est simple, et une autre requete
        // vient calculer les nombres d'articles publies ;
        // si en revanche on doit classer par nombre, la bonne requete
        // est la concatenation de $query_nombres et de $query_auteurs


        $auteurs = Array();

        if ($type_requete == 'auteur') {
            $query = "SELECT id_auteur, nom, bio, email, nom_site, url_site, login, pass, statut, profil, maj, pgp, htpass, en_ligne , imessage, messagerie, alea_actuel, alea_futur, prefs, cookie_oubli, source "
                        . " FROM ".$GLOBALS['table_prefix']."_auteurs auteurs WHERE 1=1 $sql_statut_auteurs	$sql_order";
         
            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
            }
            while ($row = $queryResult->fetchRow()) {
        		$auteurs[$row['id_auteur']] = $row;
	    	    $nombre_auteurs ++;

		        $nom_auteur = strtoupper($row['nom']);
		        $premiere_lettre = addslashes(strtoupper(substr($nom_auteur,0,1)));
		        if ($premiere_lettre != $lettre_prec) {
        			$lettre[$premiere_lettre] = $nombre_auteurs;
		        }
		        $lettre_prec = $premiere_lettre;
	        }
        $queryResult->free();

        if ($visiteurs == 'oui') $auteurs[$row['id_auteur']]['compteur'] = 0; 
        else {
            $query = "SELECT auteurs.id_auteur, UPPER(auteurs.nom) AS nom, COUNT(articles.id_article) AS compteur
    		    FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles
    		    WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article
    		    $sql_statut_auteurs $sql_statut_articles
    		    GROUP BY auteurs.id_auteur, auteurs.profil, nom
    		    $sql_order";
            
            $queryResult = $db->query($query);
    
            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
            }
    
            while ($row = $queryResult->fetchRow())
    		    $auteurs[$row['id_auteur']]['compteur'] = $row['compteur'];
    
            $queryResult->free();
        }
    
    	// si on n'est pas minirezo, supprimer les auteurs sans article publie
    	// sauf les admins, toujours visibles.
    	/********Modification Authorization elebescond@clever-age.com***************************/
        // TODO : on ne devrait pas checker les autorisations ici 
    	$authorization = &recuperer_instance_authorization('afficherNombreArticle', $GLOBALS['connect_id_auteur']);
    	if(!$authorization->isAuthorizedAction()) {
    	/*
    	if ($connect_statut != 'minirezo') {
        */
        /*****************FIN modif authorization***********************************************/
		    /*
		    reset($auteurs);
		    $profilMetier = &recuperer_instance_profil();
            $monProfil = $profilMetier->getProfilForIntitule('item_webmestre');
            if(PEAR::isError($monProfil)) {
                die($monProfil->getMessage());
            }

		    while (list(,$auteur) = each ($auteurs)) {
		        if (! $auteur['compteur'] AND ($auteur['profil'] < $monProfil->getPoids())) {
                //if (! $auteur['compteur'] AND ($auteur['profil'] != 'minirezo')) {
				    unset($auteurs[$auteur['id_auteur']]);
				    $nombre_auteurs --;
			    }
		    }
		    */
	    }

        } else { // tri par nombre
	        /*
	        $query = "SELECT auteurs.*, UPPER(nom) AS unom, COUNT(articles.id_article) AS compteur
    		    FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles
		        WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article
		        $sql_statut_auteurs $sql_statut_articles
		        GROUP BY auteurs.id_auteur
		        $sql_order";
		    */

		    $profilMetier = &recuperer_instance_profil();
		    $allProfils = $profilMetier->getAllProfils();
		    if(PEAR::isError($allProfils)) {
		        die($allProfils->getMessage());
		    }

		    while(list(, $monProfil) = each($allProfils)) {
                $poids[] = $monProfil->getPoids();
            }

		    $query = "SELECT auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut, auteurs.profil,  COUNT(articles.id_article) AS compteur FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article AND auteurs.profil IN (" . join(",", $poids) . ") GROUP BY auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut, auteurs.profil ORDER BY compteur DESC, auteurs.nom ASC";
		    //$query = "SELECT auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut, auteurs.profil,  COUNT(articles.id_article) AS compteur FROM ".$GLOBALS['table_prefix']."_auteurs auteurs, ".$GLOBALS['table_prefix']."_auteurs_articles lien, ".$GLOBALS['table_prefix']."_articles articles WHERE auteurs.id_auteur=lien.id_auteur AND lien.id_article=articles.id_article AND auteurs.statut IN ('minirezo', 'comite', '5poubelle') GROUP BY auteurs.id_auteur, auteurs.nom, auteurs.url_site, auteurs.email, auteurs.statut ORDER BY compteur DESC, auteurs.nom ASC";
             
		    //echo "<br>$query<br>";
            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                  null, null, null, null, false);
            }
            unset($vus);
            while ($row = $queryResult->fetchRow()) {
    	    	$auteurs[$row['id_auteur']] = $row;
		        $vus .= ','.$row['id_auteur'];
		        $nombre_auteurs ++;
    	    }

            $queryResult->free();

	        // si on est admin, ajouter tous les auteurs sans articles
	        // sinon ajouter seulement les admins sans articles
    	    /********Modification Authorization elebescond@clever-age.com***************************/
			$authorization = &recuperer_instance_authorization('afficherNombreArticle', $GLOBALS['connect_id_auteur']);
    	    if($authorization->isAuthorizedAction())
    	    /*
        	    if ($connect_statut == 'minirezo')
            */
            /*****************FIN modif authorization***********************************************/
	            $sql_statut_auteurs_ajout = $sql_statut_auteurs;
	        else {
        	    $profilMetier = &recuperer_instance_profil();
        	    $monProfil8 = $profilMetier->getProfilForIntitule('item_administrateur');
        	    $monProfil4 = $profilMetier->getProfilForIntitule('item_webmestre');
        		$sql_statut_auteurs_ajout = " AND auteurs.profil IN (".$monProfil8->getPoids().",".$monProfil4->getPoids().")";
        		//$sql_statut_auteurs_ajout = " AND auteurs.statut = 'minirezo'";
            }

    	    $query = "SELECT auteurs.*, UPPER(nom), 0 as compteur
    		    FROM ".$GLOBALS['table_prefix']."_auteurs auteurs
		        WHERE id_auteur NOT IN (0$vus)
		        $sql_statut_auteurs_ajout
		        $sql_order";
            //echo $query;
             
            $queryResult = $db->query($query);

            if (DB::isError($queryResult)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllInfosForDisplay()] ".$queryResult->getMessage()."", null,
                    null, null, null, null, false);
            }

            while ($row = $queryResult->fetchRow()) {
        		$auteurs[$row['id_auteur']] = $row;
		        $nombre_auteurs ++;
	        }

	        $queryResult->free();
        }


        unset ($rub_restreinte);
        /********Modification Authorization elebescond@clever-age.com***************************/
    	$authorization = &recuperer_instance_authorization('afficherAdminRestreint', $GLOBALS['connect_id_auteur']);
    	if($authorization->isAuthorizedAction()) { // recuperer les admins restreints
    	/*
        if ($connect_statut == 'minirezo') { // recuperer les admins restreints
        */
        /*****************FIN modif authorization***********************************************/
            //-----------Zone de modification Clever Age elebescond----
            $rubriqueMetier = &recuperer_instance_rubrique();
            $rub_restreinte = $rubriqueMetier->getAllAuteurRubrique();
            if(PEAR::isError($rub_restreinte)) {
                die($rub_restreinte->getMessage());
            }
            /*
            $restreint = ".$GLOBALS['table_prefix']."_query("SELECT * FROM ".$GLOBALS['table_prefix']."_auteurs_rubriques");
            while ($row = ".$GLOBALS['table_prefix']."_fetch_array($restreint))
        	    $rub_restreinte[$row['id_auteur']] .= ','.$row['id_rubrique'];
            */
            //--------Fin de zone de modification----------------------
        }

        return $lettre;

    }

    // }}}


    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $email
     * @access public
     */

    function &getAllForLoginAndNotAuteurIdAndNotStatut($login, $id_auteur, $statut) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='".addslashes($login)."' AND id_auteur!=$id_auteur AND statut!='$statut'";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}

    /**
     * Returns an array of Autors.
     *
     *
     * @return an array of Autors
     * @param $email
     * @access public
     */

    function &getAllForLoginAndNotAuteurIdAndNotProfil($login, $id_auteur, $profil) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $profilMetier = &recuperer_instance_profil();
        $monProfil = $profilMetier->getProfilForIntitule($profil);

$query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE login='".addslashes($login)."' AND id_auteur!=$id_auteur AND profil!=".$monProfil->getPoids();

		//echo $query;

        $queryResult = $db->query($query);



        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllForLoginAndNotAuteurIdAndNotStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

   // }}}

    // {{{ createIgnore()

    function createIgnore() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_auteurs";
        $auteurId = $db->nextId($string_prefix, true);

        if (DB::isError($auteurId)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$auteurId->getMessage()."", null,
                null, null, null, null, false);
        }

        $this->_auteurId = $auteurId;


        $query = "SELECT id_auteur FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur=".$this->_auteurId."";
         
        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        if($result->numRows() == 0) {
            $query = "INSERT INTO ".$GLOBALS['table_prefix']."_auteurs (".AUTEUR_ALL_FIELDS.") VALUES "
                ."(".$this->_auteurId.", "
                ."'".$db->quoteString($this->_nom)."', "
                ."'".$db->quoteString($this->_bio)."', "
                ."'".$db->quoteString($this->_email)."', "
                ."'".$db->quoteString($this->_nomSite)."', "
                ."'".$db->quoteString($this->_urlSite)."', "
                ."'".$db->quoteString($this->_login)."', "
                ."'".$db->quoteString($this->_pass)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."'".$db->quoteString($this->_maj)."', "
                ."'".$db->quoteString($this->_pgp)."', "
                ."'".$db->quoteString($this->_htpass)."', "
                ."'".$db->quoteString($this->_enLigne)."', "
                ."'".$db->quoteString($this->_imessage)."', "
                ."'".$db->quoteString($this->_messagerie)."', "
                ."'".$db->quoteString($this->_aleaActuel)."', "
                ."'".$db->quoteString($this->_aleaFutur)."', "
                ."'".$db->quoteString($this->_prefs)."', "
                ."'".$db->quoteString($this->_cookieOubli)."', "
                ."'".$db->quoteString($this->_source)."')";

             

            $result = $db->query($query);
            if (DB::isError($result)) {
                return PEAR::raiseError("[".get_class($this)." DB_auteur : createIgnore()] ".$result->getMessage()."", null,
                    null, null, null, null, false);
            }
        }
    }

    // }}}

    // {{{ getAllConnections($auteurId)

    /**
     * This method returns all Connections
     * @param auteurId
     * @return  int
     * @access  public
     */
    function &getAllConnections($auteurId) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllConnections()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();
        $maDate->subtractSeconds(intval(5*60));

        $query = "SELECT ".AUTEUR_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur!=$auteurId AND imessage!='non' AND messagerie!='non' AND en_ligne>'" . $maDate->getDate(DATE_FORMAT_ISO) . "'";
        //echo $query.'<br>';
        //$query = "SELECT id_auteur, nom FROM ".$GLOBALS['table_prefix']."_auteurs WHERE id_auteur!=$auteurId AND imessage!='non' AND messagerie!='non' AND en_ligne>DATE_SUB(NOW(),INTERVAL 5 MINUTE)";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_auteur : getAllConnections()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultAuteur = &BD_auteur::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultAuteur->_fetchData($row);
            $result[] = &$resultAuteur;
        }
        $queryResult->free();
        return $result;
    }

    // }}}



    /** Renvoie l'id de la premire rubrique pour laquelle l'auteur  des droits.
     * @param      int      $id_rubrique_parente
     * @return     int
     * @todo       J'ai comme l'impression que l'algo n'est pas optimal...
     *             Si l'auteur n'a pas de droits sur la premire rubrique teste, on descend dans
     *             l'arbo de ladite rubrique au lieu de tester auparavant les rubriques du mme niveau.
     */
    function getPremiereRubrique( $id_rubrique_parente = 0 ) {
        $rubrique =& recuperer_instance_rubrique();
        $rubriques_filles = $rubrique->getAllForParentId( $id_rubrique_parente );

        foreach ( $rubriques_filles as $rub ) {
            $rub_id = $rub->getRubriqueId();
            $auth =& recuperer_instance_authorization( 'isManagedRubriqueByAuteurId',
                                                       $this->getAuteurId(),
                                                       array('rubriqueId' => $rub_id) );

            if ( $auth->isAuthorizedAction() ) {
                return $rub_id;
            } else {
                // return $this->getPremiereRubrique( $rub_id );
            }
        }
        
        // si on est l c'est qu'on a pas trouv notre rubrique 
        reset ($rubriques_filles);
        foreach ( $rubriques_filles as $rub ) {
            $rub_id = $rub->getRubriqueId();
            $is_ok = $this->getPremiereRubrique( $rub_id );
            if ($is_ok !== false) return $is_ok;            
        }
        
        return false; 
    }
}

?>
