<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Author List Data abstraction.
//

if (defined("_BD_AUTEURLISTDATA")) return;
    define("_BD_AUTEURLISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

/**
 * This class implements data lists for Author business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_auteurListData extends BD_objectListData {

    /**
     * Create a new author list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     *
     * @return mixed a newly created BreveListData object, or a PEAR error code on
     * error
     *
     * access public
     */

    function &factory($dbParameters = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/auteurlistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/auteurlistdata_common.php");
            $classname = "BD_auteurlistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/auteurlistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_auteurListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Constructor.
     *
     * @access public
     */

    function BD_auteurListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ getHTMLList($titre_table, $requete)

    /**
     * returns the HTML List for the various author data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $firstElement=0, $lastElement=0) {
	    $paramsCountQuery = $params;

        $copyParams = $params;

	    $tranches = $this->_getHTMLNavigation($queryType, $params, 2);

	    $requete = $this->_getQuery($queryType, false, $copyParams);

    	if (strlen($tranches)) {

	    	debut_cadre_relief("redacteurs-24.gif");

		    if ($titre_table) {
			    echo "<p><table width=100% cellpadding=0 cellspacing=0 border=0 background=''>";
			    echo "<tr><td width=100% background=''>";
			    echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";
			    echo "<tr bgcolor='#333333'><td width=100% colspan=2><font face='Verdana,Arial,Helvetica,sans-serif' size=3 color='#FFFFFF'>";
			    echo "<b>$titre_table</b></font></td></tr>";
		    }
		    else {
    			echo "<p><table width=100% cellpadding=3 cellspacing=0 border=0 background=''>";
		    }

		    echo $tranches;

            $db = &$this->_getDB();
            if (DB::isError($db)) {
                die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
            }
		
		    if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result = $db->limitQuery($requete, $limitStart, $limitCount, $params);
            } else {
                if($lastElement > 0) {
                    $result = $db->limitQuery($requete, $firstElement, $lastElement, $params);
                }
                else {
                    $result = $db->query($requete, $params);
                }
            }
            if (DB::isError($result)) {
                die("la requete a choue! ".$result->getMessage());
            }		

		    $table = '';
		    while ($row = $result->fetchRow()) {
    			$vals = '';
    
			    $id_auteur = $row['id_auteur'];
			    $tous_id[] = $id_auteur;
			    $nom = $row['nom'];
    
			    $s = bonhomme_statut($row);
			    $s .= "<a href=\"auteurs_edit.php3?id_auteur=$id_auteur\">";
			    $s .= typo($nom);
			    $s .= "</a>";
			    $vals[] = $s;
			    $table[] = $vals;
		    }
		    $result->free();

    		$largeurs = array('');
	    	$styles = array('arial2');
		    afficher_liste($largeurs, $table, $styles);

    		if ($titre_table) echo "</TABLE></TD></TR>";
	    	echo "</TABLE>";
		    fin_cadre_relief();
	    }
	    return $tous_id;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[AUTEURS_RECHERCHE_INT] = "SELECT objet.*, SUM(idx.points) AS points FROM ".$GLOBALS['table_prefix']."_auteurs objet, ".$GLOBALS['table_prefix']."_index_auteurs idx WHERE objet.id_auteur = idx.id_auteur AND idx.hash IN (!) GROUP BY objet.id_auteur ORDER BY points DESC";
        $this->_queriesCount[AUTEURS_RECHERCHE_INT] = "SELECT COUNT(*) AS points FROM ".$GLOBALS['table_prefix']."_auteurs objet, ".$GLOBALS['table_prefix']."_index_auteurs idx WHERE objet.id_auteur = idx.id_auteur AND idx.hash IN (!)";
    }

    // }}}
}
?>