<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Breve business persistence abstraction.
// @version    $Id$
//

require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";

define("BREVE_ALL_FIELDS", " id_breve, date_heure, titre, texte, lien_titre, lien_url, statut, id_rubrique, maj, extra, lang, langue_choisie ");

/**
 * BD_breve is a base class for breve business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_breve extends BD_metier {
    // {{{ properties

    /**
    * Breve ID.
    * @var     int
    * @access  private
    */
    var $_breveId;

    /**
    * Creation Date.
    * @var     Date
    * @access  private
    */
    var $_dateHeure;

    /**
    * Title.
    * @var     String
    * @access  private
    */
    var $_titre;

    /**
    * Text.
    * @var     String
    * @access  private
    */
    var $_texte;

    /**
    * Title link.
    * @var     String
    * @access  private
    */
    var $_lienTitre;

    /**
    * URL Link.
    * @var     String
    * @access  private
    */
    var $_lienUrl;

    /**
    * Statute.
    * @var     String
    * @access  private
    */
    var $_statut;

    /**
     * _statutsHisto
     * historique des statuts pour cet instance d'objet
     * @access private
     * @var Array 
     **/
    var $_statutsHisto = array ();

    /**
    * Rubrique ID.
    * @var     int
    * @access  private
    */
    var $_rubriqueId;

    /**
    * Last Update.
    * @var     Date
    * @access  private
    */
    var $_majDate;

    /**
    * Extra.
    * @var     String
    * @access  private
    */
    var $_extra;

    /**
    * Lang.
    * @var     String
    * @access  private
    */
    var $_lang;

    /**
     * Lang functions activation.
     * @var     String
     * @access  private
     */
    var $_langue_choisie;    
    
    /**
    * _rubriqueIdsHisto
    * historique des rubriques pour cet instance d'objet
    * @access private
    * @var Array 
    **/
    var $_rubriqueIdsHisto = array ();
    
    
    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/breve_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/breve_common.php");
            $classname = "BD_breve_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/breve_".$dbParameters->_dbEngine.".php");
            $classname = "BD_breve_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_breve constructor.
     *
     * @access public
     */

    function BD_breve() {
    }

    // }}}

    // {{{ getBreveId()

    /**
     * Returns the breve ID
     * @return  int
     * @access  public
     */

    function getBreveId() {
        return $this->_breveId;
    }

    // }}}

    // {{{ setBreveId()

    /**
     * Sets the breve ID
     * @param  int
     * @access  public
     */

    function setBreveId($breveId) {
        $this->_breveId = $breveId;
    }

    // }}}

    // {{{ getDateHeure()

    /**
     * Returns the Time
     * @return  Date
     * @access  public
     */

    function getDateHeure() {
        return $this->_dateHeure;
    }

    // }}}

    // {{{ setDateHeure()

    /**
     * Sets the Time
     * @param  Date
     * @access  public
     */

    function setDateHeure($dateHeure) {
         $this->_dateHeure = $dateHeure;
    }

    // }}}

    // {{{ getTitre()

    /**
     * Returns the Title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the Title
     * @param  String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}

    // {{{ getTexte()

    /**
     * Returns the Text
     * @return  String
     * @access  public
     */

    function getTexte() {
        return $this->_texte;
    }

    // }}}

    // {{{ setTexte()

    /**
     * Sets the Text
     * @param  String
     * @access  public
     */

    function setTexte($texte) {
        $this->_texte = corriger_caracteres($texte);
    }

    // }}}

    // {{{ getLienTitre

    /**
     * Returns the Title link
     * @return  String
     * @access  public
     */

    function getLienTitre() {
        return $this->_lienTitre;
    }

    // }}}

    // {{{ setLienTitre()

    /**
     * Sets the Title Link
     * @param  String
     * @access  public
     */

    function setLienTitre($lienTitre) {
        $this->_lienTitre = corriger_caracteres($lienTitre);
    }

    // }}}

    // {{{ getLienUrl()

    /**
     * Returns the URL
     * @return  String
     * @access  public
     */

    function getLienUrl() {
        return $this->_lienUrl;
    }

    // }}}

    // {{{ setLienUrl()

    /**
     * Sets the URL
     * @return  String
     * @access  public
     */

    function setlienUrl($lienUrl) {
        $this->_lienUrl = corriger_caracteres($lienUrl);
    }

    // }}}

    // {{{ getStatut()

    /**
     * Returns the Statute
     * @return  String
     * @access  public
     */

    function getStatut() {
        return $this->_statut;
    }

    // }}}

    // {{{ setStatut()

    /**
     * Sets the Statute
     * @param  String
     * @access  public
     */

    function setStatut($statut) {
        $this->_statut = $statut;
        $this->_statutsHisto[] = $this->_statut;
    }


    // {{{ getRubriqueId()

    /**
     * Returns the Heading ID
     * @return  int
     * @access  public
     */

    function getRubriqueId() {
        return $this->_rubriqueId;
    }

    // }}}

    // {{{ setRubriqueId()

    /**
     * Sets the heading ID
     * @param  int
     * @access  public
     */

    function setRubriqueId($rubriqueId) {
        if (isset($this->_rubriqueId) and ($this->_rubriqueId != $rubriqueId) ) {
            // on sauvegarde cette rubrique
            $this->_rubriqueIdsHisto[] = $this->_rubriqueId;
        }
         $this->_rubriqueId = $rubriqueId;
    }

    // }}}

    // {{{ getRubriqueIdsHisto

    function getRubriqueIdsHisto() {
        return $this->_rubriqueIdsHisto;
    }

    // }}}


    // {{{ getMajDate()

    /**
     * Returns the last Update
     * @return  Date
     * @access  public
     */

    function getMajDate() {
        return $this->_majDate;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Returns the last upDate
     * @return  Date
     * @access  public
     */

    function setMajDate($majDate) {
        $this->_majDate = $majDate;
    }

    // {{{ getExtra()

    /**
     * Returns the extra field
     * @return  String
     * @access  public
     */

    function getExtra() {
        return $this->_extra;
    }

    // }}}

    // {{{ setLang()

    /**
     * Returns the lang
     * @return  String
     * @access  public
     */

    function setLang($lang) {
        $this->_lang = $lang;
    }

    function getLang() {
        return $this->_lang;
    }

    // }}}

    // {{{ setMajDate()

    /**
     * Returns the extra field
     * @return  String
     * @access  public
     */

    function setExtra($extra) {
        $this->_extra = $extra;
    }

    // {{{ getLangChoisie()

    /**
     * get Lang functions activation.
     * @var     String
     * @access  private
     */

    function getLangChoisie() {
        return $this->_langChoisie;
    }

    // }}}
    
    // {{{ setLangChoisie()


    /**
     * Set Lang functions activation.
     * @var     String
     * @access  private
     */

    function setLangChoisie($langChoisie) {
        $this->_langChoisie = $langChoisie;
    }

    // }}}


    // {{{ create()

    /**
     * This method is used to create a new breve in the database
     * @access public
     */

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : create()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_breves";
        $breveId = $db->nextId($string_prefix, true);
        if (DB::isError($breveId)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : create()] ".$breveId->getMessage()."", null,
                null, null, null, null, false);
        }
        $this->_breveId = $breveId;

        $maDate = new Date();
	    $this->setDateHeure($maDate->getDate(DATE_FORMAT_ISO));

        if($this->_rubriqueId == null) $this->_rubriqueId = 0;
        

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_breves (".BREVE_ALL_FIELDS.") VALUES "
                ."(".$this->_breveId.", "
                ."'".$db->quoteString($this->_dateHeure)."', "
                ."'".$db->quoteString($this->_titre)."', "
                ."'".$db->quoteString($this->_texte)."', "
                ."'".$db->quoteString($this->_lienTitre)."', "
                ."'".$db->quoteString($this->_lienUrl)."', "
                ."'".$db->quoteString($this->_statut)."', "
                ."".$this->_rubriqueId.", "
                ."'".$db->quoteString($this->_majDate)."', "
                ."'".$db->quoteString($this->_extra)."', "
                ."'".$db->quoteString($this->_lang)."', "
                ."'".$db->quoteString($this->_langChoisie)."' )";
         
         
		//echo '<br>' . $query . '<br>';

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : create()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Mise  jour des objets lis
        $this->updateRelatedObjects();

    }

    // }}}

    // {{{ update()

    /**
     * This method is used to update this breve in the database
     * @access public
     */

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        
        $maDate = new Date();
	    $this->setMajDate($maDate->getDate(DATE_FORMAT_ISO));

        $query = "UPDATE ".$GLOBALS['table_prefix']."_breves "
                ."SET date_heure = '".$db->quoteString($this->_dateHeure)."', "
                ."titre = '".$db->quoteString($this->_titre)."', "
                ."texte = '".$db->quoteString($this->_texte)."', "
                ."lien_titre = '".$db->quoteString($this->_lienTitre)."', "
                ."lien_url = '".$db->quoteString($this->_lienUrl)."', "
                ."statut = '".$db->quoteString($this->_statut)."', "
                ."id_rubrique = ".$this->_rubriqueId.", "
                ."maj = '".$db->quoteString($this->_majDate)."', "
                ."extra = '".$db->quoteString($this->_extra)."', "
                ."lang = '".$db->quoteString($this->_lang)."', "
                ."langue_choisie = '".$db->quoteString($this->_langChoisie)."' "
                ."WHERE id_breve = ".$this->_breveId;

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Mise  jour des objets lis
        $this->updateRelatedObjects();        
        
    }

    // }}}

    // {{{ load()

    /**
     * This method is used to load a breve from the database
     * @access  public
     * @param   int $idBreve id of breve to load
     */

    function load($idBreve) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : load()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        //echo '----> ' . $GLOBALS['table_prefix'] . '<br />' ;

        $query = "SELECT".BREVE_ALL_FIELDS."FROM ".$GLOBALS['table_prefix']."_breves WHERE id_breve = $idBreve";
        //echo '<br>' . $query . '<br>';
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : load()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {

                $maDate = new Date($row['maj']);
                $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

                $this->_fetchData($row);
            } else {
                return PEAR::raiseError("[".get_class($this)." DB_breve : load($idBreve)] Aucune breve ne correspond pas  cet ID!", null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    /**
     * This method is used to delete a breve from the database
     * @access  public
     * @param   int $breveID of breve to delete
     */

    function delete($breveId) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_breves WHERE id_breve = $breveId";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : delete()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        
        // Mise  jour des objets lis
        $this->updateRelatedObjects();
                 
    }

    // }}}

    // {{{ _fetchData()

    /**
     * This method is used to fetch result set fields into the object fields
     *
     * @param   $row    resultset row
     * @access  private
     */

    function _fetchData($row) {
        $this->setBreveId($row['id_breve']);
        $this->setDateHeure($row['date_heure']);
        $this->setTitre($row['titre']);
        $this->setTexte($row['texte']);
        $this->setLienTitre($row['lien_titre']);
        $this->setLienUrl($row['lien_url']);
        $this->setStatut($row['statut']);
        $this->setRubriqueId($row['id_rubrique']);
        $this->setMajDate($row['maj']);
        $this->setExtra($row['extra']);
        $this->setLang($row['lang']);
        $this->setLangChoisie($row['langue_choisie']);
    }

    // }}}

    // {{{ deleteMajDate($majDate)

    /**
     * This method is used to delete all breves former to mydate
     * @access  public
     */

    function deleteMajDate($mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->getDate(DATE_FORMAT_ISO);
        //echo "<br>".$mydate;
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_breves WHERE maj < '$mydate'";
         
        //echo "<br>".$query;
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteRubriqueAndMajDate($rubrique,$mydate)

    /**
     * This method is used to delete all breves which do not belong to the headings and former to mydate
     * @access  public
     */

    function deleteRubriqueAndMajDate($rubrique,$mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteRubriqueAndMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        $mydate = $dateTmp->format('%Y-%m-%d %H:%M:%S');

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique NOT IN ($rubriques) AND maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteRubriqueAndMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ deleteStatusAndMajDate($statut,$majDate)

    /**
     * This method is used to delete all breves which have statute $statut and former to mydate
     * @param $statut
     * @param $mydate
     * @access  public
     */

    function deleteStatusAndMajDate($statut,$mydate) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteStatusAndMajDate()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $dateTmp = new Date($mydate);
        //$mydate = $dateTmp->format('%Y-%m-%d %H:%M:%S'); it's the same that iso!
		$mydate = $dateTmp->getDate(DATE_FORMAT_ISO);
		
        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_breves WHERE statut=" . $status . " AND maj < '$mydate'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteStatusAndMajDate()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ getAllRubriqueId()

    function getAllRubriqueId() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_rubrique FROM ".$GLOBALS['table_prefix']."_rubriques";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllRubriqueId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $rubriques[] = $row['id_rubrique'];}
        $result->free();
        return $breves;
    }


    // }}}

    // {{{ getAllBreveId()

    function getAllBreveId() {
        $breves = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllBreveId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_breve FROM ".$GLOBALS['table_prefix']."_breves";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllBreveId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        while ($row = $result->fetchRow()) {    $breves[] = $row['id_breve'];}
        $result->free();
        return $breves;
    }


    // }}}

    // {{{ getRubriqueIdsByStatus($statut)

    function getRubriqueIdsByStatus($statut) {
        $rubriqueIds = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getRubriqueIdsByStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT DISTINCT id_rubrique FROM ".$GLOBALS['table_prefix']."_breves WHERE statut = '$statut'";
         
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getRubriqueIdsByStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $result->fetchRow()) {
            $rubriqueIds[] = $row['id_rubrique'];
        }
        $result->free();
        return $rubriqueIds;
    }

    // }}}

    // {{{ getMaxDateHeure($id_rubrique,$statut)

    function getMaxDateHeure($id_rubrique, $statut) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getMaxDateHeure()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT MAX(date_heure) as date_h FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique='$id_rubrique' AND statut='$statut'";
		
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getMaxDateHeure()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $result->free();
            if ($row["date_h"] == null) {
                return new Date('1970-01-01 00:00:00');
            }
            else {
                return new Date($row["date_h"]);
            }        
        }
        $result->free();
    }

    // }}}

    // {{{ howManyBreveForRubrique($statut)

    function howManyBreveForRubrique($id_rubrique) {
        $howManyBreve = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreveForRubrique()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) AS cnt FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique=$id_rubrique";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreveForRubrique()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $row = $result->fetchRow();
            $howManybreve = intval($row["cnt"]);
        }
        $result->free();
        return $howManyBreve;
    }

    // }}}

    // {{{ howManyBreve()

    function howManyBreve($status) {
        $howManyBreve = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreve()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(*) AS cnt FROM ".$GLOBALS['table_prefix']."_breves where statut='".$status."'";
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreve()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManybreve = intval($row["cnt"]);
        }
        $result->free();
        return $howManyBreve;
    }

    // }}}

    // {{{ howManyBreveForMot($conf_mot,$aff_articles,$statut)

    function HowManyBreveForMot($conf_mot,$aff_articles,$statut)    {
        $howManyBreve = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : HowManyBreveForMot()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve "
		        . "WHERE lien.id_mot=$conf_mot AND breve.id_breve=lien.id_breve "
			    . "AND breve.statut LIKE '%$aff_articles%' AND breve.statut!='refuse'";

		/*
		$query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_mots_breves lien, ".$GLOBALS['table_prefix']."_breves breve "
		        . "WHERE lien.id_mot=$conf_mot AND breve.id_breve=lien.id_breve "
			    . "AND FIND_IN_SET(breve.statut,'$aff_articles')>0 AND breve.statut!='refuse'";
		*/

		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : HowManyBreveForMot()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyBreve = intval($row["cnt"]);
        }
        $result->free();
        return $howManyBreve;
    }

    // }}}

    // {{{ howManyBreveIdForStatut($statut)

    function howManyBreveIdForStatut($statut)    {
        $howManyBreveId = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreveIdForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(id_breve) as cnt FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='$statut'";

		
		 
		$result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyBreveIdForStatut()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            $howManyBreveId = intval($row["cnt"]);
        }
        $result->free();
        return $howManyBreveId;
    }

    // }}}

    // {{{ getAllForRubriqueIds($rubriques)

    /**
     * Returns an array of Breve.
     *
     *
     * @return Array of Breve
     * @param $rubriques
     * @access public
     */

    function &getAllForRubriqueIds($rubriques) {
        $breves = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllForRubriqueIds()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT id_article, statut, maj FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique IN ($rubriques)";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllForRubriqueIds()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());

        $maDate = new Date($row['maj']);
        $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

        $resultBreve->_fetchData($row);
        $breves[] = &$resultBreve;
    }
    $queryResult->free();
    return $breves;
    }

    // }}}

    // {{{ getToday()

    /**
     * Returns an array of Breve representing
     * the current day published breves.
     *
     *
     * @return Array of Breve
     * @param $month
     * @param $year
     * @access public
     */

    function &getToday($month, $year) {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getToday()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date("$year-$month-01 00:00:00");
        $maDate->addSeconds(intval(3600*24*31));
        $maDate->setDay(01);

        $query = "SELECT id_breve, titre, date_heure FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='publie' AND date_heure >='$year-$month-0' AND date_heure < '".$maDate->getDate(DATE_FORMAT_ISO)."' ORDER BY date_heure";
        //$query = "SELECT id_breve, titre, date_heure FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='publie' AND date_heure >='$year-$month-0' AND date_heure < DATE_ADD('$year-$month-1', INTERVAL 1 MONTH) ORDER BY date_heure";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getToday()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());
            $resultBreve->setBreveId($row['id_breve']);
            $resultBreve->setTitre($row['titre']);
            $resultBreve->setDateHeure($row['date_heure']);
            $result[] = &$resultBreve;
        }

        $queryResult->free();
        return $result;
    }

    // }}}

    // {{{ isStatus()

    function isStatus($status) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : isStatus()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT breve.* FROM ".$GLOBALS['table_prefix']."_breves breves WHERE breves.id_breve=".$this->_breveId." AND status='".$status."'";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : isStatus()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        $isStatus = ($result->numRows() > 0);
        $result->free();
        return $isStatus;
    }

    // }}}

    // {{{ updateSecteursForRubriques()

    function updateSecteursForRubriques($id_secteur,$rubriques_totales) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateSecteursForRubriques()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_breves SET id_rubrique=$id_secteur WHERE id_rubrique IN ($rubriques_totales)";

        //echo '<br>' . $query . '<br><br>';
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateSecteursForRubriques()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ updateDateAndStatusForBreve()

    function updateDateAndStatusForBreve($statut,$id_breve) {
        $db = &$this->_getDB();
        $this->load($id_breve);
        $this->setStatut( $statut );

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateDateAndStatusForBreve()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date();

        $query = "UPDATE ".$GLOBALS['table_prefix']."_breves SET date_heure='" . $maDate->getDate(DATE_FORMAT_ISO) . "', statut='$statut' WHERE id_breve=$id_breve";
        
        //echo $query;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateDateAndStatusForBreve()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        // Mise  jour des objets lis
        $this->updateRelatedObjects();
    }

    // }}}

    // {{{ updateDateAndStatusForBreve()

    function updateDateForBreveId($date,$id_breve) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateDateForBreveId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_breves SET date_heure='$date' WHERE id_breve=$id_breve";
        
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : updateDateForBreveId()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }

        // Mise  jour des objets lis
        $this->updateRelatedObjects();
    }


    // }}}

    // {{{ getAllDocumentsLies($id_breve, $mode)

    /**
     * Returns an array of Document Id.
     *
     *
     * @return Array of Document Id
     * @param $id_breve
     * @access public
     */

    function &getAllDocumentsLies($id_breve, $mode, $docs_exclus = "", $id_doublons = null) {
        $documentIds = array();
        $db = &$this->_getDB();

        if (!$id_breve) return;

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllDocumentsLies()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT docs.id_document FROM ".$GLOBALS['table_prefix']."_documents docs, ".$GLOBALS['table_prefix']."_documents_breves l WHERE l.id_breve=$id_breve AND l.id_document=docs.id_document ".$docs_exclus." AND docs.mode_spip='$mode'";
        if ($id_doublons) $query .= " AND docs.id_document NOT IN (".$id_doublons.") ";
        $query .= " ORDER BY docs.id_document";

         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllDocumentsLies()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $documentIds[] = $row['id_document'];
    }
    $queryResult->free();
    return $documentIds;
    }

    // }}}
    
    // {{{ addBookmark($id_auteur)

	function addBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : addBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_bookmarks (id_auteur, id_objet, type_bookmark) VALUES (" . $id_auteur . "," . $this->getBreveId() . ", 'breve')";
		
		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : addBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
				
	}
	
	// }}}
    
    // {{{ deleteBookmark($id_auteur)

	function deleteBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_bookmarks WHERE id_auteur=" . $id_auteur . " AND id_objet=" . $this->getBreveId() . " AND type_bookmark='breve'";
		
		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : deleteBookmark()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }
				
	}
	
	// }}}

	// {{{ isBookmark($id_auteur)

	function isBookmark($id_auteur) {
		
		$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : isBookmark()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(*) as cnt FROM ".$GLOBALS['table_prefix']."_bookmarks WHERE id_auteur=" . $id_auteur . " AND id_objet=" . $this->getBreveId() . " AND type_bookmark='breve'";
		 
		//echo '<br>' . $query . '<br>';
        
		$result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : isBookmark()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        if ($row = $result->fetchRow()) {
            if($row["cnt"] > 0) return true;
        }		
		return false;
				
	}
	
	// }}}

    // {{{ howManyProposed()

    /**
     * This method returns the number of proposed breves
     * @return  int
     * @access  public
     */
    function howManyProposed() {
        $howManyProposed = 0;
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyProposed()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT count(id_breve) AS cnt FROM ".$GLOBALS['table_prefix']."_breves where statut='prop'";

        $result = $db->getOne($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : howManyProposed()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            $howManyProposed = $result;
        }

        return $howManyProposed;
    }

    // }}}

    // {{{ getAllForStatut($statut, $orderBy = null, $desc = null, $limitDebut = null, $limitFin = null)

    /**
     * Returns an array of Breve.
     *
     * @return Array of Breve
     * @param $statut
     * @access public
     */

    function &getAllForStatut($statut, $orderBy = null, $desc = null, $limitDebut = null, $limitFin = null) {
        $breves = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllForStatut()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT * FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='$statut'";

        if ($orderBy != null)   $query .= " ORDER BY $orderBy";
        
        if ($desc != null)   $query .= " DESC";

         
        if( $limitDebut != null && $limitFin != null ) {
            $queryResult = $db->limitQuery($query, $limitDebut, $limitFin);
        }
        else {
            $queryResult = $db->query($query);
        }

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllForStatut()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultBreve->_fetchData($row);
            $breves[] = &$resultBreve;
        }
        $queryResult->free();
        return $breves;
    }

    // }}}

    // {{{ getBrevesOfTheDay($date)

    /**
     * Returns an array of Breves Of The Day..
     *
     * @return Array of Breve
     * @param $date
     * @access public
     */

    function &getBrevesOfTheDay($date) {
        $breves = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getBrevesOfTheDay()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $maDate = new Date($date);
        $maDate->addSeconds(intval(3600*24));
        
        $query = "SELECT ".BREVE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='publie' AND date_heure >='$date' AND date_heure < '" . $maDate->getDate(DATE_FORMAT_ISO) . "' ORDER BY date_heure";
         
        //echo "<br><br>$query<br><br>";

        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getBrevesOfTheDay()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultBreve->_fetchData($row);
            $breves[] = &$resultBreve;
        }
        $queryResult->free();
        return $breves;
    }

    // }}}

	// {{{ getAllMotherLang()

    /**
     * This method return la langue des rubriques mere pour chaque breve fils
     * @return	Array
     */

    function getAllMotherLang() {
        
        $breves = array();
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllMotherLang()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT fils.id_breve AS id_breve, mere.lang AS lang FROM ".$GLOBALS['table_prefix']."_breves fils, ".$GLOBALS['table_prefix']."_rubriques mere WHERE fils.id_rubrique = mere.id_rubrique AND fils.langue_choisie != 'oui' AND mere.lang<>'' AND mere.lang<>fils.lang";
         

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getAllMotherLang()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        } else {
            while ($row = $result->fetchRow()) {
                $breves[] = $row;
            }
        }
        
        return $breves;
        
    }

	// }}}

    // {{{ getBrevesOfTheDay($date)

    /**
     * Returns an array of Breves Of The Day..
     *
     * @return Array of Breve
     * @param $date
     * @access public
     */

    function &getBrevesForRubriqueId($rubriqueId, $orderBy = null, $desc = null, $limitDebut = null, $limitFin = null) {
        $breves = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getBrevesForRubriqueId()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT ".BREVE_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique=$rubriqueId";

        if ($orderBy != null)   $query .= " ORDER BY $orderBy";
        
        if ($desc != null)   $query .= " DESC";
         
        //echo "<br><br>$query<br><br>";
        
        if( $limitDebut != null && $limitFin != null ) {
            $queryResult = $db->limitQuery($query, $limitDebut, $limitFin);
        }
        else {
            $queryResult = $db->query($query);
        }

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getBrevesForRubriqueId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

        while ($row = $queryResult->fetchRow()) {
            $resultBreve = &BD_breve::factory($this->getDbParameters(), $this->getDbOptions());

            $maDate = new Date($row['maj']);
            $row['maj']= $maDate->getDate(DATE_FORMAT_TIMESTAMP);

            $resultBreve->_fetchData($row);
            $breves[] = &$resultBreve;
        }
        $queryResult->free();
        return $breves;
    }

    // }}}
    
	// {{{ getLangUsed()

    /**
     * This method return la liste des langues utiliss par les breves.
     * @return	Array
     */

    function &getLangUsed() {
        $langues = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getLangUsed()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        $query = "SELECT DISTINCT lang FROM ".$GLOBALS['table_prefix']."_breves WHERE statut='publie'";
		
         
		$queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError("[".get_class($this)." DB_breve : getLangUsed()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        }

    while ($row = $queryResult->fetchRow()) {
        $langues[] = $row['lang'];
    }
    $queryResult->free();
    return $langues;
    }

    // }}}
        
}
?>