<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Breve List Data abstraction.
//

if (defined("_BD_BREVELISTDATA")) return;
    define("_BD_BREVELISTDATA", "1");

require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/objectlistdata.php";
require_once (dirname(__FILE__)."/inc_rubrique_factory.php");
require_once dirname(__FILE__)."/inc_listdata_querytypes_constants.php";

/**
 * This class implements data lists for Breve business data type
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_breveListData extends BD_objectListData {

    /**
     * Create a new breve list data object for the specified database parameters
     * passed
     *
     * @param BD_parameters $dbParameters database configuration object
     *
     * @return mixed a newly created BreveListData object, or a PEAR error code on
     * error
     *
     * access public
     */

    function &factory($dbParameters = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/brevelistdata_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/brevelistdata_common.php");
            $classname = "BD_brevelistdata_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/brevelistdata_".$dbParameters->_dbEngine.".php");
            $classname = "BD_breveListData_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // {{{ constructor

    /**
     * Constructor.
     *
     * @access public
     */

    function BD_breveListData() {
        $par = get_parent_class(get_parent_class($this));
        $this->$par();
    }

    // }}}


    // {{{ getHTMLList($titre_table, $requete, $affrub=false)

    /**
     * returns the HTML List for the various breve data lists implementations
     * This method should <b>NEVER<b> be overloaded, otherwise EXTRA-EXTRA-CARE is required
     * while overloading this method.
     *
     * @return String reprensenting the generated HTML list navigation
     * @param $queryType int representing the desired query type (refer to inc_listdata_query_types_contants.php)
     * @param $params array containing the query parameters
     * @param $countQuery boolean : if set to true, the returned query is a count result query for the specified query type.
     * @access public
     */

    function displayHTMLList($titre_table, $queryType, $params = array(), $affrub=false, $firstElement=0, $lastElement=0) {
	    global $connect_id_auteur;

        $copyParams = $params;

        $tranches = $this->_getHTMLNavigation($queryType, $params, 2);

        $requete = $this->_getQuery($queryType, false, $copyParams);

        if (strlen($tranches)) {
    		debut_cadre_relief("breve-24.gif");
    		if ($titre_table) {
	    		echo "<p><table width=100% cellpadding=0 cellspacing=0 border=0 background=''>";
			    echo "<tr><td width=100% background=''>";
			    echo "<table width=100% cellpadding=3 cellspacing=0 border=0>";
			    echo "<tr bgcolor='#EEEECC'><td width=100% colspan=2><font face='Verdana,Arial,Helvetica,sans-serif' size=3 color='#000000'>";
			    echo "<b>$titre_table</b></font></td></tr>";
		    }
		    else {
			    echo "<p><table width=100% cellpadding=3 cellspacing=0 border=0 background=''>";
		    }
    	echo $tranches;
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            die("Impossible d'obternir une connexion  la base de donnes! ".$db->getMessage());
        }

		if ($this->_getQueryIsLimited()) {
                $limitStart = $this->_getLimitStart();
                $limitCount = $this->_getLimitCount();
                $result = $db->limitQuery($requete, $limitStart, $limitCount, $copyParams);
        } else {
            if($lastElement > 0) {
                $result = $db->limitQuery($requete, $firstElement, $lastElement, $copyParams);
            }
            else {
                $result = $db->query($requete, $copyParams);
            }
        }
		/*
		$result = spip_query($requete);
        */
        if (DB::isError($result)) {
            die("la requete a choue! ".$result->getMessage());
        }

		$table = '';

		while ($row = $result->fetchRow()) {
			$vals = '';

            switch($queryType) {
                case BREVES_FORUM_MESSAGE:
                    $id_breve = $row['id_breve'];
					$forumMetier = &recuperer_instance_forum();
					$nbMessageTotal = $forumMetier->howManyForumForBreveId($id_breve) . ' message(s)';

        			$titre = $row['titre'];
        			$statut = $row['statut'];
        			$id_rubrique = $row['id_rubrique'];
        			switch ($statut) {
        			case 'prop':
        				$puce = "puce-blanche";
        				$title = _T('titre_breve_proposee');
        				break;
        			case 'publie':
        				$puce = "puce-verte";
        				$title = _T('titre_breve_publiee');
        				break;
        			case 'refuse':
        				$puce = "puce-rouge";
        				$title = _T('titre_breve_refusee');
        				break;
        			}

                    $authorization = &recuperer_instance_authorization('controlerForum', $GLOBALS['connect_id_auteur'], array('id_rubrique' => $id_rubrique));
                    if($authorization->isAuthorizedAction()) {
        			    $s = "<a href='breves_voir.php3?id_breve=$id_breve' title=\"$title\">";
        			    $s .= "<img src='img_pack/$puce.gif' alt='' width='8' height='9' border='0'></a>&nbsp;&nbsp;";
        			    $s .= "<a href='breves_voir.php3?id_breve=$id_breve'>";
        			    $s .= typo($titre);
        			    $s .= "</a>";
                        $forumMetier = &recuperer_instance_forum();
                        $nbMessProp = $forumMetier->howManyForumForBreveIdAndStatuts($id_breve, "'prop'");
                        $s .= "<td align='right' colspan=1><img src=\"img_pack/puce-orange.gif\" alt='"._T('message_attente_validation')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,prop&vierge=1&id_current_forum=$id_breve&type_forum=breve'>$nbMessProp message(s) en attente</a></td>";

                        $s .= "<tr><td align=center colspan=3>";

                        $nbMessPublie = $forumMetier->howManyForumForBreveIdAndStatuts($id_breve, "'publie'");
                        $s .= "<img src=\"img_pack/puce-verte.gif\" alt='"._T('message_publie')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie&vierge=1&id_current_forum=$id_breve&type_forum=breve'>$nbMessPublie mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        $nbMessOff = $forumMetier->howManyForumForBreveIdAndStatuts($id_breve, "'off'");
                        $s .= "<img src=\"img_pack/puce-rouge.gif\" alt='"._T('message_off')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,off&vierge=1&id_current_forum=$id_breve&type_forum=breve'>$nbMessOff mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                        $nbMessPoubelle = $forumMetier->howManyForumForBreveIdAndStatuts($id_breve, "'poubelle'");
                        $s .= "<img src=\"img_pack/puce-poubelle.gif\" alt='"._T('message_poubelle')."' width=\"13\" height=\"14\" border=\"0\">&nbsp;<a href='controle_forum_suite.php3?affType=discussion&affMessage[]=publie,poubelle&vierge=1&id_current_forum=$id_breve&type_forum=breve'>$nbMessPoubelle mess</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

                        $s .= "</td></tr>";

        			    $vals[] = $s;

        			    $s = "<div align=\"right\">";
        			    if ($affrub) {
            				$rubriqueMetier = &recuperer_instance_rubrique();
                            $loadOK = $rubriqueMetier->load($id_rubrique);
                            if (!PEAR::isError($loadOK)) {

                                $s .= typo($rubriqueMetier->getTitre());
                            }
                            /*
                            $rub = spip_fetch_array(".$GLOBALS['table_prefix']."_query("SELECT titre FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_rubrique=$id_rubrique"));
        				    $s .= typo($rub['titre']);
        			        */
        			    } else if ($statut != "prop")
            				$s .= affdate($date_heure);
        			    else
            				$s .= _T('info_a_valider');
        			    $s .= "</div>";
        			    $vals[] = $s;
        			    $table[] = $vals;
        			}
                    break;
                default:
        			$id_rubrique = $row['id_rubrique'];
                	$id_breve = $row['id_breve'];
        			$tous_id[] = $id_breve;
        			$date_heure = $row['date_heure'];
        			$titre = $row['titre'];
        			$statut = $row['statut'];

        			switch ($statut) {
        			case 'prop':
        				$puce = "puce-blanche";
        				$title = _T('titre_breve_proposee');
        				break;
        			case 'publie':
        				$puce = "puce-verte";
        				$title = _T('titre_breve_publiee');
        				break;
        			case 'refuse':
        				$puce = "puce-rouge";
        				$title = _T('titre_breve_refusee');
        				break;
        			}

        			$s = "<a href='breves_voir.php3?id_breve=$id_breve' title=\"$title\">";
        			$s .= "<img src='img_pack/$puce.gif' alt='' width='8' height='9' border='0'></a>&nbsp;&nbsp;";
        			$s .= "<a href='breves_voir.php3?id_breve=$id_breve'>";
        			$s .= typo($titre);
        			$s .= "</a>";
        			$vals[] = $s;

        			$s = "<div align=\"right\">";
        			if ($affrub) {
        				$rubriqueMetier = &recuperer_instance_rubrique();
                        $loadOK = $rubriqueMetier->load($id_rubrique);
                        if (!PEAR::isError($loadOK)) {

                            $s .= typo($rubriqueMetier->getTitre());
                        }
                        /*
                        $rub = spip_fetch_array(".$GLOBALS['table_prefix']."_query("SELECT titre FROM ".$GLOBALS['table_prefix']."_rubriques WHERE id_rubrique=$id_rubrique"));
        				$s .= typo($rub['titre']);
        			    */
        			} else if ($statut != "prop")
        				$s .= affdate($date_heure);
        			else
        				$s .= _T('info_a_valider');
        			$s .= "</div>";
        			$vals[] = $s;
        			$table[] = $vals;
        			break;
        		}
            }
		$result->free();

		/*
		".$GLOBALS['table_prefix']."_free_result($result);
        */

		$largeurs = array('', '');
		$styles = array('arial2', 'arial1');
		afficher_liste($largeurs, $table, $styles);

		if ($titre_table) echo "</TABLE></TD></TR>";
		echo "</TABLE>";
		fin_cadre_relief();
	    }
	    return $tous_id;
    }

    // }}}

    // {{{ _fillQueries()

    /**
     * This methods fill the query associative arrays with SQL 92 compliant
     * queries. Each driver that requires specific SQL querying must implement
     * the _adaptQueriesToDriver() method.
     * @access  private
     * @see     _adaptQueriesToDriver()
     */
    function _fillQueries() {
        $this->_queries[BREVES_BY_STATE_AND_RUBRIQUE] = "SELECT id_breve, date_heure, titre, statut FROM ".$GLOBALS['table_prefix']."_breves "
                                          . "WHERE id_rubrique=! AND statut IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[BREVES_BY_STATE_AND_RUBRIQUE] = "SELECT COUNT(id_breve) FROM ".$GLOBALS['table_prefix']."_breves "
                                          . "WHERE id_rubrique=? AND statut IN (!)";
        $this->_queries[BREVES_BY_STATE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_breves "
                                          . "WHERE statut IN (!) ORDER BY date_heure DESC";
        $this->_queriesCount[BREVES_BY_STATE] = "SELECT COUNT(id_breve) FROM ".$GLOBALS['table_prefix']."_breves "
                                          . "WHERE statut IN (!)";

        $this->_queries[BREVES_BY_LIEN] = "SELECT breves.* FROM ".$GLOBALS['table_prefix']."_breves breves, ".$GLOBALS['table_prefix']."_mots_breves lien WHERE lien.id_mot=? "
	                                        . "AND lien.id_breve=breves.id_breve ORDER BY breves.date_heure DESC";
	    $this->_queriesCount[BREVES_BY_LIEN] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_breves breves, ".$GLOBALS['table_prefix']."_mots_breves lien WHERE lien.id_mot=? "
	                                        . "AND lien.id_breve=breves.id_breve";

        $this->_queries[BREVES_BY_RUBRIQUE] = "SELECT * FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique=? ORDER BY date_heure DESC";
	    $this->_queriesCount[BREVES_BY_RUBRIQUE] = "SELECT COUNT(*) FROM ".$GLOBALS['table_prefix']."_breves WHERE id_rubrique=?";

        $this->_queries[BREVES_RECHERCHE] = "SELECT * ".
                                                "FROM ".$GLOBALS['table_prefix']."_breves WHERE <!spipBREVE_CONSTRUCTION_RECHERCHEspip!> ORDER BY maj DESC";
        $this->_queriesCount[BREVES_RECHERCHE] = "SELECT count(id_breve) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_breves WHERE  <!spipBREVE_CONSTRUCTION_RECHERCHEspip!>";

        $this->_queries[BREVES_RECHERCHE_INT] = "SELECT objet.id_breve, objet.titre, objet.date_heure, objet.statut, SUM(idx.points) AS points ".
                                                    "FROM ".$GLOBALS['table_prefix']."_breves objet, ".$GLOBALS['table_prefix']."_index_breves idx ".
                                                    "WHERE objet.id_breve = idx.id_breve AND idx.hash IN (!) AND objet.id_breve NOT IN (!) GROUP BY objet.id_breve, objet.titre, objet.date_heure, objet.statut ORDER BY points DESC";
        $this->_queriesCount[BREVES_RECHERCHE_INT] = "SELECT COUNT(*) ".
                                                    "FROM ".$GLOBALS['table_prefix']."_breves objet, ".$GLOBALS['table_prefix']."_index_breves idx ".
                                                    "WHERE objet.id_breve = idx.id_breve AND idx.hash IN (!) AND objet.id_breve NOT IN (!)";


        $this->_queries[BREVES_FORUM_MESSAGE] = "SELECT DISTINCT(".$GLOBALS['table_prefix']."_breves.id_breve), ".$GLOBALS['table_prefix']."_breves.titre, ".$GLOBALS['table_prefix']."_breves.id_rubrique, ".$GLOBALS['table_prefix']."_breves.date_heure, ".$GLOBALS['table_prefix']."_breves.statut FROM ".$GLOBALS['table_prefix']."_breves, ".$GLOBALS['table_prefix']."_forum WHERE ( (".$GLOBALS['table_prefix']."_breves.id_breve = ".$GLOBALS['table_prefix']."_forum.id_breve) ) ORDER BY ".$GLOBALS['table_prefix']."_breves.date_heure";
        $this->_queriesCount[BREVES_FORUM_MESSAGE] = "SELECT count(id_forum) FROM ".$GLOBALS['table_prefix']."_breves, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve GROUP BY ".$GLOBALS['table_prefix']."_forum.id_breve";


        /*
        $this->_queries[BREVES_FORUM_MESSAGE_PROP] = "SELECT count(id_forum) AS count, ".$GLOBALS['table_prefix']."_breves.* FROM ".$GLOBALS['table_prefix']."_breves, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.statut IN ('prop') GROUP BY ".$GLOBALS['table_prefix']."_forum.id_breve ORDER BY ".$GLOBALS['table_prefix']."_forum.date_heure DESC";
        $this->_queriesCount[BREVES_FORUM_MESSAGE_PROP] = "SELECT count(id_forum) AS count FROM ".$GLOBALS['table_prefix']."_breves, ".$GLOBALS['table_prefix']."_forum WHERE ".$GLOBALS['table_prefix']."_forum.id_breve=".$GLOBALS['table_prefix']."_breves.id_breve AND ".$GLOBALS['table_prefix']."_forum.statut IN ('prop') GROUP BY ".$GLOBALS['table_prefix']."_forum.id_breve";
        */
    }

    // }}}
}
?>