<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND  <elebescond@clever-age.com>                |
// |         Antoine ANGENIEUX <aangenieux@clever-age.com>                |
// +----------------------------------------------------------------------+
//
// Base class for Groupe Mot business persistence abstraction.
//

if (defined('_BD_NL_USER_GROUPS')) return;
    define('_BD_NL_USER_GROUPS', "1");

require_once 'PEAR.php';
require_once 'DB.php';
require_once dirname(__FILE__).'/metier.php';
require_once dirname(__FILE__).'/../../inc_version.php3';

define('GROUPE_NL_USER_GROUPS', ' id_groupe, lst_id, pst_id, titre ');

/**
 * BD_cm_user_groups is a base class for nl_user_groups business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @access	public
 */
class BD_cm_user_groups extends BD_metier {

    // {{{ properties

    /**
     * Group ID.
     * @var     int
     * @access  private
     */
    var $_groupeId;

    /**
     * List ID. If filled, reference the newsletter model to which
     * this group is attached
     * @var     int
     * @access  private
     */
    var $_lstId;

    /**
     * Post ID. If filled, reference the newsletter instance to which
     * this group is attached
     * @var     int
     * @access  private
     */
    var $_pstId;

    /**
     * Titre.
     * @var	String
     * @access private
     */
	var $_titre;

    // }}}

    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/nl_user_groups_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/cm_user_groups_common.php");
            $classname = "BD_cm_user_groups_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/nl_user_groups_".$dbParameters->_dbEngine.".php");
            $classname = "BD_cm_user_groups_".$dbParameters->_dbEngine;
        }
        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * BD_cm_user_groups constructor.
     *
     * @access public
     */

    function BD_cm_user_groups() {
    }

    // }}}

    // {{{ getGroupeId()

    /**
     * Returns the Group ID
     * @return  int
     * @access  public
     */

    function getGroupeId() {
        return $this->_groupeId;
    }

    // }}}

    // {{{ setGroupeId()

    /**
     * Sets the Groupe ID
     * @param   int
     * @access  public
     */

    function setGroupeId($groupeId) {
        $this->_groupeId = $groupeId;
    }

    // }}}

	// {{{ getLstId()

	/**
	 * Gets the List ID
	 * @return	int
	 * @access public
	 */

	function getLstId() {
		return $this->_lstId;
	}

	// }}}

	// {{{ setLstId()

	/**
	 * Sets the List ID
	 * @param	int
	 * @access public
	 */

	function setLstId($lstId) {
		$this->_lstId = $lstId;
	}

	// }}}

	// {{{ getPstId()

	/**
	 * Gets the Post ID
	 * @return	int
	 * @access	public
	 */

	function getPstId() {
		return $this->_pstId;
	}

	// }}}

	// {{{ setPstId()

	/**
	 * Sets the Post ID
	 * @param	int
	 * @access	public
	 */

	function setPstId($pstId) {
		$this->_pstId = $pstId;
	}

	// }}}

    // {{{ getTitre()

    /**
     * Returns the group word title
     * @return  String
     * @access  public
     */

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    /**
     * Sets the groupe word title
     * @param   String
     * @access  public
     */

    function setTitre($titre) {
        $this->_titre = corriger_caracteres($titre);
    }

    // }}}

    // {{{ create()

    function create() {
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : create()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }
        $string_prefix = $GLOBALS['table_prefix']."_cm_user_groups ";
        $groupeId = $db->nextId($string_prefix, true);
        if (DB::isError($groupeId)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : create()] '.$groupeId->getMessage(), null,
                                    null, null, null, null, false);
        }

        $this->_groupeId = $groupeId;

        $query = "INSERT INTO ".$GLOBALS['table_prefix']."_cm_user_groups (".GROUPE_NL_USER_GROUPS.") VALUES "
                ."(".$this->_groupeId.", "
                .$this->_lstId.", "
                .$this->_pstId.", "
                .$db->quote($this->_titre).")";

        //echo "--->".$query."<br>";

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : create()] '.$result->getMessage(), null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : update()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "UPDATE ".$GLOBALS['table_prefix']."_cm_user_groups "
                ."SET lst_id = ".$this->_lstId .", pst_id = ".$this->_pstId.", titre = ".$db->quote($this->_titre)
                ." WHERE id_groupe = ".$this->_groupeId;

         

        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : update()] '.$result->getMessage(), null,
                null, null, null, null, false);
        }

    }

    // }}}

    // {{{ load()

    function load($idGroupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : load()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "SELECT".GROUPE_NL_USER_GROUPS."FROM ".$GLOBALS['table_prefix']."_cm_user_groups WHERE id_groupe = ".$idGroupe;

		//echo '<br>' . $query .  '<br>';

         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : load()] '.$result->getMessage(), null,
                null, null, null, null, false);
        } else {
            if ($row = $result->fetchRow()) {
                $this->_fetchData($row);
            } else {
                return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : load('.$idGroupe.')] Aucun groupe ne correspond pas  cet ID!', null,
                                    null, null, null, null, false);
            }
            $result->free();
        }
    }

    // }}}

    // {{{ delete()

    function delete($idGroupe) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : delete()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "DELETE FROM ".$GLOBALS['table_prefix']."_cm_user_groups WHERE id_groupe = ".$idGroupe;
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : delete()] '.$result->getMessage(), null,
                null, null, null, null, false);
        }
    }

    // }}}

    // {{{ _fetchData()

    function _fetchData($row) {
        $this->setGroupeId($row['id_groupe']);
        $this->setLstId($row['lst_id']);
        $this->setPstId($row['pst_id']);
        $this->setTitre($row['titre']);
    }

    // }}}

    // {{{ getAllGroupe()

    /**
     * Returns an array of Group.
     *
     *
     * @return Array of Group
     * @param $critere for sorting (field name)
     * @access public
     */

    function &getAllGroupe($critere = 'id_groupe') {
        $result = array();
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllGroupe()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_NL_USER_GROUPS." FROM ".$GLOBALS['table_prefix']."_cm_user_groups ORDER BY $critere";
         
        $queryResult = $db->query($query);

        if (DB::isError($queryResult)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllGroupe()] '.$queryResult->getMessage(), null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeUser = &BD_cm_user_groups::factory($this->getDbParameters(), $this->getDbOptions());
            $resultGroupeUser->_fetchData($row);
            $result[] = &$resultGroupeUser;
        }
        $queryResult->free();
        return $result;
    }

    // }}}


    // {{{ howManyInGroup

    /**
     * Returns the number of keywords for a given user group
     * WARNING : Does NOT return THE NUMBER of USERS that matches those keywords !
     * @return  int     number of keywords in group
     * @access  public
     */

    //TODO : La table ".$GLOBALS['table_prefix']."_nl_user n'existe pas. Elle contient un id_mot et un id_groupe.
    //TODO : Mme fonctionnement que les groupes de mot cl et mot cl!


    function howManyInGroup() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : howManyInGroup()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "SELECT COUNT(id_mot) FROM ".$GLOBALS['table_prefix']."_nl_user WHERE id_groupe=".$this->_groupeId;

        $result = $db->getOne($query);

        if (DB::isError($result)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : howManyInGroup()] '.$queryResult->getMessage(), null,
                null, null, null, null, false);
        }
        return $result;

    }

    // }}}

    // {{{ getAllUserGroups($id_newsletter)

    function getAllUserGroups($id_newsletter) {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllUserGroups()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_NL_USER_GROUPS." FROM ".$GLOBALS['table_prefix']."_cm_user_groups WHERE lst_id = $id_newsletter";

		//echo '<br> recup des groups generaux :   ' . $query . '<br>';
         
        $queryResult = $db->query($query);

		$result = array();

        if (DB::isError($queryResult)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllUserGroups()] '.$queryResult->getMessage(), null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeUser = &BD_cm_user_groups::factory($this->getDbParameters(), $this->getDbOptions());
            $resultGroupeUser->_fetchData($row);
            $result[] = &$resultGroupeUser;
        }
        $queryResult->free();
        return $result;

    }

    // }}}

    // {{{ getAllUserGroupsForPostId($id_post)

    function getAllUserGroupsForPostId($id_post) {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllUserGroupsForPostId()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }

        $query = "SELECT ".GROUPE_NL_USER_GROUPS." FROM ".$GLOBALS['table_prefix']."_cm_user_groups WHERE pst_id = $id_post";

		//echo '<br> recup des groupes specifique :   ' . $query . '<br>';
         
        $queryResult = $db->query($query);

		$result = array();

        if (DB::isError($queryResult)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getAllUserGroupsForPostId()] '.$queryResult->getMessage(), null,
                null, null, null, null, false);
        }
        while ($row = $queryResult->fetchRow()) {
            $resultGroupeUser = &BD_cm_user_groups::factory($this->getDbParameters(), $this->getDbOptions());
            $resultGroupeUser->_fetchData($row);
            $result[] = &$resultGroupeUser;
        }
        $queryResult->free();
        return $result;

    }

    // }}}

    // {{{ getSubscribersForGroupeId()

    function getSubscribersForGroupId() {

        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError('['.get_class($this).' BD_cm_user_groups : getSubscribersForGroupId()] '.$db->getMessage(), null,
                null, null, null, null, false);
        }


		$motMetier = &recuperer_instance_mot();
		$motAffecte = $motMetier->getAllFromMotsAndAnotherTable('cm', 'id_groupe', $this->getGroupeId());
		
		$motAffecteIds = array();

	    while (list(, $monMot) = each($motAffecte)) {
	    	$motAffecteIds = array_merge ($motAffecteIds, $motMetier->getSubBranchIds($monMot->getMotId()));
		}
		
	    $motAffecteIds = array_unique($motAffecteIds);
	    if (sizeOf($motAffecteIds) == 0) {
	    	$motAffecteIds[] = -1;
		}
		
        $query = "SELECT ".$GLOBALS['table_prefix']."_auteurs.id_auteur, ".$GLOBALS['table_prefix']."_auteurs.email FROM ".$GLOBALS['table_prefix']."_auteurs, ".$GLOBALS['table_prefix']."_mots_auteurs WHERE ".$GLOBALS['table_prefix']."_mots_auteurs.id_mot IN (" . join(",", $motAffecteIds) . ") AND ".$GLOBALS['table_prefix']."_auteurs.id_auteur=".$GLOBALS['table_prefix']."_mots_auteurs.id_auteur";

		//echo '<br>' . $query . '<br>';
         
        $queryResult = $db->query($query);
        
		$auteurs = array();
        if (DB::isError($queryResult)) {
			return PEAR::raiseError("[".get_class($this)." BD_cm_user_groups : getSubscribersForGroupId()] ".$queryResult->getMessage()."", null,
                null, null, null, null, false);
        } else {
        	while ($row = $queryResult->fetchRow()) {
        		$email = $row['email'];
        		$auteurs[$email] = array(	'id_auteur' => $row['id_auteur'],
        							'id_sub' => 0,
        							'email' => $row['email'],
        							'mode' => 1);        		
	    	}
	    	$queryResult->free();
        }
    	return $auteurs;
    }

    // }}}

}
?>