<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Erwan LE BESCOND <elebescond@clever-age.com>       et moi ?          |
// +----------------------------------------------------------------------+
//
// $Id$

require_once dirname(__FILE__)."/metier.php";

if (file_exists(dirname(__FILE__)."/inc_config_metier.php")) { 
    require_once dirname(__FILE__)."/inc_config_metier.php";
}

/**
 * BD_metier is a base class for all business persistence abstraction implementations, and must be
 * inherited by all such.
 * @package	BD
 * @author  Antoine Angnieux <aangenieux@clever-age.com>
 * @author 	Erwan Le Bescond <elebescond@clever-age.com>
 * @author  Olivier Mansour <omansour@clever-age.com>
 * @access	public
 */


class BD_connexion extends BD_metier {
    // {{{ properties
    
    /**
     * Parameters instance used for PEAR::DB factory and
     * Metier subclasses factories.
     *
     * @access private
     */
    var $_dbParameters;
    

    // }}}


    // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {

        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/connexion_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/connexion_common.php");
            $classname = "BD_connexion_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/connexion_".$dbParameters->_dbEngine.".php");
            $classname = "BD_connexion_".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }
        //echo "$classname";
        $obj =& new $classname;
        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        /*
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
        */
        return $obj;
    }

    // }}}


    // {{{ isConnected()

    function isConnected() {
        /*
        require_once dirname(__FILE__)."/inc_metier_factory.php";
        $metier = &recuperer_instance_metier();
        
        $db = $metier->_getDB();
        */
        $db = $this->_getDB();
        
        if (DB::isError($db)) {
            //return PEAR::raiseError("[".get_class($this)." DB_connexion : isConnected()] ".$db->getMessage()."", null,
            //    null, null, null, null, false);
            return false;
        }
        // TODO : pas plus rapide pour tester la connection et l'installation de SPIP Agora ? 
        $query = "SELECT COUNT(nom) as compteur FROM ".$GLOBALS['table_prefix']."_meta";
        /* 
        echo $query;
        */
         
        $result = $db->query($query);
 
        if (DB::isError($result)) {
            //return PEAR::raiseError("[".get_class($this)." DB_connexion : isConnected()] ".$result->getMessage()."", null,
            //    null, null, null, null, false);
            return false;
        }
        else {
            if ($row = $result->fetchRow()) {
                //return $row['compteur'];           
                return true;     
            } else {
            	return false;	
            }           
        }
    }
    // }}}


    /**
     * Getter method to retreive the instance Parameters object
     *
     * @return      DB parameters
     * @access      public
     */

    function getDbParameters() {
        return $this->_dbParameters;
    }

    // }}}

    // {{{ setDbParameters()

    /**
     * Setter method to set the instance Parameters object
     *
     * @param $dbParameters     new DB parameters
     */

    function setDbParameters($dbParameters) {
        if (strtolower(get_class($dbParameters)) == "bd_parameters") {
            $this->_dbParameters = $dbParameters;
        } else {
           // return PEAR::raiseError("Erreur! le parametre de la methode setDbParameters doit etre un objet de la hierarchie DB_parameters !",
           //                   null, null, null, null, null, false);
           die ("Erreur! le parametre de la methode setDbParameters doit etre un objet de la hierarchie DB_parameters !"); // en attendant mieux;
        }
    }

    // }}}


}
?>
