<?php
//
// +----------------------------------------------------------------------+
// | Copyright (c) 2003 Clever Age                                        |
// +----------------------------------------------------------------------+
// | Author: Francois-Xavier LACROIX <fxlacroix@clever-age.com>
//           Olivier Mansour           |
// +----------------------------------------------------------------------+
//
// Base class for manage the history of a visitor
// $Id$


require_once "PEAR.php";
require_once "DB.php";
require_once dirname(__FILE__)."/metier.php";
require_once dirname(__FILE__)."/../../inc_filtres.php3";
require_once dirname(__FILE__)."/../../inc_meta.php3";

// ajout Olivier Mansour 
require_once dirname (__FILE__)."/inc_article_factory.php";
require_once dirname (__FILE__)."/inc_rubrique_factory.php";
require_once dirname (__FILE__)."/inc_breve_factory.php";
require_once dirname (__FILE__)."/inc_auteur_factory.php";
// fin ajout Olivier Mansour

define("DERNIERES_VISITES_ALL_FIELDS", ' id_pers,date_heure,url,titre ');

/**
 * Classe m�tier pour la gestion de l'historique des auteurs (les pages les plus visit�s pour un auteur)
 * @package BD
 * @author  Fran�ois-Xavier LACROIX <fxlacroix@clever-age.com>
 * @author  Erwan LE BESCOND <elebescond@clever-age.com>
 * @access  public
 */
class BD_dernieres_visites extends BD_metier {

 // {{{ properties

    var $_id_pers;
    var $_date;
    var $_url;
    var $_titre;

    // }}}

 // {{{ factory()
    function &factory($dbParameters = null, $dbOptions = null) {
        if(file_exists(dirname(__FILE__)."/".$dbParameters->_dbEngine."/dernieres_visites_".$dbParameters->_dbEngine.".php") == false) {
            include_once(dirname(__FILE__)."/common/dernieres_visites_common.php");
            $classname = "BD_dernieres_visites_common";
        }
        else {
            include_once(dirname(__FILE__)."/".$dbParameters->_dbEngine."/dernieres_visites_".$dbParameters->_dbEngine.".php");
            $classname = "BD_dernieres_visites_common".$dbParameters->_dbEngine;
        }

        if (!class_exists($classname)) {
            return PEAR::raiseError("Cannot instanciate class $classname", null,
                                    null, null, null, null, false);
        }

        $obj =& new $classname;

        $result = $obj->setDbParameters($dbParameters);
        if ($dbOptions != null) {
            $obj->setDbOptions($dbOptions);
        }
        if (PEAR::isError($result)) {
            return $result;
        } else {
            return $obj;
        }
    }

    // }}}

    // {{{ constructor

    /**
     * DB_subscriber constructor.
     *
     * @access public
     */

    function BD_subscriber() {
    }

    // }}}

    // {{{ getIdPers()

    function getIdPers() {
        return $this->_id_pers;
    }

    // }}}

    // {{{ setIdPers()

    function setIdPers($id) {
        $this->_id_pers = $id;
    }

    // }}}

    // {{{ getDate()

    function getDate() {
        return $this->_date;
    }

    // }}}

    // {{{ setDate()

    function setDate($date) {
         $this->_date = $date;
    }

    // }}}

  // {{{ getUrl()

    function getUrl() {
        return $this->_url;
    }

    // }}}

    // {{{ setUrl()

    function setUrl($adresse) {
         $this->_url = $adresse;
    }

    // }}}

    // {{{ getTitre()

    function getTitre() {
        return $this->_titre;
    }

    // }}}

    // {{{ setTitre()

    function setTitre($titre) {
         $this->_titre = $titre;
    }

    // }}}


    // {{{ Create() 
 //Fonction de cr�ation d'un objet dans la table ".$GLOBALS['table_prefix']."_dernieres_visites : les dernieres pages les plus visit�se

    function create() {
       
		//$tot = $visites->calcul_nb($GLOBALS['auteur_session']['id_auteur']);
	    //On v�rifie que la liste n'est pas plein e (10) ou que l'url n'est pas d�ja sauvegard�e
	    $nb_dernieres_vistes = lire_meta ('nb_dernieres_visites');
	    if (!$nb_dernieres_vistes) $nb_dernieres_vistes = 10;
	    if($this->notExistUrl($this->getUrl(), $this->getIdPers())) {
	        if ($this->calcul_nb() >= $nb_dernieres_vistes) {
	            $date_old = $this->createUpdateOld();
			} else {
		

				$db = &$this->_getDB();
		        if (DB::isError($db)) {
		            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : create()] ".$db->getMessage()."", null,
		                null, null, null, null, false);
		        }
		
		        if($this->_id_pers == null) $this->_id_pers = 0;
		        if($this->_date == null) {
		        	$maDate = new Date();
		        	$this->_date = $maDate->getDate(DATE_FORMAT_ISO);
		        }
		        if($this->_titre == null) $this->_titre = "";
		        if($this->_id_element == null) $this->_id_element = 0;
		        if($this->_type == null) $this->_type = "";
		        if($this->_url == null) $this->_url = "";		
		
		         $query = "INSERT INTO ".$GLOBALS['table_prefix']."_dernieres_visites (".DERNIERES_VISITES_ALL_FIELDS.") VALUES "
        	        ."('".$this->_id_pers."', "
                	."'".$this->_date."', "
                	."'".$db->quoteString($this->_url)."', "
                	."'".$db->quoteString($this->_titre)."')";
				
			
				$result = $db->query($query);
        		if (DB::isError($result)) {
            		return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : create()] ".$result->getMessage()."", null,
                		null, null, null, null, false);
        		}
	        }
	    }
	    else {
	    	return $this->update();
	    }
    }

    // }}}
    
	// {{{ update()

    function update() {
        $db = &$this->_getDB();

        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : update()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

       	$maDate = new Date();
       	$this->_date = $maDate->getDate(DATE_FORMAT_ISO);

        $query = "UPDATE ".$GLOBALS['table_prefix']."_dernieres_visites "
                ."SET id_pers = ".$this->_id_pers.", "
                ."date_heure = '".$db->quoteString($this->_date)."', "
				."url = '".$db->quoteString($this->_url)."', "
                ."titre = '".$db->quoteString($this->_titre)."' "                
                ."WHERE id_pers = ".$this->_id_pers." AND url = '".$db->quoteString($this->_url)."'";         

		echo $query;

        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : update()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
    }

    // }}}    
    
	// {{{ listePage()
               
	function listePage($id_pers) {
    	$tab = array();
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : listePage()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT ".DERNIERES_VISITES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_dernieres_visites WHERE id_pers = $id_pers";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : listePage()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        else
            while($row = $result->fetchRow()) {
                $tab[] = $row['url'];
			}  
        
	    return ($tab);     
    }
  
   // }}}

	function getUrlTitre($url){
  
    	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : getUrlTitre()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT ".DERNIERES_VISITES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_dernieres_visites WHERE url = '$url'";

		//echo $query;
         
        $result = $db->query($query);

        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : getUrlTitre()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        else {
            if($row = $result->fetchRow()) {
                return($row['titre']);
			}  
        }
	}



	function calcul_nb() {
    	$db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : delete()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

		$query = "SELECT COUNT(url) AS total FROM ".$GLOBALS['table_prefix']."_dernieres_visites WHERE id_pers='" . $this->getIdPers() . "'";
     
		$result = $db->query($query);

		if (DB::isError($result)) {
        	return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : load()] ".$result->getMessage()."", null,
            	null, null, null, null, false);
        } else 
            if ($row = $result->fetchRow()) {
               $total = $row["total"]; 
            }
      return($total);
    }

	// {{{ createUpdateOld() 
 	//Fonction de creation d'un objet dans la table ".$GLOBALS['table_prefix']."_dernieres_visites
 	//On fait un update sur la visite la plus ancienne

    function createUpdateOld() {
		$db = &$this->_getDB();
		if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : create_update_old()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }

        if($this->_id_pers == null) $this->_id_pers = 0;
        if($this->_date == null) $this->_date = "";
        if($this->_url == null) $this->_url = "";
        if($this->_titre == null) $this->_titre = "";
        if($this->_id_element == null) $this->_id_element = 0;
        if($this->_type == null) $this->_type = "";
       
		$query = "SELECT MIN(date_heure) as date_min FROM ".$GLOBALS['table_prefix']."_dernieres_visites";
		
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : create_update_old()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        else{
           if ($row = $result->fetchRow()) {
                $date = $row["date_min"]; 
                if($this->_id_pers == null) $this->_id_pers = 0;
                if($this->_date == null) $this->_date = "";
                if($this->_url == null) $this->_url = "";     
                $query = "UPDATE ".$GLOBALS['table_prefix']."_dernieres_visites SET url='$this->_url', date_heure='$this->_date' WHERE date_heure='$date'";
                 
                $result = $db->query($query);
            }  
        }
    }

    // }}}
    
    
    // {{{ notExistUrl() 
    //Methode pour verifier si une meme uRL N'est pas encore enregistree dans la table
    
    function notExistUrl($url,$id_pers) {
        
        $db = &$this->_getDB();
        if (DB::isError($db)) {
                return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : notExistUrl()] ".$db->getMessage()."", null,
                    null, null, null, null, false);
            }
		else{
			$query = "SELECT ".DERNIERES_VISITES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_dernieres_visites where url='$url' AND id_pers=$id_pers";
                 
            $res = $db->query($query);
            if (DB::isError($res)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : notExistUrl()] ".$res->getMessage()."", null,
                null, null, null, null, false);
            }
            else
            if (!($res->fetchRow()))
                return(true);
            else
                return(false);
        }

    }
    
	// }}}
    
    // {{{ listeLastPages()
    
    /**
     * Retourne le tableau des dernieres visites
     * @return  Array
     * @access  public
     * @param int id_pers 
     * @param string order
     */
               
    function listeLastPages($id_pers, $order='desc') {
        $tab = array();
        $db = &$this->_getDB();
        if (DB::isError($db)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : listePage()] ".$db->getMessage()."", null,
                null, null, null, null, false);
        }
        $query = "SELECT ".DERNIERES_VISITES_ALL_FIELDS." FROM ".$GLOBALS['table_prefix']."_dernieres_visites WHERE id_pers = $id_pers 
            order by date_heure $order";
         
        $result = $db->query($query);
        if (DB::isError($result)) {
            return PEAR::raiseError("[".get_class($this)." DB_dernieres_visites : listePage()] ".$result->getMessage()."", null,
                null, null, null, null, false);
        }
        else
            while($row = $result->fetchRow()) {
                $tab[] = $row['url'];
            }  
        
        return ($tab);     
    }
  
   // }}}
}





